!-----------------------------------------------------------------------
!     Copyright (C) 2000-2013 GFD Dennou Club. All rights reserved.
!-----------------------------------------------------------------------

module Thermo_Function  ! Ǯϳؤ˴طؿ
  ! Ǯϳѿ֤Ѵؿξ, "..2.."Ȥˤʤ.
  ! ξ, 2 ƤΤ 2 θˤΤѴȤ
  ! Ȥ̣Ƥ.
use Thermo_Const
use Phys_Const
use Algebra
use Statistics

contains

real function tetens(T)  ! ƥƥμ¸Ѥ˰¿׻.
  use Thermo_Const
  implicit none
  real, intent(in) :: T  ! 絤β [K]
  real, parameter :: a=7.5, b=237.7, c=9.5, d=265.5

  if(t<=t0)then
     tetens=e0*10.0**(c*(t-t0)/(t-t0+d))
  else
     tetens=e0*10.0**(a*(t-t0)/(t-t0+b))
  end if

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function goff_gratch(T)  ! goff-gratch μѤ˰¿׻.
  use Thermo_Const
  implicit none
  real, intent(in) :: T  ! 絤β [K]
  real, parameter :: a=-7.90298, b=5.02808, c=-1.3816e-7, d=8.1328e-3
  real, parameter :: pa=11.344, pb=-3.49149
  real, parameter :: tst=373.15
  real, parameter :: est=1.01325e5
  real :: term

  term=a*(tst/T-1.0)+b*log10(tst/T)+c*(10.0**(pa*(1.0-T/tst))-1.0)+d*(10.0**(pb*(tst/T-1.0))-1.0)
  goff_gratch=est*10.0**(term)

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function goff_gratch_i(T)  ! goff-gratch μѤ˰¿ (ɹ˰) ׻.
  use Thermo_Const
  implicit none
  real, intent(in) :: T  ! 絤β [K]
  real, parameter :: a=-9.09718, b=-3.56654, c=0.876793
  real, parameter :: est=6.1173e2
  real :: term

  term=a*(ti0/T-1.0)+b*log10(ti0/T)+c*(1.0-t/ti0)
  goff_gratch_i=ei0*10.0**(term)

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function es_Bolton(T)  ! Bolton(1980) μˡѤ˰¿׻.
  use Thermo_Const
  implicit none
  real, intent(in) :: T  ! 絤β [K]
  real, parameter :: a=17.67, c=29.65

  es_Bolton=e0*exp(a*((T-t0)/(T-c)))

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function es_TD(e)  ! es_Bolton Ѥ˰¿η׻εջ
! Ϫ٤׻.
  use Thermo_Const
  implicit none
  real, intent(in) :: e  ! 絤ο [Pa]
  real, parameter :: a=17.67, c=29.65

  if(e>0.0)then
     es_TD=c+(a*(t0-c))/(a-log(e/e0))
  else
     es_TD=t0  ! true ??
  end if

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function LH(T)  !  T ˤǮη׻
  ! ܴؿ, ǮȤη̤Ȥۤ礭ʺޤʤ.
  ! ܷ׻, ǮβѲ˴ؤ֥ҥۥåդμפѤ.
  ! ޤ, κݤɬפʱο갵Ǯӿ갵Ǯ
  ! ٰ¸ʤΤȲꤷ, 줾
  ! $C_l=4190,\; C_{pv}=1870$ȤͤѤƳФطǤ.
  ! ä, ѤǮͤ䤽βٰ¸θȷѲǽ.
  use Thermo_Const
  implicit none
  real, intent(in) :: T  ! 絤β [K]

  LH=LH0-2.32e3*(T-t0)

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function eP_2_qv(e,P)  ! 麮׻
  use Thermo_Const
  implicit none
  real, intent(in) :: e  !  [Pa]
  real, intent(in) :: P  ! 絤 [Pa]
  real :: eps

  eps=Rd/Rv
  eP_2_qv=eps*e/(P-e)

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function TP_2_qvs(T,P)  ! ٤˰º׻
  ! Ǥ, es_Bolton Ѥ˰¿׻,
  ! eP_2_qv ѤƺѴ뤳Ȥ˰º׻.
  use Thermo_Const
  implicit none
  real, intent(in) :: T  !  [K]
  real, intent(in) :: P  ! 絤 [Pa]
  real :: eps
  real :: es

  eps=Rd/Rv
  es=es_Bolton(T)
  TP_2_qvs=eps*es/(P-es)

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function qvP_2_e(qv,P)  ! ׻
  use Thermo_Const
  implicit none
  real, intent(in) :: qv  !  [kg / kg]
  real, intent(in) :: P  !  [Pa]
  real :: eps

  eps=Rd/Rv
  qvP_2_e=P*qv/(eps+qv)

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function theta_dry(T,P)  ! 絤ˤ벹̤׻
  ! , 絤ˤƤ, ¬ P ȤƷ׻뤳ȤǤ
  ! η̴̤ؿ theta_moist η̤ȤۤѤʤ.
  use Thermo_Const
  implicit none
  real, intent(in) :: T  !  [K]
  real, intent(in) :: P  ! 絤ε(⤷, 絤) [Pa]
  real :: kappa

  kappa=Rd/Cpd
  theta_dry=T*(p0/P)**kappa

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function theta_moist(T,P,qv)  ! 絤ˤ벹̤׻
  use Thermo_Const
  implicit none
  real, intent(in) :: T  !  [K]
  real, intent(in) :: P  ! 絤 [Pa]
  real, intent(in) :: qv  !  [kg / kg]
  real :: eps, kappa, CR

  eps=Rd/Rv
  kappa=Rd/Cpd
  CR=Cpv/Cpd

  kappa=kappa*((1.0+qv/eps)/(1.0+qv*CR))  ! kappa ͤ夫񤭤Ƥ뤳Ȥ
  theta_moist=T*(p0/P)**kappa

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function thetaP_2_T(theta,P)  ! , Ϥ鲹٤׻(絤ȤƷ׻)
  use Thermo_Const
  implicit none
  real, intent(in) :: theta  !  [K]
  real, intent(in) :: P  ! 絤 [Pa]
  real :: kappa

  kappa=Rd/Cpd

  thetaP_2_T=theta*(P/p0)**kappa

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function thetaT_2_P(theta,T)  ! , ٤鰵Ϥ׻(絤ȤƷ׻)
  use Thermo_Const
  implicit none
  real, intent(in) :: theta  !  [K]
  real, intent(in) :: T  !  [T]
  real :: kappa

  kappa=Cpd/Rd

  thetaT_2_P=p0*(T/theta)**kappa

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function TqvP_2_TLCL(T,qv,P)  !! ٤Ⱥ T_LCL ׻
  ! 椫,  T_LCL ׻
  use Thermo_Const
  implicit none
  real, intent(in) :: T  !  [K]
  real, intent(in) :: qv  !  [kg / kg]
  real, intent(in) :: P  !  [Pa]
  real, parameter :: coe=2840.0, a=3.5, b=4.805, c=55.0
  real :: e

  e=qvP_2_e(qv,P)
  e=e*1.0e-2
  if(e>0.0)then
     TqvP_2_TLCL=coe/(a*log(T)-log(e)-b)+55.0
  else
     TqvP_2_TLCL=coe/(a*log(T)-b)+55.0  ! true ??
  end if

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function thetae_Bolton(T,qv,P)  ! Bolton(1980) ˤˡѤ̤׻.
  ! T_LCL ѤΤ, ΤδؿѤ.
  use Thermo_Const
  implicit none
  real, intent(in) :: T  !  [K]
  real, intent(in) :: qv  !  [kg / kg]
  real, intent(in) :: P  !  [Pa]
  real :: T_LCL, qvs
  real, parameter :: a=0.2854, b=0.28, c=3376.0, d=0.81

  T_LCL=TqvP_2_TLCL(T,qv,P)
  qvs=TP_2_qvs(T_LCL,P)
  thetae_Bolton=T*((p0/P)**(a*(1.0-b*qvs)))  &
   &            *exp((c/T_LCL-2.54)*qvs*(1.0+d*qvs))

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function thetaes_Bolton(T,P)  ! Bolton(1980) ˤˡѤ˰̤׻.
  use Thermo_Const
  implicit none
  real, intent(in) :: T  !  [K]
  real, intent(in) :: P  !  [Pa]
  real :: qvs
  real, parameter :: a=0.2854, b=0.28, c=3376.0, d=0.81

  qvs=TP_2_qvs(T,P)
  thetaes_Bolton=T*((p0/P)**(a*(1.0-b*qvs)))  &
   &            *exp((c/T-2.54)*qvs*(1.0+d*qvs))

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function TqvP_2_thetae(T,qv,P)  ! , , ̤׻.
  ! T_LCL ѤΤ, ΤδؿѤ.
  use Thermo_Const
  implicit none
  real, intent(in) :: T  !  [K]
  real, intent(in) :: qv  !  [kg / kg]
  real, intent(in) :: P  !  [Pa]
  real :: T_LCL, kappa, theta_d, e, qvs
  real, parameter :: a=0.2854, b=0.28, c=3376.0, d=0.81

  kappa=Rd/Cpd
  e=qvP_2_e(qv,P)
  T_LCL=TqvP_2_TLCL(T,qv,P)
  theta_d=T*(p0/(P-e))**kappa
  qvs=TP_2_qvs(T_LCL,P)
  TqvP_2_thetae=theta_d*exp(LH(T_LCL)*qvs/(Cpd*T_LCL))

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function TqvP_2_thetaes(T,P)  ! , , ˰̤׻.
  ! T_LCL ѤΤ, ΤδؿѤ.
  use Thermo_Const
  implicit none
  real, intent(in) :: T  !  [K]
!  real, intent(in) :: qv  !  [kg / kg]
  real, intent(in) :: P  !  [Pa]
  real :: kappa, theta_d, qvs !,e
  real, parameter :: a=0.2854, b=0.28, c=3376.0, d=0.81

  kappa=Rd/Cpd
!  e=qvP_2_e(qv,P)
!  theta_d=T*(p0/(P-e))**kappa
  theta_d=T*(p0/P)**kappa
  qvs=TP_2_qvs(T,P)
  TqvP_2_thetaes=theta_d*exp(LH(T)*qvs/(Cpd*T))

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function RHT_2_e(RH,T)  ! м٤Ȳ٤׻
  ! $RH=(e/es)\times 100$ Ȥ׻.
  use Thermo_Const
  implicit none
  real, intent(in) :: RH  ! м [%]
  real, intent(in) :: T  !  [K]
  real :: es

  es=es_Bolton(T)
  RHT_2_e=RH*es*1.0e-2

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function eT_2_RH(e,T)  ! Ȳ٤м٤׻
  ! $RH=(e/es)\times 100$ Ȥ׻.
  use Thermo_Const
  implicit none
  real, intent(in) :: e  !  [Pa]
  real, intent(in) :: T  !  [K]
  real :: es

  es=es_Bolton(T)
  eT_2_RH=100.0*e/es

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function RHTP_2_qv(RH,T,P)  ! м٤Ȳ٤麮׻
  ! RHT_2_e ׻, eP_2_qv 麮׻.
  use Thermo_Const
  implicit none
  real, intent(in) :: RH  ! м [%]
  real, intent(in) :: T  !  [K]
  real, intent(in) :: P  !  [Pa]
  real :: e

  e=RHT_2_e(RH,T)
  RHTP_2_qv=eP_2_qv(e,P)

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function qvTP_2_RH(qv,T,P)  ! Ȳ٤м٤׻.
  ! qvP_2_e ׻, м٤Ѥ.
  use Thermo_Const
  implicit none
  real, intent(in) :: qv  ! м [kg / kg]
  real, intent(in) :: T  !  [K]
  real, intent(in) :: P  !  [Pa]
  real :: e

  e=qvP_2_e(qv,P)
  qvTP_2_RH=eT_2_RH(e,T)

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function exner_func_dry(P)  ! 絤ˤĤƤΥʡؿ׻
  use Thermo_Const
  implicit none
  real, intent(in) :: P  !  [Pa]
  real :: kappa

  kappa=Rd/Cpd
  exner_func_dry=(P/p0)**kappa

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function hypsometric_form(p,z,T,z_t)  ! ٤ȵͿƤ٤ε.
!  ιˤήˤɸ絤βٸΨǤ 6.5 [K/km] Ƿ׻.
  use Thermo_Const
  implicit none
  real, intent(in) :: p  ! Ȥʤ٤ˤ밵 [Pa]
  real, intent(in) :: z  ! Ȥʤ [m]
  real, intent(in) :: T  ! Ǥβ [K]
  real, intent(in), optional :: z_t  !  [m] : ǥեȤǤ 0 m.
  real, parameter :: gam = 6.5e-3  ! ɸ絤βٸΨ [K/m]
  real :: z_calc, p_tmp

!write(*,*) "hypsometric, g=", g

  if(present(z_t))then
     z_calc=z_t
  else
     z_calc=0.0
  end if

  p_tmp=p*((T+gam*z)/(T+gam*z_calc))**(g/(gam*Rd))
  hypsometric_form=p_tmp

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

!-- 餷Ф餯Ѵ -----------------

real function rhoT_2_P( rho, T )
! 絤ξ, ̩٤Ȳ٤ͿƵ.
  use Thermo_Const
  implicit none
  real, intent(in) :: rho  ! 絤̩ [kg/m^3]
  real, intent(in) :: T    ! 絤β [K]

  rhoT_2_P=rho*Rd*T

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function rhoP_2_T( rho, P )
! 絤ξ, ̩٤ȵͿƲ٤.
  use Thermo_Const
  implicit none
  real, intent(in) :: rho  ! 絤̩ [kg/m^3]
  real, intent(in) :: P    ! 絤ΰ [Pa]

  rhoP_2_T=P/(Rd*rho)

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function TP_2_rho( T, P )
! 絤ξ, ٤ȵͿ̩٤.
  use Thermo_Const
  implicit none
  real, intent(in) :: T    ! 絤β [K]
  real, intent(in) :: P    ! 絤ΰ [Pa]

  TP_2_rho=p/(Rd*T)

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function get_gamma_d()  ! ǮΨƤִؿ(δؿɬפ)
  use Thermo_Const
  use Phys_Const
  implicit none

  get_gamma_d=-g/Cpd

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function moist_laps_temp( p_stan, T_stan, p )
! Ǯˤ뼾ǮΨ˽,  p ˤ뵤ؿ.
! ϥѡε.
  use Thermo_Const
  implicit none
  real, intent(in) :: p_stan  ! ൤ɸ [Pa]
  real, intent(in) :: T_stan  ! ಹ [K]
  real, intent(in) :: p  ! ٤ˤ뵤 [Pa]
  real :: seqpt, t_temp, seqpt_temp, dt, seqpt_temp2
  integer, parameter :: ilim=20
  real, parameter :: limit=2.0e-4

  seqpt=thetaes_Bolton( T_stan, p_stan )
  seqpt_temp=thetaes_Bolton( t_stan, p )
  if(p>p_stan)then
     dt=1.0
  else
     dt=-1.0
  end if
  t_temp=t_stan+dt
  seqpt_temp2=thetaes_Bolton( t_temp, p )

  do while ( (seqpt_temp2-seqpt)*(seqpt_temp-seqpt) >0.0 )
     t_temp=t_temp+dt
     seqpt_temp=seqpt_temp2
     seqpt_temp2=thetaes_Bolton( t_temp, p )
  end do

  seqpt_temp=seqpt_temp2
  dt=1.0

  do while ( abs(seqpt_temp-seqpt) > limit )

     dt=0.5*dt

     if( (seqpt_temp-seqpt)>0.0 )then
        t_temp=t_temp-dt
     else
        t_temp=t_temp+dt
     end if

     seqpt_temp=thetaes_Bolton( t_temp, p )

  end do

  moist_laps_temp=t_temp

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

!real function




!  return
!end function

!-----------------------------------------------------
!-----------------------------------------------------





end module
