!---------------------------------------------------------------
! Copyright (C) 2009-2013 GFD Dennou Club. All rights reserved.
!---------------------------------------------------------------

module cloud
! CReSS αʪ

contains

real function Src_theta_warm( temp, ts, pres, ps, qv, qc, qr )
! warm rain Ǥ theta Υ
  use Thermo_Const
  use Thermo_Function
  implicit none
  real, intent(in) :: temp  !  [K]
  real, intent(in) :: ts  ! ɽ̤ε [K]
  real, intent(in) :: pres  ! ȡ뵤 [Pa]
  real, intent(in) :: ps  ! ɽ̤ε [Pa]
  real, intent(in) :: qv  !  [kg/kg]
  real, intent(in) :: qc  ! 庮 [kg/kg]
  real, intent(in) :: qr  ! 庮 [kg/kg]
  real :: vapor_qv

  vapor_qv=qvs( temp )

  Src_theta_warm=Lv( temp )*(CNvc()-EVcv()-EVrv())

  Src_theta_warm=rhob*Src_theta_warm/(cpd*exner())

  return

end function Src_theta_warm

!---------------------------------

real function Src_theta_cold( rhob, rhop, rho0, ptb, ptp, pb, pp, qv, qc, qr, qi, qs, qg )
! warm rain Ǥ theta Υ
  use Thermo_Const
  use Thermo_Function
  implicit none
  real, intent(in) :: rhob  ! ܾ̩ [kg/m3]
  real, intent(in) :: rhop  ! ̩٤ư [kg/m3]
  real, intent(in) :: rho0  ! ɽ̤δܾ̩ [kg/m3]
  real, intent(in) :: ptb  ! ̤δܾ [K]
  real, intent(in) :: ptp  ! ̤ư [K]
  real, intent(in) :: qv  !  [kg/kg]
  real, intent(in) :: qc  ! 庮 [kg/kg]
  real, intent(in) :: qr  ! 庮 [kg/kg]
  real, intent(in) :: qi  ! ɹ [kg/kg]
  real, intent(in) :: qs  ! 㺮 [kg/kg]
  real, intent(in) :: qg  ! Ǻ [kg/kg]
  real :: vapor_qv

  vapor_qv=qvs( temp )

  Src_theta_cold=Lv( temp )*(VDvr())  &
  &              +Ls( temp )*(NUAvi()+VDvi()+VDvs()+VDvg())  &
  &              +Lf( temp )*(NUFci()+NUCci()+NUHci()  &
  &              +CLri()-MLic()-MLsr()-MLgr()+FRrg())

  Src_theta_cold=Src_theta_cold/(cpd*exner())

  return

end function Src_theta_cold

!---------------------------------
! common function (in cloud module)
!---------------------------------

real function Lv( temp )
!  -> ǤǮǮ
  use Thermo_Const
  implicit none
  real, intent(in) :: temp  !  [K]

  Lv=2.50078e6*(ti0/temp)**(0.167+3.67e-4*temp)

  return

end function Lv

real function Ls( temp )
! ɹ -> ǤǮǮ
  use Thermo_Const
  implicit none
  real, intent(in) :: temp !  [K]

  Ls=2.834e6+100.0*(temp-ti0)

  return

end function Ls

real function Lf( temp )
!  -> ɹǤͻǮ
  use Thermo_Const
  implicit none
  real, intent(in) :: temp !  [K]

  Lf=3.34e5+2500.0*(temp-ti0)

  return

end function Lf

real function nu_air( pres, temp )
! ưǴ
  use Thermo_Const
  implicit none
  real, intent(in) :: pres !  [Pa]
  real, intent(in) :: temp !  [K]

  nu_air=1.328e-5*(p00/pres)*(temp/ti0)**1.754

  return

end function nu_air

real function mu_air( pres, temp )
! Ǵ
  use Thermo_Function
  implicit none
  real, intent(in) :: pres
  real, intent(in) :: temp
  real :: rho

  rho=TP_2_rho( temp, pres )

  mu_air=nu_air( pres, temp )*rho

  return

end function mu_air

real function Dv( pres, temp )
  use Thermo_Const
  implicit none
  real, intent(in) :: pres
  real, intent(in) :: temp

  Dv=2.23e-5*(p00/pres)*(temp/ti0)**1.81

  return

end function

real function qvss( temp, pres )
  use Thermo_Function
  implicit none
  real, intent(in) :: temp
  real, intent(in) :: pres

  qvss=eps*tetens(temp)/(pres)

  return

end function

!--------------------------------------
! warm bulk physics
!--------------------------------------

real function CNcr( qc, a )
  implicit none
  real, intent(in) :: qc
  real, intent(in), optional :: a
  real, parameter :: k1=1.0e-3
  real :: tmp

  if(present(a))then
     tmp=a
  else
     tmp=1.0e-3
  end if

  CNcr=k1*(qc-tmp)

  return

end function CNcr

real function CLcr( qc, qr )
  implicit none
  real, intent(in) :: qc
  real, intent(in) :: qr
  real, parameter :: k2=2.2

  CLcr=k2*qc*(qr**0.875)

  return

end function CLcr

real function EVrv( rhob, qv, qr, qvs, p )
  implicit none
  real, intent(in) :: rhob
  real, intent(in) :: qv
  real, intent(in) :: qr
  real, intent(in) :: qvs
  real, intent(in) :: p
  real :: C

  C=1.6+124.9*(rhob*qr)**0.2046

  EVrv=((1.0-qv/qvs)*C*(rhob*qr)**0.525)/(rhob*(5.4e5+2.55e6/(p*qvs)))

  return

end function EVrv

real function term_v( rhob, qr, rho0 )
  implicit none
  real, intent(in) :: rhob
  real, intent(in) :: qr
  real, intent(in) :: rho0

  term_v=36.34*(rho0/rhob)*(rhob*qr)**0.1346

  return

end function term_v

!-----------------------------------------
!  cold bulk parameterization
!-----------------------------------------

real function FRrg( temp, rhob, lambdar )
! γ
  use Thermo_Const
  use Cloud_Const
  use Math_Const
  implicit none
  real, intent(in) :: temp  !  [K]
  real, intent(in) :: rhob  ! ܾ̩ [kg/m3]
  real, intent(in) :: lambdar  ! γʬۤη
  real :: tsp  ! Ѳ [K]

  tsp=ti0-temp

  FRrg=20.0*pi*pi*bd*nr0*rhow*(exp(ad*tsp)-1.0)/(rhob*lambdar**7)

  return

end function FRrg

!-----------------------------------------

real function MLxr( temp, rhob, pres, qv, cat )
! , Ǥͻ
  use Math_Const
  use Thermo_Const
  use Cloud_Const
  implicit none
  real, intent(in) :: temp  !  [K]
  real, intent(in) :: rhob  ! ܾ̩ [kg/m3]
  real, intent(in) :: pres  !  [Pa]
  real, intent(in) :: qv  !  [kg/kg]
  character(1), intent(in) :: cat  ! ѴΥƥ
                ! 's' -> , 'g' -> 
  real :: tdg  ! 륷

  tdg=temp-t0

  if(tdg>t0)then
     MKxr=(2.0*pi*VENTx( temp, rhob, rhos, trim(cat) )  &
  &       *(kpa*tdg/rhob+Lv( temp )*Dv( pres, temp )*(qv-qvs(ti0)))  &
  &       +cw*tdg*(CLxy( 'c'//trim(cat) )+CLxy( 'r'//trim(cat) )))/(Lf( temp ))
  else
     MLxr=0.0
  end if

  return

end function MLxr

!-----------------------------------------

real function MLic( dt, qi )
! ɹͻ
  implicit none
  real, intent(in) :: dt  ! dtbig [s]
  real, intent(in) :: qi  ! ɹ [kg/kg]

  MLic=0.5*qi/dt

  return

end function MLic

!-----------------------------------------

real function CLxy( )
! 

end function CLxy

!-----------------------------------------










end module
