module read_namelist

  use val_define
  use mpi

  implicit none

contains

subroutine read_name_mpi()

  use val_define

  if(MY_RANK==0)then
     namelist /input /nr, hnt, nt, rmin, dr, dt, dmpstp, finame,  &
  &                   foname, ni, nl_flag, r_dmp, time_flag, force_flag,  &
  &                   diff_r, diff_t, init_n
     namelist /para /proc

     read(5,nml=input)
     read(5,nml=para)

!-- following : MPI broadcasting (sender)

     call MPI_BCAST( nr, 1, MPI_INTEGER, MY_RANK,  &
  &                  MPI_COMM_WORLD, IERROR )
     call MPI_BCAST( hnt, 1, MPI_INTEGER, MY_RANK,  &
  &                  MPI_COMM_WORLD, IERROR )
     call MPI_BCAST( nt, 1, MPI_INTEGER, MY_RANK,  &
  &                  MPI_COMM_WORLD, IERROR )
     call MPI_BCAST( rmin, 1, MPI_REAL, MY_RANK,  &
  &                  MPI_COMM_WORLD, IERROR )
     call MPI_BCAST( dr, 1, MPI_REAL, MY_RANK,  &
  &                  MPI_COMM_WORLD, IERROR )
     call MPI_BCAST( dt, 1, MPI_REAL, MY_RANK,  &
  &                  MPI_COMM_WORLD, IERROR )
     call MPI_BCAST( dmpstp, 1, MPI_INTEGER, MY_RANK,  &
  &                  MPI_COMM_WORLD, IERROR )
     call MPI_BCAST( finame(1:80), 80, MPI_CHARACTER, MY_RANK,  &
  &                  MPI_COMM_WORLD, IERROR )
     call MPI_BCAST( foname(1:80), 80, MPI_CHARACTER, MY_RANK,  &
  &                  MPI_COMM_WORLD, IERROR )
     call MPI_BCAST( ni, 1, MPI_INTEGER, MY_RANK,  &
  &                  MPI_COMM_WORLD, IERROR )
     call MPI_BCAST( nl_flag, 1, MPI_LOGICAL, MY_RANK,  &
  &                  MPI_COMM_WORLD, IERROR )
     call MPI_BCAST( r_dmp, 1, MPI_REAL, MY_RANK,  &
  &                  MPI_COMM_WORLD, IERROR )
     call MPI_BCAST( time_flag(1:1), 1, MPI_CHARACTER, MY_RANK,  &
  &                  MPI_COMM_WORLD, IERROR )
     call MPI_BCAST( force_flag(1:10), 10, MPI_CHARACTER, MY_RANK,  &
  &                  MPI_COMM_WORLD, IERROR )
     call MPI_BCAST( diff_r, 1, MPI_REAL, MY_RANK,  &
  &                  MPI_COMM_WORLD, IERROR )
     call MPI_BCAST( diff_t, 1, MPI_REAL, MY_RANK,  &
  &                  MPI_COMM_WORLD, IERROR )
     call MPI_BCAST( init_n, 1, MPI_INTEGER, MY_RANK,  &
  &                  MPI_COMM_WORLD, IERROR )

     call MPI_BCAST( proc, 1, MPI_INTEGER, MY_RANK,  &
  &                  MPI_COMM_WORLD, IERROR )

  end if

  call MPI_BARRIER( MPI_COMM_WORLD, IERROR )  ! SYNC

!-- following : MPI Broadcasting (receiver)

  if(MY_RANK/=0)then

     call MPI_BCAST( nr, 1, MPI_INTEGER, 0,  &
  &                  MPI_COMM_WORLD, IERROR )
     call MPI_BCAST( hnt, 1, MPI_INTEGER, 0,  &
  &                  MPI_COMM_WORLD, IERROR )
     call MPI_BCAST( nt, 1, MPI_INTEGER, 0,  &
  &                  MPI_COMM_WORLD, IERROR )
     call MPI_BCAST( rmin, 1, MPI_REAL, 0,  &
  &                  MPI_COMM_WORLD, IERROR )
     call MPI_BCAST( dr, 1, MPI_REAL, 0,  &
  &                  MPI_COMM_WORLD, IERROR )
     call MPI_BCAST( dt, 1, MPI_REAL, 0,  &
  &                  MPI_COMM_WORLD, IERROR )
     call MPI_BCAST( dmpstp, 1, MPI_INTEGER, 0,  &
  &                  MPI_COMM_WORLD, IERROR )
     call MPI_BCAST( finame(1:80), 80, MPI_CHARACTER, 0,  &
  &                  MPI_COMM_WORLD, IERROR )
     call MPI_BCAST( foname(1:80), 80, MPI_CHARACTER, 0,  &
  &                  MPI_COMM_WORLD, IERROR )
     call MPI_BCAST( ni, 1, MPI_INTEGER, 0,  &
  &                  MPI_COMM_WORLD, IERROR )
     call MPI_BCAST( nl_flag, 1, MPI_LOGICAL, 0,  &
  &                  MPI_COMM_WORLD, IERROR )
     call MPI_BCAST( r_dmp, 1, MPI_REAL, 0,  &
  &                  MPI_COMM_WORLD, IERROR )
     call MPI_BCAST( time_flag(1:1), 1, MPI_CHARACTER, 0,  &
  &                  MPI_COMM_WORLD, IERROR )
     call MPI_BCAST( force_flag(1:10), 10, MPI_CHARACTER, 0,  &
  &                  MPI_COMM_WORLD, IERROR )
     call MPI_BCAST( diff_r, 1, MPI_REAL, 0,  &
  &                  MPI_COMM_WORLD, IERROR )
     call MPI_BCAST( diff_t, 1, MPI_REAL, 0,  &
  &                  MPI_COMM_WORLD, IERROR )
     call MPI_BCAST( init_n, 1, MPI_INTEGER, 0,  &
  &                  MPI_COMM_WORLD, IERROR )

     call MPI_BCAST( proc, 1, MPI_INTEGER, 0,  &
  &                  MPI_COMM_WORLD, IERROR )

  end if

  if(mod((nr-2),proc)/=0)then
     if(MY_RANK==0)then
        write(*,*) "ERROR : parameter 'proc'."
        write(*,*) "'proc' is a prime factor of 'nr-2'."
        write(*,*) "stop, abnormally."

        call MPI_FINALIZE( IERROR )
        stop
     end if
  else
     nr=(nr-2)/proc+2
  end if

!  if(mod((ni-2),proc)/=0)then
!     if(MY_RANK==0)then
!        write(*,*) "ERROR : parameter 'proc'."
!        write(*,*) "'proc' is a prime factor of 'nr-2'."
!        write(*,*) "stop, abnormally."
!
!        call MPI_FINALIZE( IERROR )
!        stop
!     end if
!  else
!     ni=(ni-2)/proc+2
!  end if

  if(PETOT/=proc)then
     write(*,*) "ERROR : parameter 'proc'."
     write(*,*) "'proc' must be the same as '-np' number."
     write(*,*) "stop, abnormally."
     call MPI_FINALIZE( IERROR )
     stop
  end if

  ntheta=hnt*2+1
  jnt=hnt*3+1

end subroutine read_name_mpi

subroutine read_name()

  use val_define

  namelist /input /nr, hnt, nt, rmin, dr, dt, dmpstp, finame,  &
  &                foname, ni, nl_flag, r_dmp, time_flag, force_flag,  &
  &                diff_r, diff_t, init_n
  namelist /para /proc

  read(5,nml=input)
  read(5,nml=para)

!  if(mod((nr-2),proc)/=0)then
!     if(MY_RANK==0)then
!        write(*,*) "ERROR : parameter 'proc'."
!        write(*,*) "'proc' is a prime factor of 'nr-2'."
!        write(*,*) "stop, abnormally."
!
!        stop
!     end if
!  else
!     nr=(nr-2)/proc+2
!  end if

!  if(mod((ni-2),proc)/=0)then
!     if(MY_RANK==0)then
!        write(*,*) "ERROR : parameter 'proc'."
!        write(*,*) "'proc' is a prime factor of 'nr-2'."
!        write(*,*) "stop, abnormally."
!
!        stop
!     end if
!  else
!     ni=(ni-2)/proc+2
!  end if

!  if(PETOT/=proc)then
!     write(*,*) "ERROR : parameter 'proc'."
!     write(*,*) "'proc' must be the same as '-np' number."
!     write(*,*) "stop, abnormally."
!     stop
!  end if

  ntheta=hnt*2+1
  jnt=hnt*3+1

end subroutine read_name

end module
