!---------------------------------------------------------------
! Copyright (C) 2009-2013 GFD Dennou Club. All rights reserved.
!---------------------------------------------------------------

module Alge_Solv   ! 黻Ѥʬ򤯥⥸塼

  public  :: Poisson_GauSei
  public  :: Poisson_Jacobi
  private :: check_bound

contains

subroutine Poisson_GauSei(x, y, rho, eps, boundary, psi, bound_opt,  &
  &                       a, b, c, d, e, undef, inner_bound )
! =ǥˡˤݥε
! ƥץ, ݥϤγʬ. ǥեȤϥꤵ.
! $$a\dfrac{\partial ^2\psi}{\partial x^2} +b\dfrac{\partial ^2\psi}{\partial x\partial y} +c\dfrac{\partial ^2\psi}{\partial y^2} +d\dfrac{\partial \psi}{\partial x} +e\dfrac{\partial \psi}{\partial y} =\rho $$
! γƷбƤ.
  implicit none
  real, intent(in) :: x(:)  ! ΰβɸ
  real, intent(in) :: y(:)  ! ΰνĺɸ
  real, intent(in) :: rho(size(x),size(y))  ! ݥζ
                   ! rho =0 ǥץ饹Ѳǽ
  real, intent(in) :: eps  ! «
  character(4), intent(in) :: boundary  ! 
                ! 4 ʸǳդζͿ.
                ! 1 ʸ : x ü, 2 ʸ : y ü, 3 ʸ : x ü,
                ! 4 ʸ : y ü
                ! boundary  1 : ü, 2 : ͳü, 3 : 
  real, intent(in), optional :: bound_opt(size(x),size(y))  ! Ǥζ
                             ! Υޥ󶭳ξ : եå
  real, intent(in), optional :: a(size(x),size(y))  ! ʬη
  real, intent(in), optional :: b(size(x),size(y))  ! ʬη
  real, intent(in), optional :: c(size(x),size(y))  ! ʬη
  real, intent(in), optional :: d(size(x),size(y))  ! ʬη
  real, intent(in), optional :: e(size(x),size(y))  ! ʬη
  real, intent(inout) :: psi(size(x),size(y))  ! ݥβ
  real, intent(in), optional :: undef  ! ̤
  integer, intent(in), optional :: inner_bound(size(x),size(y))
                             ! ΰζ. ͤ˱ƤγʻǶͷ׻
                             ! 1 = ü, 10 = ¦.
                             ! 2 = y ͳü (եåϾ)
                             ! -2 = y ͳü (եåϲ)
                             ! 4 = x ͳü (եåϱ)
                             ! -4 = x ͳü (եåϺ)
                             ! 3 = , -3 = ΰξȤ
                             ! 8 = |_, ~| ξȤ⼫ͳ
                             ! -8 = |~, _| ξȤ⼫ͳ
                             ! ΰͿʤΰ׻.
                             ! ¦ʻ (10) ȿ׻Ԥ鷺,
                             ! undef ꤵ줿ͤ⤷ϥ.
                             ! ΤȤζͤ bound_opt ͤѤ.
  integer :: i, j
  integer :: nx  ! x 
  integer :: ny  ! y 
  integer :: signb  ! Ʒ׻뤫ɤ
  integer, dimension(size(x),size(y)) :: ib

  real :: defun
  real :: tmp, err, err_max
  real :: tmp_b
  real :: bnd(size(x),size(y))
  real :: dx(size(x)), dy(size(y)), dx2(size(x)), dy2(size(y))
  real, dimension(size(x),size(y)) :: dxdy
  real, dimension(size(x),size(y)) :: at, bt, ct, dt, et
  real, dimension(size(x),size(y)) :: adp, adm, cep, cem, ac, divi

  character(4) :: bound
  logical, dimension(size(x),size(y)) :: inner_flag

  bound(1:4)=boundary(1:4)

  nx=size(x)
  ny=size(y)

!-- ؿν

  psi = 0.0

!-- Ƚ̥ե饰

  if(present(inner_bound))then
     call set_bound( bound, ib, inner_flag, inner_bound )
  else
     call set_bound( bound, ib, inner_flag )
  end if

!-- ΰ衦ˤ붭ͤ

  if(present(bound_opt))then
     call setval_bound( ib, bnd, psi, bound_opt )
  else
     call setval_bound( ib, bnd, psi )
  end if

!-- ̤ͤ

  if(present(undef))then
     defun=undef
  else
     defun=0.0
  end if

!-- 
!-- a, c ˤĤƤ, ͤƤʤ,  1 .
  if(present(a))then
     call set_coe( at, ext=a )
  else
     call set_coe( at, def=1.0 )
  end if

  if(present(c))then
     call set_coe( ct, ext=c )
  else
     call set_coe( ct, def=1.0 )
  end if

  if(present(b))then
     call set_coe( bt, ext=b )
     signb=1
  else
     call set_coe( bt, def=0.0 )
     signb=0
  end if

  if(present(d))then
     call set_coe( dt, ext=d )
  else
     call set_coe( dt, def=0.0 )
  end if

  if(present(e))then
     call set_coe( et, ext=e )
  else
     call set_coe( et, def=0.0 )
  end if

!-- ʲ˳ʻҴֳ 1 ׻Ǥ褤ΤƤ.
!--  1 ΤߤѲФ褤.
!-- ʻֳ֤η׻
  do i=2,nx-1
     dx(i)=(x(i+1)-x(i-1))*0.5
     dx2(i)=dx(i)**2
  end do
  do j=2,ny-1
     dy(j)=(y(j+1)-y(j-1))*0.5
     dy2(j)=dy(j)**2
  end do

  dx(1)=(x(2)-x(1))
  dx(nx)=(x(nx)-x(nx-1))
  dy(1)=(y(2)-y(1))
  dy(ny)=(y(ny)-y(ny-1))

  do j=1,ny
     do i=1,nx
        dxdy(i,j)=dx(i)*dy(j)
     end do
  end do

!-- ݥ󷸿η׻
!-- ºݤ˥ݥ󷸿ѤΤ,  1 ¦ʤΤ,
!-- ׻̺︺Τ, 롼פ򤽤Τ褦ˤƤ.

!-- ǹ⼡ ac η׻
!$omp parallel default(shared)
!$omp do private(i,j)

  do j=2,ny-1
     do i=2,nx-1
        ac(i,j)=2.0*(at(i,j)/dx2(i)+ct(i,j)/dy2(j))
        adp(i,j)=(at(i,j)/(dx2(i))+0.5*dt(i,j)/dx(i))/ac(i,j)
        adm(i,j)=(at(i,j)/(dx2(i))-0.5*dt(i,j)/dx(i))/ac(i,j)
        cep(i,j)=(ct(i,j)/(dy2(j))+0.5*et(i,j)/dy(j))/ac(i,j)
        cem(i,j)=(ct(i,j)/(dy2(j))-0.5*et(i,j)/dy(j))/ac(i,j)
        bt(i,j)=0.25*bt(i,j)/(dxdy(i,j))/ac(i,j)
     end do
  end do

!$omp end do
!$omp end parallel

  err_max=eps  ! while 뤿صŪ

!-- ºݤΥ ---
  do while(err_max>=eps)
     err_max=0.0

     do j=2,ny-1
        do i=2,nx-1

           tmp=-rho(i,j)/ac(i,j)
           divi(i,j)=1.0

!-- ʹ, ȿ׻ɬפμ 8 ˤĤƤ줾
!-- inner_flag ΥåƱŬڤͤ򤽤줾༡׻,
!-- , γʻҷ׻ԤäƤ뤬, ib=8,-8  4 ʻҤΤȤˤ
!-- case select ʤ. ʤʤ, 岼˶ʻҤ뤳ȤϤꤨʤ.
           if(inner_flag(i,j).eqv..false.)then  ! .false. ʤΰ׻
           !-- ʻ
              if(inner_flag(i+1,j).eqv..false.)then
                 tmp=tmp+adp(i,j)*psi(i+1,j)
              else
                 select case (ib(i+1,j))
                 case(1)
                    tmp=tmp+adp(i,j)*psi(i+1,j)
                 case(-2)  ! ʻҤ 2 Ϥꤨʤ.
                    tmp=tmp+adp(i,j)*bnd(i+1,j)*dx(i+1)
                    divi(i,j)=divi(i,j)-adp(i,j)
                 case(3)
                    tmp=tmp+adp(i,j)*psi(2,j)
                 case(4)
                    tmp=tmp+adp(i,j)*(psi(i+1,j+1)-bnd(i+1,j)*dy(j))
                 case(-4)
                    tmp=tmp+adp(i,j)*(psi(i+1,j-1)+bnd(i+1,j)*dy(j))
                 end select
              end if

           !-- ʻ
              if(inner_flag(i-1,j).eqv..false.)then
                 tmp=tmp+adm(i,j)*psi(i-1,j)
              else
                 select case (ib(i-1,j))
                 case(1)
                    tmp=tmp+adm(i,j)*psi(i-1,j)
                 case(2)  ! ʻҤ -2 Ϥꤨʤ.
                    tmp=tmp-adm(i,j)*bnd(i-1,j)*dx(i-1)
                    divi(i,j)=divi(i,j)-adm(i,j)
                 case(3)
                    tmp=tmp+adm(i,j)*psi(nx-1,j)
                 case(4)
                    tmp=tmp+adm(i,j)*(psi(i-1,j+1)-bnd(i-1,j)*dy(j))
                 case(-4)
                    tmp=tmp+adm(i,j)*(psi(i-1,j-1)+bnd(i-1,j)*dy(j))
                 end select
              end if

           !-- ʻ
              if(inner_flag(i,j+1).eqv..false.)then
                 tmp=tmp+cep(i,j)*psi(i,j+1)
              else
                 select case (ib(i,j+1))
                 case(1)
                    tmp=tmp+cep(i,j)*psi(i,j+1)
                 case(2)
                    tmp=tmp+cep(i,j)*(psi(i+1,j+1)-bnd(i,j+1)*dx(i))
                 case(-2)
                    tmp=tmp+cep(i,j)*(psi(i-1,j+1)+bnd(i,j+1)*dx(i))
                 case(3)
                    tmp=tmp+cep(i,j)*psi(i,2)
                 case(-4)  ! ʻҤ 4 Ϥꤨʤ.
                    tmp=tmp+cep(i,j)*bnd(i,j+1)*dy(j+1)
                    divi(i,j)=divi(i,j)-cep(i,j)
                 end select
              end if

           !-- ʻ
              if(inner_flag(i,j-1).eqv..false.)then
                 tmp=tmp+cem(i,j)*psi(i,j-1)
              else
                 select case (ib(i,j-1))
                 case(1)
                    tmp=tmp+cem(i,j)*psi(i,j-1)
                 case(2)
                    tmp=tmp+cem(i,j)*(psi(i+1,j-1)-bnd(i,j-1)*dx(i))
                 case(-2)
                    tmp=tmp+cem(i,j)*(psi(i-1,j-1)+bnd(i,j-1)*dx(i))
                 case(3)
                    tmp=tmp+cem(i,j)*psi(i,ny-1)
                 case(4)  ! ʻҤ -4 Ϥꤨʤ.
                    tmp=tmp-cem(i,j)*bnd(i,j-1)*dy(j-1)
                    divi(i,j)=divi(i,j)-cem(i,j)
                 end select
              end if

           !-- 4 ʻ
              if(signb==1)then  ! ⤽ bt = 0 ʤ׻ʤ.
                 tmp_b=0.0
                 select case (ib(i-1,j-1))  ! ʻ
                 case(1)
                    tmp_b=tmp_b+psi(i-1,j-1)
                 case(2)
                    tmp_b=tmp_b+psi(i,j-1)-bnd(i-1,j-1)*dx(i-1)
                 case(-2)
                    tmp_b=tmp_b+psi(i-2,j-1)+bnd(i-1,j-1)*dx(i-1)
                 case(4)
                    tmp_b=tmp_b+psi(i-1,j)-bnd(i-1,j-1)*dy(j-1)
                 case(-4)
                    tmp_b=tmp_b+psi(i-1,j-2)+bnd(i-1,j-1)*dy(j-1)
                 case(3)  ! Ǽʤ, i==2  j==2 ꤨʤ.
                    if(i==2)then
                       tmp_b=tmp_b+psi(nx-1,j-1)
                    else if(j==2)then
                       tmp_b=tmp_b+psi(i-1,ny-1)
                    end if
                 case(-3)  !  -3 ʤ, ΰκʤ.
                    tmp_b=tmp_b+psi(nx-1,ny-1)
                 case(8)  ! Ǥ -8 ¸ߤʤ
                    divi(i,j)=divi(i,j)-bt(i,j)
                    tmp_b=tmp_b  &
  &                            -0.5*(bnd(i,j-1)*dy(j-1)+bnd(i-1,j)*dx(i-1))

                 end select
                 
                 select case (ib(i+1,j+1))  ! ʻ
                 case(1)
                    tmp_b=tmp_b+psi(i+1,j+1)
                 case(2)
                    tmp_b=tmp_b+psi(i,j+2)-bnd(i+1,j+1)*dx(i+1)
                 case(-2)
                    tmp_b=tmp_b+psi(i,j+1)+bnd(i+1,j+1)*dx(i+1)
                 case(4)
                    tmp_b=tmp_b+psi(i+1,j+2)-bnd(i+1,j+1)*dy(j+1)
                 case(-4)
                    tmp_b=tmp_b+psi(i+1,j)+bnd(i+1,j+1)*dy(j+1)
                 case(3)  ! ξ,  i==nx-1  j==ny-1 ʤ.
                    if(i==nx-1)then
                       tmp_b=tmp_b+psi(2,j-1)
                    else if(j==ny-1)then
                       tmp_b=tmp_b+psi(i-1,2)
                    end if
                 case(-3)  !  -3 ʤ, ΰαʤ.
                    tmp_b=tmp_b+psi(2,2)
                 case(8)  ! Ǥ -8 ¸ߤʤ
                    divi(i,j)=divi(i,j)-bt(i,j)
                    tmp_b=tmp_b  &
  &                            +0.5*(bnd(i,j+1)*dy(j+1)+bnd(i+1,j)*dx(i+1))

                 end select

                 select case (ib(i-1,j+1))  ! ʻ
                 case(1)
                    tmp_b=tmp_b+psi(i-1,j+1)
                 case(2)
                    tmp_b=tmp_b+psi(i,j+1)-bnd(i-1,j+1)*dx(i-1)
                 case(-2)
                    tmp_b=tmp_b+psi(i-2,j+1)+bnd(i-1,j+1)*dx(i-1)
                 case(4)
                    tmp_b=tmp_b+psi(i-1,j+2)-bnd(i-1,j+1)*dy(j+1)
                 case(-4)
                    tmp_b=tmp_b+psi(i-1,j)+bnd(i-1,j+1)*dy(j+1)
                 case(3)  ! Ǽʤ, i==2  j==ny-1 ꤨʤ.
                    if(i==2)then
                       tmp_b=tmp_b+psi(nx-1,j-1)
                    else if(j==ny-1)then
                       tmp_b=tmp_b+psi(i-1,2)
                    end if
                 case(-3)  !  -3 ʤ, ΰκʤ.
                    tmp_b=tmp_b+psi(nx-1,2)
                 case(-8)  ! Ǥ 8 ¸ߤʤ
                    divi(i,j)=divi(i,j)-bt(i,j)
                    tmp_b=tmp_b  &
  &                            +0.5*(bnd(i,j+1)*dy(j+1)-bnd(i-1,j)*dx(i-1))

                 end select

                 select case (ib(i+1,j-1))  ! ʻ
                 case(1)
                    tmp_b=tmp_b+psi(i+1,j-1)
                 case(2)
                    tmp_b=tmp_b+psi(i+2,j-1)-bnd(i+1,j-1)*dx(i+1)
                 case(-2)
                    tmp_b=tmp_b+psi(i,j-1)+bnd(i+1,j-1)*dx(i+1)
                 case(4)
                    tmp_b=tmp_b+psi(i-1,j)-bnd(i+1,j-1)*dy(j-1)
                 case(-4)
                    tmp_b=tmp_b+psi(i-1,j-2)+bnd(i+1,j-1)*dy(j-1)
                 case(3)  ! Ǽʤ, i==nx-1  j==2 ꤨʤ.
                    if(i==nx-1)then
                       tmp_b=tmp_b+psi(2,j-1)
                    else if(j==2)then
                       tmp_b=tmp_b+psi(i+1,ny-1)
                    end if
                 case(-3)  !  -3 ʤ, ΰαʤ.
                    tmp_b=tmp_b+psi(2,ny-1)
                 case(-8)  ! Ǥ 8 ¸ߤʤ
                    divi(i,j)=divi(i,j)-bt(i,j)
                    tmp_b=tmp_b  &
  &                            +0.5*(-bnd(i,j-1)*dy(j-1)+bnd(i+1,j)*dx(i+1))

                 end select
              end if

              tmp=tmp+bt(i,j)*tmp_b
              tmp=tmp/divi(i,j)

           end if

           err=abs(tmp-psi(i,j))

!-- ι
           if(err_max<=err)then
              err_max=err
           end if

           psi(i,j)=tmp

        end do
     end do

  end do

!-- 

  call calculate_bound( ib, dx, dy, bnd, psi )

!-- ̤ΰˤ undef .

  do j=1,ny
     do i=1,nx
        if(ib(i,j)==10)then
           psi(i,j)=defun
        end if
     end do
  end do

end subroutine Poisson_GauSei


subroutine Poisson_Jacobi(x, y, rho, eps, boundary, psi, bound_opt,  &
  &                       a, b, c, d, e, undef, inner_bound )
  ! openmp ˤ륹å󤬲ǽ.
  ! ǥˡǤϥ르ꥺ󲽤Ȼפ줿Τ,
  ! ׻ˤݥεѤɬפȤʤʤ,
  ! 䥳ˡΤΤѤ줿.
  implicit none
  real, intent(in) :: x(:)  ! ΰβɸ
  real, intent(in) :: y(:)  ! ΰνĺɸ
  real, intent(in) :: rho(size(x),size(y))  ! ݥζ
                   ! rho =0 ǥץ饹Ѳǽ
  real, intent(in) :: eps  ! «
  character(4), intent(in) :: boundary  ! 
                ! 4 ʸǳդζͿ.
                ! 1 ʸ : x ü, 2 ʸ : y ü, 3 ʸ : x ü,
                ! 4 ʸ : y ü
                ! boundary  1 : ü, 2 : ͳü, 3 : 
  real, intent(in), optional :: bound_opt(size(x),size(y))  ! Ǥζ
                             ! Υޥ󶭳ξ : եå
  real, intent(in), optional :: a(size(x),size(y))  ! ʬη
  real, intent(in), optional :: b(size(x),size(y))  ! ʬη
  real, intent(in), optional :: c(size(x),size(y))  ! ʬη
  real, intent(in), optional :: d(size(x),size(y))  ! ʬη
  real, intent(in), optional :: e(size(x),size(y))  ! ʬη
  real, intent(in), optional :: undef  ! ̤
  integer, intent(in), optional :: inner_bound(size(x),size(y))
                             ! ΰζ. ͤ˱ƤγʻǶͷ׻
                             ! 1 = ü, 10 = ¦.
                             ! 2 = y ͳü (եåϾ)
                             ! -2 = y ͳü (եåϲ)
                             ! 4 = x ͳü (եåϱ)
                             ! -4 = x ͳü (եåϺ)
                             ! 3 = , -3 = ΰξȤ
                             ! 8 = |_, ~| ξȤ⼫ͳ
                             ! -8 = |~, _| ξȤ⼫ͳ
                             ! ΰͿʤΰ׻.
                             ! ¦ʻ (10) ȿ׻Ԥ鷺,
                             ! undef ꤵ줿ͤ⤷ϥ.
                             ! ΤȤζͤ bound_opt ͤѤ.
  real, intent(inout) :: psi(size(x),size(y))  ! ݥβ

  integer :: i, j
  integer :: nx  ! x 
  integer :: ny  ! y 
  integer :: signb  !  b ¸ߤ뤫
  integer, dimension(size(x),size(y)) :: ib

  real :: defun
  real :: err, err_max
  real :: bnd(size(x),size(y))
  real :: dx(size(x)), dy(size(y)), dx2(size(x)), dy2(size(y))
  real, dimension(size(x),size(y)) :: dxdy
  real, dimension(size(x),size(y)) :: at, bt, ct, dt, et
  real, dimension(size(x),size(y)) :: adp, adm, cep, cem, ac
  real, dimension(size(x),size(y)) :: tmp, tmp_b, divi

  character(4) :: bound
  logical, dimension(size(x),size(y)) :: inner_flag

  bound(1:4)=boundary(1:4)

  nx=size(x)
  ny=size(y)

!-- ؿν

  psi = 0.0

!-- Ƚ̥ե饰

  if(present(inner_bound))then
     call set_bound( bound, ib, inner_flag, inner_bound )
  else
     call set_bound( bound, ib, inner_flag )
  end if

!-- ΰ衦ˤ붭ͤ

  if(present(bound_opt))then
     call setval_bound( ib, bnd, psi, bound_opt )
  else
     call setval_bound( ib, bnd, psi )
  end if

!-- ̤ͤ

  if(present(undef))then
     defun=undef
  else
     defun=0.0
  end if

!-- 
!-- a, c ˤĤƤ, ͤƤʤ,  1 .

  if(present(a))then
     call set_coe( at, ext=a )
  else
     call set_coe( at, def=1.0 )
  end if

  if(present(c))then
     call set_coe( ct, ext=c )
  else
     call set_coe( ct, def=1.0 )
  end if

  if(present(b))then
     call set_coe( bt, ext=b )
     signb=1
  else
     call set_coe( bt, def=0.0 )
     signb=0
  end if

  if(present(d))then
     call set_coe( dt, ext=d )
  else
     call set_coe( dt, def=0.0 )
  end if

  if(present(e))then
     call set_coe( et, ext=e )
  else
     call set_coe( et, def=0.0 )
  end if

!-- ʲ˳ʻҴֳ 1 ׻Ǥ褤ΤƤ.
!--  1 ΤߤѲФ褤.
!-- ʻֳ֤η׻
  do i=2,nx-1
     dx(i)=(x(i+1)-x(i-1))*0.5
     dx2(i)=dx(i)**2
  end do
  do j=2,ny-1
     dy(j)=(y(j+1)-y(j-1))*0.5
     dy2(j)=dy(j)**2
  end do

  dx(1)=(x(2)-x(1))
  dx(nx)=(x(nx)-x(nx-1))
  dy(1)=(y(2)-y(1))
  dy(ny)=(y(ny)-y(ny-1))

  do j=1,ny
     do i=1,nx
        dxdy(i,j)=dx(i)*dy(j)
     end do
  end do

!-- ݥ󷸿η׻
!-- ºݤ˥ݥ󷸿ѤΤ,  1 ¦ʤΤ,
!-- ׻̺︺Τ, 롼פ򤽤Τ褦ˤƤ.

!-- ǹ⼡ ac η׻
!$omp parallel default(shared)
!$omp do private(i,j)

  do j=2,ny-1
     do i=2,nx-1
        ac(i,j)=2.0*(at(i,j)/dx2(i)+ct(i,j)/dy2(j))
        adp(i,j)=(at(i,j)/(dx2(i))+0.5*dt(i,j)/dx(i))/ac(i,j)
        adm(i,j)=(at(i,j)/(dx2(i))-0.5*dt(i,j)/dx(i))/ac(i,j)
        cep(i,j)=(ct(i,j)/(dy2(j))+0.5*et(i,j)/dy(j))/ac(i,j)
        cem(i,j)=(ct(i,j)/(dy2(j))-0.5*et(i,j)/dy(j))/ac(i,j)
        bt(i,j)=0.25*bt(i,j)/(dxdy(i,j))/ac(i,j)
     end do
  end do

!$omp end do
!$omp end parallel

  err_max=eps  ! while 뤿صŪ

!-- ºݤΥ ---
  do while(err_max>=eps)
     err_max=0.0
!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j)
     do j=2,ny-1
        do i=2,nx-1

           tmp(i,j)=-rho(i,j)/ac(i,j)
           divi(i,j)=1.0

!-- ʹ, ȿ׻ɬפμ 8 ˤĤƤ줾
!-- inner_flag ΥåƱŬڤͤ򤽤줾༡׻,
!-- , γʻҷ׻ԤäƤ뤬, ib=8,-8  4 ʻҤΤȤˤ
!-- case select ʤ. ʤʤ, 岼˶ʻҤ뤳ȤϤꤨʤ.
           if(inner_flag(i,j).eqv..false.)then  ! .false. ʤΰ׻
           !-- ʻ
              if(inner_flag(i+1,j).eqv..false.)then
                 tmp(i,j)=tmp(i,j)+adp(i,j)*psi(i+1,j)
              else
                 select case (ib(i+1,j))
                 case(1)
                    tmp(i,j)=tmp(i,j)+adp(i,j)*psi(i+1,j)
                 case(-2)  ! ʻҤ 2 Ϥꤨʤ.
                    tmp(i,j)=tmp(i,j)+adp(i,j)*bnd(i+1,j)*dx(i+1)
                    divi(i,j)=divi(i,j)-adp(i,j)
                 case(3)
                    tmp(i,j)=tmp(i,j)+adp(i,j)*psi(2,j)
                 case(4)
                    tmp(i,j)=tmp(i,j)+adp(i,j)*(psi(i+1,j+1)-bnd(i+1,j)*dy(j))
                 case(-4)
                    tmp(i,j)=tmp(i,j)+adp(i,j)*(psi(i+1,j-1)+bnd(i+1,j)*dy(j))
                 end select
              end if

           !-- ʻ
              if(inner_flag(i-1,j).eqv..false.)then
                 tmp(i,j)=tmp(i,j)+adm(i,j)*psi(i-1,j)
              else
                 select case (ib(i-1,j))
                 case(1)
                    tmp(i,j)=tmp(i,j)+adm(i,j)*psi(i-1,j)
                 case(2)  ! ʻҤ -2 Ϥꤨʤ.
                    tmp(i,j)=tmp(i,j)-adm(i,j)*bnd(i-1,j)*dx(i-1)
                    divi(i,j)=divi(i,j)-adm(i,j)
                 case(3)
                    tmp(i,j)=tmp(i,j)+adm(i,j)*psi(nx-1,j)
                 case(4)
                    tmp(i,j)=tmp(i,j)+adm(i,j)*(psi(i-1,j+1)-bnd(i-1,j)*dy(j))
                 case(-4)
                    tmp(i,j)=tmp(i,j)+adm(i,j)*(psi(i-1,j-1)+bnd(i-1,j)*dy(j))
                 end select
              end if

           !-- ʻ
              if(inner_flag(i,j+1).eqv..false.)then
                 tmp(i,j)=tmp(i,j)+cep(i,j)*psi(i,j+1)
              else
                 select case (ib(i,j+1))
                 case(1)
                    tmp(i,j)=tmp(i,j)+cep(i,j)*psi(i,j+1)
                 case(2)
                    tmp(i,j)=tmp(i,j)+cep(i,j)*(psi(i+1,j+1)-bnd(i,j+1)*dx(i))
                 case(-2)
                    tmp(i,j)=tmp(i,j)+cep(i,j)*(psi(i-1,j+1)+bnd(i,j+1)*dx(i))
                 case(3)
                    tmp(i,j)=tmp(i,j)+cep(i,j)*psi(i,2)
                 case(-4)  ! ʻҤ 4 Ϥꤨʤ.
                    tmp(i,j)=tmp(i,j)+cep(i,j)*bnd(i,j+1)*dy(j+1)
                    divi(i,j)=divi(i,j)-cep(i,j)
                 end select
              end if

           !-- ʻ
              if(inner_flag(i,j-1).eqv..false.)then
                 tmp(i,j)=tmp(i,j)+cem(i,j)*psi(i,j-1)
              else
                 select case (ib(i,j-1))
                 case(1)
                    tmp(i,j)=tmp(i,j)+cem(i,j)*psi(i,j-1)
                 case(2)
                    tmp(i,j)=tmp(i,j)+cem(i,j)*(psi(i+1,j-1)-bnd(i,j-1)*dx(i))
                 case(-2)
                    tmp(i,j)=tmp(i,j)+cem(i,j)*(psi(i-1,j-1)+bnd(i,j-1)*dx(i))
                 case(3)
                    tmp(i,j)=tmp(i,j)+cem(i,j)*psi(i,ny-1)
                 case(4)  ! ʻҤ -4 Ϥꤨʤ.
                    tmp(i,j)=tmp(i,j)-cem(i,j)*bnd(i,j-1)*dy(j-1)
                    divi(i,j)=divi(i,j)-cem(i,j)
                 end select
              end if

           !-- 4 ʻ
              if(signb==1)then  ! ⤽ bt = 0 ʤ׻ʤ.
                 tmp_b(i,j)=0.0
                 select case (ib(i-1,j-1))  ! ʻ
                 case(1)
                    tmp_b(i,j)=tmp_b(i,j)+psi(i-1,j-1)
                 case(2)
                    tmp_b(i,j)=tmp_b(i,j)+psi(i,j-1)-bnd(i-1,j-1)*dx(i-1)
                 case(-2)
                    tmp_b(i,j)=tmp_b(i,j)+psi(i-2,j-1)+bnd(i-1,j-1)*dx(i-1)
                 case(4)
                    tmp_b(i,j)=tmp_b(i,j)+psi(i-1,j)-bnd(i-1,j-1)*dy(j-1)
                 case(-4)
                    tmp_b(i,j)=tmp_b(i,j)+psi(i-1,j-2)+bnd(i-1,j-1)*dy(j-1)
                 case(3)  ! Ǽʤ, i==2  j==2 ꤨʤ.
                    if(i==2)then
                       tmp_b(i,j)=tmp_b(i,j)+psi(nx-1,j-1)
                    else if(j==2)then
                       tmp_b(i,j)=tmp_b(i,j)+psi(i-1,ny-1)
                    end if
                 case(-3)  !  -3 ʤ, ΰκʤ.
                    tmp_b(i,j)=tmp_b(i,j)+psi(nx-1,ny-1)
                 case(8)  ! Ǥ -8 ¸ߤʤ
                    divi(i,j)=divi(i,j)-bt(i,j)
                    tmp_b(i,j)=tmp_b(i,j)  &
  &                            -0.5*(bnd(i,j-1)*dy(j-1)+bnd(i-1,j)*dx(i-1))

                 end select
                 
                 select case (ib(i+1,j+1))  ! ʻ
                 case(1)
                    tmp_b(i,j)=tmp_b(i,j)+psi(i+1,j+1)
                 case(2)
                    tmp_b(i,j)=tmp_b(i,j)+psi(i,j+2)-bnd(i+1,j+1)*dx(i+1)
                 case(-2)
                    tmp_b(i,j)=tmp_b(i,j)+psi(i,j+1)+bnd(i+1,j+1)*dx(i+1)
                 case(4)
                    tmp_b(i,j)=tmp_b(i,j)+psi(i+1,j+2)-bnd(i+1,j+1)*dy(j+1)
                 case(-4)
                    tmp_b(i,j)=tmp_b(i,j)+psi(i+1,j)+bnd(i+1,j+1)*dy(j+1)
                 case(3)  ! ξ,  i==nx-1  j==ny-1 ʤ.
                    if(i==nx-1)then
                       tmp_b(i,j)=tmp_b(i,j)+psi(2,j-1)
                    else if(j==ny-1)then
                       tmp_b(i,j)=tmp_b(i,j)+psi(i-1,2)
                    end if
                 case(-3)  !  -3 ʤ, ΰαʤ.
                    tmp_b(i,j)=tmp_b(i,j)+psi(2,2)
                 case(8)  ! Ǥ -8 ¸ߤʤ
                    divi(i,j)=divi(i,j)-bt(i,j)
                    tmp_b(i,j)=tmp_b(i,j)  &
  &                            +0.5*(bnd(i,j+1)*dy(j+1)+bnd(i+1,j)*dx(i+1))

                 end select

                 select case (ib(i-1,j+1))  ! ʻ
                 case(1)
                    tmp_b(i,j)=tmp_b(i,j)+psi(i-1,j+1)
                 case(2)
                    tmp_b(i,j)=tmp_b(i,j)+psi(i,j+1)-bnd(i-1,j+1)*dx(i-1)
                 case(-2)
                    tmp_b(i,j)=tmp_b(i,j)+psi(i-2,j+1)+bnd(i-1,j+1)*dx(i-1)
                 case(4)
                    tmp_b(i,j)=tmp_b(i,j)+psi(i-1,j+2)-bnd(i-1,j+1)*dy(j+1)
                 case(-4)
                    tmp_b(i,j)=tmp_b(i,j)+psi(i-1,j)+bnd(i-1,j+1)*dy(j+1)
                 case(3)  ! Ǽʤ, i==2  j==ny-1 ꤨʤ.
                    if(i==2)then
                       tmp_b(i,j)=tmp_b(i,j)+psi(nx-1,j-1)
                    else if(j==ny-1)then
                       tmp_b(i,j)=tmp_b(i,j)+psi(i-1,2)
                    end if
                 case(-3)  !  -3 ʤ, ΰκʤ.
                    tmp_b(i,j)=tmp_b(i,j)+psi(nx-1,2)
                 case(-8)  ! Ǥ 8 ¸ߤʤ
                    divi(i,j)=divi(i,j)-bt(i,j)
                    tmp_b(i,j)=tmp_b(i,j)  &
  &                            +0.5*(bnd(i,j+1)*dy(j+1)-bnd(i-1,j)*dx(i-1))

                 end select

                 select case (ib(i+1,j-1))  ! ʻ
                 case(1)
                    tmp_b(i,j)=tmp_b(i,j)+psi(i+1,j-1)
                 case(2)
                    tmp_b(i,j)=tmp_b(i,j)+psi(i+2,j-1)-bnd(i+1,j-1)*dx(i+1)
                 case(-2)
                    tmp_b(i,j)=tmp_b(i,j)+psi(i,j-1)+bnd(i+1,j-1)*dx(i+1)
                 case(4)
                    tmp_b(i,j)=tmp_b(i,j)+psi(i-1,j)-bnd(i+1,j-1)*dy(j-1)
                 case(-4)
                    tmp_b(i,j)=tmp_b(i,j)+psi(i-1,j-2)+bnd(i+1,j-1)*dy(j-1)
                 case(3)  ! Ǽʤ, i==nx-1  j==2 ꤨʤ.
                    if(i==nx-1)then
                       tmp_b(i,j)=tmp_b(i,j)+psi(2,j-1)
                    else if(j==2)then
                       tmp_b(i,j)=tmp_b(i,j)+psi(i+1,ny-1)
                    end if
                 case(-3)  !  -3 ʤ, ΰαʤ.
                    tmp_b(i,j)=tmp_b(i,j)+psi(2,ny-1)
                 case(-8)  ! Ǥ 8 ¸ߤʤ
                    divi(i,j)=divi(i,j)-bt(i,j)
                    tmp_b(i,j)=tmp_b(i,j)  &
  &                            +0.5*(-bnd(i,j-1)*dy(j-1)+bnd(i+1,j)*dx(i+1))

                 end select
              end if

              tmp(i,j)=tmp(i,j)+bt(i,j)*tmp_b(i,j)
              tmp(i,j)=tmp(i,j)/divi(i,j)

           end if
        end do
     end do
!$omp end do
!$omp end parallel

!!-- ޤǤ if ʸΥǥȤĴᤷʤ.
!        end if
!
!        tmp=tmp/ac(i,j)
!-- η׻ ---
     do j=2,ny-1
        do i=2,nx-1
           err=abs(tmp(i,j)-psi(i,j))

!-- ι
           if(err_max<=err)then
              err_max=err
           end if
        end do
     end do

!-- ƹ

     do j=2,ny-1
        do i=2,nx-1
           psi(i,j)=tmp(i,j)
        end do
     end do

  end do
  
!-- 

  call calculate_bound( ib, dx, dy, bnd, psi )

!-- ̤ΰˤ undef .

  do j=1,ny
     do i=1,nx
        if(ib(i,j)==10)then
           psi(i,j)=defun
        end if
     end do
  end do

end subroutine Poisson_Jacobi

!-----------------------------------
! ʲ, private subroutine
!-----------------------------------

subroutine set_bound( bound, ib, inner_flag, inner_bound )
! ȿˡ롼ˤꤵ붭Υե饰å, ꤹ.
  implicit none
  character(4), intent(in) :: bound   ! ΰ趭Υե饰
  integer, intent(inout) :: ib(:,:)   ! Ƚ
  logical, intent(inout) :: inner_flag(size(ib,1),size(ib,2))
                            ! ΰ趭ե饰
  integer, intent(in), optional :: inner_bound(size(ib,1),size(ib,2))
                            ! ΰ趭Ƚ
  integer :: i, j, nx, ny

  nx=size(ib,1)
  ny=size(ib,2)

!-- ѿν

  ib=0
  inner_flag=.false.

!-- ǧ.
!-- ʤΤ, ξüȤ 3 ꤵƤʤȤʤ.
  if(bound(1:1)=='3')then
     if(bound(3:3)/='3')then
        write(*,*) "### ERROR ###"
        write(*,*) "if bound = 3, bound(1:1)==bound(3:3). STOP."
        stop
     end if
  end if

  if(bound(3:3)=='3')then
     if(bound(1:1)/='3')then
        write(*,*) "### ERROR ###"
        write(*,*) "if bound = 3, bound(1:1)==bound(3:3). STOP."
        stop
     end if
  end if

  if(bound(2:2)=='3')then
     if(bound(4:4)/='3')then
        write(*,*) "### ERROR ###"
        write(*,*) "if bound = 3, bound(2:2)==bound(4:4). STOP."
        stop
     end if
  end if

  if(bound(4:4)=='3')then
     if(bound(2:2)/='3')then
        write(*,*) "### ERROR ###"
        write(*,*) "if bound = 3, bound(2:2)==bound(4:4). STOP."
        stop
     end if
  end if

  select case (bound(1:1))
  case ('1')
     do i=2,nx-1
        ib(i,1)=1
     end do

  case ('2')
     do i=2,nx-1
        ib(i,1)=4  ! y ΥեåǻͤϾ¦
     end do

  case ('3')
     do i=2,nx-1
        ib(i,1)=3  ! y  (x ) 
     end do
  end select

  select case (bound(2:2))
  case ('1')
     do j=2,ny-1
        ib(1,j)=1
     end do

  case ('2')
     do j=2,ny-1
        ib(1,j)=2  ! x Υեåǻͤϱ¦
     end do

  case ('3')
     do j=2,ny-1
        ib(1,j)=-3  ! x  (y ) 
     end do
  end select

  select case (bound(3:3))
  case ('1')
     do i=2,nx-1
        ib(i,ny)=1
     end do

  case ('2')
     do i=2,nx-1
        ib(i,ny)=-4  ! y Υեåǻͤϲ¦
     end do

  case ('3')
     do i=2,nx-1
        ib(i,ny)=3  ! y  (x ) 
     end do
  end select

  select case (bound(4:4))
  case ('1')
     do j=2,ny-1
        ib(nx,j)=1
     end do

  case ('2')
     do j=2,ny-1
        ib(nx,j)=-2  ! x ΥեåǻͤϺ¦
     end do

  case ('3')
     do j=2,ny-1
        ib(nx,j)=-3  ! x  (y ) 
     end do
  end select

!-- ΰ 2 դŤʤΤ, Ǥζˡϰʲνͥ褹.
!-- (1) ɤ餫 1 ΤȤ, ΰ 1,
!-- (2) (1) ʳǤɤ餫 3 ΤȤ, ΰ 3.
!-- (3) (1), (2) ʳ 2. Ĥޤ, ξȤ 2 ʤ 2 Ȥʤ.

  ib(1,1)=0
  ib(1,ny)=0
  ib(nx,1)=0
  ib(nx,ny)=0

  if(bound(1:1)=='1')then
     ib(1,1)=1
     ib(nx,1)=1
  end if
  if(bound(2:2)=='1')then
     ib(1,1)=1
     ib(1,ny)=1
  end if
  if(bound(3:3)=='1')then
     ib(1,ny)=1
     ib(nx,ny)=1
  end if
  if(bound(4:4)=='1')then
     ib(nx,1)=1
     ib(nx,ny)=1
  end if

!-- 4 Ȥξ
  if(bound(1:2)=='33')then
     ib(1,1)=-3
     ib(1,ny)=-3
     ib(nx,1)=-3
     ib(nx,ny)=-3
  end if

  if(bound(1:1)=='3')then
     if(ib(1,1)==0)then
        ib(1,1)=3
     end if
     if(ib(nx,1)==0)then
        ib(nx,1)=3
     end if
  end if
  if(bound(2:2)=='3')then
     if(ib(1,1)==0)then
        ib(1,1)=3
     end if
     if(ib(1,ny)==0)then
        ib(1,ny)=3
     end if
  end if
  if(bound(3:3)=='3')then
     if(ib(1,ny)==0)then
        ib(1,ny)=3
     end if
     if(ib(nx,ny)==0)then
        ib(nx,ny)=3
     end if
  end if
  if(bound(4:4)=='3')then
     if(ib(nx,1)==0)then
        ib(nx,1)=3
     end if
     if(ib(nx,ny)==0)then
        ib(nx,ny)=3
     end if
  end if

!-- ΰζǤ뤳Ȥ 8, -8 Ǽ.
!-- 8 ξ, Ǥ뤳Ȥ, -8 ξ, 夫Ǥ뤳Ȥ򼨤.

  if(ib(1,1)==0)then
     ib(1,1)=8
  end if
  if(ib(nx,1)==0)then
     ib(nx,1)=-8
  end if
  if(ib(1,ny)==0)then
     ib(1,ny)=-8
  end if
  if(ib(nx,ny)==0)then
     ib(nx,ny)=8
  end if

!-- 

  if(present(inner_bound))then
     do j=2,ny-1
        do i=2,nx-1
           ib(i,j)=inner_bound(i,j)
           if(inner_bound(i,j)/=0)then
              inner_flag(i,j)=.true.
           end if
        end do
     end do
  end if

  do i=1,nx  ! inner_bound ꤵƤ˴ؤ餺, ΰüϷ׻ʤ.
     inner_flag(i,1)=.true.
     inner_flag(i,ny)=.true.
  end do

  do j=1,ny
     inner_flag(1,j)=.true.
     inner_flag(nx,j)=.true.
  end do

end subroutine set_bound

subroutine setval_bound( ib, bnd, psi, bound_opt )
! ͤ򶭳ȽȤꤹ.
  implicit none
  integer, intent(in) :: ib(:,:)  ! Ƚ
  real, intent(inout) :: bnd(size(ib,1),size(ib,2))  ! Ǥ
  real, intent(inout) :: psi(size(ib,1),size(ib,2))  ! 
  real, intent(in), optional :: bound_opt(size(ib,1),size(ib,2))  ! Ǥ
  integer :: i, j, nx, ny

  nx=size(ib,1)
  ny=size(ib,2)

!-- ͤ
  if(present(bound_opt))then
     do j=1,ny
        do i=1,nx
           bnd(i,j)=bound_opt(i,j)
        end do
     end do
  else
     do j=1,ny
        do i=1,nx
           bnd(i,j)=0.0
        end do
     end do
  end if

!--  "ib(i,j)==1 ξΤ"
!-- ΰˤĤƤ⤳Ƥޤ.

  do j=1,ny
     do i=1,nx
        if(ib(i,j)==1)then
           psi(i,j)=bnd(i,j)
        end if
     end do
  end do

end subroutine setval_bound

subroutine set_coe( coe, ext, def )
! 2  ext ǻꤵ줿ͤ⤷ def ǻꤵ줿ͤ.
! ext, def ɤ optional Ǥ뤬, ɬɤ餫ϻꤵƤʤȤʤ.
  implicit none
  real, intent(inout) :: coe(:,:)  ! 
  real, intent(in), optional :: ext(size(coe,1),size(coe,2))  ! 
  real, intent(in), optional :: def  ! 
  integer :: i, j, nx, ny

  nx=size(coe,1)
  ny=size(coe,2)

  if(present(ext))then
     do j=1,ny
        do i=1,nx
           coe(i,j)=ext(i,j)
        end do
     end do
  else if(present(def))then
     do j=1,ny
        do i=1,nx
           coe(i,j)=def
        end do
     end do
  else
     write(*,*) "### ERROR ###"
     write(*,*) "subroutine set_coe must be set optional argument 'ext' or 'def'"
     write(*,*) "STOP."
     stop
  end if

end subroutine set_coe

subroutine calculate_bound( ib, dx, dy, bnd, psi )
! ib Ƚ̤򸵤, Υޥ, ˤĤƶͤ׻.
! ǥꥯ췿˷׻ƤΤǤǤϷ׻ʤ.
  integer, intent(in) :: ib(:,:)  ! Ƚ
  real, intent(in) :: dx(size(ib,1))  ! x γʻҲ
  real, intent(in) :: dy(size(ib,2))  ! y γʻҲ
  real, intent(in) :: bnd(size(ib,1),size(ib,2))  ! (Υޥ󷿤Τ߻)
  real, intent(inout) :: psi(size(ib,1),size(ib,2))  ! ؿ
  integer :: i, j, nx, ny

  nx=size(ib,1)
  ny=size(ib,2)

  do j=1,ny
     do i=1,nx
        select case (ib(i,j))
        case (2)  ! x ˥եå, ¦
           psi(i,j)=psi(i+1,j)-bnd(i,j)*dx(i)
        case (-2)  ! x ˥եå, ¦
           psi(i,j)=psi(i-1,j)+bnd(i,j)*dx(i)
        case (4)  ! y ˥եå, ¦
           psi(i,j)=psi(i,j+1)-bnd(i,j)*dy(j)
        case (-4)  ! y ˥եå, ¦
           psi(i,j)=psi(i,j-1)+bnd(i,j)*dy(j)
        case (3)  ! 
           if(j==1)then
              psi(i,j)=psi(i,ny-1)
           else if(j==ny)then
              psi(i,j)=psi(i,2)
           else if(i==1)then
              psi(i,j)=psi(nx-1,j)
           else if(i==nx)then
              psi(i,j)=psi(2,j)
           end if
        case (-3)  ! 4 Ʊ
           if(i==1.and.j==1)then
              psi(i,j)=psi(nx-1,ny-1)
           else if(i==1.and.j==ny)then
              psi(i,j)=psi(nx-1,2)
           else if(i==nx.and.j==1)then
              psi(i,j)=psi(2,ny-1)
           else if(i==nx.and.j==ny)then
              psi(i,j)=psi(2,2)
           end if

        case (8)  ! ξեåǺѤ
           if(i==1.and.j==1)then  ! -- ɾ 1
              psi(i,j)=psi(i+1,j+1)-0.5*(bnd(i+1,j)*dy(j)+bnd(i,j+1)*dx(i))

           else if(i==nx.and.j==ny)then  ! -- ɾ 2
              psi(i,j)=psi(i-1,j-1)+0.5*(bnd(i-1,j)*dy(j)+bnd(i,j-1)*dx(i))

           else if(ib(i-1,j)==10.or.ib(i,j-1)==10)then
              ! -- ɾ 1 Ʊ
              psi(i,j)=psi(i+1,j+1)-0.5*(bnd(i+1,j)*dy(j)+bnd(i,j+1)*dx(i))

           else if(ib(i+1,j)==10.or.ib(i,j+1)==10)then
              ! -- ɾ 2 Ʊ
              psi(i,j)=psi(i-1,j-1)+0.5*(bnd(i-1,j)*dy(j)+bnd(i,j-1)*dx(i))

           end if

        case (-8)  ! ξեåǱѤ
           if(i==1.and.j==ny)then  ! -- ɾ 1
              psi(i,j)=psi(i+1,j+1)+0.5*(bnd(i+1,j)*dy(j)-bnd(i,j-1)*dx(i))

           else if(i==nx.and.j==1)then  ! -- ɾ 2
              psi(i,j)=psi(i-1,j-1)+0.5*(-bnd(i-1,j)*dy(j)+bnd(i,j+1)*dx(i))

           else if(ib(i-1,j)==10.or.ib(i,j+1)==10)then
              ! -- ɾ 1 Ʊ
              psi(i,j)=psi(i+1,j+1)+0.5*(bnd(i+1,j)*dy(j)-bnd(i,j-1)*dx(i))

           else if(ib(i+1,j)==10.or.ib(i,j-1)==10)then
              ! -- ɾ 2 Ʊ
              psi(i,j)=psi(i-1,j-1)+0.5*(-bnd(i-1,j)*dy(j)+bnd(i,j+1)*dx(i))

           end if
        end select 
     end do
  end do

end subroutine calculate_bound

end module Alge_Solv
