program splitter
! ͥǡ MPI ѥǡѴ.

  use gtool_history
  use Algebra
  use Phys_Const
  use Statistics
  use val_define
  use read_namelist

  implicit none

  integer :: pnr
  integer :: i, j, m
  real, allocatable, dimension(:) :: tri, tvb, thb, tub
  real, allocatable, dimension(:) :: pri, pvb, phb, pub
  character(80) :: fname, pfiname
  character(1) :: data_flag, radial_flag
  character(4) :: cpe

!-- namelist ɤ߹

  call read_name()   ! _mpi ǤϤʤΤ, nr ϥץǳƤʤ.

!-- allocating array

  if(mod((nr-2),proc)==0)then
     pnr=(nr-2)/proc+2
  else
     write(*,*) "ERROR : parameter 'proc' must be a prime factor of 'nr-2'."
     write(*,*) "now configuration : nr   = ", nr
     write(*,*) "now configuration : proc = ", proc
     write(*,*) "stop abnormally."
     stop
  end if

  allocate(ri(ni))
  allocate(ub(ni))
  allocate(vb(ni))
  allocate(hb(ni))
  allocate(tri(nr))
  allocate(tvb(nr))
  allocate(tub(nr))
  allocate(thb(nr))
  allocate(pri(pnr))
  allocate(pvb(pnr))
  allocate(pub(pnr))
  allocate(phb(pnr))

!-- ɸѿ

  call HistoryGet( trim(finame), 'r', ri )
  call HistoryGet( trim(finame), 'ubar', ub )
  call HistoryGet( trim(finame), 'vbar', vb )
  call HistoryGet( trim(finame), 'hbar', hb )

!-- ϥեκɸ

  tri=(/((rmin+dr*(i-1)),i=1,nr)/)

!-- ϥǡγʻҥǡϥǡγʻҥǡ

  call auto_interpolation_1d( ri, tri, ub, tub )
  call auto_interpolation_1d( ri, tri, vb, tvb )
  call auto_interpolation_1d( ri, tri, hb, thb )

  call interpo_search_1d( ri, tri(1), i )
write(*,*) ri(1), tri(1), ub(1), tub(1), i
write(*,*) ri(1), tri(1), vb(1), tvb(1)
write(*,*) ri(1), tri(1), hb(1), thb(1)

!-- ϥեν

  do j=1,proc
     do i=1,pnr
        m=(pnr-2)*(j-1)+i
        pri(i)=tri(m)
        pub(i)=tub(m)
        pvb(i)=tvb(m)
        phb(i)=thb(m)
     end do

     write(cpe,'(i4.4)') j-1

     pfiname=trim(adjustl(finame(1:len_trim(finame)-3)))//'.'//cpe(1:4)//'.nc'

     call HistoryCreate( file=trim(pfiname), title='shallow initial data', &
  &                      source='test', institution='test',  &
  &                      dims=(/'r'/), dimsizes=(/pnr/),  & 
  &                      longnames=(/'r-coordinate'/),  &
  &                      units=(/'m'/), origin=0.0, interval=0.0 )

     call HistoryPut( 'r', pri )

     call HistoryAddVariable( varname='ubar', dims=(/'r'/), &
  &                           longname='basic radial wind',  &
  &                           units='m/s', xtype='float')

     call HistoryPut( 'ubar', pub )

     call HistoryAddVariable( varname='vbar', dims=(/'r'/), &
  &                           longname='basic tangential wind',  &
  &                           units='m/s', xtype='float')

     call HistoryPut( 'vbar', pvb )

     call HistoryAddVariable( varname='hbar', dims=(/'r'/), &
  &                           longname='basic geopotential',  &
  &                           units='m', xtype='float')

     call HistoryPut( 'hbar', phb )

     call HistoryClose

  end do

end program
