program SEQ
! Pendergrass_Willoughby 2009 Υ䡼ꥢåǥ
  use derivation
  use alge_solv
  use file_operate
  use gtool_history
  use Thermo_Const
  use Thermo_Function
  use Math_Const
  use Phys_Const

  implicit none

!-- namelist valiables
  integer :: nr, nz
  integer :: mom_flag
  real :: coril
  character(4) :: bc
  character(80) :: fname
  character(80) :: sound_name  ! ǥ󥰥ե̾

!-- internal valiables
  real, allocatable :: r(:)  ! ưºɸ
  real, allocatable :: z(:)  ! ľɸ
  real, allocatable :: v0(:,:)  ! ®
  real, allocatable :: pres(:,:)  ! 
  real, allocatable :: theta0(:,:)  ! 
  real, allocatable :: exner0(:,:)  ! ʡؿ
  real, allocatable :: rho(:,:)  ! 
  real, allocatable :: Q(:,:)  ! 
  real, allocatable :: buoterm(:,:)  ! 
  real, allocatable :: xi(:,:)  ! 
  real, allocatable :: zeta(:,:)  ! 
  real, allocatable :: Grad(:,:)  ! 
  real, allocatable :: gamma(:,:)  ! 
  real, allocatable :: drhodz(:,:)  ! 
  real, allocatable :: dgammadz(:,:)  ! 
  real, allocatable :: S(:,:)  ! 
  real, allocatable :: N2(:,:)  ! 
  real, allocatable :: drhodr(:,:)  ! 
  real, allocatable :: dgammadr(:,:)  ! 
  real, allocatable :: Buo(:,:)  ! 
  real, allocatable :: dv0dr(:,:)  ! 
  real, allocatable :: I2(:,:)  ! 
  real, allocatable :: Id2(:,:)  ! 
  real, allocatable :: Rrho_inv(:,:)  ! 
  real, allocatable :: Hrho_inv(:,:)  ! 
  real, allocatable :: dQdr(:,:)  ! 
  real, allocatable :: dximomdz(:,:)  ! 
  real, allocatable :: ximom(:,:)  ! 
  real, allocatable :: dQdz(:,:)  ! 
  real, allocatable :: force(:,:)  ! 
  real, allocatable :: term1(:,:)  ! 
  real, allocatable :: term2(:,:)  ! 
  real, allocatable :: term3(:,:)  ! 
  real, allocatable :: term4(:,:)  ! 
  real, allocatable :: term5(:,:)  ! 
  real, allocatable :: psi(:,:)  ! 
  real, allocatable :: bound(:,:)  ! 
  real, allocatable :: u2(:,:)  ! 
  real, allocatable :: w2(:,:)  ! 
  real, allocatable :: mom(:,:)  ! 
  real, allocatable :: dmomdz(:,:)  ! 
  real, allocatable :: taur(:,:)  ! 
  real, allocatable :: tauz(:,:)  ! 
  real, allocatable :: nu(:,:)  ! 

!-- parameter
  real, parameter :: Cd=1.5e-3  ! ư̸򴹷
  real, parameter :: theta_const=273.16
  real, parameter :: eps=1.0e6

!-- tmp valiables
  integer :: i, j
  real :: coriol

!-- namelist Υѥ᡼
  namelist /input /nr, nz, bc, fname, sound_name, coril, mom_flag
  read(5,nml=input)

!-- γ
  allocate(r(nr))
  allocate(z(nz))
  allocate(v0(nr,nz))
  allocate(pres(nr,nz))
  allocate(theta0(nr,nz))
  allocate(exner0(nr,nz))
  allocate(rho(nr,nz)) 
  allocate(Q(nr,nz)) 
  allocate(buoterm(nr,nz)) 
  allocate(xi(nr,nz)) 
  allocate(zeta(nr,nz)) 
  allocate(Grad(nr,nz)) 
  allocate(gamma(nr,nz)) 
  allocate(drhodz(nr,nz)) 
  allocate(dgammadz(nr,nz)) 
  allocate(S(nr,nz)) 
  allocate(N2(nr,nz)) 
  allocate(drhodr(nr,nz)) 
  allocate(dgammadr(nr,nz)) 
  allocate(Buo(nr,nz)) 
  allocate(dv0dr(nr,nz)) 
  allocate(I2(nr,nz)) 
  allocate(Id2(nr,nz)) 
  allocate(Rrho_inv(nr,nz)) 
  allocate(Hrho_inv(nr,nz)) 
  allocate(dQdr(nr,nz)) 
  allocate(dximomdz(nr,nz)) 
  allocate(ximom(nr,nz)) 
  allocate(dQdz(nr,nz)) 
  allocate(force(nr,nz)) 
  allocate(term1(nr,nz)) 
  allocate(term2(nr,nz)) 
  allocate(term3(nr,nz)) 
  allocate(term4(nr,nz)) 
  allocate(term5(nr,nz)) 
  allocate(psi(nr,nz)) 
  allocate(bound(nr,nz)) 
  allocate(u2(nr,nz)) 
  allocate(w2(nr,nz)) 
  allocate(mom(nr,nz))
  allocate(dmomdz(nr,nz))
  allocate(taur(nr,nz))
  allocate(tauz(nr,nz))
  allocate(nu(nr,nz))

  coriol=2.0*omega*sin(coril*pi/180.0)
  bound=0.0

!-- ɸͤ
!  r=(/(dr*real(i-1),i=1,nr)/)
!  z=(/(dz*real(i-1),i=1,nz)/)

!-- ͤɤ߹

!  call read_file( trim(fname), nr, nz, 1, v0 )
!  call read_file( trim(fname), nr, nz, 2, p0 )
!  call read_file( trim(fname), nr, nz, 3, Q )
!  call read_file( trim(fname), nr, nz, 4, v0 )

!-- gtool ˤɤ߹

  call HistoryGet( trim(fname), 'r', r(1:nr) )
  call HistoryGet( trim(fname), 'z', z(1:nz) )
  call HistoryGet( trim(fname), 'pres', pres(1:nr,1:nz) )
  call HistoryGet( trim(fname), 'Q', Q(1:nr,1:nz) )
  call HistoryGet( trim(fname), 'theta', theta0(1:nr,1:nz) )
  call HistoryGet( trim(fname), 'v', v0(1:nr,1:nz) )
  call HistoryGet( trim(fname), 'rho', rho(1:nr,1:nz) )

!-- Q ǮΨºݤη׻ɬפϤ˴.
  do j=1,nz
     do i=1,nr
        Q(i,j)=Q(i,j)*g/Cpd/theta0(i,j)
     end do
  end do

!-- ư̥η׻

  mom=0.0

  select case (mom_flag)
  case (0)
     write(*,*) "### momentum source is zero."
  case (1)  ! ®پ줫׻.
     write(*,*) "### momentum source is calculating with Vt."
     dmomdz=0.0
     nu=0.0

     do i=1,nr
        call grad_1d( z, v0(i,:), tauz(i,:) )
     end do

     do j=1,nz
        call grad_1d( r, v0(:,j), taur(:,j) )
     end do

     do j=1,nz
        do i=2,nr
           nu(i,j)=200.0**2*sqrt((taur(i,j)-v0(i,j)/r(i))**2+tauz(i,j)**2)
        end do
     end do

     do j=1,nz
        do i=2,nr
           if(j/=1)then
              taur(i,j)=nu(i,j)*(taur(i,j)-v0(i,j)/r(i))
           else
              taur(i,j)=-Cd*abs(v0(i,j))*v0(i,j)
           end if
        end do
     end do

     do j=1,nz
        do i=1,nr
           tauz(i,j)=nu(i,j)*tauz(i,j)
        end do
     end do

!-- ޤǤ, ϥƥ󥽥η׻λ.
!-- ʹߤήեåη׻.

     do i=1,nr
        call grad_1d( z, tauz(i,:), dmomdz(i,:) )
        do j=1,nz
           mom(i,j)=dmomdz(i,j)
        end do
     end do

     do j=1,nz
        call grad_1d( r, taur(:,j), dmomdz(:,j) )
        do i=1,nr
           mom(i,j)=mom(i,j)+dmomdz(i,j)
        end do
        do i=2,nr
           mom(i,j)=mom(i,j)+2.0*taur(i,j)/r(i)
        end do
        do i=1,nr
           mom(i,j)=mom(i,j)/rho(i,j)
        end do
     end do

!     do i=1,nr
!        mom(i,1)=-Cd*abs(v0(i,1))*v0(i,1)
!        call grad_1d( z, mom(i,:), dmomdz(i,:) )
!     end do

  case (2)
     write(*,*) "### momentum source is writing the external file."
     call HistoryGet( trim(fname), 'mom', mom(1:nr,1:nz) )

  end select

!-- ʪ̤η׻
  do j=1,nz
     do i=1,nr
        exner0(i,j)=exner_func_dry( pres(i,j) )
!        rho(i,j)=TP_2_rho( thetaP_2_T( theta0(i,j), pres(i,j) ), pres(i,j) )
!     rho(i,j)=1000.0*(exner0(i,j)**(kappa))/(Rd*theta0(i,j))
!     Q(i,j)=qv(i,j)*g/(cpd*theta0(i,j))
        buoterm(i,j)=g*log(theta0(i,j)/theta_const)

        if(r(i)/=0.0)then
           xi(i,j)=2.0*v0(i,j)/r(i)+coriol
           Grad(i,j)=v0(i,j)**2/r(i)+coriol*v0(i,j)
        else
           xi(i,j)=coriol
           Grad(i,j)=coriol*v0(i,j)
        end if

        gamma(i,j)=Grad(i,j)/g
        ximom(i,j)=xi(i,j)*mom(i,j)
     end do
  end do

!-- ʪ̤θ۷׻
  do i=1,nr
     call grad_1d( z, rho(i,:), drhodz(i,:) )
     call grad_1d( z, gamma(i,:), dgammadz(i,:) )
     call grad_1d( z, v0(i,:), S(i,:) )
     call grad_1d( z, theta0(i,:), N2(i,:) )
     do j=1,nz  ! buoterm ľܷ׻ΤǤϤʤ, ֥ȿư׻.
        N2(i,j)=(g/theta0(i,j))*N2(i,j)
     end do
     call grad_1d( z, Q(i,:), dQdz(i,:) )
     call grad_1d( z, ximom(i,:), dximomdz(i,:) )
  end do

  do j=1,nz
     call grad_1d( r, rho(:,j), drhodr(:,j) )
     call grad_1d( r, gamma(:,j), dgammadr(:,j) )
     call grad_1d( r, theta0(:,j), Buo(:,j) )
     do i=1,nr  ! buoterm ľܷ׻ΤǤϤʤ, ֥ȿư׻.
        Buo(i,j)=(g/theta0(i,j))*Buo(i,j)
     end do
     call grad_1d( r, v0(:,j), dv0dr(:,j) )
     call grad_1d( r, Q(:,j), dQdr(:,j) )
  end do

!-- ʪ̤η׻
  do j=1,nz
     do i=1,nr
        Hrho_inv(i,j)=drhodz(i,j)/rho(i,j)

        if(r(i)/=0.0)then
           Rrho_inv(i,j)=1.0/r(i)+drhodr(i,j)/rho(i,j)
           zeta(i,j)=dv0dr(i,j)+v0(i,j)/r(i)+coriol
        else
           Rrho_inv(i,j)=drhodr(i,j)/rho(i,j)
           zeta(i,j)=dv0dr(i,j)+coriol
        end if

        I2(i,j)=zeta(i,j)*xi(i,j)
        Id2(i,j)=I2(i,j)-gamma(i,j)*Buo(i,j)
     end do
  end do

!-- Ϥγƹ෸η׻
  do j=1,nz
     do i=1,nr
        term1(i,j)=abs(N2(i,j))
        term2(i,j)=-2.0*Buo(i,j)
        term3(i,j)=Id2(i,j)
        term4(i,j)=-Rrho_inv(i,j)*N2(i,j)+Buo(i,j)*Hrho_inv(i,j)  &
  &                -dgammadz(i,j)*N2(i,j)

        if(r(i)/=0.0)then
           term5(i,j)=-Id2(i,j)*Hrho_inv(i,j)+Buo(i,j)*Rrho_inv(i,j)  &
  &                   +3.0*xi(i,j)*S(i,j)/(r(i))+dgammadr(i,j)*N2(i,j)
        else
           term5(i,j)=-Id2(i,j)*Hrho_inv(i,j)+Buo(i,j)*Rrho_inv(i,j)  &
  &                   +dgammadr(i,j)*N2(i,j)
        end if

        force(i,j)=r(i)*rho(i,j)*(dQdr(i,j)+gamma(i,j)*dQdz(i,j))
!        force(i,j)=r(i)*rho(i,j)*(dQdr(i,j)-dximomdz(i,j)+gamma(i,j)*dQdz(i,j))
!write(*,*) term1(i,j), term2(i,j), term3(i,j), term4(i,j), term5(i,j), force(i,j), i, j
     end do
  end do

do j=1,nr
write(*,*) gamma(j,2)
end do

!-- ݥ󥽥

  call Poisson_Jacobi( r(1:nr), z(1:nz), force(1:nr,1:nz), eps,  &
  &                    bc, psi(1:nr,1:nz), bound(1:nr,1:nz),  &
  &                    a=term1(1:nr,1:nz),  b=term2(1:nr,1:nz),  &
  &                    c=term3(1:nr,1:nz),  d=term4(1:nr,1:nz),  &
  &                    e=term5(1:nr,1:nz)) 

!-- ήؿ 2 ۴Ĥη׻

  do i=1,nr
     call grad_1d( z, psi(i,:), u2(i,:) )
  end do

  do j=1,nz
     call grad_1d( r, psi(:,j), w2(:,j) )
  end do

  do j=1,nz
     do i=1,nr
        if(r(i)/=0.0)then
           u2(i,j)=-u2(i,j)/(r(i)*rho(i,j))
           w2(i,j)=w2(i,j)/(r(i)*rho(i,j))
        else
           u2(i,j)=0.0
           w2(i,j)=0.0
        end if
     end do
  end do

!-- եؤν񤭽Ф

!  call write_file( trim(output_fname), nr, nz, 1, psi )
!  call write_file( trim(output_fname), nr, nz, 2, u2, mode='old' )
!  call write_file( trim(output_fname), nr, nz, 3, w2, mode='old' )

!-- gtool ˤ񤭽Ф

  call HistoryCreate( file='result_'//trim(fname), title='SEQ result data', &
    & source='test', institution='test', dims=(/'r','z'/), dimsizes=(/nr,nz/),  &
    & longnames=(/'r-coordinate','z-coordinate'/),  &
    & units=(/'m','m'/), origin=0.0, interval=0.0 )

  call HistoryPut( 'r', r )
  call HistoryPut( 'z', z )

  call HistoryAddVariable( varname='u', dims=(/'r','z'/), &
    & longname='radial wind', units='m/s', xtype='float')

  call HistoryPut( 'u', u2 )

  call HistoryAddVariable( varname='w', dims=(/'r','z'/), &
    & longname='vertical wind', units='m/s', xtype='float')

  call HistoryPut( 'w', w2 )

  call HistoryAddVariable( varname='psi', dims=(/'r','z'/), &
    & longname='mass stream function', units='kg/s', xtype='float')

  call HistoryPut( 'psi', psi )

  call HistoryAddVariable( varname='force', dims=(/'r','z'/), &
    & longname='mass stream function', units='kg/s', xtype='float')

  call HistoryPut( 'force', force )

  call HistoryClose

!-- λ

  write(*,*) "Program is terminated, normally."

end program
