module make_init
! ͥǡ.

  use gtool_history
  use Derivation
  use Algebra
  use Alge_Solv
  use Phys_Const
  use val_define
  use read_namelist
  use val_alloc
  use val_coord
  use Thermo_Const
  use Thermo_Function

contains

subroutine make_initialize()

  use Thermo_Const
  use Phys_Const
  implicit none

  integer :: i, j, k
  real, dimension(nr+1,nz+1) :: tmp_pres, tmp_pold
  real, dimension(nri,nzi) :: tmp_pi

!-- ͥǡɤ߹

  call HistoryGet( trim(finame), 'r', r_i )
  call HistoryGet( trim(finame), 'z', z_i )
  call HistoryGet( trim(finame), 'u', u_i )
  call HistoryGet( trim(finame), 'v', v_i )
  call HistoryGet( trim(finame), 'w', w_i )
  call HistoryGet( trim(finame), 'p', p_i )   ! p_i -> Pa
  call HistoryGet( trim(finame), 't', t_i )
  call HistoryGet( trim(finame), 'qv', qv_i )
  call HistoryGet( trim(finame), 'qt', qt_i )

!-- Ϥ򵬳ʲ
  do k=1,nzi
     do j=1,nri
        tmp_pi(j,k)=exner_func_dry( p_i(j,k) )  ! tmp_pi -> 1
        p_i(j,k)=tmp_pi(j,k)                    ! p_i -> 1
     end do
  end do

!-- ǡؤ
  call auto_interpolation_2d( r_i, z_i, r_u, z_s, u_i, u_old )
  call auto_interpolation_2d( r_i, z_i, r_s, z_s, v_i, v_old )
  call auto_interpolation_2d( r_i, z_i, r_s, z_w, w_i, w_old )
  call auto_interpolation_2d( r_i, z_i, r_s, z_s, p_i, p_old )  ! p_old -> 1
  call auto_interpolation_2d( r_i, z_i, r_s, z_s, t_i, t_old )
  call auto_interpolation_2d( r_i, z_i, r_s, z_s, qv_i, qv_old )
  call auto_interpolation_2d( r_i, z_i, r_s, z_s, qt_i, qt_old )

  !-- original data
  do k=1,nz+1
     do j=1,nr+1
        tmp_pold(j,k)=p_old(j,k)   ! tmp_pold -> 1
     end do
  end do

!-- ǡǡؤ(Don't openMP)
  do k=1,nz+1
     tmp_pres(nr,k)=p0*(tmp_pold(nr,k)**(Cpd/Rd))
     do j=1,nr+1
        ub_u(j,k)=0.0
        vb_s(j,k)=0.0
        wb_w(j,k)=0.0
        pb_s(j,k)=tmp_pold(nr,k)   ! pb_s -> 1
                                ! ¦ΤΰΤߤʿѾȤѤ.
        p_old(j,k)=tmp_pold(j,k)-pb_s(j,k)  ! p_old -> 1 (perturbation)
                                ! ϤΤк׻Ԥ.
        ptb_s(j,k)=t_old(nr,k)
        qvb_s(j,k)=qv_old(nr,k)
        qtb_s(j,k)=qt_old(nr,k)
        tempb_s(j,k)=thetaP_2_T( t_old(nr,k), tmp_pres(nr,k) )
        rhob_s(j,k)=TP_2_rho( tempb_s(j,k), tmp_pres(nr,k) )
        ptvb_s(j,k)=TqvP_2_thetav( tempb_s(j,k), qvb_s(j,k), tmp_pres(nr,k) )
        pteb_s(j,k)=thetae_Bolton( tempb_s(j,k), qvb_s(j,k), tmp_pres(nr,k) )
     end do
  end do

!-- new data
  do k=1,nz+1
     do j=1,nr+1
        u_new(j,k)=u_old(j,k)
        v_new(j,k)=v_old(j,k)
        w_new(j,k)=w_old(j,k)
        p_new(j,k)=p_old(j,k)    ! p_new -> 1
        t_new(j,k)=t_old(j,k)
        qv_new(j,k)=qv_old(j,k)
        qt_new(j,k)=qt_old(j,k)
     end do
  end do

!-- Υǡ򸵤, ѿΤ, ƥåˤ.
!$omp parallel default(shared)
!$omp do schedule(dynamic) private(k)
  do k=1,nz+1
     call auto_interpolation_1d( r_s, r_u, ptb_s(:,k), ptb_u(:,k) )
     call auto_interpolation_1d( r_s, r_u, ptvb_s(:,k), ptvb_u(:,k) )
     call auto_interpolation_1d( r_s, r_u, qvb_s(:,k), qvb_u(:,k) )
     call auto_interpolation_1d( r_s, r_u, rhob_s(:,k), rhob_u(:,k) )
  end do
!$omp end do

!$omp do schedule(dynamic) private(j)
  do j=1,nr+1
     call auto_interpolation_1d( z_s, z_w, ptb_s(j,:), ptb_w(j,:) )
     call auto_interpolation_1d( z_s, z_w, ptvb_s(j,:), ptvb_w(j,:) )
     call auto_interpolation_1d( z_s, z_w, qvb_s(j,:), qvb_w(j,:) )
     call auto_interpolation_1d( z_s, z_w, rhob_s(j,:), rhob_w(j,:) )
  end do
!$omp end do
!$omp end parallel

!-- , sst ϰȤƷ׻Ƥ.
  sst_s=sst
  sst_u=sst 
!  call auto_interpolation_1d( r_i, r_s, sst_i, sst_s )
!  call auto_interpolation_1d( r_i, r_u, sst_i, sst_u )

end subroutine make_initialize

end module
