program cloud_1d
  use Derivation
  use file_operate
  use gtool_history
  use Thermo_Function
  use Thermo_Const
  use Cloud_Basic
  use Cloud_Cold
  use Basis
  use Math_Const

  implicit none

  integer :: i, j, k, nmax, nt, dmpstp
  real, parameter :: zmax=5000.0   ! vertical wind maximum height.
  real, parameter :: wfact=2.0   ! vertical wind maximum height.
  real :: dt, rho0
  real :: VDvr_term, NUAvi_term, VDvi_term, VDvs_term, VDvg_term
  real :: NUFci_term, NUCci_term, NUHci_term, CLcs_term, CLcg_term
  real :: CLri_term, CLrs_term, CLrg_term, CLcr_term, CLir_term
  real :: CLis_term, CLig_term, CLsr_term, CLsg_term
  real :: MLic_term, MLsr_term, MLgr_term
  real :: FRrg_term, SHsr_term, SHgr_term
  real :: CNcr_term, CNis_term, CNsg_term
  real :: SPsi_term, SPgi_term, PG_term
  real :: ars
  real, allocatable, dimension(:) :: z, w, qv, qr, qc, rho, pt
  real, allocatable, dimension(:) :: qi, qs, qg
  real, allocatable, dimension(:) :: old_qv, old_qr, old_qc, old_pt
  real, allocatable, dimension(:) :: old_qi, old_qs, old_qg
  real, allocatable, dimension(:) :: tmp_qv, tmp_qr, tmp_qc, tmp_pt
  real, allocatable, dimension(:) :: tmp_qi, tmp_qs, tmp_qg, tmp_temp
  real, allocatable, dimension(:) :: temp, pres, fallqr, fallqs, fallqg
  real, allocatable, dimension(:) :: dqvdz, dqrdz, dqcdz, dptdz
  real, allocatable, dimension(:) :: dqidz, dqsdz, dqgdz
  real, allocatable, dimension(:) :: dfallqrdz, dfallqsdz, dfallqgdz
  real, allocatable, dimension(:) :: forceqv, forceqc, forceqr, forcept
  real, allocatable, dimension(:) :: forceqi, forceqs, forceqg
  real, dimension(2) :: qvbc, qcbc, qrbc, qibc, qsbc, qgbc, ptbc
  character(100) :: fname, outname
  character(20), allocatable, dimension(:,:) :: cval

  namelist /input /dt, nt, fname, outname, dmpstp
  read(5,nml=input)

  nmax=line_number_counter( trim(fname) )

  allocate(cval(4,nmax))
  allocate(z(nmax))
  allocate(w(nmax))
  allocate(qv(nmax))
  allocate(qc(nmax))
  allocate(qr(nmax))
  allocate(qi(nmax))
  allocate(qs(nmax))
  allocate(qg(nmax))
  allocate(rho(nmax))
  allocate(pt(nmax))
  allocate(fallqr(nmax))
  allocate(fallqs(nmax))
  allocate(fallqg(nmax))
  allocate(tmp_qv(nmax))
  allocate(tmp_qc(nmax))
  allocate(tmp_qr(nmax))
  allocate(tmp_qi(nmax))
  allocate(tmp_qs(nmax))
  allocate(tmp_qg(nmax))
  allocate(tmp_pt(nmax))
  allocate(tmp_temp(nmax))
  allocate(old_qv(nmax))
  allocate(old_qc(nmax))
  allocate(old_qr(nmax))
  allocate(old_qi(nmax))
  allocate(old_qs(nmax))
  allocate(old_qg(nmax))
  allocate(old_pt(nmax))
  allocate(temp(nmax))
  allocate(pres(nmax))
  allocate(dqvdz(nmax))
  allocate(dqcdz(nmax))
  allocate(dqrdz(nmax))
  allocate(dqidz(nmax))
  allocate(dqsdz(nmax))
  allocate(dqgdz(nmax))
  allocate(dptdz(nmax))
  allocate(dfallqrdz(nmax))
  allocate(dfallqsdz(nmax))
  allocate(dfallqgdz(nmax))
  allocate(forcept(nmax))
  allocate(forceqv(nmax))
  allocate(forceqc(nmax))
  allocate(forceqr(nmax))
  allocate(forceqi(nmax))
  allocate(forceqs(nmax))
  allocate(forceqg(nmax))

!-- reading data from fname

  call read_file_text( trim(fname), 4, nmax, cval )

  do j=1,nmax
     z(j)=c2r_convert( trim(adjustl(cval(1,j))) )
     pres(j)=c2r_convert( trim(adjustl(cval(2,j))) )
     temp(j)=c2r_convert( trim(adjustl(cval(3,j))) )
     qv(j)=c2r_convert( trim(adjustl(cval(4,j))) )
     pt(j)=theta_dry( temp(j), pres(j) )
     rho(j)=TP_2_rho( thetaP_2_T(pt(j), pres(j)), pres(j))
  end do

!-- setting vertical wind

  do i=1,nmax
!     w(i)=exp(-(z(i)-z(nmax/2))**2)
     if(2.0*(zmax-z(1))>=z(i))then
        w(i)=wfact*sin(pi*(z(i)-z(1))/(z(nmax)-z(1)))
     else
        w(i)=0.0
     end if
     qc(i)=0.0
     qr(i)=0.0
     qi(i)=0.0
     qs(i)=0.0
     qg(i)=0.0
  end do

!  rho0=TP_2_rho( thetaP_2_T(pt(1), pres(1)), pres(1))
  rho0=1.225

  ptbc=(/pt(1),pt(nmax)/)
  qvbc=(/qv(1),qv(nmax)/)
  qcbc=0.0
  qrbc=0.0
  qibc=0.0
  qsbc=0.0
  qgbc=0.0

!-- output file is initialized.

  call HistoryCreate( file=trim(outname), title='cloud',  &
  &                   source='test', institution='test', dims=(/'z', 't'/),  &
  &                   dimsizes=(/nmax,0/),  &
  &                   longnames=(/'Z-coordinate', 'time        '/),  &
  &                   units=(/'m','s'/), origin=0.0,  &
  &                   interval=dt*real(dmpstp) )

  call HistoryPut( 'z', z )
!  call HistoryPut( 't', t )

  call HistoryAddVariable( varname='pt', dims=(/'z','t'/),  &
  &                        longname='potential temperature',  &
  &                        units='K', xtype='float' )
  call HistoryAddVariable( varname='qv', dims=(/'z','t'/),  &
  &                        longname='mixing ratio of water vapor',  &
  &                        units='kg kg-1', xtype='float' )
  call HistoryAddVariable( varname='qc', dims=(/'z','t'/),  &
  &                        longname='mixing ratio of cloud water',  &
  &                        units='kg kg-1', xtype='float' )
  call HistoryAddVariable( varname='qr', dims=(/'z','t'/),  &
  &                        longname='mixing ratio of rain',  &
  &                        units='kg kg-1', xtype='float' )
  call HistoryAddVariable( varname='qi', dims=(/'z','t'/),  &
  &                        longname='mixing ratio of ice',  &
  &                        units='kg kg-1', xtype='float' )
  call HistoryAddVariable( varname='qs', dims=(/'z','t'/),  &
  &                        longname='mixing ratio of snow',  &
  &                        units='kg kg-1', xtype='float' )
  call HistoryAddVariable( varname='qg', dims=(/'z','t'/),  &
  &                        longname='mixing ratio of graupel',  &
  &                        units='kg kg-1', xtype='float' )

!-- starting time integration

  do i=1,nt

  !-- initializing forcing terms

     do j=1,nmax
        forcept(j)=0.0
        forceqv(j)=0.0
        forceqc(j)=0.0
        forceqr(j)=0.0
        forceqi(j)=0.0
        forceqs(j)=0.0
        forceqg(j)=0.0
     end do

  !-- calculating terminal velocity.
  !-- [note] 

     do j=1,nmax
!        write(*,*) "falling speed", UhxN( 'r', qr(j), rho(j), rho0 ),  &
!        UhxN( 's', qs(j), rho(j), rho0 ),  &
!        UhxN( 'g', qg(j), rho(j), rho0 )
        fallqr(j)=rho(j)*UhxN( 'r', qr(j), rho(j), rho0 )*qr(j)
        fallqs(j)=rho(j)*UhxN( 's', qs(j), rho(j), rho0 )*qs(j)
        fallqg(j)=rho(j)*UhxN( 'g', qg(j), rho(j), rho0 )*qg(j)
     end do

  !-- calculating microphysics schemes

     do j=2,nmax-1
        if(qv(j)>0.0.or.qc(j)>0.0.or.qr(j)>0.0)then
           NUAvi_term=NUAvi( temp(j), pres(j), qv(j), qi(j), rho(j) )
           NUFci_term=NUFci( temp(j), qc(j), rho(j) )
           NUCci_term=NUCci( temp(j), pres(j), qc(j), rho(j) )
           NUHci_term=NUHci( temp(j), qc(j), dt )
           VDvr_term=VDvx( 'r', temp(j), pres(j), qv(j), qc(j), qr(j),  &
  &                        qr(j), rho(j), rho0 )
           VDvi_term=VDvi( temp(j), pres(j), qv(j), qi(j), rho(j) )
           VDvs_term=VDvx( 's', temp(j), pres(j), qv(j), qc(j), qr(j),  &
  &                        qs(j), rho(j), rho0 )
           VDvg_term=VDvx( 'g', temp(j), pres(j), qv(j), qc(j), qr(j),  &
  &                        qg(j), rho(j), rho0 )
           CLcs_term=CLxy( 'cs', temp(j), pres(j), qc(j), qs(j), rho(j), rho0 )
           CLcg_term=CLxy( 'cg', temp(j), pres(j), qc(j), qg(j), rho(j), rho0 )
           CLri_term=CLxy( 'ri', temp(j), pres(j), qr(j), qi(j), rho(j), rho0, qv=qv(j) )
           CLrs_term=CLxy( 'rs', temp(j), pres(j), qr(j), qs(j), rho(j), rho0 )
           CLrg_term=CLxy( 'rg', temp(j), pres(j), qr(j), qg(j), rho(j), rho0 )
           CLcr_term=CLxy( 'cr', temp(j), pres(j), qc(j), qr(j), rho(j), rho0 )
           CLir_term=CLxy( 'ir', temp(j), pres(j), qi(j), qr(j), rho(j), rho0 )
           CLis_term=CLxy( 'is', temp(j), pres(j), qi(j), qs(j), rho(j), rho0 )
           CLig_term=CLxy( 'ig', temp(j), pres(j), qi(j), qg(j), rho(j), rho0 )
           CLsr_term=CLxy( 'sr', temp(j), pres(j), qs(j), qr(j), rho(j), rho0 )
           CLsg_term=CLxy( 'sg', temp(j), pres(j), qs(j), qg(j), rho(j), rho0 )
           MLic_term=MLic( temp(j), qi(j), dt )
           MLsr_term=MLxr( 's', temp(j), pres(j), qv(j), qc(j), qr(j),  &
  &                        qs(j), rho(j), rho0 )
           MLgr_term=MLxr( 'g', temp(j), pres(j), qv(j), qc(j), qr(j),  &
  &                        qg(j), rho(j), rho0 )
           PG_term=PGdw( temp(j), pres(j), qv(j), qc(j), qr(j), qi(j),  &
  &                      qs(j), qg(j), rho(j), rho0 )
           FRrg_term=FRrg( temp(j), qr(j), rho(j) )
           SHsr_term=CLcs_term+CLrs_term
           if(temp(j)<=ti0)then
              SHgr_term=CLcg_term+CLrg_term+CLig_term+CLsg_term-PG_term
           else
              SHgr_term=CLcg_term+CLrg_term
           end if
           CNcr_term=CNcr( 'B', temp(j), pres(j), qc(j), rho(j) )
           CNis_term=CNis( temp(j), pres(j), qi(j), qs(j), qv(j),  &
  &                  rho(j), rho0 )
           CNsg_term=CNsg( temp(j), pres(j), qc(j), qs(j), rho(j), rho0 )
           SPsi_term=SPxi( 's', temp(j), pres(j), qv(j), qc(j), qr(j), qi(j),  &
  &                        qs(j), qg(j), rho(j), rho0 )
           SPgi_term=SPxi( 'g', temp(j), pres(j), qv(j), qc(j), qr(j), qi(j),  &
  &                        qs(j), qg(j), rho(j), rho0 )
           ars=Category_rs( qr(j), qs(j), rho(j) )
           forcept(j)=forcept(j)  &
  &                   +Lv( temp(j) )*(VDvr_term)/(Cpd*exner_func_dry( pres(j) ))  &
  &                   +(Ls( temp(j) )/(Cpd*exner_func_dry( pres(j) )))  &
  &                   *(NUAvi_term+VDvi_term+VDvs_term+VDvg_term)  &
  &                   +(Lf( temp(j) )/(Cpd*exner_func_dry( pres(j) )))  &
  &                   *(NUFci_term+NUCci_term+CLcs_term+CLcg_term+CLri_term  &
  &                    +CLrs_term+CLrg_term-MLic_term-MLsr_term-MLgr_term  &
  &                    +FRrg_term-SHsr_term-SHgr_term)
           forceqv(j)=forceqv(j)-NUAvi_term  &
  &                             -VDvr_term-VDvi_term-VDvs_term-VDvg_term
if(forceqv(j)/=0.0)then
           write(*,*) "qv tend", NUAvi_term,  &
  &                             -VDvr_term, -VDvi_term, -VDvs_term, -VDvg_term
end if
           forceqc(j)=forceqc(j)-NUFci_term-NUCci_term  &
  &                             -CLcr_term-CLcs_term-CLcg_term-CLcr_term  &
  &                             +MLic_term
           forceqr(j)=forceqr(j)+VDvr_term+CLcr_term-CLri_term-CLrg_term  &
  &                             +CNcr_term+MLsr_term+MLgr_term-FRrg_term  &
  &                             +SHsr_term+SHgr_term
           forceqi(j)=forceqi(j)+NUAvi_term+NUFci_term+NUCci_term  &
  &                             +VDvi_term-CLir_term-CLis_term  &
  &                             +CNis_term-MLic_term+SPsi_term+SPgi_term
           forceqs(j)=forceqs(j)-SPsi_term+VDvs_term+CLcs_term+CLrs_term*ars  &
  &                             +CLis_term-CLsr_term*(1.0-ars)-CLsg_term  &
  &                             +CNis_term-CNsg_term-MLsr_term-SHsr_term
!if(forceqs(j)/=0.0)then
!write(*,*) -NUFci_term,-NUCci_term, -CLcr_term,-CLcs_term,-CLcg_term,-CLcr_term, +MLic_term
!           write(*,*) -SPsi_term, +VDvs_term, +CLcs_term, +CLrs_term, ars,  &
!  &                             +CLis_term, -CLsr_term*(1.0-ars), -CLsg_term,  &
!  &                             +CNis_term, -CNsg_term, -MLsr_term, -SHsr_term
!end if
           forceqg(j)=forceqg(j)-SPgi_term+VDvg_term+PG_term  &
  &                             +CLri_term+CLir_term  &
  &                             +(CLrs_term+CLsr_term)*(1.0-ars)  &
  &                             +CNsg_term-MLgr_term+FRrg_term-SHgr_term
        end if
     end do

  !-- adding the advecting terms
  !-- calculating vertical gradient

     call grad_1d( z, qv, dqvdz )
     call grad_1d( z, qc, dqcdz )
     call grad_1d( z, qr, dqrdz )
     call grad_1d( z, qi, dqidz )
     call grad_1d( z, qs, dqsdz )
     call grad_1d( z, qg, dqgdz )
     call grad_1d( z, fallqr, dfallqrdz )
     call grad_1d( z, fallqs, dfallqsdz )
     call grad_1d( z, fallqg, dfallqgdz )

     do j=2,nmax-1
        forceqv(j)=forceqv(j)-w(j)*dqvdz(j)
        forceqc(j)=forceqc(j)-w(j)*dqcdz(j)
        forceqr(j)=forceqr(j)-w(j)*dqrdz(j)+dfallqrdz(j)/rho(j)
        forceqi(j)=forceqi(j)-w(j)*dqidz(j)
        forceqs(j)=forceqs(j)-w(j)*dqsdz(j)+dfallqsdz(j)/rho(j)
        forceqg(j)=forceqg(j)-w(j)*dqgdz(j)+dfallqgdz(j)/rho(j)
     end do

     if(i==1)then  ! first step is Euler method.
        do j=2,nmax-1
           tmp_pt(j)=pt(j)+dt*forcept(j)
           tmp_qv(j)=qv(j)+dt*forceqv(j)
           tmp_qc(j)=qc(j)+dt*forceqc(j)
           tmp_qr(j)=qr(j)+dt*forceqr(j)
           tmp_qi(j)=qi(j)+dt*forceqi(j)
           tmp_qs(j)=qs(j)+dt*forceqs(j)
           tmp_qg(j)=qg(j)+dt*forceqg(j)
        end do

        call forced_zero( tmp_qv )
        call forced_zero( tmp_qc )
        call forced_zero( tmp_qr )
        call forced_zero( tmp_qi )
        call forced_zero( tmp_qs )
        call forced_zero( tmp_qg )

        !-- Moist Saturated Adjustment

        do j=2,nmax-1
           if(tmp_qv(j)>0.0.or.tmp_qi(j)>0.0)then
              call Moist_Sature_Adjust_Ice( pres(j), tmp_pt(j), tmp_qv(j), tmp_qi(j) )
           end if
           if(tmp_qv(j)>0.0.or.tmp_qc(j)>0.0)then
              call Moist_Sature_Adjust( pres(j), tmp_pt(j), tmp_qv(j), tmp_qc(j) )
           end if
        end do

        call forced_zero( tmp_qv )
        call forced_zero( tmp_qc )
        call forced_zero( tmp_qr )
        call forced_zero( tmp_qi )
        call forced_zero( tmp_qs )
        call forced_zero( tmp_qg )

        !-- boundary condition

!        tmp_pt(1)=tmp_pt(2)
!        tmp_pt(nmax)=tmp_pt(nmax-1)
!        tmp_qv(1)=tmp_qv(2)
!        tmp_qv(nmax)=tmp_qv(nmax-1)
        tmp_qi(1)=tmp_qi(2)
        tmp_qi(nmax)=tmp_qi(nmax-1)
        tmp_qs(1)=tmp_qs(2)
        tmp_qs(nmax)=tmp_qs(nmax-1)
        tmp_qg(1)=tmp_qg(2)
        tmp_qg(nmax)=tmp_qg(nmax-1)
        tmp_qc(1)=tmp_qc(2)
        tmp_qc(nmax)=tmp_qc(nmax-1)
        tmp_qr(1)=tmp_qr(2)
        tmp_qr(nmax)=tmp_qr(nmax-1)
        tmp_pt(1)=ptbc(1)
        tmp_pt(nmax)=ptbc(2)
        tmp_qv(1)=qvbc(1)
        tmp_qv(nmax)=qvbc(2)
!        tmp_qc(1)=qcbc(1)
!        tmp_qc(nmax)=qcbc(2)
!        tmp_qr(1)=qrbc(1)
!        tmp_qr(nmax)=qrbc(2)

  write(*,*) "*******************************************"
  write(*,*) "File damp (time =", 0.0, "[s])."
  write(*,*) "*******************************************"
        call HistoryPut( 'pt', pt )
        call HistoryPut( 'qv', qv )
        call HistoryPut( 'qc', qc )
        call HistoryPut( 'qr', qr )
        call HistoryPut( 'qi', qi )
        call HistoryPut( 'qs', qs )
        call HistoryPut( 'qg', qg )

        do j=1,nmax
           old_pt(j)=pt(j)
           old_qv(j)=qv(j)
           old_qc(j)=qc(j)
           old_qr(j)=qr(j)
           old_qi(j)=qi(j)
           old_qs(j)=qs(j)
           old_qg(j)=qg(j)
           pt(j)=tmp_pt(j)
           temp(j)=thetaP_2_T( tmp_pt(j), pres(j) )
           qv(j)=tmp_qv(j)
           qc(j)=tmp_qc(j)
           qr(j)=tmp_qr(j)
           qi(j)=tmp_qi(j)
           qs(j)=tmp_qs(j)
           qg(j)=tmp_qg(j)
        end do

     else  ! after step is leap flog method.

        do j=2,nmax-1
           tmp_pt(j)=old_pt(j)+2.0*dt*forcept(j)
           tmp_qv(j)=old_qv(j)+2.0*dt*forceqv(j)
           tmp_qc(j)=old_qc(j)+2.0*dt*forceqc(j)
           tmp_qr(j)=old_qr(j)+2.0*dt*forceqr(j)
           tmp_qi(j)=old_qi(j)+2.0*dt*forceqi(j)
           tmp_qs(j)=old_qs(j)+2.0*dt*forceqs(j)
           tmp_qg(j)=old_qg(j)+2.0*dt*forceqg(j)
        end do

        call forced_zero( tmp_qv )
        call forced_zero( tmp_qc )
        call forced_zero( tmp_qr )
        call forced_zero( tmp_qi )
        call forced_zero( tmp_qs )
        call forced_zero( tmp_qg )

        !-- Moist Saturated Adjustment

        do j=2,nmax-1
           if(tmp_qv(j)>0.0.or.tmp_qi(j)>0.0)then
              call Moist_Sature_Adjust_Ice( pres(j), tmp_pt(j), tmp_qv(j), tmp_qi(j) )
           end if
           if(tmp_qv(j)>0.0.or.tmp_qc(j)>0.0)then
              call Moist_Sature_Adjust( pres(j), tmp_pt(j), tmp_qv(j), tmp_qc(j) )
           end if
        end do

        call forced_zero( tmp_qv )
        call forced_zero( tmp_qc )

        !-- boundary condition

!        tmp_pt(1)=tmp_pt(2)
!        tmp_pt(nmax)=tmp_pt(nmax-1)
!        tmp_qv(1)=tmp_qv(2)
!        tmp_qv(nmax)=tmp_qv(nmax-1)
        tmp_qi(1)=tmp_qi(2)
        tmp_qi(nmax)=tmp_qi(nmax-1)
        tmp_qs(1)=tmp_qs(2)
        tmp_qs(nmax)=tmp_qs(nmax-1)
        tmp_qg(1)=tmp_qg(2)
        tmp_qg(nmax)=tmp_qg(nmax-1)
        tmp_qc(1)=tmp_qc(2)
        tmp_qc(nmax)=tmp_qc(nmax-1)
        tmp_qr(1)=tmp_qr(2)
        tmp_qr(nmax)=tmp_qr(nmax-1)
        tmp_pt(1)=ptbc(1)
        tmp_pt(nmax)=ptbc(2)
        tmp_qv(1)=qvbc(1)
        tmp_qv(nmax)=qvbc(2)
!        tmp_qc(1)=qcbc(1)
!        tmp_qc(nmax)=qcbc(2)
!        tmp_qr(1)=qrbc(1)
!        tmp_qr(nmax)=qrbc(2)

        if(mod(i-1,dmpstp)==0)then
           call HistoryPut( 'pt', pt )
           call HistoryPut( 'qv', qv )
           call HistoryPut( 'qc', qc )
           call HistoryPut( 'qr', qr )
           call HistoryPut( 'qi', qi )
           call HistoryPut( 'qs', qs )
           call HistoryPut( 'qg', qg )
           write(*,*) "*******************************************"
           write(*,*) "File damp (time =", real(i-1)*dt, "[s])."
           write(*,*) "*******************************************"
        end if

        do j=1,nmax
           old_pt(j)=pt(j)
           old_qv(j)=qv(j)
           old_qc(j)=qc(j)
           old_qr(j)=qr(j)
           old_qi(j)=qi(j)
           old_qs(j)=qs(j)
           old_qg(j)=qg(j)
           pt(j)=tmp_pt(j)
           temp(j)=thetaP_2_T( tmp_pt(j), pres(j) )
           qv(j)=tmp_qv(j)
           qc(j)=tmp_qc(j)
           qr(j)=tmp_qr(j)
           qi(j)=tmp_qi(j)
           qs(j)=tmp_qs(j)
           qg(j)=tmp_qg(j)
        end do
     end if

     write(*,*) "This step is ", i, "(time =", real(i-1)*dt, "[s])."

  end do

  write(*,*) "solver is normally."

contains

subroutine forced_zero( val )
  implicit none
  real, intent(inout) :: val(:)
  integer :: i, n

  n=size(val)

  do i=1,n
     if(val(i)<0.0)then
        val(i)=0.0
     end if
  end do

end subroutine forced_zero
end program
