module force_solv
! ׻⥸塼
! Ѥ륹åɳʻҤ,
! ʪΰ躸üˤĤ, j=1, k=1 ȤƤΤ,
! åɳʻҤˤʬԤݤ, 顼Ǥʬ
! grad_for_1d , ¾Υ٥ȥǤʬˤ grad_back_1d Ѥ뤳.
  use val_define
  use read_namelist
  use val_alloc
  use val_coord
  use real_initialize
  use Derivation
  use sub_calc
  use Thermo_Function

contains

subroutine force()

  implicit none

  integer :: i, j, k

  !-- ν

  call real_init( force_u )
  call real_init( force_v )
  call real_init( force_w )
  call real_init( force_p )
  call real_init( force_t )
  call real_init( force_qv )
  call real_init( force_qt )

  !-- temporary terms

  call real_init( ADV_u )
  call real_init( ADV_v )
  call real_init( ADV_w )
  call real_init( ADV_t )
  call real_init( ADV_qv )
  call real_init( ADV_qt )

  !-- grid ؤͤγǼ
  !-- 줿ͽѿѿسǼ.
  call reset_val()

  !-- u -> v, w, v -> u, w, w -> u, v
  call auto_staggered_interp()

  !-- ƶη׻
  !-- ADVECTION
  call ADV_calc()
!  call DIFF_calc()
!  call BUOY_calc()
!  call CLOUD_calc()
!  call CC_calc()
!  call GRADP_calc()
!  call FLUX_calc()
!  call RAD_calc()

  !-- γƹ׻, 

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(j,k)

  do k=1,nz
     do j=1,nr
        force_u(j,k)=ADV_u(j,k)+DIFF_u(j,k)+GRADP_u(j,k)+CC_u(j,k)+SPG_u(j,k)
        force_v(j,k)=ADV_v(j,k)+DIFF_v(j,k)+CC_v(j,k)+SPG_v(j,k)
        force_w(j,k)=ADV_w(j,k)+DIFF_w(j,k)+GRADP_w(j,k)+BUOY_w(j,k)+SPG_w(j,k)
        force_p(j,k)=FLUX_s(j,k)
        force_t(j,k)=ADV_t(j,k)+DIFF_t(j,k)+RAD_t(j,k)+SPG_t(j,k)
        force_qv(j,k)=ADV_qv(j,k)+DIFF_qv(j,k)+SPG_qv(j,k)
        force_qt(j,k)=ADV_qt(j,k)+DIFF_qt(j,k)+SPG_qt(j,k)+FALL_qt(j,k)
!write(*,*) "check each val", ADV_u(j,k), ADV_v(j,k), ADV_w(j,k), ADV_t(j,k), j, k
     end do
  end do

!$omp end do
!$omp end parallel

end subroutine


subroutine ADV_calc()
!-- ή׻Ԥ.
  use val_define
  implicit none
  integer :: j, k
  real, dimension(nr+1,nz+1) :: dudr_u, dvdr_s, dwdr_w, dtdr_s, dqvdr_s, dqtdr_s
  real, dimension(nr+1,nz+1) :: dudz_u, dvdz_s, dwdz_w, dtdz_s, dqvdz_s, dqtdz_s

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(k)
  do k=1,nz+1
     !-- (dudr)_u
     call grad_1d( r_u, u_u(:,k), dudr_u(:,k) )
     !-- (dwdr)_w
     call grad_1d( r_s, w_w(:,k), dwdr_w(:,k) )
     !-- (dphidr)_s
     call grad_1d( r_s, v_s(:,k), dvdr_s(:,k) )
     call grad_1d( r_s, t_s(:,k), dtdr_s(:,k) )
     call grad_1d( r_s, qv_s(:,k), dqvdr_s(:,k) )
     call grad_1d( r_s, qt_s(:,k), dqtdr_s(:,k) )
  end do
!$omp end do

!$omp do schedule(dynamic) private(j)
  do j=1,nr+1
     !-- (dudz)_u
     call grad_1d( z_s, u_u(j,:), dudz_u(j,:) )
     !-- (dwdz)_w
     call grad_1d( z_w, w_w(j,:), dwdz_w(j,:) )
     !-- (dphidz)_s
     call grad_1d( z_s, v_s(j,:), dvdz_s(j,:) )
     call grad_1d( z_s, t_s(j,:), dtdz_s(j,:) )
     call grad_1d( z_s, qv_s(j,:), dqvdz_s(j,:) )
     call grad_1d( z_s, qt_s(j,:), dqtdz_s(j,:) )
  end do
!$omp end do
!$omp end parallel

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(j,k)
  do k=1,nz+1
     do j=1,nr+1
        ADV_u(j,k)=-u_u(j,k)*dudr_u(j,k)-w_u(j,k)*dudz_u(j,k)
        ADV_v(j,k)=-u_s(j,k)*dvdr_s(j,k)-w_s(j,k)*dvdz_s(j,k)
        ADV_w(j,k)=-u_w(j,k)*dwdr_w(j,k)-w_w(j,k)*dwdz_w(j,k)
        ADV_t(j,k)=-u_s(j,k)*dtdr_s(j,k)-w_s(j,k)*dtdz_s(j,k)
        ADV_qv(j,k)=-u_s(j,k)*dqvdr_s(j,k)-w_s(j,k)*dqvdz_s(j,k)
        ADV_qt(j,k)=-u_s(j,k)*dqtdr_s(j,k)-w_s(j,k)*dqtdz_s(j,k)
if(ADV_u(j,k)/=0.0)then
   write(*,*) "ADV u check", u_u(j,k), w_u(j,k), dudr_u(j,k), dudz_u(j,k), j, k
end if
if(ADV_u(j,k)/=0.0)then
   write(*,*) "ADV v check", u_s(j,k), w_s(j,k), dvdr_s(j,k), dvdz_s(j,k), j, k
end if
if(ADV_w(j,k)/=0.0)then
   write(*,*) "ADV w check", u_w(j,k), w_w(j,k), dwdr_w(j,k), dwdz_w(j,k), j, k
end if
if(ADV_t(j,k)/=0.0)then
   write(*,*) "ADV t check", u_s(j,k), w_s(j,k), dtdr_s(j,k), dtdz_s(j,k), j, k
end if
     end do
  end do
!$omp end do
!$omp end parallel

end subroutine ADV_calc


subroutine CC_calc()
!-- Ϥȥꥪ׻.
  use val_define
  implicit none
  integer :: j, k

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(j,k)
  do k=1,nz+1
     do j=1,nr+1
        if(r_u(j)/=0.0)then
           CC_u(j,k)=(coril+v_u(j,k)/r_u(j))*v_u(j,k)
        else
           CC_u(j,k)=0.0
        end if
        if(r_s(j)/=0.0)then
           CC_v(j,k)=-(coril+v_s(j,k)/r_s(j))*u_s(j,k)
        else
           CC_v(j,k)=0.0
        end if
     end do
  end do
!$omp end do
!$omp end parallel

end subroutine CC_calc


subroutine BUOY_calc()
!-- Ϥ׻.
  use val_define
  use Phys_Const
  implicit none
  integer :: j, k

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(j,k)
  do k=1,nz+1
     do j=1,nr+1
        BUOY_w(j,k)=g*((t_w(j,k)-ptb_w(j,k))/ptb_w(j,k)  &
  &                    +0.61*(qv_w(j,k)-qvb_w(j,k))-qt_w(j,k))
     end do
  end do
!$omp end do
!$omp end parallel

end subroutine BUOY_calc


subroutine FLUX_calc()
!-- Υեå׻.
  use val_define
  use Thermo_Const
  implicit none
  integer :: j, k
  real, dimension(nr+1,nz+1) :: fu_s, fw_s, dfudr_s, dfwdz_s

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(j,k)
  do k=1,nz+1
     do j=1,nr+1
        fu_s(j,k)=r_s(j)*u_s(j,k)*rhob_s(j,k)*ptvb_s(j,k)
        fw_s(j,k)=w_s(j,k)*rhob_s(j,k)*ptvb_s(j,k)
     end do
  end do
!$omp end do
!$omp end parallel

  !-- (dfudr)_s
!$omp parallel default(shared)
!$omp do schedule(dynamic) private(k)
  do k=1,nz+1
     call grad_1d( r_s, fu_s(:,k), dfudr_s(:,k) )
  end do
!$omp end do

!$omp do schedule(dynamic) private(j)
  !-- (dfwdr)_s
  do j=1,nr+1
     call grad_1d( z_s, fw_s(j,:), dfwdz_s(j,:) )
  end do
!$omp end do
!$omp end parallel

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(j,k)
  do k=1,nz+1
     do j=1,nr+1
        if(r_s(j)/=0.0)then
           FLUX_s(j,k)=((Cpd/Cvd)*Rd*tempb_s(j,k)/(Cpd*rhob_s(j,k)*ptvb_s(j,k)*ptvb_s(j,k)))  &
  &                    *(dfudr_s(j,k)/r_s(j)+dfwdz_s(j,k))
        else
           FLUX_s(j,k)=0.0
        end if
     end do
  end do
!$omp end do
!$omp end parallel

end subroutine FLUX_calc


subroutine GRADP_calc()
!-- Ϸٷ׻Ԥ.
  use val_define
  use Thermo_Const
  implicit none
  integer :: j, k
  real, dimension(nr+1,nz+1) :: dpdr_u, dpdz_w

  !-- (dpdr)_u
!$omp parallel default(shared)
!$omp do schedule(dynamic) private(k)
  do k=1,nz+1
     call grad_back_1d( r_s, p_s(:,k), dpdr_u(:,k) )
  end do
!$omp end do

!$omp do schedule(dynamic) private(j)
  !-- (dpdz)_w
  do j=1,nr+1
     call grad_back_1d( z_s, p_s(j,:), dpdz_w(j,:) )
  end do
!$omp end do
!$omp end parallel

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(j,k)
  do k=1,nz+1
     do j=1,nr+1
        GRADP_u(j,k)=-Cpd*ptvb_u(j,k)*dpdr_u(j,k)
        GRADP_w(j,k)=-Cpd*ptvb_w(j,k)*dpdz_w(j,k)
     end do
  end do
!$omp end do
!$omp end parallel

end subroutine GRADP_calc


subroutine RAD_calc()
  use val_define
  implicit none
  integer :: j, k

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(j,k)
  do k=1,nz+1
     do j=1,nr+1
        RAD_t(j,k)=-(t_s(j,k)-ptb_s(j,k))/tau_R
     end do
  end do
!$omp end do
!$omp end parallel

end subroutine RAD_calc


subroutine DIFF_calc()
!-- ήȻ׻.
  use val_define
  implicit none
  integer :: j, k
  real :: tmpa, tmpb
  real, dimension(nr+1,nz+1) :: dvrdr_s
  real, dimension(nr+1,nz+1) :: dwdr_u, dwdr_w, dwdr_s
  real, dimension(nr+1,nz+1) :: dudr_u, dudr_w, dudr_s
  real, dimension(nr+1,nz+1) :: dvdr_u, dvdr_w, dvdr_s
  real, dimension(nr+1,nz+1) :: dwdz_u, dwdz_w, dwdz_s
  real, dimension(nr+1,nz+1) :: dudz_u, dudz_w, dudz_s
  real, dimension(nr+1,nz+1) :: dvdz_u, dvdz_w, dvdz_s
  real, dimension(nr+1,nz+1) :: dptvbdz_u, dptvbdz_w, dptvbdz_s
  real, dimension(nr+1,nz+1) :: dptvdz_u, dptvdz_w, dptvdz_s
  real, dimension(nr+1,nz+1) :: qall_u, qall_s, qall_w
  real, dimension(nr+1,nz+1) :: dqalldz_u, dqalldz_s, dqalldz_w
  real, dimension(nr+1,nz+1) :: dptedz_u, dptedz_s, dptedz_w
  real, dimension(nr+1,nz+1) :: ftr_s, fqvr_s, fqtr_s
  real, dimension(nr+1,nz+1) :: ftz_s, fqvz_s, fqtz_s
  real, dimension(nr+1,nz+1) :: ftz_w, fqvz_w, fqtz_w
  real, dimension(nr+1,nz+1) :: taurr_u, tauzz_w, tautt_u
  real, dimension(nr+1,nz+1) :: taurz_u, taurz_w, taurt_s, tauzt_s
  real, dimension(nr+1,nz+1) :: S_u, S_w, S_s
  real, dimension(nr+1,nz+1) :: Ri_u, Ri_w, Ri_s
  real, dimension(nr+1,nz+1) :: nu_u, nu_w, nu_s
  real, dimension(nr+1,nz+1) :: drtrrdr_u, dr2trtdr_s, drtrzdr_w
  real, dimension(nr+1,nz+1) :: dftrdr_s, dfqvrdr_s, dfqtrdr_s
  real, dimension(nr+1,nz+1) :: dtrzdz_u, dtztdz_s, dtzzdz_w
  real, dimension(nr+1,nz+1) :: dftzdz_s, dfqvzdz_s, dfqtzdz_s
  real, dimension(nr+1,nz+1) :: tmpv_s
  real, dimension(nr+1) :: CD_u, CD_s, CE_s

  !-- preparing calc
!$omp parallel default(shared)
!$omp do schedule(dynamic) private(j,k)
  do k=1,nz+1
     do j=1,nr+1
        if(r_s(j)/=0.0)then
           tmpv_s(j,k)=v_s(j,k)/r_s(j)
        else
           tmpv_s(j,k)=0.0
        end if
     end do
  end do
!$omp end do
!$omp end parallel

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(k)
  do k=1,nz+1
     call grad_back_1d( r_s, w_s(:,k), dwdr_u(:,k) )  ! taurz_u
     call grad_1d( r_s, w_w(:,k), dwdr_w(:,k) )            ! taurz_w
     call grad_1d( r_s, w_s(:,k), dwdr_s(:,k) )
     call grad_1d( r_u, u_u(:,k), dudr_u(:,k) )
     call grad_1d( r_s, u_s(:,k), dudr_s(:,k) )
     call grad_1d( r_s, u_w(:,k), dudr_w(:,k) )
     call grad_1d( r_s, tmpv_s(:,k), dvrdr_s(:,k) )
     call grad_1d( r_s, v_s(:,k), dvdr_s(:,k) )
     call grad_back_1d( r_s, v_s(:,k), dvdr_u(:,k) )
     call grad_1d( r_s, v_w(:,k), dvdr_w(:,k) )
     call grad_1d( r_s, t_s(:,k), ftr_s(:,k) )
     call grad_1d( r_s, qv_s(:,k), fqvr_s(:,k) )
     call grad_1d( r_s, qt_s(:,k), fqtr_s(:,k) )
  end do
!$omp end do

!$omp do schedule(dynamic) private(k)
  do j=1,nr+1
     call grad_1d( z_s, u_u(j,:), dudz_u(j,:) )            ! taurz_u
     call grad_back_1d( z_s, u_s(j,:), dudz_w(j,:) )       ! taurz_w
     call grad_1d( z_s, u_s(j,:), dudz_s(j,:) )
     call grad_1d( z_s, v_u(j,:), dvdz_u(j,:) )
     call grad_1d( z_s, v_s(j,:), dvdz_s(j,:) )
     call grad_back_1d( z_s, v_s(j,:), dvdz_w(j,:) )
     call grad_1d( z_s, w_u(j,:), dwdz_u(j,:) )
     call grad_for_1d( z_w, w_w(j,:), dwdz_s(j,:) )
     call grad_1d( z_w, w_w(j,:), dwdz_w(j,:) )
     call grad_1d( z_s, t_s(j,:), ftz_w(j,:) )
     call grad_1d( z_s, qv_s(j,:), fqvz_w(j,:) )
     call grad_1d( z_s, qt_s(j,:), fqtz_w(j,:) )
     call grad_1d( z_s, qall_u(j,:), dqalldz_u(j,:) )
     call grad_1d( z_s, qall_s(j,:), dqalldz_s(j,:) )
     call grad_back_1d( z_s, qall_s(j,:), dqalldz_w(j,:) )
     call grad_1d( z_s, pte_u(j,:), dptedz_u(j,:) )
     call grad_1d( z_s, pte_s(j,:), dptedz_s(j,:) )
     call grad_back_1d( z_s, pte_s(j,:), dptedz_w(j,:) )
     call grad_1d( z_s, ptvb_u(j,:), dptvbdz_u(j,:) )
     call grad_1d( z_s, ptvb_s(j,:), dptvbdz_s(j,:) )
     call grad_back_1d( z_s, ptvb_s(j,:), dptvbdz_w(j,:) )
     call grad_1d( z_s, ptv_u(j,:), dptvdz_u(j,:) )
     call grad_1d( z_s, ptv_s(j,:), dptvdz_s(j,:) )
     call grad_back_1d( z_s, ptv_s(j,:), dptvdz_w(j,:) )
  end do
!$omp end do
!$omp end parallel

  !-- calculating nu
  !-- 1st. calculating S
!$omp parallel default(shared)
!$omp do schedule(dynamic) private(j,k)
  do k=1,nz+1
     do j=1,nr+1
        if(r_u(j)/=0.0)then
           S_u(j,k)=2.0*(dudr_u(j,k)**2+(u_u(j,k)/r_u(j))**2+dwdz_u(j,k)**2)  &
  &                 +(dudz_u(j,k)+dwdr_u(j,k))**2  &
  &                 +(dvdr_u(j,k)-v_u(j,k)/r_u(j))**2  &
  &                 +dvdz_u(j,k)**2
        else
           S_u(j,k)=0.0
        end if
        if(r_s(j)/=0.0)then
           S_s(j,k)=2.0*(dudr_s(j,k)**2+(u_s(j,k)/r_s(j))**2+dwdz_s(j,k)**2)  &
  &                 +(dudz_s(j,k)+dwdr_s(j,k))**2  &
  &                 +(dvdr_s(j,k)-v_s(j,k)/r_s(j))**2  &
  &                 +dvdz_s(j,k)**2
           S_w(j,k)=2.0*(dudr_w(j,k)**2+(u_w(j,k)/r_s(j))**2+dwdz_w(j,k)**2)  &
  &                 +(dudz_w(j,k)+dwdr_w(j,k))**2  &
  &                 +(dvdr_w(j,k)-v_w(j,k)/r_s(j))**2  &
  &                 +dvdz_w(j,k)**2
        else
           S_s(j,k)=0.0
           S_w(j,k)=0.0
        end if
     end do
  end do
!$omp end do
!$omp end parallel

  !-- 2nd. calculating Ri
!$omp parallel default(shared)
!$omp do schedule(dynamic) private(j,k)
  do k=1,nz+1
     do j=1,nr+1
        if(qt_u(j,k)>0.0)then
           if(S_u(j,k)/=0.0)then
              tmpa=1.0+LH(temp_u(j,k))*qv_u(j,k)/(Rd*temp_u(j,k))
              tmpb=1.0+0.622*(LH(temp_u(j,k))**2)*qv_u(j,k)/(Cpd*Rd*(temp_u(j,k)**2))
              Ri_u(j,k)=((tmpa/(tmpb*ptvb_u(j,k)))*dptedz_u(j,k)-dqalldz_u(j,k))  &
  &                     *(g/(S_u(j,k)*S_u(j,k)))
           else
              Ri_u(j,k)=0.0
           end if
           if(S_s(j,k)/=0.0)then
              tmpa=1.0+LH(temp_s(j,k))*qv_s(j,k)/(Rd*temp_s(j,k))
              tmpb=1.0+0.622*(LH(temp_s(j,k))**2)*qv_s(j,k)/(Cpd*Rd*(temp_s(j,k)**2))
              Ri_s(j,k)=((tmpa/(tmpb*ptvb_s(j,k)))*dptedz_s(j,k)-dqalldz_s(j,k))  &
  &                     *(g/(S_s(j,k)*S_s(j,k)))
           else
              Ri_s(j,k)=0.0
           end if
           if(S_w(j,k)/=0.0)then
              tmpa=1.0+LH(temp_w(j,k))*qv_w(j,k)/(Rd*temp_w(j,k))
              tmpb=1.0+0.622*(LH(temp_w(j,k))**2)*qv_w(j,k)/(Cpd*Rd*(temp_w(j,k)**2))
              Ri_w(j,k)=((tmpa/(tmpb*ptvb_w(j,k)))*dptedz_w(j,k)-dqalldz_w(j,k))  &
  &                     *(g/(S_w(j,k)*S_w(j,k)))
           else
              Ri_w(j,k)=0.0
           end if
        else
           if(S_u(j,k)/=0.0)then
              Ri_u(j,k)=g*dptvdz_u(j,k)/(ptvb_u(j,k)*S_u(j,k)*S_u(j,k))
           else
              Ri_u(j,k)=0.0
           end if
           if(S_s(j,k)/=0.0)then
              Ri_s(j,k)=g*dptvdz_s(j,k)/(ptvb_s(j,k)*S_s(j,k)*S_s(j,k))
           else
              Ri_s(j,k)=0.0
           end if
           if(S_w(j,k)/=0.0)then
              Ri_w(j,k)=g*dptvdz_w(j,k)/(ptvb_w(j,k)*S_w(j,k)*S_w(j,k))
           else
              Ri_w(j,k)=0.0
           end if
        end if
     end do
  end do
!$omp end do
!$omp end parallel

  !-- 3rd. calculating nu
!$omp parallel default(shared)
!$omp do schedule(dynamic) private(j,k)
  do k=1,nz+1
     do j=1,nr+1
        if(Ri_u(j,k)>1.0)then
           nu_u(j,k)=0.0
        else
           nu_u(j,k)=lo*lo*sqrt(1.0-Ri_u(j,k))*S_u(j,k)
        end if
        if(Ri_s(j,k)>1.0)then
           nu_s(j,k)=0.0
        else
           nu_s(j,k)=lo*lo*sqrt(1.0-Ri_s(j,k))*S_s(j,k)
        end if
        if(Ri_w(j,k)>1.0)then
           nu_w(j,k)=0.0
        else
           nu_w(j,k)=lo*lo*sqrt(1.0-Ri_w(j,k))*S_w(j,k)
        end if
     end do
  end do
!$omp end do
!$omp end parallel

  !-- calculating tau
  !-- DIFF term ׻˹碌 r ɬפʲսˤ餫ᤫƤ.
!$omp parallel default(shared)
!$omp do schedule(dynamic) private(j,k)
  do k=1,nz+1
     do j=1,nr+1
        taurr_u(j,k)=2.0*r_u(j)*nu_u(j,k)*dudr_u(j,k)
        tauzz_w(j,k)=2.0*nu_w(j,k)*dwdz_w(j,k)
        taurt_s(j,k)=nu_s(j,k)*(r_s(j)**3)*dvrdr_s(j,k)
        taurz_u(j,k)=nu_u(j,k)*(dudz_u(j,k)+dwdr_u(j,k))
        taurz_w(j,k)=r_s(j)*nu_w(j,k)*(dudz_w(j,k)+dwdr_w(j,k))
        tauzt_s(j,k)=nu_s(j,k)*dvdz_s(j,k)
        if(r_u(j)/=0.0)then
           tautt_u(j,k)=2.0*nu_u(j,k)*u_u(j,k)/r_u(j)
        else
           tautt_u(j,k)=0.0
        end if
        ftr_s(j,k)=-r_s(j)*nu_s(j,k)*ftr_s(j,k)
        fqvr_s(j,k)=-r_s(j)*nu_s(j,k)*fqvr_s(j,k)
        fqtr_s(j,k)=-r_s(j)*nu_s(j,k)*fqtr_s(j,k)
        ftz_s(j,k)=-nu_s(j,k)*ftz_s(j,k)
        fqvz_s(j,k)=-nu_s(j,k)*fqvz_s(j,k)
        fqtz_s(j,k)=-nu_s(j,k)*fqtz_s(j,k)
     end do
  end do
!$omp end do
!$omp end parallel

  !-- surface process
!$omp parallel default(shared)
!$omp do schedule(dynamic) private(j)
  do j=1,nr+1
     CD_u(j)=CD0+4.0e-5*sqrt(u_u(j,1)**2+v_u(j,1)**2)
     CD_s(j)=CD0+4.0e-5*sqrt(u_s(j,1)**2+v_s(j,1)**2)
     CE_s(j)=CD_s(j)
     taurz_u(j,1)=CD_u(j)*u_u(j,1)*sqrt(u_u(j,1)**2+v_u(j,1)**2)
     taurz_w(j,1)=0.0
     tauzt_s(j,1)=CD_s(j)*v_s(j,1)*sqrt(u_s(j,1)**2+v_s(j,1)**2)
     ftr_s(j,1)=r_s(j)*CE_s(j)*sqrt(u_s(j,1)**2+v_s(j,1)**2)*(pts(j)-t_s(j,1))
     fqvr_s(j,1)=r_s(j)*CE_s(j)*sqrt(u_s(j,1)**2+v_s(j,1)**2)*(qvs(j)-qv_s(j,1))
     fqtz_s(j,1)=0.0
  end do
!$omp end do
!$omp end parallel

  !-- domain top process
  do j=1,nr+1
     taurz_u(j,nz+1)=0.0
     taurz_w(j,nz+1)=0.0
     tauzt_s(j,nz+1)=0.0
     ftr_s(j,nz+1)=0.0
     fqvr_s(j,nz+1)=0.0
     fqtz_s(j,nz+1)=0.0
  end do

  !-- gradient tau, F
!$omp parallel default(shared)
!$omp do schedule(dynamic) private(k)
  do k=1,nz+1
     call grad_1d( r_u, taurr_u(:,k), drtrrdr_u(:,k) )
     call grad_1d( r_s, taurt_s(:,k), dr2trtdr_s(:,k) )
     call grad_1d( r_s, taurz_w(:,k), drtrzdr_w(:,k) )
     call grad_1d( r_s, ftr_s(:,k), dftrdr_s(:,k) )
     call grad_1d( r_s, fqvr_s(:,k), dfqvrdr_s(:,k) )
     call grad_1d( r_s, fqtr_s(:,k), dfqtrdr_s(:,k) )
  end do
!$omp end do

!$omp do schedule(dynamic) private(j)
  do j=1,nr+1
     call grad_1d( z_s, taurz_u(:,k), dtrzdz_u(:,k) )
     call grad_1d( z_s, tauzt_s(:,k), dtztdz_s(:,k) )
     call grad_1d( z_w, tauzz_w(:,k), dtzzdz_w(:,k) )
     call grad_1d( z_s, ftz_s(:,k), dftzdz_s(:,k) )
     call grad_1d( z_s, fqvz_s(:,k), dfqvzdz_s(:,k) )
     call grad_1d( z_s, fqtz_s(:,k), dfqtzdz_s(:,k) )
  end do
!$omp end do
!$omp end parallel

  !-- calculating DIFF term
!$omp parallel default(shared)
!$omp do schedule(dynamic) private(j,k)
  do k=1,nz+1
     do j=1,nr+1
        if(r_u(j)/=0.0)then
           DIFF_u(j,k)=(drtrrdr_u(j,k)-tautt_u(j,k))/r_u(j)+dtrzdz_u(j,k)
        else
           DIFF_u(j,k)=0.0
        end if
        if(r_s(j)/=0.0)then
           DIFF_v(j,k)=dr2trtdr_s(j,k)/r_s(j)/r_s(j)+dtztdz_s(j,k)
           DIFF_w(j,k)=drtrzdr_w(j,k)/r_s(j)+dtzzdz_w(j,k)
           DIFF_t(j,k)=-dftrdr_s(j,k)/r_s(j)-dftzdz_s(j,k)
           DIFF_qv(j,k)=-dfqvrdr_s(j,k)/r_s(j)-dfqvzdz_s(j,k)
           DIFF_qt(j,k)=-dfqtrdr_s(j,k)/r_s(j)-dfqtzdz_s(j,k)
        else
           DIFF_v(j,k)=0.0
           DIFF_w(j,k)=0.0
           DIFF_t(j,k)=0.0
           DIFF_qv(j,k)=0.0
           DIFF_qt(j,k)=0.0
        end if
     end do
  end do
!$omp end do
!$omp end parallel

end subroutine DIFF_calc


subroutine SPG_calc()
!-- ݥؤ׻.
  use val_define
  implicit none
  integer :: j, k

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(j,k)
  do k=1,nz+1
     do j=1,nr+1
        if( z_s(k)>zsp )then
           SPG_u(j,k)=-SPG_coe*(z_s(k)-zsp)*(u_u(j,k)-ub_u(j,k))
           SPG_v(j,k)=-SPG_coe*(z_s(k)-zsp)*(v_s(j,k)-vb_s(j,k))
           SPG_t(j,k)=-SPG_coe*(z_s(k)-zsp)*(t_s(j,k)-ptb_s(j,k))
           SPG_qv(j,k)=-SPG_coe*(z_s(k)-zsp)*(qv_s(j,k)-qvb_s(j,k))
           SPG_qt(j,k)=-SPG_coe*(z_s(k)-zsp)*qt_s(j,k)
        else
           SPG_u(j,k)=0.0
           SPG_v(j,k)=0.0
           SPG_t(j,k)=0.0
           SPG_qv(j,k)=0.0
           SPG_qt(j,k)=0.0
        end if
        if( z_w(k)>zsp )then
           SPG_w(j,k)=-SPG_coe*(z_w(k)-zsp)*(w_w(j,k)-wb_w(j,k))
        else
           SPG_w(j,k)=0.0
        end if
     end do
  end do
!$omp end do
!$omp end parallel


end subroutine SPG_calc


subroutine CLOUD_calc()
  use val_define
  implicit none
  integer :: j, k
  real, dimension(nr+1,nz+1) :: termv, qtfall

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(j,k)
  do k=1,nz+1
     do j=1,nr+1
        if(qt_s(j,k)>=qt_thres)then
           termv(j,k)=fallv
        else
           termv(j,k)=0.0
        end if
        qtfall(j,k)=rhob_s(j,k)*qt_s(j,k)*termv(j,k)
     end do
  end do
!$omp end do
!$omp end parallel

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(j,k)
  do j=1,nr+1
     call grad_1d( r_s, qtfall(j,:), FALL_qt(j,:) )
     do k=1,nz+1
        FALL_qt(j,k)=FALL_qt(j,k)/rhob_s(j,k)
     end do
  end do
!$omp end do
!$omp end parallel

end subroutine CLOUD_calc


subroutine auto_staggered_interp()
!-- staggered ʻҤγؤޤԤ.
  use val_define
  implicit none
  integer :: j, k

  !-- u_u -> u_s, u_w
  !-- w_w -> w_s, w_u
  !-- s_s -> s_u, s_w
!$omp parallel default(shared)
!$omp do schedule(dynamic) private(k)
  do k=1,nz+1
     call auto_interpolation_1d( r_u, r_s, u_u(:,k), u_s(:,k), stdopt=.true. )
     call auto_interpolation_1d( r_s, r_u, w_s(:,k), w_u(:,k), stdopt=.true. )
     call auto_interpolation_1d( r_s, r_u, p_s(:,k), p_u(:,k), stdopt=.true. )
     call auto_interpolation_1d( r_s, r_u, t_s(:,k), t_u(:,k), stdopt=.true. )
     call auto_interpolation_1d( r_s, r_u, ptv_s(:,k), ptv_u(:,k), stdopt=.true. )
     call auto_interpolation_1d( r_s, r_u, qv_s(:,k), qv_u(:,k), stdopt=.true. )
     call auto_interpolation_1d( r_s, r_u, qt_s(:,k), qt_u(:,k), stdopt=.true. )
  end do
!$omp end do

!$omp do schedule(dynamic) private(j)
  do j=1,nr+1
     call auto_interpolation_1d( z_s, z_w, u_s(j,:), u_w(j,:), stdopt=.true. )
     call auto_interpolation_1d( z_w, z_s, w_w(j,:), w_s(j,:), stdopt=.true. )
     call auto_interpolation_1d( z_s, z_w, p_s(j,:), p_w(j,:), stdopt=.true. )
     call auto_interpolation_1d( z_s, z_w, t_s(j,:), t_w(j,:), stdopt=.true. )
     call auto_interpolation_1d( z_s, z_w, ptv_s(j,:), ptv_w(j,:), stdopt=.true. )
     call auto_interpolation_1d( z_s, z_w, qv_s(j,:), qv_w(j,:), stdopt=.true. )
     call auto_interpolation_1d( z_s, z_w, qt_s(j,:), qt_w(j,:), stdopt=.true. )
  end do
!$omp end do
!$omp end parallel

end subroutine auto_staggered_interp


subroutine reset_val()
!-- ͽѿκѿؤιԤ.
  use val_define
  use Thermo_Const
  implicit none
  integer :: j, k
  real, dimension(nr+1,nz+1) :: tmp_p
  real :: tmpv

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(j,k)
  do k=1,nz+1
     do j=1,nr+1
        u_u(j,k)=u_old(j,k)
        v_s(j,k)=v_old(j,k)
        w_w(j,k)=w_old(j,k)
        p_s(j,k)=p_old(j,k)
        t_s(j,k)=t_old(j,k)
        qv_s(j,k)=qv_old(j,k)
        qt_s(j,k)=qt_old(j,k)
        tmp_p(j,k)=p0*(pb_s(j,k)+p_old(j,k))**(Cpd/Rd)
        temp_s(j,k)=thetaP_2_T( t_old(j,k), tmp_p(j,k) )
        ptv_s(j,k)=thetaP_2_T( t_old(j,k), tmp_p(j,k) )
!write(*,*) "temp", temp_s(j,k), qv_s(j,k), tmp_p(j,k), pb_s(j,k), p_old(j,k)
     end do
  end do
!$omp end do
!$omp end parallel

!-- ̤ˤѿ򹹿.
  do j=1,nr+1
     tmpv=hydro_calc( z_s(1), temp_s(j,1), tmp_p(j,1),  &
  &                   z_s(2), temp_s(j,2), tmp_p(j,2), 0.0 )
     pts(j)=theta_dry( sst_s(j), tmpv )
     qvs(j)=TP_2_qvs( sst_s(j), tmpv )
  end do

end subroutine reset_val


end module
