!= Tetens (1930) Ѥ˰漾λ
!
!= Evaluate saturation specific humidity with Tetens (1930)
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: saturate_t1930.F90,v 1.2 2008-11-23 15:08:26 morikawa Exp $
! Tag Name::  $Name: dcpam5-20100224 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module saturate_t1930
  !
  != Tetens (1930) Ѥ˰漾λ
  !
  != Evaluate saturation specific humidity with Tetens (1930)
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! Tetens (1930) , ˰¾ $ p^{*} $ ˴ؤʲμ
  ! Ѥ, ˰漾˰漾βʬͤ򻻽Фޤ. 
  !
  ! Saturation specific humidity and temperature derivative of it 
  ! are calculated with a folloing formula for saturation watar vapor pressure 
  ! $ p^{*} $ in Tetens (1930). 
  !
  ! \[
  !    q^{*} (T, p) 
  !      = 611 \varepsilon 
  !        \frac{ \exp \left( \frac{l}{R_v} 
  !                           \left( \frac{1}{273} - \frac{1}{T} \right)
  !                    \right) } { p } \] \[
  !    \DP{q^{*} (T, p)}{T} 
  !      = 611 \varepsilon \frac{l}{R_v T^2}
  !        \frac{ \exp \left( \frac{l}{R_v} 
  !                           \left( \frac{1}{273} - \frac{1}{T} \right)
  !                    \right) } { p }
  !      = \frac{q^{*} l}{R_v T^2}
  ! \]
  !
  ! , $ T $ ϲ, $ p $ ϵ, $ R_v $ ϶ŷʬε,  
  ! $ \varepsilon $ ϶ŷʬ絤ʬ, 
  ! $ l $ ϶ŷʬǮǤ. 
  !
  !== References
  !
  ! * Tetens, O., 1930: 
  !   Uder einige meteorologische Begriffe.
  !   <i>Zeitschrift fur Geophysik</i>, <b>6</b>, 297--309.
  !
  !== Procedures List
  !
  ! CalcQVapSat            :: ˰漾η׻
  ! CalcDQVapSatDTemp      :: ˰漾βʬη׻
  ! ------------  :: ------------
  ! CalcQVapSat            :: Calculate saturation specific humidity
  ! CalcDQVapSatDTemp      :: Calculate temperature derivative of saturation specific humidity
  !
  !--
  !== NAMELIST
  !
  ! NAMELIST#saturate_t1930_nml
  !++

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: CalcQVapSat, CalcDQVapSatDTemp

  ! ѿ
  ! Public variables
  !
  logical, save, public:: saturate_t1930_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !
  character(*), parameter:: module_name = 'saturate_t1930'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20100224 $' // &
    & '$Id: saturate_t1930.F90,v 1.2 2008-11-23 15:08:26 morikawa Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !

contains

  function CalcQVapSat( Temp, Press ) result( QVapSat )
    !
    !  *Temp* ȵ *Press* Ѥ, 
    ! ˰漾 *QVapSat* ޤ. 
    !
    ! Calculate saturation specific humidity *QVapSat* using
    ! temperature *Temp* and air pressure *Press*. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & GasRWet, &
                              ! $ R_v $ [J kg-1 K-1]. 
                              ! ŷʬε. 
                              ! Gas constant of condensible elements
      & LatentHeat, &
                              ! $ L $ [J kg-1] . 
                              ! ŷǮ. 
                              ! Latent heat of condensation
      & EpsV                  ! $ \epsilon_v $ . 
                              ! ʬ. 
                              ! Molecular weight of water vapor

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: Temp
                              ! $ T $ . . Temperature
    real(DP), intent(in):: Press
                              ! $ p $ . . Air pressure
    real(DP):: QVapSat
                              ! $ q^{*} $ . ˰漾. Saturation specific humidity

    ! ѿ
    ! Work variables
    !

    ! ˰漾׻Τʸؿ (CalcQVapSatSF, CalcDQVapSatDTempSF)
    ! Declaration of statement function for 
    !   calculation of saturation specific humidity 
    !   ("CalcQVapSatSF", "CalcDQVapSatDTempSF")
    !
#include "../saturate/saturate_t1930_sf.f90"
    EpsVSF    = EpsV
    LatHeatSF = LatentHeat
    GasRWetSF = GasRWet

    ! ¹ʸ ; Executable statement
    !

    ! ˰漾η׻
    ! Calculate saturation specific humidity
    !
    ! CalcQVapSatSF ʸؿ. (¹ʸľ)
    ! "CalcQVapSatSF" is statement function and 
    !   is declared just before executable statement. 
    ! 
    QVapSat = CalcQVapSatSF( Temp, Press )

  end function CalcQVapSat

  !-------------------------------------------------------------------

  function CalcDQVapSatDTemp( Temp, QVapSat ) result( DQVapSatDTemp )
    !
    !  *Temp* ˰漾 *QVapSat* Ѥ, 
    ! ˰漾βʬ *DQVapSatDTemp* ޤ. 
    !
    ! Calculate temperature derivative of saturation specific humidity 
    ! *DQVapSatDTemp* using
    ! temperature *Temp* and saturation specific humidity *QVapSat*. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & GasRWet, &
                              ! $ R_v $ [J kg-1 K-1]. 
                              ! ŷʬε. 
                              ! Gas constant of condensible elements
      & LatentHeat, &
                              ! $ L $ [J kg-1] . 
                              ! ŷǮ. 
                              ! Latent heat of condensation
      & EpsV                  ! $ \epsilon_v $ . 
                              ! ʬ. 
                              ! Molecular weight of water vapor

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: Temp
                              ! $ T $ . . Temperature
    real(DP), intent(in):: QVapSat
                              ! $ q^{*} $ . ˰漾. Saturation specific humidity
    real(DP):: DQVapSatDTemp
                              ! $ \DP{q^{*}}{T} $ . ˰漾βʬ. 
                              ! Temperature derivative of saturation specific humidity. 

    ! ѿ
    ! Work variables
    !

    ! ˰漾׻Τʸؿ (CalcQVapSatSF, CalcDQVapSatDTempSF)
    ! Declaration of statement function for 
    !   calculation of saturation specific humidity 
    !   ("CalcQVapSatSF", "CalcDQVapSatDTempSF")
    !
#include "../saturate/saturate_t1930_sf.f90"
    EpsVSF    = EpsV
    LatHeatSF = LatentHeat
    GasRWetSF = GasRWet

    ! ¹ʸ ; Executable statement
    !

    ! ˰漾βʬη׻
    ! Calculate temperature derivative of saturation specific humidity
    !
    ! CalcDQVapSatDTempSF ʸؿ. (¹ʸľ)
    ! "CalcDQVapSatDTempSF" is statement function and 
    !   is declared just before executable statement. 
    ! 
    DQVapSatDTemp = CalcDQVapSatDTempSF( Temp, QVapSat )

  end function CalcDQVapSatDTemp

  !-------------------------------------------------------------------

  subroutine SaturateInit
    !
    ! saturate_t1930 ⥸塼νԤޤ. 
    !--
    ! NAMELIST#saturate_t1930_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !++
    !
    ! "saturate_t1930" module is initialized. 
    !--
    ! "NAMELIST#saturate_t1930_nml" is loaded in this procedure. 
    !++

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! ʸ ; Declaration statements
    !
    implicit none

!!$    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
!!$                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
!!$    namelist /saturate_t1930_nml/ 
          !
          ! ǥեͤˤĤƤϽ³ "saturate_t1930#SaturateInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "saturate_t1930#SaturateInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( saturate_t1930_inited ) return
    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !


!!$    ! NAMELIST ɤ߹
!!$    ! NAMELIST is input
!!$    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml, &           ! (in)
!!$        & nml = saturate_t1930_nml, &  ! (out)
!!$        & iostat = iostat_nml )   ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$    end if

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
    saturate_t1930_inited = .true.
  end subroutine SaturateInit

  !-------------------------------------------------------------------

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: gridset_inited

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: constants_inited

    ! ¹ʸ ; Executable statement
    !

    if ( .not. gridset_inited ) &
      & call MessageNotify( 'E', module_name, '"gridset" module is not initialized.' )

    if ( .not. constants_inited ) &
      & call MessageNotify( 'E', module_name, '"constants" module is not initialized.' )

  end subroutine InitCheck

end module saturate_t1930
