!= ǡɤ߹
!
!= Reading time series
!
! Authors::   Yoshiyuki O. Takahashi, Satoshi NODA
! Version::   $Id: read_time_series.f90,v 1.12 2010-08-24 03:14:12 yot Exp $ 
! Tag Name::  $Name: dcpam5-20110228-4 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module read_time_series
  !
  != ǡɤ߹
  !
  != Reading time series
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ɽ̲, O3 ̤ʤɤλǡ NetCDF ե뤫ɤ߹. 
  !
  ! Reading time series data, such as sea surface temperature, O3, and so on, from 
  ! NetCDF file. 
  !
  !== Procedures List
!!$  ! GroundFileGet    :: ɽ̥ǡե
!!$  !--
!!$  ! GroundFileOpen   :: ɽ̥ǡեΥץ
!!$  ! GroundFileOutput :: ɽ̥ǡեؤΥǡ
!!$  ! GroundFileClose  :: ɽ̥ǡեΥ
  !++
  ! ------------     :: ------------
!!$  ! GroundFileGet    :: Input ground data file
!!$  !--
!!$  ! GroundFileOpen   :: Open ground data file
!!$  ! GroundFileOutput :: Data output to ground data file
!!$  ! GroundFileClose  :: Close ground data file
  !++
  !
  !== NAMELIST
  !
!!$  ! NAMELIST#ground_file_io_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING, &  ! ʸ.       Strings. 
    &                 TOKEN      ! .   Keywords. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: SetValuesFromTimeSeriesWrapper
!!$  public:: SetValuesFromTimeSeries

  ! ѿ
  ! Public variables
  !
  logical, save, public:: read_time_series_inited = .false.
                              ! ե饰. 
                              ! Initialization flag


  type time_series_data
    character(STRING):: FileName
                              ! ե̾. 
                              ! File name
    character(STRING):: VarName
                              ! ѿ̾. 
                              ! Variable name
    integer          :: NDims
    integer          :: tmax
    integer          :: NVLevels
    real(DP), pointer:: z_VLevels(:)
    real(DP), pointer:: a_time(:)
    integer , pointer:: a_tindex(:)
    real(DP), pointer:: xyza_SavedData(:,:,:,:)
    real(DP), pointer:: xyz_VarTimeInterpolated(:,:,:)
  end type time_series_data

  logical, save :: flag_mpi_split = .true.

  type(time_series_data), save :: TSDataInfoSST
  type(time_series_data), save :: TSDataInfoSIC
  type(time_series_data), save :: TSDataInfoO3


  ! ѿ
  ! Private variables
  !


  character(*), parameter:: module_name = 'read_time_series_from_file'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20110228-4 $' // &
    & '$Id: read_time_series.f90,v 1.12 2010-08-24 03:14:12 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
  interface SetValuesFromTimeSeriesWrapper
    module procedure SetValFromTimeSeriesWrapper2D, SetValFromTimeSeriesWrapper3D
  end interface

contains

  subroutine SetValFromTimeSeriesWrapper2D( &
    & FileName, VarName, &
    & xy_Var,            &               ! (inout)
    & keyword            &
    & )


    ! ʸ ; Declaration statements
    !
    implicit none

    character(*), intent(in   ):: FileName
                              ! ե̾. 
                              ! File name
    character(*), intent(in   ):: VarName
                              ! ѿ̾. 
                              ! Variable name
    real(DP)    , intent(inout):: xy_Var(0:imax-1, 1:jmax)
                              ! ɽ̲. 
                              ! Surface temperature
    character(*), intent(in   ):: keyword


    if ( keyword == 'SST' ) then
      call SetValuesFromTimeSeries( &
        & TSDataInfoSST,     &
        & FileName, VarName, &
        & xy_Var = xy_Var    &               ! (inout)
        & )
    else if ( keyword == 'SIC' ) then
      call SetValuesFromTimeSeries( &
        & TSDataInfoSIC,     &
        & FileName, VarName, &
        & xy_Var = xy_Var    &               ! (inout)
        & )
    else
      stop 'Unsupported keyword'
    end if


  end subroutine SetValFromTimeSeriesWrapper2D

  !-------------------------------------------------------------------

  subroutine SetValFromTimeSeriesWrapper3D( &
    & FileName, VarName, &
    & xyz_Press,         &               ! (in)
    & xyz_Var,           &               ! (inout)
    & keyword            &
    & )


    ! ʸ ; Declaration statements
    !
    implicit none

    character(*), intent(in   ):: FileName
                              ! ե̾. 
                              ! File name
    character(*), intent(in   ):: VarName
                              ! ѿ̾. 
                              ! Variable name
    real(DP)    , intent(in   ):: xyz_Press(0:imax-1, 1:jmax, 1:kmax)
                              ! ɽ̲. 
                              ! Surface temperature
    real(DP)    , intent(inout):: xyz_Var(0:imax-1, 1:jmax, 1:kmax)
                              ! ɽ̲. 
                              ! Surface temperature
    character(*), intent(in   ):: keyword


    if ( keyword == 'O3' ) then
      call SetValuesFromTimeSeries( &
        & TSDataInfoO3,          &
        & FileName, VarName,     &
        & xyz_Press = xyz_Press, &           ! (in)
        & xyz_Var = xyz_Var      &           ! (inout)
        & )
    else
      stop 'Unsupported keyword'
    end if


  end subroutine SetValFromTimeSeriesWrapper3D

  !-------------------------------------------------------------------

  subroutine SetValuesFromTimeSeries( &
    & TSDataInfo,        &
    & FileName, VarName, &
    & xyz_Press,         &               ! (in   ) optional
    & xy_Var,            &               ! (inout) optional
    & xyz_Var            &               ! (inout) optional
    & )
    !
    ! ɽ̤νΥǡꤷޤ. 
    ! xy_SurfTemp ʳϰܤ˸ƤФ줿Τꤵޤ. 
    !
    ! Get various data on ground. 
    ! Arguments excluding "xy_SurfTemp" are configured at first only. 
    !

    ! ⥸塼 ; USE statements
    !

    ! gtool4 ǡ
    ! Gtool4 data input
    !
    use gtool_history, only: HistoryGet

    ! ʸ
    ! Character handling
    !
    use dc_string, only: toChar

    ! դӻμ갷
    ! Date and time handler
    !
    use dc_calendar, only: DCCalDateEvalSecOfYear

    ! 
    ! Time control
    !
    use timeset, only: TimeN, InitialDate

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! ʸ ; Declaration statements
    !
    implicit none

    type(time_series_data), intent(inout):: TSDataInfo
    character(*)          , intent(in   ):: FileName
                              ! ե̾. 
                              ! File name
    character(*)          , intent(in   ):: VarName
                              ! ѿ̾. 
                              ! Variable name
    real(DP)    , optional, intent(in   ):: xyz_Press(0:imax-1, 1:jmax, 1:kmax)
                              ! 3 . 
                              ! 3D array
    real(DP)    , optional, intent(inout):: xy_Var (0:imax-1, 1:jmax)
                              ! 2 . 
                              ! 2D array
    real(DP)    , optional, intent(inout):: xyz_Var(0:imax-1, 1:jmax, 1:kmax)
                              ! 3 . 
                              ! 3D array

    ! ѿ
    ! Work variables
    !
    real(DP):: SecOfYear
    integer :: tindex

!!$    real(DP):: xyza_VarInterpolated(0:imax-1, 1:jmax, 1:kmax, 2)

    integer :: t

    if ( ( .not. present( xy_Var ) ) .and. ( .not. present( xyz_Var ) ) ) then
      call MessageNotify( 'E', module_name, 'xy_Var or xyz_Var have to be given.' )
    end if

    if ( ( present( xyz_Var ) ) .and. ( .not. present( xyz_Press ) ) ) then
      call MessageNotify( 'E', module_name, 'xyz_Press has to be given, when xyz_Var is given.' )
    end if

    ! ¹ʸ ; Executable statement
    !
    if ( .not. associated( TSDataInfo % a_time ) ) then
      if ( present( xy_Var ) ) then
        call StructureInit(       &
          & FileName, VarName, 2, &
          & TSDataInfo            &
          & )
      else
        call StructureInit(       &
          & FileName, VarName, 3, &
          & TSDataInfo            &
          & )
      end if
    end if


    ! Update values of time paying attention to leap year
    !
    call UpdateTime(     &
      & TSDataInfo             & ! (inout)
      & )


    if ( TSDataInfo % tmax >= 2 ) then

      SecOfYear = DCCalDateEvalSecOfYear( TimeN, date = InitialDate )

!!$      write( 6, * ) TSDataInfo%a_time(TSDataInfo%a_tindex(1)), &
!!$        & SecOfYear, TSDataInfo%a_time(TSDataInfo%a_tindex(2))

      if ( ( SecOfYear <   TSDataInfo%a_time(TSDataInfo%a_tindex(1)) ) .or. &
        &  ( SecOfYear >=  TSDataInfo%a_time(TSDataInfo%a_tindex(2)) ) ) then

        TSDataInfo % a_tindex(1) = 0
        TSDataInfo % a_tindex(2) = 1
        do t = 1, TSDataInfo%tmax
          if ( TSDataInfo % a_time(t) <= SecOfYear ) then
            TSDataInfo % a_tindex(1) = t
            TSDataInfo % a_tindex(2) = t+1
          end if
        end do

!!$        write( 6, * ) '##############################################'
!!$        write( 6, * ) '##############################################'
!!$        write( 6, * ) '##############################################'
!!$        write( 6, * ) '##############################################'
!!$        write( 6, * ) '##############################################'
!!$        write( 6, * ) 'in if', TSDataInfo % a_tindex(1), TSDataInfo % a_tindex(2)
!!$        write( 6, * ) '##############################################'
!!$        write( 6, * ) '##############################################'
!!$        write( 6, * ) '##############################################'
!!$        write( 6, * ) '##############################################'
!!$        write( 6, * ) '##############################################'

        tindex = TSDataInfo % a_tindex(1)
        if ( tindex == 0 ) then
          tindex = TSDataInfo % tmax
        else if ( tindex == TSDataInfo % tmax + 1 ) then
          tindex = 1
        else
          tindex = tindex
        end if

        if ( present( xy_Var ) ) then
          call HistoryGet(                                       &
            & TSDataInfo%FileName,                               &
            & TSDataInfo%VarName,                                &
            & TSDataInfo%xyza_SavedData(:,:,1,1),                &
            & range = 'time=^'//toChar(tindex),                  &
            & flag_mpi_split = flag_mpi_split                    &
            & )
        else
          call HistoryGet(                                       &
            & TSDataInfo%FileName,                               &
            & TSDataInfo%VarName,                                &
            & TSDataInfo%xyza_SavedData(:,:,:,1),                &
            & range = 'time=^'//toChar(tindex),                  &
            & flag_mpi_split = flag_mpi_split                    &
            & )
        end if

        tindex = TSDataInfo % a_tindex(2)
        if ( tindex == 0 ) then
          tindex = TSDataInfo % tmax
        else if ( tindex == TSDataInfo % tmax + 1 ) then
          tindex = 1
        else
          tindex = tindex
        end if

        if ( present( xy_Var ) ) then
          call HistoryGet(                                       &
            & TSDataInfo%FileName,                               &
            & TSDataInfo%VarName,                                &
            & TSDataInfo%xyza_SavedData(:,:,1,2),                &
            & range = 'time=^'//toChar(tindex),                  &
            & flag_mpi_split = flag_mpi_split                    &
            & )
        else
          call HistoryGet(                                       &
            & TSDataInfo%FileName,                               &
            & TSDataInfo%VarName,                                &
            & TSDataInfo%xyza_SavedData(:,:,:,2),                &
            & range = 'time=^'//toChar(tindex),                  &
            & flag_mpi_split = flag_mpi_split                    &
            & )
        end if

      end if

      if ( present( xy_Var ) ) then
        xy_Var =                                              &
          &   ( TSDataInfo%xyza_SavedData(:,:,1,2)    &
          &   - TSDataInfo%xyza_SavedData(:,:,1,1)  ) &
          & / ( TSDataInfo%a_time(TSDataInfo%a_tindex(2))    &
          &   - TSDataInfo%a_time(TSDataInfo%a_tindex(1))  ) &
          & * ( SecOfYear                                     &
          &    - TSDataInfo%a_time(TSDataInfo%a_tindex(1))  ) &
          & + TSDataInfo%xyza_SavedData(:,:,1,1)
      else

        TSDataInfo%xyz_VarTimeInterpolated =                  &
          &   ( TSDataInfo%xyza_SavedData(:,:,:,2)            &
          &   - TSDataInfo%xyza_SavedData(:,:,:,1)  )         &
          & / ( TSDataInfo%a_time(TSDataInfo%a_tindex(2))     &
          &   - TSDataInfo%a_time(TSDataInfo%a_tindex(1))  )  &
          & * ( SecOfYear                                     &
          &    - TSDataInfo%a_time(TSDataInfo%a_tindex(1))  ) &
          & + TSDataInfo%xyza_SavedData(:,:,:,1)

        call VerticalInterpolation(     &
          & TSDataInfo%NVLevels, TSDataInfo%z_VLevels, & ! (in )
          & TSDataInfo%xyz_VarTimeInterpolated,        & ! (in )
          & xyz_Press,                                 & ! (in )
          & xyz_Var                                    & ! (out)
          & )

      end if

    else

      if ( present( xy_Var ) ) then
        xy_Var = TSDataInfo%xyza_SavedData(:,:,1,1)
      else
        call VerticalInterpolation(     &
          & TSDataInfo%NVLevels, TSDataInfo%z_VLevels, & ! (in )
          & TSDataInfo%xyza_SavedData(:,:,:,1),        & ! (in )
          & xyz_Press,                                 & ! (in )
          & xyz_Var                                    & ! (out)
          & )
      end if

    end if


  end subroutine SetValuesFromTimeSeries

  !-------------------------------------------------------------------

  subroutine VerticalInterpolation(     &
    & NVLevels, z_VLevelsIn, xyz_VarIn, & ! (in )
    & xyz_VLevelsOut,                   & ! (in )
    & xyz_VarOut                        & ! (out)
    & )

    ! ⥸塼 ; USE statements
    !

    ! ʸ ; Declaration statements
    !
    implicit none

    integer , intent(in ):: NVLevels
    real(DP), intent(in ):: z_VLevelsIn(1:NVLevels)
    real(DP), intent(in ):: xyz_VarIn  (0:imax-1, 1:jmax, 1:NVLevels)
    real(DP), intent(in ):: xyz_VlevelsOut(0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(out):: xyz_VarOut    (0:imax-1, 1:jmax, 1:kmax)


    ! ѿ
    ! Work variables
    !
    integer:: i
    integer:: j
    integer:: k
    integer:: kk
    integer:: xyz_kk(0:imax-1, 1:jmax, 1:kmax)


    ! ¹ʸ ; Executable statement
    !

    ! Check order of vertical levels
    !
    if ( z_VlevelsIn(1) < z_VlevelsIn(2) ) then
      call MessageNotify( 'E', module_name, 'The order of vertical levels is inappropriate.' )
    end if


    xyz_kk = 1

    do kk = 1, NVLevels-1

      do k = 1, kmax
        do j = 1, jmax
          do i = 0, imax-1
            if ( xyz_VLevelsOut(i,j,k) < z_VLevelsIn(kk) ) then
              xyz_kk(i,j,k) = kk
            end if
          end do
        end do
      end do

    end do


    do k = 1, kmax
      do j = 1, jmax
        do i = 0, imax-1

!!$          if ( xyz_VLevelsOut(i,j,k) > z_VLevelsIn(1) ) then
!!$            xyz_VarOut(i,j,k) = xyz_VarIn(i,j,1)
!!$
!!$!          else if ( xyz_VLevelsOut(i,j,k) < z_VLevelsIn(NVLevels) ) then
!!$!            call MessageNotify( 'E', module_name, 'Vertical level is out of given range.' )
!!$!!            xyz_VarOut(i,j,k) = 0.0d0
!!$
!!$          else
!!$
!!$            xyz_VarOut(i,j,k) = &
!!$              &   ( xyz_VarIn(i,j,xyz_kk(i,j,k)+1)     - xyz_VarIn(i,j,xyz_kk(i,j,k)) ) &
!!$              & / log( z_VLevelsIn   (xyz_kk(i,j,k)+1) / z_VLevelsIn(xyz_kk(i,j,k))   ) &
!!$              & * log( xyz_VLevelsOut(i,j,k)           / z_VLevelsIn(xyz_kk(i,j,k))   ) &
!!$              & + xyz_VarIn(i,j,xyz_kk(i,j,k))
!!$
!!$          end if


          xyz_VarOut(i,j,k) = &
            &   log(   ( xyz_VarIn(i,j,xyz_kk(i,j,k)+1) + 1.0d-100 )                  &
            &        / ( xyz_VarIn(i,j,xyz_kk(i,j,k)  ) + 1.0d-100 )                ) &
            & / log( z_VLevelsIn   (xyz_kk(i,j,k)+1) / z_VLevelsIn(xyz_kk(i,j,k))   ) &
            & * log( xyz_VLevelsOut(i,j,k)           / z_VLevelsIn(xyz_kk(i,j,k))   ) &
            & + log( xyz_VarIn(i,j,xyz_kk(i,j,k)) + 1.0d-100 )
          xyz_VarOut(i,j,k) = exp( xyz_VarOut(i,j,k) )


        end do
      end do
    end do


    do k = 1, kmax
      do j = 1, jmax
        do i = 0, imax-1

          if ( xyz_VarOut(i,j,k) < 0.0d0 ) then
            xyz_VarOut(i,j,k) = 0.0d0
          end if

        end do
      end do
    end do


!!$    i = 0
!!$    j = jmax / 2
!!$    do k = 1, NVLevels
!!$      write( 92, * ) z_VLevelsIn(k), xyz_VarIn(i,j,k)
!!$    end do
!!$    write( 92, * )
!!$    call flush( 92 )
!!$    do k = 1, kmax
!!$      write( 93, * ) xyz_VLevelsOut(i,j,k), xyz_VarOut(i,j,k)
!!$    end do
!!$    write( 93, * )
!!$    call flush( 93 )
!!$    stop


  end subroutine VerticalInterpolation

  !-------------------------------------------------------------------

  subroutine UpdateTime(     &
    & TSDataInfo             & ! (inout)
    & )

    ! ⥸塼 ; USE statements
    !

    ! μ갷
    ! Calendar and Date handler
    !
    use dc_calendar, only: &
      & DC_CAL_DATE             ! ɽǡ.
                                ! Data type for date and time

    ! դӻμ갷
    ! Date and time handler
    !
    use dc_calendar, only: DCCalInquire, DCCalDateCreate, DCCalDateInquire, DCCalDateDifference, DCCalDateChkLeapYear

    ! 
    ! Time control
    !
    use timeset, only: TimeN, InitialDate

    ! ʸ ; Declaration statements
    !
    implicit none

    type(time_series_data), intent(inout):: TSDataInfo


    ! ѿ
    ! Work variables
    !
    integer           :: hour_in_day, min_in_hour, day_in_year
    integer, pointer  :: day_in_month_ptr(:) => null()
    real(DP)          :: sec_in_min, sec_in_day

    integer           :: year
    type(DC_CAL_DATE) :: PreYearDate


    ! ¹ʸ ; Executable statement
    !


    if ( TSDataInfo % tmax >= 2 ) then

      call DCCalInquire( &
        & day_in_month_ptr = day_in_month_ptr , & ! (out)
        & hour_in_day      = hour_in_day  , &     ! (out)
        & min_in_hour      = min_in_hour  , &     ! (out)
        & sec_in_min       = sec_in_min )         ! (out)
      day_in_year = sum( day_in_month_ptr )
      deallocate( day_in_month_ptr )
      sec_in_day  = hour_in_day * min_in_hour * sec_in_min


      ! Set TSDataInfo % a_time(0)
      !

      call DCCalDateInquire(       &
        & year       = year,       & ! (out)
        & elapse_sec = TimeN,      & ! (in)
        & date       = InitialDate & ! (in)
        & )
      call DCCalDateCreate(        &
        & year       = year - 1,   & ! (in)
        & month      = 1,          & ! (in)
        & day        = 1,          & ! (in)
        & hour       = 0,          & ! (in)
        & min        = 0,          & ! (in)
        & sec        = 0.0_DP,     & ! (in)
        & date       = PreYearDate & ! (out)
        & )

      if ( DCCalDateChkLeapYear( 0.0_DP, PreYearDate ) ) then
        TSDataInfo % a_time(0                ) = &
          & - ( ( day_in_year + 1 ) * sec_in_day - TSDataInfo % a_time(TSDataInfo%tmax) )
      else
        TSDataInfo % a_time(0                ) = &
          & - (   day_in_year       * sec_in_day - TSDataInfo % a_time(TSDataInfo%tmax) )
      end if


      ! Set TSDataInfo % a_time(TSDataInfo%tmax+1)
      !

      if ( DCCalDateChkLeapYear( TimeN, InitialDate ) ) then
        TSDataInfo % a_time(TSDataInfo%tmax+1) = &
          &     ( day_in_year + 1 ) * sec_in_day + TSDataInfo % a_time(1              )
      else
        TSDataInfo % a_time(TSDataInfo%tmax+1) = &
          &       day_in_year       * sec_in_day + TSDataInfo % a_time(1              )
      end if


    end if


  end subroutine UpdateTime

  !-------------------------------------------------------------------

  subroutine StructureInit(     &
    & FileName, VarName, NDims, &
    & TSDataInfo                &
    & )

    ! ⥸塼 ; USE statements
    !

    ! gtool4 ǡ
    ! Gtool4 data input
    !
    use gtool_history, only: HistoryGet, HistoryGetPointer

    ! ʸ
    ! Character handling
    !
    use dc_string, only: toChar

    ! դӻμ갷
    ! Date and time handler
    !
    use dc_calendar, only: DCCalInquire, DCCalDateEvalSecOfYear

    ! 
    ! Time control
    !
    use timeset, only: TimeN, InitialDate

    ! NetCDF wrapper
    !
    use netcdf_wrapper, only: NWGetAtt, NWInqDimLen

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! ʸ ; Declaration statements
    !
    implicit none

    character(*)          , intent(in   ):: FileName
                              ! ե̾. 
                              ! File name
    character(*)          , intent(in   ):: VarName
                              ! ѿ̾. 
                              ! Variable name
    integer               , intent(in   ):: NDims
                              ! ְʳѿμ. 
                              ! Number of dimensions except for time dimension
    type(time_series_data), intent(inout):: TSDataInfo


    ! ѿ
    ! Work variables
    !
    real(DP)         :: SecOfYear
!!$    real(DP), pointer:: a_time(:)
    integer          :: tindex
    integer          :: t

    character(STRING):: VLevelName

    character(STRING):: attchar

    integer:: hour_in_day, min_in_hour, day_in_year
    integer, pointer:: day_in_month_ptr(:) => null()
    real(DP):: sec_in_min, sec_in_day

    ! ¹ʸ ; Executable statement
    !

!!$    nullify( a_time )


    call DCCalInquire( &
      & day_in_month_ptr = day_in_month_ptr , & ! (out)
      & hour_in_day      = hour_in_day  , &     ! (out)
      & min_in_hour      = min_in_hour  , &     ! (out)
      & sec_in_min       = sec_in_min )         ! (out)
    day_in_year = sum( day_in_month_ptr )
    deallocate( day_in_month_ptr )
    sec_in_day  = hour_in_day * min_in_hour * sec_in_min


    TSDataInfo % FileName = FileName
    TSDataInfo % VarName  = VarName
    TSDataInfo % NDims    = NDims


    if ( TSDataInfo % NDims == 2 ) then
      TSDataInfo % NVLevels = 1
    else
      VLevelName = "plev"

      call HistoryGetPointer(               &
        & TSDataInfo%FileName,              &
        & VLevelName,                       &
        & TSDataInfo % z_VLevels,           &
        & flag_mpi_split = flag_mpi_split   &
        & )
      TSDataInfo % NVLevels = size( TSDataInfo % z_Vlevels )

    end if


    !-----
!!$    call HistoryGetPointer(               &
!!$      & TSDataInfo%FileName,              &
!!$      & 'time',                           &
!!$      & a_time,                           &
!!$      & flag_mpi_split = flag_mpi_split   &
!!$      & )
!!$    TSDataInfo % tmax = size( a_time )
!!$
!!$    call NWGetAtt( TSDataInfo%FileName, 'time', 'units', attchar )
!!$    if ( ( attchar(1:3) == 'day' ) .or. &
!!$      &  ( attchar(1:3) == 'DAY' ) .or. &
!!$      &  ( attchar(1:3) == 'Day' ) ) then
!!$      a_time = a_time * DAY_SECONDS
!!$    else
!!$      call MessageNotify( 'E', module_name, 'Unit of time, %c, is not supported.', c1 = trim(attchar) )
!!$    end if
    !-----


    call NWInqDimLen( &
      & TSDataInfo%FileName,    & ! (in )
      & 'time', & ! (in )
      & TSDataInfo%tmax      & ! (out)
      & )


    if ( TSDataInfo % tmax >= 2 ) then

      SecOfYear = DCCalDateEvalSecOfYear( TimeN, date = InitialDate )

      !-----
!!$      allocate( TSDataInfo % a_time(0:TSDataInfo%tmax+1) )
!!$      TSDataInfo % a_time(0) = - ( YEAR_DAYS * DAY_SECONDS - a_time(TSDataInfo%tmax) )
!!$      do t = 1, TSDataInfo%tmax
!!$        TSDataInfo % a_time(t) = a_time(t)
!!$      end do
!!$      TSDataInfo % a_time(TSDataInfo%tmax+1) = YEAR_DAYS * DAY_SECONDS + a_time(1)
!!$      deallocate( a_time )
      !-----


      allocate( TSDataInfo % a_time(0:TSDataInfo%tmax+1) )
      call HistoryGet(               &
        & TSDataInfo%FileName,              &
        & 'time',                           &
        & TSDataInfo%a_time(1:TSDataInfo%tmax),                           &
        & flag_mpi_split = flag_mpi_split   &
        & )
      call NWGetAtt( TSDataInfo%FileName, 'time', 'units', attchar )

      if ( ( attchar(1:3) == 'day' ) .or. &
        &  ( attchar(1:3) == 'DAY' ) .or. &
        &  ( attchar(1:3) == 'Day' ) ) then

        TSDataInfo%a_time(1:TSDataInfo%tmax) = &
          & TSDataInfo%a_time(1:TSDataInfo%tmax) * sec_in_day
      else
        call MessageNotify( 'E', module_name, 'Unit of time, %c, is not supported.', &
          & c1 = trim(attchar) )
      end if

      TSDataInfo % a_time(0                ) = &
        & - ( day_in_year * sec_in_day - TSDataInfo % a_time(TSDataInfo%tmax) )
      TSDataInfo % a_time(TSDataInfo%tmax+1) = &
        &     day_in_year * sec_in_day + TSDataInfo % a_time(1              )


      allocate( TSDataInfo % a_tindex(1:2) )
      allocate( TSDataInfo % xyza_SavedData(0:imax-1,1:jmax,1:TSDataInfo%NVLevels,1:2) )

      TSDataInfo % a_tindex(1) = 0
      TSDataInfo % a_tindex(2) = 1
      do t = 1, TSDataInfo%tmax
        if ( TSDataInfo % a_time(t) <= SecOfYear ) then
          TSDataInfo % a_tindex(1) = t
          TSDataInfo % a_tindex(2) = t+1
        end if
      end do

      tindex = TSDataInfo % a_tindex(1)
      if ( tindex == 0 ) then
        tindex = TSDataInfo % tmax
      else if ( tindex == TSDataInfo % tmax + 1 ) then
        tindex = 1
      else
        tindex = tindex
      end if

      if ( TSDataInfo % NDims == 2 ) then
        call HistoryGet(                                       &
          & TSDataInfo%FileName,                               &
          & TSDataInfo%VarName,                                &
          & TSDataInfo%xyza_SavedData(:,:,1,1),                &
          & range = 'time=^'//toChar(tindex),                  &
          & flag_mpi_split = flag_mpi_split                    &
          & )
      else
        call HistoryGet(                                       &
          & TSDataInfo%FileName,                               &
          & TSDataInfo%VarName,                                &
          & TSDataInfo%xyza_SavedData(:,:,:,1),                &
          & range = 'time=^'//toChar(tindex),                  &
          & flag_mpi_split = flag_mpi_split                    &
          & )
      end if

      tindex = TSDataInfo % a_tindex(2)
      if ( tindex == 0 ) then
        tindex = TSDataInfo % tmax
      else if ( tindex == TSDataInfo % tmax + 1 ) then
        tindex = 1
      else
        tindex = tindex
      end if

      if ( TSDataInfo % NDims == 2 ) then
        call HistoryGet(                                       &
          & TSDataInfo%FileName,                               &
          & TSDataInfo%VarName,                                &
          & TSDataInfo%xyza_SavedData(:,:,1,2),                &
          & range = 'time=^'//toChar(tindex),                  &
          & flag_mpi_split = flag_mpi_split                    &
          & )
      else
        call HistoryGet(                                       &
          & TSDataInfo%FileName,                               &
          & TSDataInfo%VarName,                                &
          & TSDataInfo%xyza_SavedData(:,:,:,2),                &
          & range = 'time=^'//toChar(tindex),                  &
          & flag_mpi_split = flag_mpi_split                    &
          & )
      end if

      allocate( TSDataInfo%xyz_VarTimeInterpolated(0:imax-1, 1:jmax, 1:TSDataInfo%NVLevels) )

    else

      !-----
!!$      allocate( TSDataInfo % a_time(TSDataInfo%tmax) )
!!$      do t = 1, TSDataInfo%tmax
!!$        TSDataInfo % a_time(t) = a_time(t)
!!$      end do
      !-----


      allocate( TSDataInfo % a_time(TSDataInfo%tmax) )
      call HistoryGet(               &
        & TSDataInfo%FileName,              &
        & 'time',                           &
        & TSDataInfo%a_time(1:TSDataInfo%tmax),                           &
        & flag_mpi_split = flag_mpi_split   &
        & )
      call NWGetAtt( TSDataInfo%FileName, 'time', 'units', attchar )
      if ( ( attchar(1:3) == 'day' ) .or. &
        &  ( attchar(1:3) == 'DAY' ) .or. &
        &  ( attchar(1:3) == 'Day' ) ) then
        TSDataInfo%a_time(1:TSDataInfo%tmax) = &
          & TSDataInfo%a_time(1:TSDataInfo%tmax) * sec_in_day
      else
        call MessageNotify( 'E', module_name, 'Unit of time, %c, is not supported.', &
          & c1 = trim(attchar) )
      end if

      allocate( TSDataInfo % a_tindex(1:1) )
      allocate( TSDataInfo % xyza_SavedData(0:imax-1,1:jmax,1:TSDataInfo%NVLevels,1:1) )

      TSDataInfo % a_tindex(1) = 1

      if ( TSDataInfo % NDims == 2 ) then
        call HistoryGet(                                       &
          & TSDataInfo%FileName,                               &
          & TSDataInfo%VarName,                                &
          & TSDataInfo%xyza_SavedData(:,:,1,1),                &
          & range = 'time=^'//toChar(TSDataInfo%a_tindex(1)),  &
          & flag_mpi_split = flag_mpi_split                    &
          & )
      else
        call HistoryGet(                                       &
          & TSDataInfo%FileName,                               &
          & TSDataInfo%VarName,                                &
          & TSDataInfo%xyza_SavedData(:,:,:,1),                &
          & range = 'time=^'//toChar(TSDataInfo%a_tindex(1)),  &
          & flag_mpi_split = flag_mpi_split                    &
          & )
      end if

    end if


  end subroutine StructureInit

end module read_time_series
