!= ʪ
!
!= Physical constants settings
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: constants.f90,v 1.7 2010-09-12 01:52:47 yot Exp $ 
! Tag Name::  $Name: dcpam5-20110228-4 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module constants
  !
  != ʪ
  !
  != Physical constants settings
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ʪꤪݴɤԤޤ. 
  ! ǥեͤϵ絤ꤷͤꤵƤޤ. 
  ! ͤ NAMELIST ѿ constants_nml ˤäѹ뤳Ȥ
  ! ǽǤ. 
  !
  ! Physical constants are set and stored. 
  ! By default, values on atmosphere of earth are set. 
  ! These values can be changed by NAMELIST group name 
  ! "constants_nml". 
  !
  !== Procedures List
  !
  ! ConstantsInit :: ʪ
  ! ------------  :: ------------
  ! ConstantsInit :: Settings of physical constants
  !
  !== NAMELIST
  !
  ! NAMELIST#constants_nml
  !


  ! ⥸塼 ; USE statements
  !

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP     ! ټ¿. Double precision. 

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: ConstantsInit

  ! ѿ
  ! Public variables
  !
  logical, save, public:: constants_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  real(DP), parameter, public:: PI = 3.1415926535897932_DP
                              ! $ \pi $ .
                              ! ߼Ψ.  Circular constant
  real(DP), parameter, public:: GasRUniv = 8.314_DP
                              ! $ R^{*} $ [J K-1 mol-1].
                              ! ׵.  Universal gas constant
  real(DP), parameter, public:: StB = 5.67e-8_DP
                              ! $ \sigma_{SB} $ . 
                              ! ƥեܥĥޥ. 
                              ! Stefan-Boltzmann constant
  real(DP), parameter, public:: FKarm = 0.4_DP
                              ! $ k $ .
                              ! ޥ. 
                              ! Karman constant

  real(DP), save, public:: RPlanet
                              ! $ a $ [m]. 
                              ! Ⱦ. 
                              ! Radius of planet
  real(DP), save, public:: Omega
                              ! $ \Omega $ [s-1]. 
                              ! ž®. 
                              ! Angular velocity
  real(DP), save, public:: Grav
                              ! $ g $ [m s-2]. 
                              ! ϲ®. 
                              ! Gravitational acceleration
  real(DP), save, public:: MolWtDry
                              ! $ M $ [kg mol-1]. 
                              ! 絤ʿʬ. 
                              ! Mean molecular weight of dry air
  real(DP), save, public:: CpDry
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure
  real(DP), save, public:: MolWtWet
                              ! $ M_v $ [kg mol-1]. 
                              ! ŷʬʿʬ. 
                              ! Mean molecular weight of condensible elements
  real(DP), save, public:: CpWet
                              ! $ C_v $ [J kg-1 K-1] . 
                              ! ŷʬ갵Ǯ. 
                              ! Specific heat of condensible elements at constant pressure
  real(DP), save, public:: LatentHeat
                              ! $ L $ [J kg-1] . 
                              ! ŷǮ. 
                              ! Latent heat of condensation
  real(DP), save, public:: LatentHeatFusion
                              ! $ L $ [J kg-1] . 
                              ! ͻǮ. 
                              ! Latent heat of fusion

  real(DP), save, public:: GasRDry
                              ! $ R $ [J kg-1 K-1]. 
                              ! 絤ε. 
                              ! Gas constant of air
  real(DP), save, public:: GasRWet
                              ! $ R_v $ [J kg-1 K-1]. 
                              ! ŷʬε. 
                              ! Gas constant of condensible elements
  ! EpsV will be removed. 
  real(DP), save, public:: EpsV
                              ! $ \epsilon_v $ . 
                              ! ʬ. 
                              ! Molecular weight of water vapor


  ! ѿ
  ! Private variables
  !

  character(*), parameter:: module_name = 'constants'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20110228-4 $' // &
    & '$Id: constants.f90,v 1.7 2010-09-12 01:52:47 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  subroutine ConstantsInit
    !
    ! constants ⥸塼νԤޤ. 
    ! NAMELIST#constants_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "constants" module is initialized. 
    ! NAMELIST#constants_nml is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! ʸ ; Declaration statements
    !
    implicit none

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /constants_nml/ &
      & RPlanet, Omega, Grav, &
      & MolWtDry, CpDry, &
      & MolWtWet, CpWet, &
      & LatentHeat
          !
          ! ǥեͤˤĤƤϽ³ "constants#ConstantsInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "constants#ConstantsInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( constants_inited ) return
    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !
    RPlanet          = 6.371e6_DP
    Omega            = 2.0_DP * PI / ( 60.0_DP * 60.0_DP * 23.9345_DP )
    Grav             = 9.8_DP

    CpDry            = 1004.6_DP
    MolWtDry         = 28.964e-3_DP

    CpWet            = 1810.0_DP
    MolWtWet         = 18.01528e-3_DP

    LatentHeat       = 2.5e6_DP 
    LatentHeatFusion = 334.0d3

    ! NAMELIST 
    ! Input from NAMELIST
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &           ! (in)
        & nml = constants_nml, &  ! (out)
        & iostat = iostat_nml )   ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
      if ( iostat_nml == 0 ) write( STDOUT, nml = constants_nml )
    end if

    GasRDry          = GasRUniv / MolWtDry
    GasRWet          = GasRUniv / MolWtWet
    EpsV             = MolWtWet / MolWtDry


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  PI               = %f', d = (/ PI               /) )
    call MessageNotify( 'M', module_name, '  GasRUniv         = %f', d = (/ GasRUniv         /) )
    call MessageNotify( 'M', module_name, '  StB              = %f', d = (/ StB              /) )
    call MessageNotify( 'M', module_name, '  FKarm            = %f', d = (/ FKarm            /) )

    call MessageNotify( 'M', module_name, '  RPlanet          = %f', d = (/ RPlanet          /) )
    call MessageNotify( 'M', module_name, '  Omega            = %f', d = (/ Omega            /) )
    call MessageNotify( 'M', module_name, '  Grav             = %f', d = (/ Grav             /) )

    call MessageNotify( 'M', module_name, '  CpDry            = %f', d = (/ CpDry            /) )
    call MessageNotify( 'M', module_name, '  MolWtDry         = %f', d = (/ MolWtDry         /) )

    call MessageNotify( 'M', module_name, '  CpWet            = %f', d = (/ CpWet            /) )
    call MessageNotify( 'M', module_name, '  MolWtWet         = %f', d = (/ MolWtWet         /) )
    call MessageNotify( 'M', module_name, '  LatentHeat       = %f', d = (/ LatentHeat       /) )
    call MessageNotify( 'M', module_name, '  LatentHeatFusion = %f', d = (/ LatentHeatFusion /) )

    call MessageNotify( 'M', module_name, '  GasRDry          = %f', d = (/ GasRDry          /) )
    call MessageNotify( 'M', module_name, '  GasRWet          = %f', d = (/ GasRWet          /) )
    call MessageNotify( 'M', module_name, '  EpsV       = %f', d = (/ EpsV       /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    constants_inited = .true.
  end subroutine ConstantsInit

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! ¹ʸ ; Executable statement
    !

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

  end subroutine InitCheck

end module constants
