/* src/grph2/uhpack/uherbz.f -- translated by f2c (version 20020621).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "libtinyf2c.h"

/* Common Block Declarations */

struct {
    logical lclip;
} szbls2_;

#define szbls2_1 szbls2_

struct {
    logical lclipt;
} szbtx3_;

#define szbtx3_1 szbtx3_

/* Table of constant values */

static integer c__1 = 1;

/* ----------------------------------------------------------------------- */
/*     Copyright (C) 2000-2004 GFD Dennou Club. All rights reserved. */
/* ----------------------------------------------------------------------- */
/* Subroutine */ int uherbz_(integer *n, real *upx1, real *upx2, real *upy, 
	integer *itype, integer *index, real *rsize)
{
    /* System generated locals */
    integer i__1;
    real r__1;

    /* Builtin functions */
    integer s_wsfi(icilist *), do_fio(integer *, char *, ftnlen), e_wsfi(void)
	    ;

    /* Local variables */
    static integer i__;
    static real dy, vx1, vx2, uyy, vyy;
    static char cobj[80];
    extern /* Subroutine */ int cdblk_(char *, ftnlen);
    static logical lmiss;
    static real rmiss;
    static logical lyuni;
    static real uymin, uymax;
    extern /* Subroutine */ int gllget_(char *, logical *, ftnlen);
    static real rundef;
    extern /* Subroutine */ int glrget_(char *, real *, ftnlen), sglget_(char 
	    *, logical *, ftnlen), msgdmp_(char *, char *, char *, ftnlen, 
	    ftnlen, ftnlen), sgrget_(char *, real *, ftnlen), stftrf_(real *, 
	    real *, real *, real *), swocls_(char *, ftnlen), uuqidv_(real *, 
	    real *), szcllv_(void), szsidx_(integer *), swoopn_(char *, char *
	    , ftnlen, ftnlen), szclsv_(void), szpllv_(real *, real *), 
	    szoplv_(void), szmvlv_(real *, real *), szplsv_(real *, real *), 
	    szopsv_(void), szmvsv_(real *, real *), szstyp_(integer *);

    /* Fortran I/O blocks */
    static icilist io___5 = { 0, cobj, 0, "(2I8,F8.5)", 80, 1 };


    /* Parameter adjustments */
    --upy;
    --upx2;
    --upx1;

    /* Function Body */
    if (*n < 1) {
	msgdmp_("E", "UHERBZ", "NUMBER OF POINTS IS LESS THAN 1.", (ftnlen)1, 
		(ftnlen)6, (ftnlen)32);
    }
    if (*itype == 0) {
	msgdmp_("M", "UHERBZ", "LINE TYPE IS 0 / DO NOTHING.", (ftnlen)1, (
		ftnlen)6, (ftnlen)28);
	return 0;
    }
    if (*index == 0) {
	msgdmp_("M", "UHERBZ", "LINE INDEX IS 0 / DO NOTHING.", (ftnlen)1, (
		ftnlen)6, (ftnlen)29);
	return 0;
    }
    if (*index < 0) {
	msgdmp_("E", "UHERBZ", "LINE INDEX IS LESS THAN 0.", (ftnlen)1, (
		ftnlen)6, (ftnlen)26);
    }
    if (*rsize == 0.f) {
	msgdmp_("M", "UHERBZ", "MARKER SIZE IS 0 / DO NOTHING.", (ftnlen)1, (
		ftnlen)6, (ftnlen)30);
	return 0;
    }
    if (*rsize < 0.f) {
	msgdmp_("E", "UHERBZ", "MARKER SIZE IS LESS THAN ZERO.", (ftnlen)1, (
		ftnlen)6, (ftnlen)30);
    }
    sglget_("LCLIP", &szbls2_1.lclip, (ftnlen)5);
    szbtx3_1.lclipt = szbls2_1.lclip;
    glrget_("RUNDEF", &rundef, (ftnlen)6);
    glrget_("RMISS", &rmiss, (ftnlen)5);
    gllget_("LMISS", &lmiss, (ftnlen)5);
    if (upx1[1] == rundef || upx2[1] == rundef) {
	msgdmp_("E", "UHERBZ", "RUNDEF CAN NOT BE UESED FOR UPY1 OR UPY2", (
		ftnlen)1, (ftnlen)6, (ftnlen)40);
    }
    s_wsfi(&io___5);
    do_fio(&c__1, (char *)&(*itype), (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&(*index), (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&(*rsize), (ftnlen)sizeof(real));
    e_wsfi();
    cdblk_(cobj, (ftnlen)80);
    swoopn_("UHERBZ", cobj, (ftnlen)6, (ftnlen)80);
    szsidx_(index);
    szstyp_(itype);
    lyuni = upy[1] == rundef;
    if (lyuni) {
	uuqidv_(&uymin, &uymax);
	if (uymin == rundef) {
	    sgrget_("UYMIN", &uymin, (ftnlen)5);
	}
	if (uymax == rundef) {
	    sgrget_("UYMAX", &uymax, (ftnlen)5);
	}
	dy = (uymax - uymin) / (*n - 1);
    }
    i__1 = *n;
    for (i__ = 1; i__ <= i__1; ++i__) {
	if (lyuni) {
	    uyy = uymin + dy * (i__ - 1);
	} else {
	    uyy = upy[i__];
	}
	if (! ((uyy == rmiss || upx1[i__] == rmiss || upx2[i__] == rmiss) && 
		lmiss)) {
	    stftrf_(&upx1[i__], &uyy, &vx1, &vyy);
	    stftrf_(&upx2[i__], &uyy, &vx2, &vyy);
	    szoplv_();
	    szmvlv_(&vx1, &vyy);
	    szpllv_(&vx2, &vyy);
	    szcllv_();
	    szopsv_();
	    r__1 = vyy - *rsize / 2.f;
	    szmvsv_(&vx1, &r__1);
	    r__1 = vyy + *rsize / 2.f;
	    szplsv_(&vx1, &r__1);
	    r__1 = vyy - *rsize / 2.f;
	    szmvsv_(&vx2, &r__1);
	    r__1 = vyy + *rsize / 2.f;
	    szplsv_(&vx2, &r__1);
	    szclsv_();
	}
/* L20: */
    }
    swocls_("UHERBZ", (ftnlen)6);
    return 0;
} /* uherbz_ */

