/* src/math1/maplib/mpfmwl.f -- translated by f2c (version 20020621).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "libtinyf2c.h"

/* ----------------------------------------------------------------------- */
/*     MAP PROJECTION (MOLLWEIDE-LIKE)                  93/02/20 S.SAKAI */
/* ----------------------------------------------------------------------- */
/*     Copyright (C) 2000-2004 GFD Dennou Club. All rights reserved. */
/* ----------------------------------------------------------------------- */
/* Subroutine */ int mpfmwl_0_(int n__, real *xlon, real *ylat, real *x, real 
	*y)
{
    /* Builtin functions */
    double cos(doublereal), sin(doublereal), asin(doublereal);

    /* Local variables */
    static real pi, rna;
    extern doublereal rfpi_(void);
    extern /* Subroutine */ int glrget_(char *, real *, ftnlen);
    extern doublereal xmplon_(real *);

    switch(n__) {
	case 1: goto L_mpimwl;
	}

    pi = rfpi_();
    *x = xmplon_(xlon) * 2.8284272000000001f * cos(*ylat) / pi;
    *y = sin(*ylat) * 1.4142136f;
    return 0;
/* ----------------------------------------------------------------------- */

L_mpimwl:
    pi = rfpi_();
    if (dabs(*y) < 1.4142136f) {
	*ylat = asin(*y / 1.4142136f);
	*xlon = *x / 1.4142136f / cos(*ylat) * pi / 2;
	if (dabs(*xlon) <= pi) {
	    return 0;
	}
    } else if (dabs(*y) == 1.4142136f && *x == 0.f) {
	*xlon = 0.f;
	*ylat = *y / 1.4142136f * pi / 2;
    }
    glrget_("RUNDEF", &rna, (ftnlen)6);
    *xlon = rna;
    *ylat = rna;
    return 0;
} /* mpfmwl_ */

/* Subroutine */ int mpfmwl_(real *xlon, real *ylat, real *x, real *y)
{
    return mpfmwl_0_(0, xlon, ylat, x, y);
    }

/* Subroutine */ int mpimwl_(real *x, real *y, real *xlon, real *ylat)
{
    return mpfmwl_0_(1, xlon, ylat, x, y);
    }

