*-----------------------------------------------------------------------
*     USPACK AUTO SCALING ROUTINE (LOG)              S. SAKAI  92/03/04
*-----------------------------------------------------------------------

      SUBROUTINE USUSCL(CAXIS, UMIN,  UMAX,  VMIN,  VMAX,
     #                  NLBL,  NTICKS, ITYPE, UFAC)

      REAL      SC(4)
      CHARACTER CAXIS*1, CP*8
      DATA      SC / 1., 2., 5., 10./

*----------------------- ARGUMENT CHECK --------------------------------

      IF(CAXIS.NE.'X' .AND. CAXIS.NE.'Y')
     #   CALL MSGDMP('E', 'USUSCL', 'INVALID CAXIS')

      IF(VMIN.GE.VMAX)
     #   CALL MSGDMP('E', 'USUSCL', 'VMIN>VMAX')

*--------------------------- PARAMETERS --------------------------------

      CP = CAXIS//'FAC'
      CALL USRGET(CP, UFACA)

      CP = 'ITYPE'//CAXIS
      CALL USIGET(CP, ITYPEA)

      CP = 'NLBL'//CAXIS
      CALL USIGET(CP, NLBLA)

      CP = 'NTICKS'//CAXIS
      CALL USIGET(CP, NTICKA)

      CP = 'MXDGT'//CAXIS
      CALL USIGET(CP, MXDGT)

      CALL GLRGET('RUNDEF' , RUNDEF)
      CALL GLIGET('IUNDEF' , IUNDEF)
      CALL UZRGET('RSIZEL1', CW)

*--------------------------- ITYPE & UFAC ------------------------------

      CALL GNSAVE
      CALL GNSBLK(SC, 4)
      CALL GNGE(UMAX, BUMAX, IPMAX)
      CALL GNLE(UMIN, BUMIN, IPMIN)
      CALL GNRSET

      IF(IPMAX.LE.IPMIN+1) THEN
        ITYPE = 3
        IF(IPMAX+1.GT.MXDGT .OR. 2-IPMIN.GT.MXDGT) THEN
          UFAC = 1.D1**IPMIN
        ELSE
          UFAC = 1.
        ENDIF
      ELSE
        ITYPE = 2
        UFAC  = 1.
      ENDIF

      IF(ITYPEA.NE.IUNDEF) ITYPE = ITYPEA
      IF(UFACA .NE.RUNDEF) UFAC  = UFACA

*--------------------------- NLBL & NTISCKS ----------------------------

      DV = (VMAX-VMIN) / (LOG10(UMAX)-LOG10(UMIN)) / CW
      IF(DV.GE.10.) THEN
        NLBL   = 3
        NTICKS = 9
      ELSEIF(DV.GE.5.) THEN
        NLBL   = 1
        NTICKS = 9
      ELSEIF(DV.GE.2.5) THEN
        NLBL   = 1
        NTICKS = 5
      ELSE
        NLBL   = 1
        NTICKS = 2
      ENDIF

      IF(NLBLA .NE.IUNDEF) NLBL   = NLBLA
      IF(NTICKA.NE.IUNDEF) NTICKS = NTICKA

      RETURN
      END
