/* Copyright (C) by GFD-Dennou Club, 1999-2000.  All rights reserved. */
/*
 *     dcl graphic driver for tektronix emulator
 *
 *                         91/08/10 by S. Takehiro
 *                         91/10/15 by M. Shiotani
 *                         93/04/15 by A. Numaguti (wait option)
 */

#include <stdio.h>

#define WSXMNZ   30.0        /* x-coord. of w.s. window lower-left  corner */
#define WSXMXZ 1000.0        /* y-coord. of w.s. window lower-left  corner */
#define WSYMNZ   30.0        /* x-coord. of w.s. window upper-right corner */
#define WSYMXZ  750.0        /* y-coord. of w.s. window upper-right corner */
#define FACTZ     2.0        /* scaling factor */
#define TRUE   1             /* numeric value for true  */
#define FALSE  0             /* numeric value for false */
#define LWDATR TRUE          /* line width  capability */
#define LCLATR FALSE         /* line color  capability */
#define LTNATR FALSE         /* hard fill   capability */
#define LIMATR FALSE         /* bit image   capability */
#define LPTATR FALSE         /* mouse point capability */

#define FF   12
#define CR   13
#define ES   27
#define GS   29
#define OP   "[?38h"
#define EX   "[?38l"
#define CL    3

static int iwdidz, iclidz, iwtroz, lwait;

/*------------------------- device ------------------------*/

void ztdopn_(iwait)
    int *iwait;
{
    int C;

/* open ( and activate ) workstation */

    lwait = *iwait;
    if (lwait) {
	puts("<CR> to start Tek");
	C = fgetc (stdin);
    }
    fputc (ES, stdout);
    fputs (OP, stdout);
    fputc (CR, stdout);
}

void ztdcls_()
{

/* ( deactivate and ) close workstation */

    fputc (ES, stdout);
    fputc (CL, stdout);
    fputc (CR, stdout);

    fputc (ES, stdout);
    fputc (FF, stdout);
    fputc (CR, stdout);

    fputc (ES, stdout);
    fputs (EX, stdout);
    fputc (CR, stdout);
}

/*------------------------- page --------------------------*/

void ztpopn_()
{

/* open page ( or screen ) */

    fputc (ES, stdout);
    fputc (FF, stdout);
    fputc (CR, stdout);
}

void ztpcls_()
{
    int C;
    void ztixiy();

/* close page ( or screen ) */

    fputc (GS, stdout);
    ztixiy (0, 50);
    if (lwait) {
	puts ("\n<CR> to continue");
	C = fgetc (stdin);
    }
}

/*------------------------- object ------------------------*/

void ztoopn_(objname, comment)
    char *objname, *comment;
{

}

void ztocls_(objname)
    char *objname;
{

}

/*------------------------- line --------------------------*/

void ztswdi_(iwdidx)
    int *iwdidx;
{

/* set line width index */

}

void ztscli_(iclidx)
    int *iclidx;
{

/* set line color index */

}

void ztgopn_()
{

/* open graphic segment */

}

void ztgmov_(wx, wy)
    float *wx, *wy;
{
    int iwx, iwy;
    void ztixiy();

/* pen-up move */

    iwx = *wx;
    iwy = *wy;
    fputc (GS, stdout);
    ztixiy (iwx, iwy);
}

void ztgplt_(wx, wy)
    float *wx, *wy;
{
    int iwx, iwy;
    void ztixiy();

/* pen-down move */

    iwx = *wx;
    iwy = *wy;
    ztixiy (iwx, iwy);
}

void ztgcls_()
{

/* close graphic segment */

    fputc (CR, stdout);
}

/*------------------------- tone --------------------------*/

void ztgton_(np, wpx, wpy, itpat)
    int *np, *itpat;
    float wpx[], wpy[];
{

/* hard fill */

}

/*------------------------- image -------------------------*/

void ztiopn_(iwx, iwy, iwidth, iheight)
    int *iwx, *iwy, *iwidth, *iheight;
{

}

void ztidat_(image, nlen)
    int *nlen, image[];
{

}

void zticls_()
{

}

/*------------------------- mouse -------------------------*/

void ztqpnt_(wx, wy, mb)
    float *wx, *wy;
    int *mb;
{

}

/*---------------------- transformation -------------------*/

void ztfint_(wx, wy, iwx, iwy)
    float *wx, *wy;
    int *iwx, *iwy;
{
    *iwx = *wx;
    *iwy = *wy;
}

void ztiint_(iwx, iwy, wx, wy)
    float *wx, *wy;
    int *iwx, *iwy;
{
    *wx = *iwx;
    *wy = *iwy;
}

/*------------------------- inquiry -----------------------*/

void ztqwdc_(lwdatr)
    int *lwdatr;
{

/* inquire line width capability */

    *lwdatr = LWDATR;
}

void ztqclc_(lclatr)
    int *lclatr;
{

/* inquire line color capability */

    *lclatr = LCLATR;
}

void ztqtnc_(ltnatr)
    int *ltnatr;
{

/* inquire hard fill capability */

    *ltnatr = LTNATR;
}

void ztqimc_(limatr)
    int *limatr;
{

/* inquire bit image capability */

    *limatr = LIMATR;
}

void ztqptc_(lptatr)
    int *lptatr;
{

/* inquire mouse point capability */

    *lptatr = LPTATR;
}

void ztqrct_(wsxmn, wsxmx, wsymn, wsymx, fact)
    float *wsxmn, *wsxmx, *wsymn, *wsymx, *fact;
{

/* inquire workstation rectangle */

    *wsxmn = WSXMNZ;
    *wsxmx = WSXMXZ;
    *wsymn = WSYMNZ;
    *wsymx = WSYMXZ;
    *fact  = FACTZ;
}

void ztsrot_(iwtrot)
    int *iwtrot;
{

/* set frame rotation flag */

    iwtroz = *iwtrot;
}

/*---------------------internal function ------------------*/

void ztixiy(ix, iy)
    int ix, iy;
{
    fputc ((iy / 32) + 32, stdout);
    fputc ((iy % 32) + 96, stdout);
    fputc ((ix / 32) + 32, stdout);
    fputc ((ix % 32) + 64, stdout);
}
