/* Copyright (C) by GFD-Dennou Club, 1999-2000.  All rights reserved. */
/* mpfmer.f -- translated by f2c (version 19990503).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* ----------------------------------------------------------------------- */
/*     MAP PROJECTION (MERCATOR)                        93/02/20 S.SAKAI */
/* ----------------------------------------------------------------------- */
/* Subroutine */ int mpfmer_0_(int n__, real *xlon, real *ylat, real *x, real 
	*y)
{
    /* Builtin functions */
    double tan(doublereal), log(doublereal), exp(doublereal), atan(doublereal)
	    ;

    /* Local variables */
    extern doublereal rfpi_(void);
    static real theta, pi;
    extern /* Subroutine */ int glrget_(char *, real *, ftnlen);
    extern doublereal xmplon_(real *);
    static real rna;

    switch(n__) {
	case 1: goto L_mpimer;
	}

    pi = rfpi_();
    theta = (*ylat + pi / 2) / 2.f;
    if (theta < 1e-5f) {
	theta = 1e-5f;
    }
    if (theta > pi / 2 - 1e-5f) {
	theta = pi / 2 - 1e-5f;
    }
    *x = xmplon_(xlon);
    *y = log(tan(theta));
    return 0;
/* ----------------------------------------------------------------------- */

L_mpimer:
    pi = rfpi_();
    *xlon = *x;
    if (dabs(*xlon) <= pi) {
	*ylat = atan(exp(*y)) * 2 - pi / 2;
	return 0;
    }
    glrget_("RUNDEF", &rna, (ftnlen)6);
    *xlon = rna;
    *ylat = rna;
    return 0;
} /* mpfmer_ */

/* Subroutine */ int mpfmer_(real *xlon, real *ylat, real *x, real *y)
{
    return mpfmer_0_(0, xlon, ylat, x, y);
    }

/* Subroutine */ int mpimer_(real *x, real *y, real *xlon, real *ylat)
{
    return mpfmer_0_(1, xlon, ylat, x, y);
    }

