*-----------------------------------------------------------------------
*     UUPQNP / UUPQID / UUPQCP / UUPQVL / UUPSVL
*-----------------------------------------------------------------------
      SUBROUTINE UUPQNP(NCP)

      CHARACTER CP*(*)

      PARAMETER (NPARA=3, RUNDEF=-999.0)

      INTEGER   IX(NPARA)
      REAL      RX(NPARA)
      LOGICAL   LX(NPARA),LCHREQ,LFIRST
      CHARACTER CPARA(NPARA)*8,CMSG*80

      EQUIVALENCE (IX,RX,LX)

      EXTERNAL  LCHREQ,LENC

      SAVE

      DATA      CPARA( 1)/'UMIN    '/, RX( 1)/RUNDEF/
      DATA      CPARA( 2)/'UMAX    '/, RX( 2)/RUNDEF/
      DATA      CPARA( 3)/'UREF    '/, RX( 3)/0.0/

      DATA      LFIRST/.TRUE./

      NCP=NPARA

      RETURN
*-----------------------------------------------------------------------
      ENTRY UUPQID(CP,IDX)

      DO 10 N=1,NPARA
        IF (LCHREQ(CP,CPARA(N))) THEN
          IDX=N
          RETURN
        END IF
   10 CONTINUE
      CMSG='PARAMETER '''//CP(1:LENC(CP))//''' IS NOT DEFINED.'
      CALL MSGDMP('E','UUPQID',CMSG)

      RETURN
*-----------------------------------------------------------------------
      ENTRY UUPQCP(IDX,CP)

      IF (1.LE.IDX .AND. IDX.LE.NPARA) THEN
        CP=CPARA(IDX)
      ELSE
        CALL MSGDMP('E','UUPQCP','IDX IS OUT OF RANGE.')
      END IF

      RETURN
*-----------------------------------------------------------------------
      ENTRY UUPQVL(IDX,IPARA)

      IF (LFIRST) THEN
        CALL RTPGET('UU:',CPARA,IX,NPARA)
        LFIRST=.FALSE.
      END IF

      IF (1.LE.IDX .AND. IDX.LE.NPARA) THEN
        IPARA=IX(IDX)
      ELSE
        CALL MSGDMP('E','UUPQVL','IDX IS OUT OF RANGE.')
      END IF

      RETURN
*-----------------------------------------------------------------------
      ENTRY UUPSVL(IDX,IPARA)

      IF (LFIRST) THEN
        CALL RTPGET('UU:',CPARA,IX,NPARA)
        LFIRST=.FALSE.
      END IF

      IF (1.LE.IDX .AND. IDX.LE.NPARA) THEN
        IX(IDX)=IPARA
      ELSE
        CALL MSGDMP('E','UUPSVL','IDX IS OUT OF RANGE.')
      END IF

      RETURN
      END
