*-----------------------------------------------------------------------
*     NORMALIZATION TRANSFORMATION (INCLUDING MAP PROJECTION)
*-----------------------------------------------------------------------
*     Copyright (C) 2000 GFD Dennou Club. All rights reserved.
*-----------------------------------------------------------------------
      SUBROUTINE STFTRN(UX, UY, VX, VY)

      SAVE


      IF (ITRZ.EQ.1) THEN
        XX = UX
        YY = UY
      ELSE IF (ITRZ.EQ.2) THEN
        XX = UX
        YY = LOG10(UY)
      ELSE IF (ITRZ.EQ.3) THEN
        XX = LOG10(UX)
        YY = UY
      ELSE IF (ITRZ.EQ.4) THEN
        XX = LOG10(UX)
        YY = LOG10(UY)
      ELSE IF (ITRZ.EQ.5) THEN
        CALL CT2PC(UX, UY, XX, YY)
      ELSE IF (ITRZ.EQ.6) THEN
        CALL CT2BC(UX, UY, XX, YY)
      ELSE IF (ITRZ.EQ.10) THEN
        CALL MPFCYL(UX, UY, XX, YY)
      ELSE IF (ITRZ.EQ.11) THEN
        CALL MPFMER(UX, UY, XX, YY)
      ELSE IF (ITRZ.EQ.12) THEN
        CALL MPFMWD(UX, UY, XX, YY)
      ELSE IF (ITRZ.EQ.13) THEN
        CALL MPFHMR(UX, UY, XX, YY)
      ELSE IF (ITRZ.EQ.14) THEN
        CALL MPFEK6(UX, UY, XX, YY)
      ELSE IF (ITRZ.EQ.15) THEN
        CALL MPFKTD(UX, UY, XX, YY)
      ELSE IF (ITRZ.EQ.20) THEN
        CALL MPFCON(UX, UY, XX, YY)
      ELSE IF (ITRZ.EQ.21) THEN
        CALL MPFCOA(UX, UY, XX, YY)
      ELSE IF (ITRZ.EQ.22) THEN
        CALL MPFCOC(UX, UY, XX, YY)
      ELSE IF (ITRZ.EQ.23) THEN
        CALL MPFBON(UX, UY, XX, YY)
      ELSE IF (ITRZ.EQ.30) THEN
        CALL MPFOTG(UX, UY, XX, YY)
      ELSE IF (ITRZ.EQ.31) THEN
        CALL MPFPST(UX, UY, XX, YY)
      ELSE IF (ITRZ.EQ.32) THEN
        CALL MPFAZM(UX, UY, XX, YY)
      ELSE IF (ITRZ.EQ.33) THEN
        CALL MPFAZA(UX, UY, XX, YY)
      ELSE IF (ITRZ.EQ.99) THEN
        CALL STFUSR(UX, UY, XX, YY)
      END IF

      IF (XX.EQ.RNA .OR. YY.EQ.RNA) THEN
        VX = RNA
        VY = RNA
      ELSE
        VX = CX*XX + VX0
        VY = CY*YY + VY0
      END IF

      RETURN
*-----------------------------------------------------------------------
      ENTRY STITRN(VX, VY, UX, UY)

      XX = (VX - VX0) / CX
      YY = (VY - VY0) / CY

      IF (ITRZ.EQ.1) THEN
        UX = XX
        UY = YY
      ELSE IF (ITRZ.EQ.2) THEN
        UX = XX
        UY = 10**YY
      ELSE IF (ITRZ.EQ.3) THEN
        UX = 10**XX
        UY = VY
      ELSE IF (ITRZ.EQ.4) THEN
        UX = 10**XX
        UY = 10**YY
      ELSE IF (ITRZ.EQ.5) THEN
        CALL CT2CP(XX, YY, UX, UY)
      ELSE IF (ITRZ.EQ.6) THEN
        CALL MSGDMP('E', 'STITRN',
     +       'INVERSE TRANSFORMATION IS NOT DEFINED FOR ITR=6.')
      ELSE IF (ITRZ.EQ.10) THEN
        CALL MPICYL(XX, YY, UX, UY)
      ELSE IF (ITRZ.EQ.11) THEN
        CALL MPIMER(XX, YY, UX, UY)
      ELSE IF (ITRZ.EQ.12) THEN
        CALL MPIMWD(XX, YY, UX, UY)
      ELSE IF (ITRZ.EQ.13) THEN
        CALL MPIHMR(XX, YY, UX, UY)
      ELSE IF (ITRZ.EQ.14) THEN
        CALL MPIEK6(XX, YY, UX, UY)
      ELSE IF (ITRZ.EQ.15) THEN
        CALL MPIKTD(XX, YY, UX, UY)
      ELSE IF (ITRZ.EQ.20) THEN
        CALL MPICON(XX, YY, UX, UY)
      ELSE IF (ITRZ.EQ.21) THEN
        CALL MPICOA(XX, YY, UX, UY)
      ELSE IF (ITRZ.EQ.22) THEN
        CALL MPICOC(XX, YY, UX, UY)
      ELSE IF (ITRZ.EQ.23) THEN
        CALL MPIBON(XX, YY, UX, UY)
      ELSE IF (ITRZ.EQ.30) THEN
        CALL MPIOTG(XX, YY, UX, UY)
      ELSE IF (ITRZ.EQ.31) THEN
        CALL MPIPST(XX, YY, UX, UY)
      ELSE IF (ITRZ.EQ.32) THEN
        CALL MPIAZM(XX, YY, UX, UY)
      ELSE IF (ITRZ.EQ.33) THEN
        CALL MPIAZA(XX, YY, UX, UY)
      ELSE IF (ITRZ.EQ.99) THEN
        CALL STIUSR(XX, YY, UX, UY)
      END IF

      RETURN
*-----------------------------------------------------------------------
      ENTRY STSTRN(ITR, CXA, CYA, VXOFF, VYOFF)

      CX  = CXA
      CY  = CYA
      VX0 = VXOFF
      VY0 = VYOFF
      ITRZ = ITR

      CALL GLRGET('RUNDEF',RNA)

      END
