*-----------------------------------------------------------------------
*     RANDOM NUMBER GENERATOR (? METHOD BY KUNUTH)
*-----------------------------------------------------------------------
*     Copyright (C) 2000 GFD Dennou Club. All rights reserved.
*-----------------------------------------------------------------------
      REAL FUNCTION RNGU3(ISEED)

      PARAMETER (MBIG=1000000000,MSEED=161803398,MZ=0,FAC=1.E-9)

      INTEGER   MA(55)
      LOGICAL   LFIRST

      SAVE

      DATA      LFIRST / .TRUE. /

      IF (ISEED.NE.0) THEN

        MJ = MSEED - IABS(ISEED)
        MJ = MOD(MJ,MBIG)
        MA(55) = MJ
        MK = 1

        DO 100 I=1,54
          II = MOD(21*I,55)
          MA(II) = MK
          MK = MJ-MK
          IF(MK.LT.MZ) MK = MK+MBIG
          MJ = MA(II)
  100   CONTINUE

        DO 300 K=1,4
          DO 200 I=1,55
            MA(I)=MA(I)-MA(1+MOD(I+30,55))
            IF(MA(I).LT.MZ)MA(I)=MA(I)+MBIG
  200     CONTINUE
  300   CONTINUE

        INEXT  = 0
        INEXTP = 31
        ISEED  = 0
        LFIRST = .FALSE.

      END IF

      IF (LFIRST) CALL MSGDMP('E', 'RNGU3',
     #     'ISEED MUST BE > 0 FOR 1ST CALL.')

      INEXT = INEXT + 1
      IF(INEXT.EQ.56) INEXT = 1

      INEXTP = INEXTP + 1
      IF(INEXTP.EQ.56) INEXTP = 1

      MJ = MA(INEXT) - MA(INEXTP)
      IF (MJ.LT.MZ) MJ = MJ + MBIG
      MA(INEXT) = MJ
      RNGU3 = MJ*FAC

      END
