*-----------------------------------------------------------------------
*     3-D TRANSFORMATION
*-----------------------------------------------------------------------
*     Copyright (C) 2000 GFD Dennou Club. All rights reserved.
*-----------------------------------------------------------------------
      SUBROUTINE STFTR3(UX, UY, UZ, VX, VY, VZ)

      LOGICAL   LXRD, LYRD, LZRD, LXLG, LYLG, LZLG

      LOGICAL   LMISS, LXRDZ, LYRDZ, LZRDZ, LXLGZ, LYLGZ, LZLGZ

      EXTERNAL  RFPI

      SAVE


      IF (LMISS .AND. 
     #    (UX.EQ.RMISS .OR. UY.EQ.RMISS .OR. UZ.EQ.RMISS)) THEN
        VX = RMISS
        VY = RMISS
        VZ = RMISS
        RETURN
      END IF

      XX = UX
      YY = UY
      ZZ = UZ

      IF (ITRZ.EQ.1) THEN
        IF(LXLGZ) XX = LOG10(XX)
        IF(LYLGZ) YY = LOG10(YY)
        IF(LZLGZ) ZZ = LOG10(ZZ)
        XXX = XX
        YYY = YY
        ZZZ = ZZ
      ELSE IF (ITRZ.EQ.2) THEN
        IF(LXLGZ) XX = LOG10(XX)
        IF(LYRDZ) YY = YY*CP
        IF(LZLGZ) ZZ = LOG10(ZZ)
        ZZZ = ZZ
        CALL CT2PC(XX,YY,XXX,YYY)
      ELSE IF (ITRZ.EQ.3) THEN
        IF(LXLGZ) XX = LOG10(XX)
        IF(LYRDZ) YY = YY*CP
        IF(LZRDZ) ZZ = ZZ*CP
        CALL CT3SC(XX, YY, ZZ, XXX, YYY, ZZZ)
      END IF

      VX = CX*XXX + VX0
      VY = CY*YYY + VY0
      VZ = CZ*ZZZ + VZ0

      RETURN
*-----------------------------------------------------------------------
      ENTRY STSTR3(ITR, CXA, CYA, CZA, VXOFF, VYOFF, VZOFF)

      ITRZ = ITR
      CX  = CXA
      CY  = CYA
      CZ  = CZA
      VX0 = VXOFF
      VY0 = VYOFF
      VZ0 = VZOFF
      CP  = RFPI()/180

      CALL GLLGET('LMISS',LMISS)
      CALL GLRGET('RMISS',RMISS)

      RETURN
*-----------------------------------------------------------------------
      ENTRY STSRD3(LXRD, LYRD, LZRD)

      LXRDZ = LXRD
      LYRDZ = LYRD
      LZRDZ = LZRD

      RETURN
*-----------------------------------------------------------------------
      ENTRY STSLG3(LXLG, LYLG, LZLG)

      LXLGZ = LXLG
      LYLGZ = LYLG
      LZLGZ = LZLG

      END
