*----------------------------------------------------------------------
      SUBROUTINE Dmesh
     &        ( xlower, xupper, ylower, yupper, nxdiv, nydiv )
*----------------------------------------------------------------------
      parameter ( ndmax = 1000 )
      DIMENSION X(NDMAX), Y(NDMAX)

      character*10 charx
*----------------------------------------------------------------------

      call sgqclp( icnow )
      if ( icnow .eq. 0 ) then
         call sgsclp(1)
      end if

      ndsub = 61
      nxthic = 3
      nythic = 3

*--------------------------- LONGITUDE LINE ---------------------------

      xdiv = ( xupper - xlower ) / nxdiv
 
      DO 100 J=1, nxdiv

         DO 200 I=1, ndsub
            X(I) = xlower + (j-1) * xdiv
            Y(I) = ylower + (i-1) * ( yupper - ylower ) / (ndsub-1)
 200     CONTINUE

         IF( mod(j-1,nxthic) .eq. 0 ) then
            ITYPE = 1
            IND = 2
            rsize = 0.01
            write(charx,601) x(1)
 601        format (g10.3)
            CALL UBPLZU(ndsub, X, Y, ITYPE, IND, charx(1:10), rsize )
            CALL SGPLZU(ndsub, X, Y, ITYPE, IND)
         ELSE
            IND = 1
            ITYPE = 3
            CALL SGPLZU(ndsub, X, Y, ITYPE, IND)
         END IF

  100 CONTINUE

*---------------------------- LATITUDE LINE ---------------------------

      ydiv = ( yupper - ylower ) / nydiv

      DO 300 J=1, nydiv

        DO 400 I=1, ndsub
          X(I) = xlower + (i-1) * ( xupper - xlower ) / (ndsub-1)
          Y(I) = ylower + (j-1) * ydiv
  400   CONTINUE

        if (mod(j-1,nythic) .eq. 0 ) then
           IND=2
           ITYPE=1
           write(charx,602) y(1)
 602       format (g10.3)
           call ubplzu( ndsub, x, y, itype, ind, charx(1:10), rsize )
        else
           IND = 1
           ITYPE = 3
           CALL SGPLZU(ndsub, X, Y, ITYPE, IND)
        end if
  300 CONTINUE


      call sgsclp( icnow )

      RETURN
      END
