module pbl_mym_const
  use pp_vardef
  implicit none

   ! For the meaing of the variables, see the papers above.
   ! N2001: Nakanishi, M., 2001
   ! NN2004: Nakanishi, M. and H. Niino, 2004
   ! NN2006: Nakanishi, M. and H. Niino, 2006
   !
  real(r_size) :: g1
                    ! gamma_1 = 1/3 - 2A_1 / B_1
  real(r_size) :: g2
                    ! gamma_2 defined at Eq. (B4) in N2001
  real(r_size) :: a1
                    ! closure constant A_1 defined at Eq.(7) in N2001
  real(r_size) :: a2
                    ! closure constant A_2 defined at Eq.(8) in N2001
  real(r_size) :: b1
                    ! closure constant B_1 defined at Eq.(5) in N2001
  real(r_size) :: b2
                    ! closure constant B_2 defined at Eq.(6) in N2001
  real(r_size) :: c1
                    ! closure constant C_1 defined at Eq.(7) in N2001
  real(r_size) :: c2
                    ! closure constant C_2 defined at Eq.(7) in N2001
  real(r_size) :: c3
                    ! closure constant C_3 defined at Eq.(7) in N2001
  real(r_size) :: c4
                    ! closure constant C_1 defined at Eq.(7) in N2001
  real(r_size) :: c5
                    ! closure constant C_1 defined at Eq.(7) in N2001
  real(r_size) :: a1_2
                    ! A_1 / A_2
  real(r_size) :: pr
                    ! Prandtl Number
  real(r_size) :: rfc
                    ! Critical flux Richardson number
  real(r_size) :: f1
                    ! F_1 defined at Eq. (B4) in N2001
  real(r_size) :: f2
                    ! F_2 defined at Eq. (B4) in N2001
  real(r_size) :: rf1
                    ! R_f1 defined at Eq. (B4) in N2001
  real(r_size) :: rf2
                    ! R_f2 defined at Eq. (B4) in N2001
  real(r_size) :: smc
                    ! A_1 F_1 / (A_2 F_2) appeared at Eq. (B2) in N2001
  real(r_size) :: shc
                    ! 3 A_2 (gamma_1 + gamma_2) appeared at Eq. (B2)
                    ! in N2001
  real(r_size) :: ri1
                    ! Ri_1 defined at Eq. (B7) in N2001
  real(r_size) :: ri2
                    ! Ri_2 defined at Eq. (B7) in N2001
  real(r_size) :: ri3
                    ! Ri_3 defined at Eq. (B7) in N2001
  real(r_size) :: ri4
                    ! Ri_4 defined at Eq. (B7) in N2001
  real(r_size) :: cc2
                    ! 1-C_2
  real(r_size) :: cc3
                    ! 1-C_3
  real(r_size) :: e1c
                    ! constant appeared in phi1 at Eq.(3a) in NN2006
  real(r_size) :: e2c
                    ! constant appeared in phi2 at Eq.(3b) in NN2006
  real(r_size) :: e3c
                    ! constant appeared in phi3 and phi3'
                    ! at Eq. (3c,d) in NN2006
  real(r_size) :: e4c
                    ! constant appeared in phi4 and phi4'
                    ! at Eq. (3e,f) in NN2006
  real(r_size) :: e5c
                    ! constant appeared in D and D'
                    ! at Eq.(2a,b) in NN2006
  real(r_size) :: my_alpha1
                    ! alpha_1 defined at Eq.(40) in N2001
  real(r_size) :: my_alpha2
                    ! alpha_2 defined at Eq.(41) in N2001
  real(r_size) :: my_alpha3
                    ! alpha_3 defined at Eq.(41) in N2001
  real(r_size) :: my_alpha4
                    ! alpha_4 defined at Eq.(39) in N2001
  real(r_size) :: alp32
                    ! my_alpha3 / my_alpha2
  real(r_size) :: elt_min
                    ! lower limit of elt
  real(r_size) :: coef_trbvar_diff_tke
                    ! factor of the diffusion for TKE to the one
                    ! for momentum
  real(r_size) :: coef_trbvar_diff
                    ! factor of the diffusion for the other prognostic
                    ! variables appeared in MY  to the one
                    ! for momentum
  real(r_size) :: qke_max
                    ! upper limit for qke (twice of TKE) for safety.
contains
  subroutine pbl_mym_const_ini
    use pbl_mym_option, only: l_my_improved_closure
    implicit none
    if (l_my_improved_closure) then
      ! closure constants in the improved MY model (MYNN)
      g1  =  0.235
      b1  = 24.0
      b2  = 15.0
      c2  =  0.7
      c3  =  0.323
      c4  =  0.0
      c5  =  0.2
      pr  =  0.74
    else
      ! closure constants in the original MY model
      g1 = 0.222
      b1 = 16.6
      b2 = 10.1
      c2 = 0.0
      c3 = 0.0
      c4 = 0.0
      c5 = 0.0
      pr  =  0.80
    end if
    ! Combined constants
    a1  = b1 * ( 1.0 - 3.0 * g1 ) / 6.0
    c1  = g1 - 1.0 / ( 3.0 * a1 * b1 ** (1.0 / 3.0))
    a2  = a1 *( g1 - c1 ) / ( g1 * pr )
    g2  = b2 / b1 * ( 1.0 - c3 ) + 2.0 * a1 / b1 * ( 3.0 - 2.0 * c2 )
    a1_2 = a1 / a2

    rfc = g1 / (g1 + g2)
    f1 = b1 * (g1 - c1)  + 3.0 * a2 *(1.0 - c2 ) * ( 1.0 - c5 )           &
      +2.0 * a1 *(3.0 -2.0 * c2)
    f2  = b1 * (g1 + g2) - 3.0 * a1 *(1.0 - c2)
    rf1 = b1 * (g1 - c1) / f1
    rf2 = b1 * g1 / f2
    smc = a1 / a2 * f1 / f2
    shc = 3.0 * a2 * (g1 + g2)

    ri1 = 0.5 /smc
    ri2 = rf1 * smc
    ri3 = 4.0 * rf2 * smc - 2.0 * ri2
    ri4 = ri2 ** 2

    cc2 =  1.0 - c2
    cc3 =  1.0 - c3
    e1c =  3.0 * a2 * b2 * cc3
    e2c =  9.0 * a1 * a2 * cc2
    e3c =  9.0 * a2 * a2 * cc2 * (1.0 - c5)
    e4c = 12.0 * a1 * a2 *cc2
    e5c =  6.0 * a1 *a1

    ! Other parameters
    my_alpha1 = 0.23
    my_alpha2 = 1.0
    my_alpha3 = 5.0
    my_alpha4 = 100.0
    elt_min = 20.0

    alp32 = my_alpha3 / my_alpha2

    coef_trbvar_diff_tke = 3.0
    coef_trbvar_diff = 1.0

    qke_max = 500.0
  end subroutine pbl_mym_const_ini

end module pbl_mym_const
