=begin JA

= configure と Config.mk.in の保守管理

# * 森川 靖大 (morikawa)
#   * $Id: configure.rd,v 1.1 2009/04/01 13:09:12 morikawa Exp $

=end JA

=begin JA

本文書は configure, Config.mk.in の保守管理について記します.

== 概説

dcpam5 では, 利用者の環境に応じた設定を
configure によって自動的に行います. 
実際には, 元々ソースコードに同梱される Config.mk.in を元に, 
configure から Config.mk ファイルを作成します. 
(configure での設定が不十分な場合には, Config.mk
を利用者に直接編集してもらう必要がある場合もあります).
各ディレクトリの Makefile はその Config.mk
を include 文によって読み込み, ビルドを行います.

   ./configure 実行 --+
                      |
                      +---> Config.mk
                      |
   Config.mk.in ------+


configure 自体は開発者側で作成した configure.in
から autoconf を用いて作成します. 
以下では, dcpam5 において configure
に関連するファイルのリストを紹介します.

保守管理の基本的な方法は 
((<"gtool5 Fortran 90/95 ライブラリ"|URL:http://www.gfd-dennou.org/library/gtool/gtool5.htm>))
に倣っているため, 
保守管理に必要なソフトウェアおよび, 保守管理の方法については,
((<gtool5 開発者向けドキュメント -- configure と Config.mk.in の保守管理|URL:http://www.gfd-dennou.org/library/gtool/gtool5/gtool5_current/doc/lib-configure.htm>))
を参照ください. 

== configure 作成に必要なファイル

* ((<aclocal.m4|URL:../../script/configure/aclocal.m4>))

  ((<configure.in|URL:../../configure.in>))
  において使用されているマクロが定義されたファイルです. 

== configure 実行時に使用される下請けスクリプト群

configure が実行される際には, 
その下請けとしていくつかのスクリプトが呼ばれます.
これらはディレクトリ ((<"script/configure"|URL:../../script/configure>))
および gtool5 トップディレクトリ以下に置かれています.

: ((<"script/configure/chkfort.sh"|URL:../../script/configure/chkfort.sh>))

  Fortran コンパイラチェック

: ((<"script/configure/chkgmake.sh"|URL:../../script/configure/chkgmake.sh>))

  GNU Make コマンドチェック

: ((<"script/configure/chkrps.sh"|URL:../../script/configure/chkrps.sh>))

  Ruby, Perl, Shell のパスチェック

: ((<"script/configure/chkrubyver.rb"|URL:../../script/configure/chkrubyver.rb>))

  Ruby バージョンチェック

: ((<config.guess|URL:../../config.guess>)), ((<config.sub|URL:../../config.sub>))

  システムタイプの判別. それぞれ
  ((<URL:http://git.savannah.gnu.org/gitweb/?p=config.git;a=blob_plain;f=config.guess;hb=HEAD>)) と
  ((<URL:http://git.savannah.gnu.org/gitweb/?p=config.git;a=blob_plain;f=config.sub;hb=HEAD>))
  よりダウンロードしたもの.

=end JA

 
=begin HTMLJA
<hr />
<small>
  $Id: configure.rd,v 1.1 2009/04/01 13:09:12 morikawa Exp $
</small>
=end HTMLJA
