=begin JA

= 火星実験 (鉛直一次元計算)

# * 高橋 芳幸 (yot)
#   * $Id: exp-Mars-1D.rd,v 1.3 2015/02/14 07:21:31 yot Exp $

=end JA
=begin EN

= Mars experiment (Vertical 1-D experiment)

# * Yoshiyuki O. Takahashi (yot)
#   * $Id: exp-Mars-1D.rd,v 1.3 2015/02/14 07:21:31 yot Exp $

=end EN


=begin JA

鉛直一次元の火星の実験を行う方法を説明します. 

この計算には以下の物理過程を用いています. 

  * 放射 (火星大気用放射, Takahashi et al., 2003; 2006 の改良・簡単化版)
  * 鉛直拡散 (Mellor and Yamada, 1982, レベル 2.5) 
#  * 積雲パラメタリゼーション: 湿潤対流調節 (Manabe et al., 1965) 
#  * 診断型大規模凝結 
  * 乾燥対流調節
  * バケツモデル

=end JA
=begin EN

A method to perform a vertical 1-dimensional Mars experiment is described. 

Following physical processes are used in this experiment.

  * Radiation (improved and/or simplified version of Takahashi et al., 2003; 2006)
  * Vertical diffusion (Mellor and Yamada, 1974, level 2) 
#  * Cumulus parameterization: Convective adjustment scheme (Manabe et al., 1965) 
#  * Large scale condensation
  * Dry convective adjustment
  * Bucket model

=end EN


=begin JA
== 概要

本実験では, 地面特性のデータ, 放射計算用データが必要です. したがって, 
実験の実行は以下の 4 つのステップで行います.

  * 実験ディレクトリの準備
  * 初期値の準備
  * 実験用データの準備
  * 実験の実行

=end JA
=begin EN
== Overview

This experiment requires data of distribution of surface properties and radiative property.
So, the experiment is performed with the following 4 steps:

  * Preparation of directory for experiments
  * Preparation of initial condition
  * Preparation of additional data for experiments
  * Execution of experiments

=end EN

=begin JA

== 実験用ディレクトリ準備

DCPAM5 の数値実験はソースツリー内部では行わず
ソースツリーとは別の外部ディレクトリにて行うことを推奨いたします. 

まず DCPAM5 ソースのトップディレクトリ(以下の例では dcpam5-YYYYMMDD とする)に移動してください. 
以下では DCPAM5 ソースディレクトリの隣に ../dcpma5-exp/Mars-1D-exp ディレクトリを作成し, そこで実験を行うことにします. 
次のように  ../dcpam5-exp/Mars-1D-exp ディレクトリを作成し, 
移動してください. 

  $ mkdir -p ../dcpam5-exp/Mars-1D-exp
  $ cd ../dcpam5-exp/Mars-1D-exp

次に, このディレクトリに実行ファイルと設定ファイル置き場を作成します. 

  $ mkdir bin
  $ mkdir conf

最後に作成したディレクトリに実行ファイルと設定ファイルをコピーします. 

  $ cp ../../dcpam5-YYYYMMDD/src/main/dcpam_main bin
  $ cp ../../dcpam5-YYYYMMDD/src/main/dcpam_init_data  bin
  $ cp ../../dcpam5-YYYYMMDD/src/main/dcpam_init_data_surface  bin
  $ cp ../../dcpam5-YYYYMMDD/exp_setup_files/*.conf conf

なお, 実行ファイルと設定ファイル (NAMELIST ファイル) があれば, どのディレクトリにおいても計算を行うことができます. 

== 初期値データファイルの作成

dcpam_init_data と init_data_M_1D_L36.conf, 
および dcpam_init_data_surface と surface_data_M_1D.conf
を用いて初期値ファイル init_1D_L36.nc を作成します. 

まず dcpam_init_data で大気中の変数の初期値を作成します. 

  $ ./bin/dcpam_init_data -N=./conf/init_data_M_1D_L36.conf

   *** MESSAGE [dcpam_init_data] ***  Run: Initial data generation
   *** MESSAGE [dcpam_init_data] ***  -- version = $Name:  $$Id: exp-Mars-1D.rd,v 1.3 2015/02/14 07:21:31 yot Exp $
   *** MESSAGE [namelist_util] ***  ----- Initialization Messages -----
   *** MESSAGE [namelist_util] ***    MaxNmlArySize = 256
   *** MESSAGE [namelist_util] ***  -- version = $Name:  $$Id: exp-Mars-1D.rd,v 1.3 2015/02/14 07:21:31 yot Exp $
   *** MESSAGE [timeset] ***  NAMELIST group "timeset_nml" is loaded from "init_data_M_1D_L36.conf".
  &TIMESET_NML
   CAL_TYPE="noleap                          ",
                             :
   *** MESSAGE [restart_file_io] ***  Output::
   *** MESSAGE [restart_file_io] ***    OutputFile = init_1D_L36.nc
   *** MESSAGE [restart_file_io] ***    IntTime    = 365. [day]
   *** MESSAGE [restart_file_io] ***  -- version = $Name:  $$Id: exp-Mars-1D.rd,v 1.3 2015/02/14 07:21:31 yot Exp $
   *** MESSAGE [GDNcFileOpen] ***  "init_1D_L36.nc" is overwritten.
   *** MESSAGE [HistoryCreate1] ***  "init_1D_L36.nc" is created (origin=0.E+00 [sec])
   *** MESSAGE [HistoryClose] ***  "init_1D_L36.nc" is closed

   ############## CPU TIME SUMMARY ################
   others                 0.120000E-01
   ------------------------------------------------
          TOTAL TIME =    0.120000E-01

次に dcpam_init_data_surface で惑星表面の変数の初期値を作成します. 

  $ ./bin/dcpam_init_data_surface -N=./conf/surface_data_M_1D.conf

   *** MESSAGE [dcpam_init_data_surface] ***  Run: SST data generation
   *** MESSAGE [dcpam_init_data_surface] ***  -- version = $Name:  $$Id: exp-Mars-1D.rd,v 1.3 2015/02/14 07:21:31 yot Exp $
   *** MESSAGE [namelist_util] ***  ----- Initialization Messages -----
   *** MESSAGE [namelist_util] ***    MaxNmlArySize = 256
   *** MESSAGE [namelist_util] ***  -- version = $Name:  $$Id: exp-Mars-1D.rd,v 1.3 2015/02/14 07:21:31 yot Exp $
   *** MESSAGE [timeset] ***  NAMELIST group "timeset_nml" is loaded from "surface_data_M_1D.conf".
  &TIMESET_NML
   CAL_TYPE="noleap                          ",
                   :
   *** MESSAGE [GDNcFileOpen] ***  "surface_1D.nc" is overwritten.
   *** MESSAGE [HistoryCreate1] ***  "surface_1D.nc" is created (origin=0.E+00 [day])
   *** MESSAGE [HistoryClose] ***  "surface_1D.nc" is closed

   ############## CPU TIME SUMMARY ################
   others                 0.800000E-02
   ------------------------------------------------
          TOTAL TIME =    0.800000E-02


== 実験用データの準備

実験用データとして, 放射パラメータのデータを
以下に用意してあります. 

  * ((<サンプルデータ|URL:http://www.gfd-dennou.org/library/dcpam/sample/2015-02-11_tutorial/Mars/>))

上記のページから "lnactbl15m_2006-07-13.nc" をダウンロードして, 実験を行うディレクトリに置いてください. 

== 実験の実行

最後に dcpam_main, dcpam_M_1D_L36.conf を用いて実験を実施します. 
解像度 L36 で 67 日分計算を行います. 
リスタートデータ, 地表面リスタートデータといくつかのヒストリデータ
ファイルが出力されます. 

  $ ./bin/dcpam_main -N=./conf/dcpam_M_1D_L36.conf | tee Mars.log

   *** MESSAGE [namelist_util] ***  ----- Initialization Messages -----
   *** MESSAGE [namelist_util] ***    MaxNmlArySize = 256
   *** MESSAGE [namelist_util] ***  -- version = $Name:  $$Id: exp-Mars-1D.rd,v 1.3 2015/02/14 07:21:31 yot Exp $
   *** MESSAGE [dcpam_main] ***  NAMELIST group "dcpam_main_nml" is loaded from "./conf/dcpam_M_T21L36.conf".
   &DCPAM_MAIN_NML FLAGDYNAMICS=T,FLAGFULLPHYSICS=T,FLAGHS94=F,FLAGVENUSSIMPLE=F,FLAGJUPITERSIMPLE=F,FLAGRADIATIONDENNOUAGCM=F,FLAGRADIATIONDCPAMEV1=F,FLAGRADIATIONDCPAMMV1=T,FLAGRADIATIONSL09=F,FLAGPHYIMP1LAYMODEL=F,FLAGPHYIMPSOILMODEL=T,FLAGPHYIMPSOILMODELSO=F,FLAGPHYIMPATMONLY=F,FLAGVERTICALFILTER=F/
   *** MESSAGE [dcpam_main] ***  FlagDynamics=<T>.
   *** MESSAGE [dcpam_main] ***  FlagRadiationDennouAGCM=<F>.
   *** MESSAGE [dcpam_main] ***  FlagRadiationDcpamEV1  =<F>.
   *** MESSAGE [dcpam_main] ***  FlagRadiationDcpamMV1  =<T>.
                         : 


実験設定を変更する場合には,
上記の実行に際して conf ディレクトリ内の 
dcpam_M_1D_L36.conf を変更してください. 

計算結果の解析・可視化の方法については((<こちら|URL:./visualization.htm>))を参照してください. 


== 結果の可視化

65-67 日目における温位の日変化は以下の図のようになります.
ただし, コードのバージョンの違いによって, 図は必ずしも下の図と全く同じにはならないかもしれません.

((:<img src="images/mars_irb_pottemp_time65-67day.png">:))

この図は, ((<Gphys|URL:http://www.gfd-dennou.org/library/ruby/products/gphys/>)) を
用いて,  下の処理によって描画しています. 

  まず irb を起動. 

  $ irb

  以下のような irb のプロンプトが表示されます.

  irb(main):001:0>

  このプロンプトに, 以下のようにコマンドを打ちます.
  左端の数字は行番号で, 打つ必要はありません.

  1: require "numru/ggraph"
  2: include NumRu
  3: gphys = GPhys::IO.open('PotTemp.nc', 'PotTemp')
  4: DCL.gropn(1)
  5: DCL.sgpset('lcntl', false) ; DCL.uzfact(0.7)
  6: GGraph.set_fig( 'itr'=> 1 )
  7: GGraph.tone( gphys.cut('lon'=>0).cut('lat'=>0).cut('sig'=>1..0.6).cut('time'=>65*24..67*24), true, 'exchange'=>true )
  8: GGraph.color_bar
  9: DCL.grcls

  irb のプロンプトにおいて quit と打つと irb を終了することができます. 

なお, ここで表示している温位の参照圧力は 1000 hPa です. 火星の平均的な地面気圧は ~7 hPa であるため, 温位は温度と値が大きく異なっていることに注意してください. 

また, 解析・可視化のもう少し詳しい方法については((<こちら|URL:./visualization.htm>))を参照してください. 

=end JA

=begin EN

== Preparation of a directory for an experiment

Let us move to the top directory of DCPAM5 src tree
(assuming dcpam5-YYYYMMDD in the following example). 
Here, we perform an experiment in ../dcpam5-exp/Mars-1D-exp directory. 
Please create the directory and enter there as follows: 

  $ mkdir -p ../dcpam5-exp/Mars-1D-exp
  $ cd ../dcpam5-exp/Mars-1D-exp

Then, pleaase create the directories for executable files and configuration
files as follows:

  $ mkdir bin
  $ mkdir conf

Finally, executable files and configuration files are copied as follows: 

  $ cp ../../dcpam5-YYYYMMDD/src/main/dcpam_main bin
  $ cp ../../dcpam5-YYYYMMDD/src/main/dcpam_init_data  bin
  $ cp ../../dcpam5-YYYYMMDD/src/main/dcpam_init_data_surface  bin
  $ cp ../../dcpam5-YYYYMMDD/exp_setup_files/*.conf conf

Note that you can perform an experiment in any directory by using executable files and configuration (NAMELIST) files.


== Preparation of initial data

Create initial data file "init_1D_L36.nc"
using "bin/dcpam_init_data", "conf/init_data_M_1D_L36.conf", 
and "bin/dcpam_init_data_surface", "conf/surface_data_M_1D.conf"

  $ ./bin/dcpam_init_data -N=./conf/init_data_M_1D_L36.conf

   *** MESSAGE [dcpam_init_data] ***  Run: Initial data generation
   *** MESSAGE [dcpam_init_data] ***  -- version = $Name:  $$Id: exp-Mars-1D.rd,v 1.3 2015/02/14 07:21:31 yot Exp $
   *** MESSAGE [namelist_util] ***  ----- Initialization Messages -----
   *** MESSAGE [namelist_util] ***    MaxNmlArySize = 256
   *** MESSAGE [namelist_util] ***  -- version = $Name:  $$Id: exp-Mars-1D.rd,v 1.3 2015/02/14 07:21:31 yot Exp $
   *** MESSAGE [timeset] ***  NAMELIST group "timeset_nml" is loaded from "init_data_M_1D_L36.conf".
  &TIMESET_NML
   CAL_TYPE="noleap                          ",
                             :
   *** MESSAGE [restart_file_io] ***  Output::
   *** MESSAGE [restart_file_io] ***    OutputFile = init_1D_L36.nc
   *** MESSAGE [restart_file_io] ***    IntTime    = 365. [day]
   *** MESSAGE [restart_file_io] ***  -- version = $Name:  $$Id: exp-Mars-1D.rd,v 1.3 2015/02/14 07:21:31 yot Exp $
   *** MESSAGE [GDNcFileOpen] ***  "init_1D_L36.nc" is overwritten.
   *** MESSAGE [HistoryCreate1] ***  "init_1D_L36.nc" is created (origin=0.E+00 [sec])
   *** MESSAGE [HistoryClose] ***  "init_1D_L36.nc" is closed

   ############## CPU TIME SUMMARY ################
   others                 0.120000E-01
   ------------------------------------------------
          TOTAL TIME =    0.120000E-01

  $ ./bin/dcpam_init_data_surface -N=./conf/surface_data_M_1D.conf

   *** MESSAGE [dcpam_init_data_surface] ***  Run: SST data generation
   *** MESSAGE [dcpam_init_data_surface] ***  -- version = $Name:  $$Id: exp-Mars-1D.rd,v 1.3 2015/02/14 07:21:31 yot Exp $
   *** MESSAGE [namelist_util] ***  ----- Initialization Messages -----
   *** MESSAGE [namelist_util] ***    MaxNmlArySize = 256
   *** MESSAGE [namelist_util] ***  -- version = $Name:  $$Id: exp-Mars-1D.rd,v 1.3 2015/02/14 07:21:31 yot Exp $
   *** MESSAGE [timeset] ***  NAMELIST group "timeset_nml" is loaded from "surface_data_M_1D.conf".
  &TIMESET_NML
   CAL_TYPE="noleap                          ",
                   :
   *** MESSAGE [GDNcFileOpen] ***  "surface_1D.nc" is overwritten.
   *** MESSAGE [HistoryCreate1] ***  "surface_1D.nc" is created (origin=0.E+00 [day])
   *** MESSAGE [HistoryClose] ***  "surface_1D.nc" is closed

   ############## CPU TIME SUMMARY ################
   others                 0.800000E-02
   ------------------------------------------------
          TOTAL TIME =    0.800000E-02


== Preparation of additional data

This experiment requires additional data, radiation parameter. 
Those data are prepared at following site.

  * ((<sample data|URL:http://www.gfd-dennou.org/library/dcpam/sample/2015-02-11_tutorial/Mars/>))

Please download "lnactbl15m_2006-07-13.nc" from above site, and place those files at experimental directory. 


== Run the experiment

At the last, run a experiment using 
"dcpam_main" and "dcpam_M_1D_L36.conf". 
Resolution is L36. 
Integration time is 67 days. 
A restart data file, a restart data file of surface data,
and some history data files are output. 

  $ ./dcpam_main -N=dcpam_M_1D_L36.conf | tee Mars.log

If you want to change experimental settings, edit "dcpam_M_1D_L36.conf" in "conf" directory. 

=end EN

=begin JA
== 最後に
実験ディレクトリに作成された計算結果を保存しておきたい場合には
データ用ディレクトリ(例えば data01)を作成し, 
ファイルを移動させて整理しておきましょう. 

  $ mkdir data01
  $ mv *.nc *.log data01/

なお, 計算結果を計算実行時にサブディレクトリへ出力することも可能です. 
((<実験設定の変更|URL:./changesetup.htm>))の出力設定の変更を参照し, 
NAMELIST "&gtool_historyauto_nml" の変数 "FilePrefix" による設定を試してみて下さい. 
=end JA

=begin EN
== Final remark
If you would like to keep the results of the numerical experiment, 
please create a sub directory ("data01" for example), move the files, 
and keep the current directory neatly. 

  $ mkdir data01
  $ mv *.nc *.log data01/

You can output the results of the numerical experimet concurrently with the
execution. Please refer to "Change output settings" 
in ((<Change experimental setup|URL:./changesetup.htm.en>)) 
and try to configure "FilePrefix" variable in NAMELIST "&gtool_historyauto_nml". 

=end EN


#=begin JA
#== 参考文献
#=end JA
#
#=begin EN
#== References
#=end EN
#
#=begin
#
#* Manabe, S., J. Smagorinsky, and R. F. Strickler, 1965: 
#  Simulated climatology of a general circulation model with a
#  hydrologic cycle,
#  ((|Mon. Wea. Rev.|)), ((*93*)), 769--798.
#
#* Mellor, G. L., and T. Yamada, 1974: 
#  A hierarchy of turbulence closure models for planetary
#  boundary layers,
#  ((|J. Atmos. Sci.|)), ((*31*)), 1791--1806.
#
#=end


=begin HTML
<hr />
<small>
  $Id: exp-Mars-1D.rd,v 1.3 2015/02/14 07:21:31 yot Exp $
</small>
=end HTML

