=begin JA

= 金星的惑星実験

# * 高橋 芳幸 (yot), 竹広 真一(takepiro)
#   * $Id: exp-Venuslike.rd,v 1.12 2014/07/07 14:50:01 yot Exp $

=end JA
=begin EN

= Experiment for Venus-like planet

# * Yoshiyuki O. Takahashi (yot), Shin-ichi Takehiro (takepiro)
#   * $Id: exp-Venuslike.rd,v 1.12 2014/07/07 14:50:01 yot Exp $

=end EN


=begin JA
Yamamoto and Takahashi (2003) に似た強制を与えた金星的惑星の
実験を実行する方法を説明します. 
=end JA
=begin EN
A method to perform an experiment for Venus-like planet by using forcing by 
Yamamoto and Takahashi (2003) is described.
=end EN


=begin JA
== 概要
本実験は海表面温度等の実験用データを用いないため, 以下の 3 つのステップで行います.

  * 実験ディレクトリの準備
  * 初期値の準備
  * 実験の実行
=end JA
=begin EN
== Overview
This experiment does not require additional data, such as SST data. 
Thus, the experiment is performed with the following 3 steps:

  * Preparation of directory for experiments
  * Preparation of initial condition
  * Execution of experiments
=end EN


=begin JA

== 実験用ディレクトリ準備

DCPAM5 の数値実験はソースツリー内部では行わず
ソースツリーとは別の外部ディレクトリにて行うことを推奨いたします. 

まず DCPAM5 ソースのトップディレクトリ(以下の例では dcpam5-YYYYMMDD とする)に移動してください. 
以下では DCPAM5 ソースディレクトリの隣に ../dcpma5-exp/Venuslike-exp ディレクトリを作成し, そこで実験を行うことにします. 
次のように  ../dcpam5-exp/Venuslike-exp ディレクトリを作成し, 
移動してください. 

  $ mkdir -p ../dcpam5-exp/Venuslike-exp
  $ cd ../dcpam5-exp/Venuslike-exp

次に, このディレクトリに実行ファイルと設定ファイル置き場を作成します. 

  $ mkdir bin
  $ mkdir conf

最後に作成したディレクトリに実行ファイルと設定ファイルをコピーします. 

  $ cp ../../dcpam5-YYYYMMDD/src/main/dcpam_main bin
  $ cp ../../dcpam5-YYYYMMDD/src/main/dcpam_init_data  bin
  $ cp ../../dcpam5-YYYYMMDD/exp_setup_files/*.conf conf

なお, 実行ファイルと設定ファイル (NAMELIST ファイル) があれば, どのディレクトリにおいても計算を行うことができます. 

=end JA
=begin EN

== Preparation of a directory for experiments

Let us move to the top directory of DCPAM5 src tree
(assuming dcpam5-YYYYMMDD in the following example). 
Here, we perform an experiment in ../dcpam5-exp/Venuslike-exp directory. 
Please create the directory and enter there as follows: 

  $ mkdir -p ../dcpam5-exp/Venuslike-exp
  $ cd ../dcpam5-exp/Venuslike-exp

Then, pleaase create the directories for executable files and configuration
files as follows:

  $ mkdir bin
  $ mkdir conf

Finally, executable files and configuration files are copied as follows: 

  $ cp ../../dcpam5-YYYYMMDD/src/main/dcpam_main bin
  $ cp ../../dcpam5-YYYYMMDD/src/main/dcpam_init_data  bin
  $ cp ../../dcpam5-YYYYMMDD/exp_setup_files/*.conf conf

Note that you can perform an experiment in any directory by using executable files and configuration (NAMELIST) files.

=end EN


=begin JA

== 初期値データファイルの作成

dcpam_init_data と init_data_Vlp_T10L50.conf
を用いて初期値ファイル init_T10L50.nc を作成します. 

  $ ./bin/dcpam_init_data -N=./conf/init_data_Vlp_T10L50.conf

   *** MESSAGE [init_data] ***  Run: Initial data generation
   *** MESSAGE [init_data] ***  -- version = $Name:  $$Id: exp-Venuslike.rd,v 1.12 2014/07/07 14:50:01 yot Exp $
   *** MESSAGE [namelist_util] ***  ----- Initialization Messages -----
   *** MESSAGE [namelist_util] ***    MaxNmlArySize = 256
   *** MESSAGE [namelist_util] ***  -- version = $Name:  $$Id: exp-Venuslike.rd,v 1.12 2014/07/07 14:50:01 yot Exp $
   *** WARNING [timeset] ***  NAMELIST group "timeset_nml" is not found in "./conf/init_data_Vlp_T10L50.conf" (iostat=186).
   *** MESSAGE [timeset] ***  ----- Initialization Messages -----
                         : 
   *** MESSAGE [initial_data] ***  ----- Initialization Messages -----
   *** MESSAGE [initial_data] ***    Pattern = SmallVapAvr = 0.
   *** MESSAGE [initial_data] ***    Ueq     = 0.
   *** MESSAGE [initial_data] ***
   *** MESSAGE [initial_data] ***  -- version = $Name:  $$Id: exp-Venuslike.rd,v 1.12 2014/07/07 14:50:01 yot Exp $


== 実験の実行

実行ファイル "dcpam_main" と NAMELIST ファイル
((<dcpam_Vlp_T10L50.conf|URL:../../exp_setup_files/dcpam_Vlp_T10L50.conf>))
を用いて, 以下のように dcpam_main を実行してください. 
プログラム終了には数分〜数十分かかります. 

(なお, クロスコンパイル環境では以下の方法でプログラムを
実行することはできないので注意してください. その場合の実行方法
に関しては, その環境でのプログラム実行マニュアルなどを参照ください. )

  $ ./bin/dcpam_main -N=./conf/dcpam_Vlp_T10L50.conf | tee Vlp.log

   *** MESSAGE [namelist_util] ***  ----- Initialization Messages -----
   *** MESSAGE [namelist_util] ***    MaxNmlArySize = 256
   *** MESSAGE [namelist_util] ***  -- version = $Name:  $$Id: exp-Venuslike.rd,v 1.12 2014/07/07 14:50:01 yot Exp $
   *** MESSAGE [dcpam_main] ***  NAMELIST group "dcpam_main_nml" is loaded from "./conf/dcpam_Vlp_T10L50.conf".
   &DCPAM_MAIN_NML FLAGDYNAMICS=T,FLAGFULLPHYSICS=F,FLAGHS94=F,FLAGVENUSSIMPLE=T,FLAGJUPITERSIMPLE=F,FLAGRADIATIONDENNOUAGCM=T,FLAGRADIATIONDCPAMEV1=F,FLAGRADIATIONDCPAMMV1=F,FLAGRADIATIONSL09=F,FLAGPHYIMP1LAYMODEL=T,FLAGPHYIMPSOILMODEL=F,FLAGPHYIMPSOILMODELSO=F,FLAGPHYIMPATMONLY=F,FLAGVERTICALFILTER=F/
   *** MESSAGE [dcpam_main] ***  FlagDynamics=<T>.
   *** MESSAGE [dcpam_main] ***  FlagRadiationDennouAGCM=<T>.
   *** MESSAGE [dcpam_main] ***  FlagRadiationDcpamEV1  =<F>.
   *** MESSAGE [dcpam_main] ***  FlagRadiationDcpamMV1  =<F>.
                     :
   *** MESSAGE [HistoryClose] ***  "VUBalance.nc" is closed
  
   ############## CPU TIME SUMMARY ################
   surface_properties     0.000000E+00
   auxiliary              0.108007E+00
   vdiffusion_my1974      0.520025E-01
   dynamics_hspl_vas83    0.187212E+01
   mass_fixer             0.280015E-01
   check_prog_vars        0.800041E-02
   timefilter_asselin19   0.280015E-01
   others                 0.552037E+00
   ------------------------------------------------
          TOTAL TIME =    0.264816E+01


この場合, 5 日分の時間積分が行われます. 
空間解像度は T10L50 (経度格子点数 32, 緯度点数 16, 鉛直層数 50) です. 
計算結果は U.nc や Temp.nc として出力されます. 
また, リスタートファイルが restart.nc として出力されます. 


== 結果の可視化

5 日後における温度の東西平均分布は以下の図のようになります.
ただし, コードのバージョンの違いによって, 図は必ずしも下の図と全く同じにはならないかもしれません.

((:<img src="images/venus_irb_temp_meanlon_time05day.png">:))

この図は, ((<Gphys|URL:http://www.gfd-dennou.org/library/ruby/products/gphys/>)) を
用いて,  下の処理によって描画しています. 

  まず irb を起動. 

  $ irb

  以下のようなプロンプトが表示されます.

  irb(main):001:0>

  このプロンプトに, 以下のようにコマンドを打ちます.
  左端の数字は行番号で, 打つ必要はありません.

  1: require "numru/ggraph"
  2: include NumRu
  3: gphys = GPhys::IO.open('Temp.nc', 'Temp')
  4: DCL.gropn(1)
  5: DCL.sgpset('lcntl', false) ; DCL.uzfact(0.7)
  6: GGraph.set_fig( 'itr'=> 2 )
  7: GGraph.tone( gphys.mean('lon').cut('time'=>5) )
  8: GGraph.color_bar
  9: DCL.grcls

  irb のプロンプトにおいて quit と打つと irb を終了することができます. 

この計算で用いている初期値は等温静止大気です. 
金星大気は, 5 日間では準定常状態には達しませんので, 上記の図はスピンアップ中の状態を表しています. 

また, 解析・可視化のもう少し詳しい方法については((<こちら|URL:./visualization.htm>))を参照してください. 

=end JA

=begin EN

== Create initial data file

Create initial data file "init_T10L50.nc"
using "dcpam_init_data" and "init_data_Vlp_T10L50.conf" 
  
  $ ./bin/dcpam_init_data -N=./conf/init_data_Vlp_T10L50.conf

   *** MESSAGE [init_data] ***  Run: Initial data generation
   *** MESSAGE [init_data] ***  -- version = $Name:  $$Id: exp-Venuslike.rd,v 1.12 2014/07/07 14:50:01 yot Exp $
   *** MESSAGE [namelist_util] ***  ----- Initialization Messages -----
   *** MESSAGE [namelist_util] ***    MaxNmlArySize = 256
   *** MESSAGE [namelist_util] ***  -- version = $Name:  $$Id: exp-Venuslike.rd,v 1.12 2014/07/07 14:50:01 yot Exp $
   *** WARNING [timeset] ***  NAMELIST group "timeset_nml" is not found in "./conf/init_data_Vlp_T10L50.conf" (iostat=186).
   *** MESSAGE [timeset] ***  ----- Initialization Messages -----
                         : 
   *** MESSAGE [initial_data] ***  ----- Initialization Messages -----
   *** MESSAGE [initial_data] ***    Pattern = SmallVapAvr = 0.
   *** MESSAGE [initial_data] ***    Ueq     = 0.
   *** MESSAGE [initial_data] ***
   *** MESSAGE [initial_data] ***  -- version = $Name:  $$Id: exp-Venuslike.rd,v 1.12 2014/07/07 14:50:01 yot Exp $


== Run the experiment

Using an executable files 'dcpam_main' and a NAMELIST file
((<dcpam_Vlp_T10L50.conf|URL:../../exp_setup_files/dcpam_Vlp_T10L50.conf>)), 
execute 'dcpam_main' as follows. 
This program will be finished in few minutes - tens of minutes. 

  $ ./bin/dcpam_main -N=./conf/dcpam_Vlp_T10L50.conf | tee Vlp.log

   *** MESSAGE [namelist_util] ***  ----- Initialization Messages -----
   *** MESSAGE [namelist_util] ***    MaxNmlArySize = 256
   *** MESSAGE [namelist_util] ***  -- version = $Name:  $$Id: exp-Venuslike.rd,v 1.12 2014/07/07 14:50:01 yot Exp $
   *** MESSAGE [dcpam_main] ***  NAMELIST group "dcpam_main_nml" is loaded from "./conf/dcpam_Vlp_T10L50.conf".
   &DCPAM_MAIN_NML FLAGDYNAMICS=T,FLAGFULLPHYSICS=F,FLAGHS94=F,FLAGVENUSSIMPLE=T,FLAGJUPITERSIMPLE=F,FLAGRADIATIONDENNOUAGCM=T,FLAGRADIATIONDCPAMEV1=F,FLAGRADIATIONDCPAMMV1=F,FLAGRADIATIONSL09=F,FLAGPHYIMP1LAYMODEL=T,FLAGPHYIMPSOILMODEL=F,FLAGPHYIMPSOILMODELSO=F,FLAGPHYIMPATMONLY=F,FLAGVERTICALFILTER=F/
   *** MESSAGE [dcpam_main] ***  FlagDynamics=<T>.
   *** MESSAGE [dcpam_main] ***  FlagRadiationDennouAGCM=<T>.
   *** MESSAGE [dcpam_main] ***  FlagRadiationDcpamEV1  =<F>.
   *** MESSAGE [dcpam_main] ***  FlagRadiationDcpamMV1  =<F>.
                     :
   *** MESSAGE [HistoryClose] ***  "VUBalance.nc" is closed
  
   ############## CPU TIME SUMMARY ################
   surface_properties     0.000000E+00
   auxiliary              0.108007E+00
   vdiffusion_my1974      0.520025E-01
   dynamics_hspl_vas83    0.187212E+01
   mass_fixer             0.280015E-01
   check_prog_vars        0.800041E-02
   timefilter_asselin19   0.280015E-01
   others                 0.552037E+00
   ------------------------------------------------
          TOTAL TIME =    0.264816E+01

In this case, 5 days integration is performed. 
Resolution is T10L50 (Number of grid points of longitude, latitude is 
32, 16, and number of vertical layer is 50). 
History data are output to 'U.nc' and 'Temp.nc' etc., 
and a restart data is output to 'restart.nc'. 


== Visualization of result

Zonal mean temperature distribution after integration for 5 days is shown below. 
It should be noted that the figure you draw may not be the same as that shown here because of difference in model version. 


((:<img src="images/venus_irb_temp_meanlon_time05day.png">:))

This figure is drawn by using ((<Gphys|URL:http://www.gfd-dennou.org/library/ruby/products/gphys/>)), as follows: 

  Please type irb. 

  $ irb

  Following prompt of irb is shown. 

  irb(main):001:0>

  Type following lines. Please note that the left-most number is line number, and it has not been typed. 

  1: require "numru/ggraph"
  2: include NumRu
  3: gphys = GPhys::IO.open('Temp.nc', 'Temp')
  4: DCL.gropn(1)
  5: DCL.sgpset('lcntl', false) ; DCL.uzfact(0.7)
  6: GGraph.set_fig( 'itr'=> 2 )
  7: GGraph.tone( gphys.mean('lon').cut('time'=>5) )
  8: GGraph.color_bar
  9: DCL.grcls

  Type quit to exit irb. 

Above figure shows spin-up phase of the atmosphere, because Venus' atmosphere 
does not reach quasi-equilibrium in 5 days. 

=end EN

=begin JA
== 最後に
実験ディレクトリに作成された計算結果を保存しておきたい場合には
データ用ディレクトリ(例えば data01)を作成し, 
ファイルを移動させて整理しておきましょう. 

  $ mkdir data01
  $ mv *.nc *.log data01/

なお, 計算結果を計算実行時にサブディレクトリへ出力することも可能です. 
((<実験設定の変更|URL:./changesetup.htm>))の出力設定の変更を参照し, 
NAMELIST "&gtool_historyauto_nml" の変数 "FilePrefix" による設定を試してみて下さい. 
=end JA

=begin EN
== Final remark
If you would like to keep the results of the numerical experiment, 
please create a sub directory ("data01" for example), move the files, 
and keep the current directory neatly. 

  $ mkdir data01
  $ mv *.nc *.log data01/

You can output the results of the numerical experimet concurrently with the
execution. Please refer to "Change output settings" 
in ((<Change experimental setup|URL:./changesetup.htm.en>)) 
and try to configure "FilePrefix" variable in NAMELIST "&gtool_historyauto_nml". 

=end EN

=begin JA
== 参考文献
=end JA

=begin EN
== References
=end EN

=begin
* ((<Yamamoto, M, and M. Takahashi, 2003:
  The fully developed superrotation simulated by a general circulation model
  of a Venus-like atmosphere,
  ((|J. Atmos. Sci.|)), ((*60*)), 561--574.
  |URL:http://journals.ametsoc.org/doi/abs/10.1175/1520-0469%282003%29060%3C0561%3ATFDSSB%3E2.0.CO%3B2>))
=end


=begin HTML
<hr />
<small>
  $Id: exp-Venuslike.rd,v 1.12 2014/07/07 14:50:01 yot Exp $
</small>
=end HTML

