#!/bin/bash

varnames=(
    "DTempDtRadL"
    "RadLUWFLXA"
    "RadLDWFLXA"
    "RadSUWFLXA"
    "RadSDWFLXA"
    "QO3"
    "QH2OVap"
    "QH2OLiq"
    "QH2OSol"
    "DTempDtRadS"
    "SigDot"
    "SoilTemp"
    "TKE"
    "U"
    "OMG"
)

#excdirs=( 5 6 7 )
excdirs=( 10 20 30 40 50 60 70 )

read -p "Will you really remove files?" input
if [ $input = "y" ] ; then
    echo "Executing ..."
else
    echo "Stop script."
    exit
fi

com0="rm -f"
for idir in {1..60} ; do
    #echo ${idir}
    if [ $idir -lt 10 ] ; then
	cdir="000"$idir
    elif [ $idir -lt 100 ] ; then
	cdir="00"$idir
    elif [ $idir -lt 1000 ] ; then
	cdir="0"$idir
    else
	cdir=$idir
    fi

    if [ -d $cdir ]; then
	# directory exists

	# check for exclude directories
	flag_skip=0
	for iexcdir in "${excdirs[@]}" ; do
	    if [ $idir -eq $iexcdir ] ; then
		flag_skip=1
	    fi
	done
	if [ $flag_skip -eq 1 ] ; then
	    # exclude directories
	    echo $cdir "is skipped."
	else
	    # remove files
	    echo ${cdir}
	    for varname in "${varnames[@]}" ; do
		#echo $varname
		com=$com0" "$cdir"/"$varname"_rank??????.nc"
		echo $com
		eval $com
	    done
	fi

    else
	echo $cdir "does not exist."
    fi
done
