program merge

  use vtype_module
  use fi_module
  use ni3_module

  implicit none

  character(extstr)     :: ctlfn
  integer               :: ctlfu
  character(extstr)     :: mode
  integer               :: ios

  integer               :: NcID

  character(extstr)     :: NcFN

  integer               :: tmax
  real(DP), allocatable :: a_Time (:)


  namelist /file/ NcFN


  ctlfn = 'js_loop_chktime.nml'
  mode  = 'read'
  call fi_open( ctlfn, mode, ctlfu )


  rewind( ctlfu )
  read( ctlfu, nml = file, iostat = ios )
!!$  write( 6, * ) NcFN
  if ( ios /= 0 ) stop 'Unable to read namelist file.'
!!$  write( 6, file )


  if ( NcFN  == '-----' ) then
     write( 6, * ) 'Inappropriate file name.'
     stop
  end if

  mode = "read"
  call ni3_open( NcFN, mode, NcID )

  call ni3_inq_dimlen( NcID, "time", tmax )

  ! read time
  !
  allocate( a_Time( tmax ) )
  call ni3_get_var( NcID, "time", a_Time )

  write( 6, * ) a_Time( tmax )

  deallocate( a_Time )

  stop
end program merge
