#!/bin/bash

#PBS -N AMIP42
##PBS -q uv-test
#PBS -q uv-large
#PBS -o stdout.log
#PBS -e stderr.log
##PBS -l select=1:ncpus=1:mpiprocs=1
## for flat MPI (MPI 4 processes)
##PBS -l select=1:ncpus=4:mpiprocs=4
## for flat MPI (MPI 8 processes)
##PBS -l select=1:ncpus=8:mpiprocs=8
## for flat MPI (MPI 16 processes)
##PBS -l select=1:ncpus=16:mpiprocs=16
## for flat MPI (MPI 32 processes)
#PBS -l select=1:ncpus=32:mpiprocs=32
## for hybrid (MPI 6 processes with 16 threads each)
##PBS -l select=1:ncpus=96:mpiprocs=6:mem=100gb
## for hybrid (MPI 8 processes with 12 threads each)
##PBS -l select=1:ncpus=96:mpiprocs=8:mem=100gb
## for hybrid (MPI 12 processes with 8 threads each)
##PBS -l select=1:ncpus=96:mpiprocs=12:mem=100gb

cd ${PBS_O_WORKDIR}
mpiexec_mpt -np 32 dplace -s1 ./dcpam_main -N=./dcpam_E_T42L26.conf

# for hybrid (MPI 8 processes with 12 threads each)
#export KMP_AFFINITY=disabled
#export OMP_NUM_THREADS=12
#mpiexec_mpt -np 8 omplace -nt ${OMP_NUM_THREADS} -c 0-95 ./dcpam_main -N=./dcpam_MarsSeries_T21L36.conf

## for hybrid (MPI 12 processes with 8 threads each)
#export KMP_AFFINITY=disabled
#export OMP_NUM_THREADS=8
#mpiexec_mpt -np 12 omplace -nt ${OMP_NUM_THREADS} -c 0-95 ./dcpam_main -N=./dcpam_MarsSeries_T15L59.conf
