#!/usr/bin/ruby
require "fileutils"

radmodels_dir = "/work02/yot/work/radmodels/lbl_k-dist/src_common"

dcpam_paths     = Dir.glob("*.?90")
radmodels_paths = Dir.glob(radmodels_dir+"/*/*.?90")

for i in 0..(dcpam_paths.size-1)
  dcpam_path = dcpam_paths[i]
  dcpam_file = dcpam_path.split("/")[-1]
  flag_find = false
  for j in 0..(radmodels_paths.size-1)
    radmodels_path = radmodels_paths[j]
    radmodels_file = radmodels_path.split("/")[-1]
    if radmodels_file == dcpam_file then
      flag_find = true
      break
    end
  end
  if flag_find then
    if FileUtils.cmp( radmodels_path, dcpam_path ) then
      print dcpam_file + " seems to be latest.\n"
    else
      print dcpam_file + " DOES NOT seem to be latest.\n"
      #
      print "Do you want to show difference of " + dcpam_file + "? (yes/no)\n"
      flag_diff = gets
      flag_diff.chomp!
      if flag_diff == 'y' || flag_diff == 'yes' then
        system( "diff -u " + radmodels_path + " " + dcpam_path )
      end
      #
      print dcpam_file + " DOES NOT seem to be latest.\n"
      print "Do you want to copy " + dcpam_file + "? (yes/no)\n"
      flag_cp = gets
      flag_cp.chomp!
      if flag_cp == 'y' || flag_cp == 'yes' then
        print "  " + dcpam_file + " is copied.\n"
        FileUtils.cp( radmodels_path, dcpam_path )
      else
        print "  " + dcpam_file + " is NOT copied.\n"
      end
    end
  else
    print "NOTE: " + dcpam_file + " is not found in radmodels directory.\n"
  end
  print "\n"
end

