!= 地面温度, 土壌温度の時間積分
! 
!= Time integration of surface temperature and soil temperature
!
! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA
! Version::   $Id: intg_surftemp.f90,v 1.10 2011/07/08 03:55:20 yot Exp $ 
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module intg_surftemp
  !
  != 地面温度, 土壌温度の時間積分
  ! 
  != Time integration of surface temperature and soil temperature
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! 地面温度と土壌温度の時間積分を行います. 
  ! 
  ! Time integration of surface temperature and soiltemperature
  !
  !== Procedures List
  !
  ! IntegralSurfTemp   :: 地面温度, 土壌温度の時間積分
  ! ---------------    :: ---------------
  ! IntegralSurfTemp   :: Time integration of surface temperature and soil temperature
  !
  !--
  !== NAMELIST
  !
  ! NAMELIST#intg_surftemp_nml
  !++

  ! モジュール引用 ; USE statements
  !

  ! 格子点設定
  ! Grid points settings
  !
  use gridset, only:   imax, & ! 経度格子点数. 
                               ! Number of grid points in longitude
    &                  jmax, & ! 緯度格子点数. 
                               ! Number of grid points in latitude
    &                  kmax, & ! 鉛直層数. 
                               ! Number of vertical level
    &                kslmax    ! 地下の鉛直層数. 
                               ! Number of subsurface vertical level

  ! 種別型パラメタ
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    &                 STRING     ! 文字列.       Strings. 

  ! メッセージ出力
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! 宣言文 ; Declaration statements
  !
  implicit none
  private

  ! 公開手続き
  ! Public procedure
  !
  public :: IntegralSurfTemp
  public :: IntgSurfTempInit

  ! 公開変数
  ! Public variables
  !

  ! 非公開変数
  ! Private variables
  !
  logical, save :: intg_surftemp_inited = .false.
                              ! 初期設定フラグ. 
                              ! Initialization flag

  character(*), parameter:: module_name = 'intg_surftemp'
                              ! モジュールの名称. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name:  $' // &
    & '$Id: intg_surftemp.f90,v 1.10 2011/07/08 03:55:20 yot Exp $'
                              ! モジュールのバージョン
                              ! Module version

contains

  !--------------------------------------------------------------------------------------

  subroutine IntegralSurfTemp(         &
    & xy_DSurfTempDt, xyz_DSoilTempDt, &          ! (in)
    & xy_SurfTemp   , xyz_SoilTemp     &          ! (inout)
    & )
    !
    ! 地面温度, 土壌温度の時間積分を行います. 
    !
    ! Time integration of surface temperature and soil temperature
    !
    !

    ! モジュール引用 ; USE statements
    !

    ! 時刻管理
    ! Time control
    !
    use timeset, only: DelTime, &  ! $ \Delta t $
      & TimesetClockStart, TimesetClockStop

    ! 宣言文 ; Declaration statements
    !
    implicit none
    real(DP), intent(in):: xy_DSurfTempDt (0:imax-1, 1:jmax)
                              ! 地表面温度変化率 (K s-1)
                              ! Surface temperature tendency (K s-1)
    real(DP), intent(in):: xyz_DSoilTempDt (0:imax-1, 1:jmax, 1:kslmax)
                              ! $ \DP{Tg}{t} $ . 土壌温度変化 (K s-1)
                              ! Temperature tendency (K s-1)
    real(DP), intent(inout):: xy_SurfTemp (0:imax-1, 1:jmax)
                              ! 地表面温度. 
                              ! Surface temperature
    real(DP), intent(inout):: xyz_SoilTemp(0:imax-1, 1:jmax, 1:kslmax)
                              ! 土壌温度 (K)
                              ! Soil temperature (K)


    ! 作業変数
    ! Work variables
    !


    ! 実行文 ; Executable statement
    !

    ! 初期化確認
    ! Initialization check
    !
    if ( .not. intg_surftemp_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! 計算時間計測開始
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )

    ! 地表面温度時間積分
    ! Time integration of surface temperature
    !
    xy_SurfTemp = xy_SurfTemp + xy_DSurfTempDt * DelTime

    ! 土壌温度時間積分
    ! Time integration of subsurface temperature
    !
    xyz_SoilTemp = xyz_SoilTemp + xyz_DSoilTempDt * DelTime

    ! 計算時間計測一時停止
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine IntegralSurfTemp

  !--------------------------------------------------------------------------------------

  subroutine IntgSurfTempInit
    !
    ! intg_surftemp モジュールの初期化を行います. 
    ! NAMELIST#intg_surftemp_nml の読み込みはこの手続きで行われます. 
    !
    ! "intg_surftemp" module is initialized. 
    ! "NAMELIST#intg_surftemp_nml" is loaded in this procedure. 
    !

    ! モジュール引用 ; USE statements
    !

    ! NAMELIST ファイル入力に関するユーティリティ
    ! Utilities for NAMELIST file input
    !
!!$    use namelist_util, only: namelist_filename, NmlutilMsg

    ! ファイル入出力補助
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! 種別型パラメタ
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output

    ! 文字列操作
    ! Character handling
    !
    use dc_string, only: StoA

    ! 宣言文 ; Declaration statements
    !
    implicit none

!!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
!!$                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read

    ! NAMELIST 変数群
    ! NAMELIST group name
    !
!!$    namelist /intg_surftemp_nml/
          !
          ! デフォルト値については初期化手続 "intg_surftemp#IntgSurfTempInit" 
          ! のソースコードを参照のこと. 
          !
          ! Refer to source codes in the initialization procedure
          ! "intg_surftemp#IntgSurfTempInit" for the default values. 
          !

    ! 実行文 ; Executable statement
    !

    if ( intg_surftemp_inited ) return


    ! デフォルト値の設定
    ! Default values settings
    !

!!$    ! NAMELIST の読み込み
!!$    ! NAMELIST is input
!!$    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml, &           ! (in)
!!$        & nml = intg_surftemp_nml, &  ! (out)
!!$        & iostat = iostat_nml )   ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$    end if

    ! 印字 ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    intg_surftemp_inited = .true.

  end subroutine IntgSurfTempInit

  !--------------------------------------------------------------------------------------

end module intg_surftemp
