
    program main

      use vtype_module
      use const_module   , only : const_set, r2d
      use lt2_module
      use ni3_module
      use netcdf


      implicit none


      integer(i4b)              :: im, jmg, jm, lm, ntrunc
      integer(i4b)              :: km, tm

      integer(i4b)              :: ita( 5, 2 )
      real(dp)    , allocatable :: dta( :, : )
      real(dp)    , allocatable :: sinlatg( : ), coslatg( : ), gwg( : )
      integer(i4b), allocatable :: ord( : ), deg( : )
      real(dp)    , allocatable :: pmn( :, : ), eps( : )

      real(dp)    , allocatable :: x_lon( : ), y_latg( : )
      real(dp)    , allocatable :: z_plev( : )

      character(extstr)         :: ncfn_in
      character(extstr)         :: mode
      character(extstr)         :: ncfn_out
      integer(i4b)              :: ncid_in
      integer(i4b)              :: ncid_out
      character(extstr)         :: name, stdname, longname, units
      character(len=extstr)     :: attname
      character(len=extstr)     :: attchar
      integer(i4b)              :: ndims = 4
      character(extstr)         :: dimname( 4 )

      real(sp)                  :: fillvalue

      real(dp)                  :: tmp11, tmp12, tmp21, tmp22
      real(dp)                  :: tmp1, tmp2
      integer(i4b)              :: nx, ny
      real(dp)    , allocatable :: xyz_o3_in   (:,:,:)
      real(dp)    , allocatable :: xyz_o3_in_ex(:,:,:)
      real(dp)    , allocatable :: xyz_o3_out  (:,:,:)
      real(dp)    , allocatable :: x( : ), y( : )
      real(dp)    , allocatable :: x_ex( : )

      real(dp)                  :: time

      integer(i4b)              :: days_of_month(12)
      real(sp)                  :: time_arr(12)
      integer(i4b), allocatable :: x_i(:)
      integer(i4b), allocatable :: y_j(:)

      integer(i4b)              ::  i,  j, k, t
      integer(i4b)              :: ii, jj


      ! T10
      im  = 32
      ! T21
      im  = 64
      ! T31
      im  = 32 * 3
      ! T42
      im  = 64 * 2
!!$      ! T63
!!$      im  = 64 * 3
!!$      ! T85
!!$      im  = 64 * 2 * 2
!!$      ! T106
!!$      im  = 64 * 5
!!$      ! T170
!!$      im  = 64 * 2 * 2 * 2
!!$      ! T255
!!$      im  = 64 * 2 * 2 * 3
!!$      ! T341
!!$      im  = 64 * 2 * 2 * 2 * 2

      jmg    = im / 2
      ntrunc = ( im - 1 ) / 3

      ! input climatology data file
      ncfn_in = '../mkclim-2015-09-25/O3_CMIP5_climatology.nc'
      ncfn_in = '../mkclim-2015-09-25/O3_CMIP5_climatology_zonalmean.nc'

      ! output data file
      ncfn_out = "out/O3_CMIP5_climatology_zonalmean_T042.nc"
      write( ncfn_out, '(a,i3.3,a)' ) "out/O3_CMIP5_climatology_zonalmean_T", ntrunc, ".nc"


      !========================================
      ! Set planetary parameters
      !
      !----------------------------------------
      ! Parameters for the Earth
      !
      call const_set( 0 )
      !
      !----------------------------------------
      ! Parameters for Mars
      !
!      call const_set( 1 )
      !
      !========================================

      call lt2_inq_arraysize( jmg, ntrunc, jm, lm )


      allocate( dta( im, 2 ) )
      allocate( sinlatg( jmg ), coslatg( jmg ), gwg( jmg ) )
      allocate( ord( lm ), deg( lm ) )
      allocate( pmn( lm, jmg ), eps( lm ) )


      call lt2_init( im, jmg, lm, ntrunc, &
           ita, dta, sinlatg, coslatg, gwg, ord, deg, pmn, eps )


      allocate( x_lon( im ), y_latg( jmg ) )
      do i = 1, im
        x_lon( i ) = 360.0d0 / im * dble( i - 1 )
      end do
      do j = 1, jmg
        y_latg( j ) = asin( sinlatg( j ) ) * r2d
      end do


!      do i = 1, im
!         write( 6, * ) i, lon( i )
!      end do
!      do j = 1, jm
!         write( 6, * ) j, lat( j )
!      end do


      !
      ! read the ETOPO2 data and average in Gaussian grid bins
      !

      mode = 'read'
      call ni3_open( ncfn_in, mode, ncid_in )

      call ni3_inq_dimlen( ncid_in, 'lon' , nx )
      call ni3_inq_dimlen( ncid_in, 'lat' , ny )
      call ni3_inq_dimlen( ncid_in, 'plev', km )
      call ni3_inq_dimlen( ncid_in, 'time', tm )

      allocate( x( nx ), y( ny ) )
      allocate( z_plev( km ) )

      call ni3_get_var( ncid_in, 'lon' , x    )
      call ni3_get_var( ncid_in, 'lat' , y    )
      call ni3_get_var( ncid_in, 'plev', z_plev )

      allocate( xyz_o3_in   ( nx, ny, km ) )
      allocate( xyz_o3_out  ( im, jm, km ) )

      allocate( x_ex( nx+1 ) )
      allocate( xyz_o3_in_ex( nx+1, ny, km ) )

      do i = 1, nx
        x_ex(i) = x(i)
      end do
      x_ex(nx+1) = 360.0d0


      name = "O3"
      call ni3_get_att( ncid_in, name, "_FillValue", fillvalue )


      !------------------------

      !
      ! Output to a NetCDF file
      !
!!$      write( ncfn_out, '(a,i3.3,a)' ) "out/O3_CMIP5_climatology_zonalmean_T", ntrunc, ".nc"
      mode = "new"
      call ni3_open( ncfn_out, mode, ncid_out )

      call ni3_cp_atts( ncid_in, ncid_out, "global" )

      name     = "lon"
      stdname  = "longitude"
      longname = "Longitude"
      units    = "degrees_east"
      call ni3_set_dim( ncid_out, name, NF90_REAL, x_lon, &
        stdname = stdname, longname = longname, units = units )
      name    = "lat"
      stdname  = "latitude"
      longname = "Latitude"
      units    = "degrees_north"
      call ni3_set_dim( ncid_out, name, NF90_REAL, y_latg, &
        stdname = stdname, longname = longname, units = units )
      name    = "plev"
      stdname  = "air_pressure"
      longname = "Pressure"
      units    = "Pa"
      call ni3_set_dim( ncid_out, name, NF90_REAL, z_plev, &
        stdname = stdname, longname = longname, units = units )
      attname = "positive"
      attchar = "down"
      call ni3_put_att( ncid_out, name, attname, attchar )
      name     = "time"
      stdname  = "time"
      longname = "time"
!!$      units    = "months since 0000-01-01"
      units    = "days since 0000-01-01"
      call ni3_def_dim( ncid_out, name, NF90_REAL, NF90_UNLIMITED, &
        stdname = stdname, longname = longname, units = units )

      dimname( 1 ) = "lon"
      dimname( 2 ) = "lat"
      dimname( 3 ) = "plev"
      dimname( 4 ) = "time"

      name         = "O3"
!!$    stdname      = "mole_fraction_of_ozone_in_air"
      stdname      = "mass_mixing_ratio_of_ozone_in_air"
      longname     = "O3"
!!$    units        = "mole mole^-1"
      units        = "1"
      call ni3_def_var( ncid_out, name, NF90_REAL, ndims, dimname, &
        stdname = stdname, longname = longname, units = units, fillvalue = fillvalue )

      call ni3_put_att( ncid_out, name, "missing_value", fillvalue )
      !------------------------


      allocate( x_i( im ) )
      allocate( y_j( jm ) )


      do t = 1, tm
        write( 6, * ) t

        call ni3_get_varss( ncid_in, 'time', t, time      )
        call ni3_get_varss( ncid_in, 'O3'  , t, xyz_o3_in )

        do k = 1, km
          do j = 1, ny
            do i = 1, nx
              if( xyz_o3_in(i,j,k) == fillvalue ) xyz_o3_in(i,j,k) = 0.0d0
            end do
          end do
        end do

        do k = 1, km
          do j = 1, ny
            do i = 1, nx
              xyz_o3_in_ex(i,j,k) = xyz_o3_in(i,j,k)
            end do
          end do
        end do
        do k = 1, km
          do j = 1, ny
            xyz_o3_in_ex(nx+1,j,k) = xyz_o3_in(1,j,k)
          end do
        end do

        do i = 1, im
          search_i : do ii = 2, nx+1
            if ( x_ex(ii) >= x_lon( i ) ) then
              x_i(i) = ii
              exit search_i
            end if
          end do search_i
        end do
        do j = 1, jm
          search_j : do jj = 2, ny
            if ( y(jj) >= y_latg( j ) ) then
              y_j(j) = jj
              exit search_j
            end if
          end do search_j
        end do

        do k = 1, km
          do j = 1, jm
            do i = 1, im

              ii = x_i(i)
              jj = y_j(j)

              tmp11 = xyz_o3_in_ex(ii-1,jj-1,k)
              tmp21 = xyz_o3_in_ex(ii  ,jj-1,k)
              tmp12 = xyz_o3_in_ex(ii-1,jj  ,k)
              tmp22 = xyz_o3_in_ex(ii  ,jj  ,k)

              tmp1 = &
                &   ( tmp12 - tmp11 ) &
                & / ( y(jj) - y(jj-1) ) * ( y_latg(j) - y(jj-1) ) &
                & + tmp11
              tmp2 = &
                &   ( tmp22 - tmp21 ) &
                & / ( y(jj) - y(jj-1) ) * ( y_latg(j) - y(jj-1) ) &
                & + tmp21

              xyz_o3_out(i,j,k) = &
                &   ( tmp2 - tmp1 ) &
                & / ( x_ex(ii) - x_ex(ii-1) ) * ( x_lon(i) - x_ex(ii-1) ) &
                & + tmp1

            end do
          end do
        end do

        xyz_o3_out = max( xyz_o3_out, 0.0d0 )


        days_of_month( 1) = 31
        days_of_month( 2) = 28
        days_of_month( 3) = 31
        days_of_month( 4) = 30
        days_of_month( 5) = 31
        days_of_month( 6) = 30
        days_of_month( 7) = 31
        days_of_month( 8) = 31
        days_of_month( 9) = 30
        days_of_month(10) = 31
        days_of_month(11) = 30
        days_of_month(12) = 31

        time_arr( 1) =  15.5
        time_arr( 2) =  45
        time_arr( 3) =  74.5
        time_arr( 4) = 105
        time_arr( 5) = 135.5
        time_arr( 6) = 166
        time_arr( 7) = 196.5
        time_arr( 8) = 227.5
        time_arr( 9) = 258
        time_arr(10) = 288.5
        time_arr(11) = 319
        time_arr(12) = 349.5


!!$        time = sum( days_of_month(1:t-1) )
        time = time_arr(t)

        name = "time"
        call ni3_put_varss( ncid_out, name, t, time )
        name = "O3"
        call ni3_put_varss( ncid_out, name, t, xyz_o3_out )

      end do


      call ni3_close( ncid_out )

      call ni3_close( ncid_in )


    end program main
