    subroutine ave( im, jm, midlon, midlat, array, arraystd )

      use vtype_module
      use ni3_module
      use netcdf

      implicit none

      integer(i4b), intent(in ) :: im, jm
      real(dp)    , intent(in ) :: midlon( im+1 ), midlat( jm+1 )
      real(dp)    , intent(out) :: array   ( im, jm )
      real(dp)    , intent(out) :: arraystd( im, jm )


      !
      ! local variables
      !
      character(extstr)         :: path, mode
      integer(i4b)              :: ncid, varid, status, st( 2 ), co( 2 )

      integer(i4b)              :: nx, ny
      real(dp)    , allocatable :: tmp_arr( : )
      real(dp)    , allocatable :: x( : ), y( : )
      real(dp)    , allocatable :: z1d( : )
      integer(i4b)              :: num( im, jm )
      integer(i4b)              ::  i,  j
      integer(i4b)              :: ii, jj



      do j = 1, jm
         do i = 1, im
            num     ( i, j ) = 0
            array   ( i, j ) = 0.0d0
            arraystd( i, j ) = 0.0d0
         end do
      end do


      !
      ! read the ETOPO2 data and average in Gaussian grid bins
      !

!      path = '../etopo2/ETOPO2v2c_f4.nc'
      path = '../etopo1/ETOPO1_Ice_c_gmt4.nc'
      mode = 'read'
      call ni3_open( path, mode, ncid )

!!$      call ni3_inq_dimlen( ncid, 'x', nx )
!!$      call ni3_inq_dimlen( ncid, 'y', ny )
      call ni3_inq_dimlen( ncid, 'lon', nx )
      call ni3_inq_dimlen( ncid, 'lat', ny )

      allocate( x( nx ), y( ny ), z1d( nx ) )

!!$      call ni3_get_var( ncid, 'x', x )
!!$      call ni3_get_var( ncid, 'y', y )
      call ni3_get_var( ncid, 'lon', x )
      call ni3_get_var( ncid, 'lat', y )

      allocate( tmp_arr( nx ) )
      do i = 1, nx
         tmp_arr( i ) = x( i )
      end do
      do i = 1, nx/2
         x( i      ) = tmp_arr( i+nx/2 )
         x( i+nx/2 ) = tmp_arr( i      ) + 360.0d0
      end do

      do j = 1, ny
         write( 6, * ) j, ny

         status = nf90_inq_varid( ncid, 'z', varid )
         call ni3_handle_err( status )

         st( 1 ) = 1 ; st( 2 ) = j ; co( 1 ) = nx ; co( 2 ) = 1
         status = nf90_get_var( ncid, varid, tmp_arr, start = st, count = co )
         call ni3_handle_err( status )

         do i = 1, nx/2
            z1d( i      ) = tmp_arr( i+nx/2 )
            z1d( i+nx/2 ) = tmp_arr( i      )
         end do


         do i = 1, nx
            if(  ( x( i ) .lt.   0.0d0 ) .or. &
                 ( x( i ) .gt. 360.0d0 ) .or. &
                 ( y( j ) .lt. -90.0d0 ) .or. &
                 ( y( j ) .gt.  90.0d0 ) ) then
               write( 6, * ) 'Longitude or latitude is out of range.'
               write( 6, * ) i, j, x( i ), y( j )
            end if


            if( x( i ) .ge. midlon( im+1 ) ) then
               ii = 1
            else
               find_ii: do ii = 1, im
                  if(  ( x( i ) .ge. midlon( ii   ) ) .and. &
                       ( x( i ) .lt. midlon( ii+1 ) ) ) exit
               end do find_ii
               if( ii .gt. im ) then
                  write( 6, * ) 'lon is unexpected value'
                  write( 6, * ) ii, im
                  write( 6, * ) i, x( i )
                  stop
               end if
            end if

            find_jj: do jj = 1, jm-1
               if(  ( y( j ) .ge. midlat( jj   ) ) .and. &
                    ( y( j ) .lt. midlat( jj+1 ) ) ) exit
            end do find_jj
            if(  ( y( j ) .ge. midlat( jm   ) ) .and. &
                 ( y( j ) .le. midlat( jm+1 ) ) ) then
               jj = jm
            end if

!            write( 6, * ) midlon( ii ), lon, midlon( ii+1 )
!            write( 6, * ) midlat( jj ), lat, midlat( jj+1 )


            array   ( ii, jj ) = array   ( ii, jj ) + dble( z1d( i )    )
            arraystd( ii, jj ) = arraystd( ii, jj ) + dble( z1d( i )**2 )
            num     ( ii, jj ) = num     ( ii, jj ) + 1


!            write( *, * ) lon, lat, itopo( i )

         end do

      end do

      call ni3_close( ncid )

      do j = 1, jm
         do i = 1, im
            if( num( i, j ) .eq. 0 ) then
               write( 6, * ) 'Error: Number of data in bin is zero.'
               write( 6, * ) i, j
               stop
            end if
            array   ( i, j ) = array   ( i, j ) / num( i, j )
            arraystd( i, j ) = arraystd( i, j ) / num( i, j )
         end do
      end do

      arraystd(:,:) = sqrt( arraystd(:,:) - array(:,:)**2 )


    end subroutine ave
