
    program main

      use vtype_module
      use const_module   , only : const_set, r2d
      use lt2_module
      use ni3_module
      use netcdf


      implicit none


      integer(i4b)              :: im, jmg, jm, lm, ntrunc

      integer(i4b)              :: ita( 5, 2 )
      real(dp)    , allocatable :: dta( :, : )
      real(dp)    , allocatable :: sinlatg( : ), coslatg( : ), gwg( : )
      integer(i4b), allocatable :: ord( : ), deg( : )
      real(dp)    , allocatable :: pmn( :, : ), eps( : )

      real(dp)    , allocatable :: lon( : ), latg( : )

      real(dp)                  :: a_Time(1)

      real(dp)    , allocatable :: midlon( : )
      real(dp)    , allocatable :: midlat( : )
      real(dp)    , allocatable :: topog   ( :, : )
      real(dp)    , allocatable :: topogstd( :, : )
      integer(i4b), allocatable :: sfcindex( :, : )
      real(dp)    , allocatable :: culint( :, : )

      real(dp)    , allocatable :: farrr( :, : ), farri( :, : )
      real(dp)    , allocatable :: sarr( : )

      integer(i4b)              :: ipow
      real(dp)                  :: factor

      character(extstr)         :: path, mode
      integer(i4b)              :: ncid
      character(extstr)         :: name, stdname, longname, units
      integer(i4b)              :: ndims
      character(extstr)         :: dimname( 3 )

      character(extstr*10)      :: title, inst, src, com

      integer(i4b)              :: i, j, l



      !========================================
      ! Set planetary parameters
      !
      !----------------------------------------
      ! Parameters for the Earth
      !
      call const_set( 0 )
      !
      !----------------------------------------
      ! Parameters for Mars
      !
!      call const_set( 1 )
      !
      !========================================


      ! T10
      im  = 32
      ! T21
      im  = 64
!!$      ! T31
!!$      im  = 32 * 3
!!$      ! T42
!!$      im  = 64 * 2
!!$      ! T63
!!$      im  = 64 * 3
!!$      ! T85
!!$      im  = 64 * 2 * 2
!!$      ! T106
!!$      im  = 64 * 5
!!$      ! T170
!!$      im  = 64 * 2 * 2 * 2
      ! T341
      im  = 64 * 2 * 2 * 2 * 2


      jmg    = im / 2
      ntrunc = ( im - 1 ) / 3


      call lt2_inq_arraysize( jmg, ntrunc, jm, lm )


      allocate( dta( im, 2 ) )
      allocate( sinlatg( jmg ), coslatg( jmg ), gwg( jmg ) )
      allocate( ord( lm ), deg( lm ) )
      allocate( pmn( lm, jmg ), eps( lm ) )


      call lt2_init( im, jmg, lm, ntrunc, &
           ita, dta, sinlatg, coslatg, gwg, ord, deg, pmn, eps )


      allocate( lon( im ), latg( jmg ) )
      do i = 1, im
         lon( i ) = 360.0d0 / im * dble( i - 1 )
      end do
      do j = 1, jmg
         latg( j ) = asin( sinlatg( j ) ) * r2d
      end do
      a_Time(1) = 0.0d0

      allocate( midlon( im+1 ) , midlat( jmg+1 ) )
      allocate( topog   ( im, jm ) )
      allocate( topogstd( im, jm ) )
      allocate( sfcindex( im, jm ) )
      allocate( culint  ( im, jm ) )

      allocate( farrr( im, jm ), farri( im, jm ) )
      allocate( sarr( lm ) )


      do i = 1, im+1-1
         midlon( i ) = 360.0d0 / dble( im ) * dble( i-1 ) &
              - 360.0d0 / dble( im ) / 2.0d0
      end do
      i = im+1
      midlon( i ) = 360.0d0


      j = 1
      midlat( j ) = -90.0d0
      do j = 2, jm
         midlat( j ) = ( latg( j-1 ) + latg( j ) ) / 2.0d0
      end do
      j = jm + 1
      midlat( j ) =  90.0d0


!      do i = 1, im
!         write( 6, * ) i, lon( i )
!      end do
!      do j = 1, jm
!         write( 6, * ) j, lat( j )
!      end do


      !
      ! topography
      !
      call ave( im, jm, midlon, midlat, topog, topogstd )
!!$      topog = 0.0d0

      do j = 1, jm
         do i = 1, im
!!$            if( topog( i, j ) .lt. 0.0d0 ) then
!!$               ! ocean
!!$               sfcindex( i, j ) = 0
!!$            else
!!$               ! land
!!$               sfcindex( i, j ) = 1
!!$            end if
            topog( i, j ) = max( topog( i, j ), 0.0d0 )
         end do
      end do


      call lt2_g2s_2d( im, jmg, jm, lm, ita, dta, gwg, pmn, &
           topog, sarr )
      ! truncation
      call lt2_truncate_2d( lm, ntrunc, sarr )
      ! filtering
      ipow = 4
      do l = 1, lm
         if( deg( l ) .gt. ntrunc ) then
            factor = 0.0d0
         else
            factor = 1.0d0 - ( dble( deg( l ) ) / dble( ntrunc ) )**ipow
         end if
         sarr( l ) = sarr( l ) * factor
      end do
      call lt2_s2g_2d( im, jmg, jm, lm, ita, dta, pmn, &
           sarr, topog )
      !
      !
      call lt2_g2s_2d( im, jmg, jm, lm, ita, dta, gwg, pmn, &
           topogstd, sarr )
      ! truncation
      call lt2_truncate_2d( lm, ntrunc, sarr )
      ! filtering
      ipow = 4
      do l = 1, lm
         if( deg( l ) .gt. ntrunc ) then
            factor = 0.0d0
         else
            factor = 1.0d0 - ( dble( deg( l ) ) / dble( ntrunc ) )**ipow
         end if
         sarr( l ) = sarr( l ) * factor
      end do
      call lt2_s2g_2d( im, jmg, jm, lm, ita, dta, pmn, &
           sarr, topogstd )



      call mksfcindex( im, jm, lon, latg, midlon, midlat, sfcindex )
!!$      sfcindex = 0


      call mkculint( im, jm, lon, latg, midlon, midlat, culint )


      ! modify standard deviation
      do j = 1, jm
         do i = 1, im
            if( sfcindex(i,j) == 0 ) then
              topogstd(i,j) = 0.0d0
            end if
         end do
      end do
      topogstd(:,:) = max( topogstd(:,:), 0.0d0 )

      !
      ! output
      !

      write( path, '( a, i3.3, a )' ) &
           'out/sp_for_Earth_T', ( im-1 ) / 3, '.nc'
      mode = 'new'
      call ni3_open( path, mode, ncid )

      title = "Orographic height and surface index"
      inst  = "dcpam/dcmodel project, GFD Dennou Club"
      src   = "Orographic height: ETOPO1 from" &
        & // " http://www.ngdc.noaa.gov/mgg/global/relief/ETOPO1/data/ice_surface/cell_registered/netcdf/ETOPO1_Ice_c_gmt4.grd.gz;" &
        & // " surface index: Global land use data by Matthews from http://data.giss.nasa.gov/landuse/vegeem.html and http://data.giss.nasa.gov/landuse/cultint.html"
      com   = "Orographic height data are obtained by areal averaging ETOPO1 data, and the surface index is obtained by interpolating Matthews' data."
      call ni3_set_ga( ncid, title = title, inst = inst, src = src, com = com )

      name     = 'lon'
      stdname  = name
      longname = name
      units    = 'degrees_east'
      call ni3_set_dim( ncid, name, NF90_DOUBLE, lon, &
           stdname, longname, units )

      name     = 'lat'
      stdname  = name
      longname = name
      units    = 'degrees_north'
      call ni3_set_dim( ncid, name, NF90_DOUBLE, latg, &
           stdname, longname, units )

      name     = 'time'
      stdname  = name
      longname = name
      units    = 'days'
      call ni3_set_dim( ncid, name, NF90_DOUBLE, a_Time, &
        & stdname, longname, units )

      name         = 'zs'
      stdname      = name
      longname     = 'orographic height'
      ndims        = 2
      dimname( 1 ) = 'lon'
      dimname( 2 ) = 'lat'
      units        = 'm'
      call ni3_def_var( ncid, name, NF90_DOUBLE, ndims, dimname(1:2), &
           stdname, longname, units )

      name         = 'zsstd'
      stdname      = name
      longname     = 'orographic height standard deviation'
      ndims        = 2
      dimname( 1 ) = 'lon'
      dimname( 2 ) = 'lat'
      units        = 'm'
      call ni3_def_var( ncid, name, NF90_DOUBLE, ndims, dimname(1:2), &
           stdname, longname, units )

      name         = 'sfcindex'
      stdname      = name
      longname     = 'surface index (vegetation)'
      ndims        = 2
      dimname( 1 ) = 'lon'
      dimname( 2 ) = 'lat'
      units        = '1'
      call ni3_def_var( ncid, name, NF90_INT, ndims, dimname(1:2), &
           stdname, longname, units )

      name         = 'culint'
      stdname      = name
      longname     = 'cultivation intensity'
      ndims        = 3
      dimname( 1 ) = 'lon'
      dimname( 2 ) = 'lat'
      dimname( 3 ) = 'time'
      units        = '1'
      call ni3_def_var( ncid, name, NF90_DOUBLE, ndims, dimname, &
           stdname, longname, units )

      name = 'zs'
      call ni3_put_var( ncid, name, topog    )
      name = 'zsstd'
      call ni3_put_var( ncid, name, topogstd )
      name = 'sfcindex'
      call ni3_put_var( ncid, name, sfcindex )
      name = 'culint'
      call ni3_put_varss( ncid, name, 1, culint )

      call ni3_close( ncid )


!!$      open( 51, file = fn, status = 'unknown' )
!!$      write( 51, * ) "# ", im, jm
!!$      do j = 1, jm
!!$         do i = 1, im
!!$            write( 51, '(5e)' ) lon( i ), lat( j ), &
!!$                 topog( i, j ) * 1.0d-3
!!$         end do
!!$         write( 51, * )
!!$      end do
!!$      close( 51 )

!!$      write( fn, '( a, i2.2, a )' ) "out/sp_for_Earth_T", ( im-1 ) / 3, &
!!$           ".data"
!!$      open( 51, file = fn, status = 'unknown' )
!!$      write( 51, * ) "#", im, jm
!!$      do j = 1, jm
!!$         do i = 1, im
!!$            write( 51, * ) lon( i ), lat( j ), &
!!$                 topog( i, j )
!!$         end do
!!$      end do
!!$      close( 51 )


    end program main
