
== 概要

DCPAM で用いる地形, 土地利用, 耕作率のデータを, 下の「処理内容」に
説明する方法で作成します. 

なお, out-sample ディレクトリ内には, これまでに作成されたいくつかの解像度の
データを置いています.


== 処理内容

* 地形(標高)
  * 使用データ
    * ETOPO1
    * http://www.ngdc.noaa.gov/mgg/global/relief/ETOPO1/data/ice_surface/cell_registered/netcdf/ETOPO1_Ice_c_gmt4.grd.gz
      * 拡張子は .grd だが, 実体は netcdf ファイル (ファイル名を変更して使用)
  * 処理内容
    * ガウス格子内のデータを平均
    * ルジャンドル変換
    * F(n) = 1 - (n/N)**4 のファクタをかける
    * 非常に強いフィルタです.
    * ルジャンドル逆変換
* 土地利用
  * 使用データ
    * http://www.gfd-dennou.org/library/dcpam/related-data/.Earth_Surface/matthews_vegtype_culint.nc
    * 元データ
      * http://data.giss.nasa.gov/landuse/vegeem.html
      * Matthews (1983)
      * 「使用データ」は, この元データを netcdf に変換したもの
  * 処理内容
    * 低解像度版 (経度格子点数 360 以下)
      * ガウス格子内に占める面積が最も大きい土地利用区分を採用
    * 高解像度版 (経度格子点数 360 以上)
      * ガウス格子に最も近いデータ点の値を採用
* 耕作率
  * 使用データ
    * http://www.gfd-dennou.org/library/dcpam/related-data/.Earth_Surface/matthews_vegtype_culint.nc
    * 元データ
      * http://data.giss.nasa.gov/landuse/cultint.html
      * Matthews (1983)
      * 「使用データ」は, この元データを netcdf に変換したもの
  * 処理内容
    * 低解像度版 (経度格子点数 360 以下)
      * ガウス格子内のデータを平均
    * 高解像度版 (経度格子点数 360 以上)
      * ガウス格子に最も近いデータ点の値を採用


== 使用方法

* Makefile の編集
  * 下の変数を設定
    * FC : Fortran90 コンパイラ
    * FFLAGS : Fortran オプション
    * NCDIR : netcdf ライブラリのパス ($(NCDIR)/lib, $(NCDIR)/include を想定)
* 東西方向の格子点数 (解像度) の指定
  * main.f90 内の変数 im を編集
    * 打ち切り波数は (im-1)/3 となる
* 使用データファイルの指定
  * main.f90 内の下の変数を編集
    * 地形 (ETOPO1_Ice_c_gmt4.nc (ETOPO1_Ice_c_gmt4.grd から名前を変更))
      * 変数 path_topog を編集
    * 土地利用 (matthews_vegtype_culint.nc)
      * 変数 path_sfcindex を編集
    * 耕作率 (matthews_vegtype_culint.nc)
      * 変数 path_culint を編集
* コンパイル
  * make
* 実行
  * 実行ファイルは a.out
  * 結果は out ディレクトリ内に生成
