    !**************************************************************************
    !**************************************************************************
    !**************************************************************************

    subroutine lt2_g2s_2d( im, jmg, jm, lm, ita, dta, gwg, pmn, &
         garr, sarr )

      use vtype_module
      use lt2_module, only : lt2_g2s

      implicit none

      integer(i4b), intent(in ) :: im, jmg, jm, lm, ita( 5, 2 )
      real(dp)    , intent(in ) :: dta( im, 2 )
      real(dp)    , intent(in ) :: gwg( jmg ), pmn( lm, jmg )
      real(dp)    , intent(in ) :: garr( im, jm )
      real(dp)    , intent(out) :: sarr( lm )


      !
      ! local variables
      !
      real(dp)     :: garr3d( im, jm, 1 )
      real(dp)     :: sarr2d( lm, 1 )
      integer(i4b) :: i, j, l


      do j = 1, jm
         do i = 1, im
            garr3d( i, j, 1 ) = garr( i, j )
         end do
      end do

      call lt2_g2s( im, jmg, jm, 1, lm, ita, dta, gwg, pmn, &
           garr3d, sarr2d )

      do l = 1, lm
         sarr( l ) = sarr2d( l, 1 )
      end do


    end subroutine lt2_g2s_2d

    !**************************************************************************
    !**************************************************************************
    !**************************************************************************

    subroutine lt2_s2g_2d( im, jmg, jm, lm, ita, dta, pmn, &
         sarr, garr )

      use vtype_module
      use lt2_module, only : lt2_s2g

      implicit none

      integer(i4b), intent(in ) :: im, jmg, jm, lm
      integer(i4b), intent(in ) :: ita( 5, 2 )
      real(dp)    , intent(in ) :: dta( im, 2 )
      real(dp)    , intent(in ) :: pmn( lm, jmg )
      real(dp)    , intent(in ) :: sarr( lm )
      real(dp)    , intent(out) :: garr( im, jm )


      !
      ! local variables
      !
      real(dp)     :: sarr2d( lm, 1 )
      real(dp)     :: garr3d( im, jm, 1 )
      integer(i4b) :: i, j, l


      do l = 1, lm
         sarr2d( l, 1 ) = sarr( l )
      end do

      call lt2_s2g( im, jmg, jm, 1, lm, ita, dta, pmn, &
           sarr2d, garr3d )

      do j = 1, jm
         do i = 1, im
            garr( i, j ) = garr3d( i, j, 1 )
         end do
      end do


    end subroutine lt2_s2g_2d

    !**************************************************************************

    subroutine lt2_s2f_2d( im, jmg, jm, lm, pmn, &
         sarr, farrr, farri )

      use vtype_module
      use lt2_module, only : lt2_s2f

      implicit none

      integer(i4b), intent(in ) :: im, jmg, jm, lm
      real(dp)    , intent(in ) :: pmn( lm, jmg )
      real(dp)    , intent(in ) :: sarr ( lm )
      real(dp)    , intent(out) :: farrr( im, jm ), farri( im, jm )


      !
      ! local variables
      !
      real(dp)     :: sarr2d( lm, 1 )
      real(dp)     :: farrr3d( im, jm, 1 ), farri3d( im, jm, 1 )
      integer(i4b) :: i, j, l


      do l = 1, lm
         sarr2d( l, 1 ) = sarr( l )
      end do

      call lt2_s2f( im, jmg, jm, 1, lm, pmn, &
           sarr2d, farrr3d, farri3d )

      do j = 1, jm
         do i = 1, im
            farrr( i, j ) = farrr3d( i, j, 1 )
            farri( i, j ) = farri3d( i, j, 1 )
         end do
      end do


    end subroutine lt2_s2f_2d

    !**************************************************************************

    subroutine lt2_g2f_2d( im, jm, ita, dta, garr, farrr, farri )

      use vtype_module
      use lt2_module, only : lt2_g2f

      implicit none

      integer(i4b), intent(in ) :: im, jm, ita( 5, 2 )
      real(dp)    , intent(in ) :: dta( im, 2 )
      real(dp)    , intent(in ) :: garr ( im, jm )
      real(dp)    , intent(out) :: farrr( im, jm ), farri( im, jm )


      !
      ! local variables
      !
      real(dp)     :: garr3d ( im, jm, 1 )
      real(dp)     :: farrr3d( im, jm, 1 ), farri3d( im, jm, 1 )
      integer(i4b) :: i, j


      do j = 1, jm
         do i = 1, im
            garr3d( i, j, 1 ) = garr( i, j )
         end do
      end do

      call lt2_g2f( im, jm, 1, ita, dta, garr3d, farrr3d, farri3d )

      do j = 1, jm
         do i = 1, im
            farrr( i, j ) = farrr3d( i, j, 1 )
            farri( i, j ) = farri3d( i, j, 1 )
         end do
      end do


    end subroutine lt2_g2f_2d

    !**************************************************************************
    ! subroutine 
    !**************************************************************************

    subroutine lt2_lap_s2s_2d( lm, deg, sarr )

      use vtype_module
      use lt2_module, only : lt2_lap_s2s

      implicit none

      integer(i4b), intent(in   ) :: lm
      integer(i4b), intent(in   ) :: deg( lm )
      real(dp)    , intent(inout) :: sarr( lm )

      !
      ! local variables
      !
      real(dp)     :: sarr2d( lm, 1 )
      integer(i4b) :: l


      do l = 1, lm
         sarr2d( l, 1 ) = sarr( l )
      end do

      call lt2_lap_s2s( 1, lm, deg, sarr2d )

      do l = 1, lm
         sarr( l ) = sarr2d( l, 1 )
      end do


    end subroutine lt2_lap_s2s_2d

    !**************************************************************************

    subroutine lt2_lamderiv_s2s_2d( lm, ord, sarr )

      use vtype_module
      use lt2_module  , only : lt2_lamderiv_s2s

      implicit none

      integer(i4b), intent(in   ) :: lm
      integer(i4b), intent(in   ) :: ord( lm )
      real(dp)    , intent(inout) :: sarr( lm )


      !
      ! local variables
      !
      real(dp)     :: sarr2d( lm, 1 )
      integer(i4b) :: l


      do l = 1, lm
         sarr2d( l, 1 ) = sarr( l )
      end do

      call lt2_lamderiv_s2s( 1, lm, ord, sarr2d )

      do l = 1, lm
         sarr( l ) = sarr2d( l, 1 )
      end do


    end subroutine lt2_lamderiv_s2s_2d

    !**************************************************************************

    subroutine lt2_cossqmuderiv_s2s_2d( lm, sarr )

      use vtype_module
      use lt2_module  , only : lt2_cossqmuderiv_s2s

      implicit none

      integer(i4b), intent(in   ) :: lm
      real(dp)    , intent(inout) :: sarr( lm )


      !
      ! local variables
      !
      real(dp)     :: sarr2d( lm, 1 )
      integer(i4b) :: l


      do l = 1, lm
         sarr2d( l, 1 ) = sarr( l )
      end do

      call lt2_cossqmuderiv_s2s( 1, lm, sarr2d )

      do l = 1, lm
         sarr( l ) = sarr2d( l, 1 )
      end do


    end subroutine lt2_cossqmuderiv_s2s_2d

    !**************************************************************************
    ! subroutine 
    !**************************************************************************

    subroutine lt2_derivop_f2s_2d( im, jmg, jm, lm, &
         coslatg, gwg, &
         farrrr, farrri, farrsr, farrsi, sarr )

      use vtype_module
      use lt2_module, only : lt2_derivop_f2s

      implicit none

      integer(i4b), intent(in ) :: im, jmg, jm, lm
      real(dp)    , intent(in ) :: coslatg( jmg ), gwg( jmg )
      real(dp)    , intent(in ) :: &
           farrrr( im, jm ), farrri( im, jm ), &
           farrsr( im, jm ), farrsi( im, jm )
      real(dp)    , intent(out) :: sarr( lm )



      !
      ! local variables
      !
      real(dp)     :: &
           farrrr3d( im, jm, 1 ), farrri3d( im, jm, 1 ), &
           farrsr3d( im, jm, 1 ), farrsi3d( im, jm, 1 )
      real(dp)     :: &
           sarr2d( lm, 1 )
      integer(i4b) :: i, j, l


      do j = 1, jm
         do i = 1, im
            farrrr3d( i, j, 1 ) = farrrr( i, j )
            farrri3d( i, j, 1 ) = farrri( i, j )
            farrsr3d( i, j, 1 ) = farrsr( i, j )
            farrsi3d( i, j, 1 ) = farrsi( i, j )
         end do
      end do

      call lt2_derivop_f2s( im, jmg, jm, 1, lm, &
           coslatg, gwg, &
           farrrr3d, farrri3d, farrsr3d, farrsi3d, sarr2d )

      do l = 1, lm
         sarr( l ) = sarr2d( l, 1 )
      end do


    end subroutine lt2_derivop_f2s_2d

    !**************************************************************************
    ! subroutine 
    !**************************************************************************

    subroutine lt2_truncate_2d( lm, ntrunc, sarr )

      use vtype_module
      use lt2_module, only : lt2_truncate

      implicit none

      integer(i4b), intent(in   ) :: lm
      integer(i4b), intent(in   ) :: ntrunc
      real(dp)    , intent(inout) :: sarr( lm )


      !
      ! local variables
      !
      real(dp)     :: sarr2d( lm, 1 )
      integer(i4b) :: l


      do l = 1, lm
         sarr2d( l, 1 ) = sarr( l )
      end do

      call lt2_truncate( 1, lm, ntrunc, sarr2d )

      do l = 1, lm
         sarr( l ) = sarr2d( l, 1 )
      end do


    end subroutine lt2_truncate_2d

    !**************************************************************************
