    subroutine mkculint( path, im, jm, lon, lat, midlon, midlat, culint )

      use vtype_module
      use const_module
      use ni3_module

      implicit none

      character(*), intent(in ) :: path
      integer(i4b), intent(in ) :: im, jm
      real(dp)    , intent(in ) :: lon( im ), lat( jm )
      real(dp)    , intent(in ) :: midlon( im+1 ) , midlat( jm+1 )
      real(dp)    , intent(out) :: culint( im, jm )


      !
      ! local variables
      !
      integer(i4b)              :: nx, ny
      real(dp)    , allocatable :: matlon( : ), matlat( : )
      real(dp)    , allocatable :: matlon_bnds( :, : ), matlat_bnds( :, : )
      integer(i4b), allocatable :: matculinti( :, : )
      real(dp)    , allocatable :: matculint ( :, : )
      real(dp)                  :: mindis
      character(extstr)         :: mode
      integer(i4b)              :: ncid
      integer(i4b)              :: i , j
      integer(i4b)              :: ii, jj

      real(dp)                  :: xy_Area( im, jm )
      real(dp)                  :: Area
      integer(i4b)              :: xy_DataNum( im, jm )


      mode = 'read'
      call ni3_open( path, mode, ncid )
      call ni3_inq_dimlen( ncid, 'lon', nx )
      call ni3_inq_dimlen( ncid, 'lat', ny )
      allocate( &
           matlon( nx ), matlat( ny ), &
           matlon_bnds( 2, nx ), matlat_bnds( 2, ny ), &
           matculinti( nx, ny ), &
           matculint ( nx, ny ) )
      call ni3_get_var( ncid, 'lon'     , matlon      )
      call ni3_get_var( ncid, 'lat'     , matlat      )
      call ni3_get_var( ncid, 'lon_bnds', matlon_bnds )
      call ni3_get_var( ncid, 'lat_bnds', matlat_bnds )
      call ni3_get_var( ncid, 'culint'  , matculinti  )
      call ni3_close( ncid )


      do j = 1, ny
         do i = 1, nx
            if( matculinti( i, j ) <= 0 ) then
              matculint( i, j ) = -1.0d100
            else if( matculinti( i, j ) == 1 ) then
              matculint( i, j ) = 0.0d0
            else if( matculinti( i, j ) == 2 ) then
              matculint( i, j ) = 0.2d0
            else if( matculinti( i, j ) == 3 ) then
              matculint( i, j ) = 0.5d0
            else if( matculinti( i, j ) == 4 ) then
              matculint( i, j ) = 0.75d0
            else if( matculinti( i, j ) == 5 ) then
              matculint( i, j ) = 1.0d0
            else
              write( 6, * ) 'Unexpected cultivation intensity: ', matculinti( i, j )
            end if
         end do
      end do


      if( ( im .ge. nx ) .or. ( jm .ge. ny ) ) then

         write( 6, * ) 'High resolution version'

         do j = 1, jm
            do i = 1, im

               call nearest( nx, ny, matlon, matlat, lat( j ), lon( i ), &
                    ii, jj, mindis )
               culint( i, j ) = matculint( ii, jj )
               culint( i, j ) = max( culint( i, j ), 0.0d0 )

            end do
         end do

      else

         write( 6, * ) 'Low resolution version'

         do j = 1, jm
           do i = 1, im
             culint    (i,j) = 0.0d0
             xy_Area   (i,j) = 0.0d0
             xy_DataNum(i,j) = 0
           end do
         end do

         do j = 1, jm
           do i = 1, im

             do jj = 1, ny
               do ii = 1, nx
                 if(  ( matlon( ii ) .ge. midlon( i   ) ) .and. &
                   &  ( matlon( ii ) .lt. midlon( i+1 ) ) .and. &
                   &  ( matlat( jj ) .ge. midlat( j   ) ) .and. &
                   &  ( matlat( jj ) .lt. midlat( j+1 ) ) ) then
                   if ( matculint(ii,jj) >= 0.0d0 ) then
                     Area = &
                       &   ( matlon_bnds(2,ii) - matlon_bnds(1,ii) ) * d2r &
                       &   * cos( matlat(jj) * d2r )                       &
                       &   * ( matlat_bnds(2,jj) - matlat_bnds(1,jj) ) * d2r
                     culint(i,j) = culint(i,j) + matculint(ii,jj) * Area
                     xy_Area(i,j) = xy_Area(i,j) + Area
                   end if
                   xy_DataNum(i,j) = xy_DataNum(i,j) + 1
                 end if
               end do
             end do
             if( xy_DataNum(i,j) == 0 ) then
               stop 'There is no grid in Matthews database in the model grid.'
             end if
             if( xy_Area(i,j) > 0.0d0 ) then
               culint(i,j) = culint(i,j) / xy_Area(i,j)
             else
               culint(i,j) = 0.0d0
             end if

           end do
         end do

      end if


      deallocate( matculinti )
      deallocate( matculint  )


    end subroutine mkculint
