    subroutine nearest( im, jm, lon, lat, objlat, objlon, &
         mini, minj, mindis )

      use vtype_module
      use const_module, only : d2r, pradi

      implicit none

      integer(i4b), intent(in ) :: im, jm
      real(dp)    , intent(in ) :: lon( im ), lat( jm )
      real(dp)    , intent(in ) :: objlat, objlon
      integer(i4b), intent(out) :: mini, minj
      real(dp)    , intent(out) :: mindis


      !
      ! local variables
      !
      real(dp)     :: sinlon( im ), coslon( im )
      real(dp)     :: sinlat( jm ), coslat( jm )
      real(dp)     :: cosdel, dist

      integer(i4b) :: i, j


      sinlon( : ) = sin( lon( : ) * d2r )
      coslon( : ) = cos( lon( : ) * d2r )
      sinlat( : ) = sin( lat( : ) * d2r )
      coslat( : ) = cos( lat( : ) * d2r )


      mindis = 1.0d10
      mini   = 0
      minj   = 0

      do j = 1, jm
         do i = 1, im
            cosdel &
                 = coslat( j ) * coslon( i ) &
                 * cos( objlat * d2r ) * cos( objlon * d2r ) &
                 + coslat( j ) * sinlon( i ) &
                 * cos( objlat * d2r ) * sin( objlon * d2r ) &
                 + sinlat( j ) * sin( objlat * d2r )
            dist = acos( cosdel ) * pradi * 1.0d-3
            if( mindis .gt. dist ) then
               mindis = dist
               mini   = i
               minj   = j
            end if
!            write( 6, '(2i,2e)' ) lon( i ), lat( j ), dist
         end do
!         write( 6, * )
      end do
!      write( 6, * ) 'mini, minj, mindis'
!      write( 6, * )  mini, minj, mindis


    end subroutine nearest
