
== 概要

DCPAM で用いる, 地球の気候値の海表面温度, 海氷面密度データを作成します. 


== 処理内容

* 海表面温度
  * 使用データ
    * AMIP 1987-2006 気候値
    * http://www.gfd-dennou.org/library/dcpam/related-data/Earth_Surface/data_from_pcmdi/sst_bc_clim.nc
  * 処理内容
    * ガウス格子内のデータを平均
    * 欠損値は, まず周囲のデータを使って埋めることと試み, それでも埋まらない
      場合には東西平均値を採用
* 海氷面密度
  * 使用データ
    * AMIP 1987-2006 気候値
    * http://www.gfd-dennou.org/library/dcpam/related-data/Earth_Surface/data_from_pcmdi/sic_bc_clim.nc
  * 処理内容
    * ガウス格子内のデータを平均
    * 欠損値は, まず周囲のデータを使って埋めることと試み, それでも埋まらない
      場合には東西平均値を採用


== 使用方法

* Makefile の編集
  * 下の変数を設定
    * FC : Fortran90 コンパイラ
    * FFLAGS : Fortran オプション
    * NCDIR : netcdf ライブラリのパス ($(NCDIR)/lib, $(NCDIR)/include を想定)
* 東西方向の格子点数 (解像度) の指定
  * main.f90 内の変数 im を編集
    * 打ち切り波数は (im-1)/3 となる
* 年平均データを生成するか季節変化するデータを生成するかの指定
  * main.f90 内の変数 flag_annual_mean を編集
    * flag_annual_mean = .true.  ! 年平均データの生成
    * flag_annual_mean = .false. ! 季節変化するデータの生成
* 生成するデータの変数の指定
  * main.f90 内の変数 id_variable を編集
    * id_variable = id_variable_sst ! 海表面温度データの生成
    * id_variable = id_variable_sic ! 海氷面密度データの生成
* 使用データファイルの指定
  * 海表面温度, 海氷面密度の元データファイルの指定
    * main.f90 内の変数 path_in を編集
  * 使用する DCPAM 用土地利用データファイルの指定
    * main.f90 内の変数 path_sfcindex を編集
* コンパイル
  * make
* 実行
  * 実行ファイルは a.out
  * 結果は out ディレクトリ内に生成
