    subroutine ave( &
      & nx, ny, x, y, z, &
      & im, jm, midlon, midlat, sfcindex, &
      & flag_fill, &
      & array &
      )

      use vtype_module

      implicit none

      integer(i4b), intent(in ) :: nx, ny
      real(dp)    , intent(in ) :: x( nx ), y( ny ), z( nx, ny )
      integer(i4b), intent(in ) :: im, jm
      real(dp)    , intent(in ) :: midlon( im+1 ), midlat( jm+1 )
      integer(i4b), intent(in ) :: sfcindex( im, jm )
      logical     , intent(in ) :: flag_fill
      real(dp)    , intent(out) :: array( im, jm )


      !
      ! local variables
      !
      integer(i4b)              :: num( im, jm )
      integer(i4b)              ::  i,  j
      integer(i4b)              :: ii, jj


      do j = 1, jm
         do i = 1, im
            num  ( i, j ) = 0
            array( i, j ) = 0.0d0
         end do
      end do


      do j = 1, ny
         do i = 1, nx

            if(  ( x( i ) .lt.   0.0d0 ) .or. &
                 ( x( i ) .gt. 360.0d0 ) .or. &
                 ( y( j ) .lt. -90.0d0 ) .or. &
                 ( y( j ) .gt.  90.0d0 ) ) then
               write( 6, * ) 'Longitude or latitude is out of range.'
               write( 6, * ) i, j, x( i ), y( j )
            end if


            if( x( i ) .ge. midlon( im+1 ) ) then
               ii = 1
            else
               find_ii: do ii = 1, im
                  if(  ( x( i ) .ge. midlon( ii   ) ) .and. &
                       ( x( i ) .lt. midlon( ii+1 ) ) ) exit
               end do find_ii
               if( ii .gt. im ) then
                  write( 6, * ) 'lon is unexpected value'
                  write( 6, * ) ii, im
                  write( 6, * ) i, x( i )
                  stop
               end if
            end if

            find_jj: do jj = 1, jm-1
               if(  ( y( j ) .ge. midlat( jj   ) ) .and. &
                    ( y( j ) .lt. midlat( jj+1 ) ) ) exit
            end do find_jj
            if(  ( y( j ) .ge. midlat( jm   ) ) .and. &
                 ( y( j ) .le. midlat( jm+1 ) ) ) then
               jj = jm
            end if

!            write( 6, * ) midlon( ii ), lon, midlon( ii+1 )
!            write( 6, * ) midlat( jj ), lat, midlat( jj+1 )


            if( z( i, j ) .ne. -1.0d0 ) then
               array( ii, jj ) = array( ii, jj ) + dble( z( i, j ) )
               num  ( ii, jj ) = num  ( ii, jj ) + 1
            end if


!            write( *, * ) lon, lat, itopo( i )

         end do

      end do


      do j = 1, jm
         do i = 1, im
!!$            if( num( i, j ) .eq. 0 ) then
!!$               write( 6, * ) 'Error: Number of data in bin is zero.'
!!$               write( 6, * ) i, j
!!$               stop
!!$            end if
            if( num( i, j ) .eq. 0 ) then
               array( i, j ) = -1.0d0
            else
               array( i, j ) = array( i, j ) / num( i, j )
            end if
         end do
      end do


      if( flag_fill ) then
        call fillgrid( &
          & im, jm, sfcindex, &
          & array &
          )
      end if


    end subroutine ave

    !************************************************************************************

    subroutine fillgrid( &
      & im, jm, sfcindex, &
      & array &
      )

      use vtype_module

      implicit none

      integer(i4b), intent(in   ) :: im, jm
      integer(i4b), intent(in   ) :: sfcindex( im, jm )
      real(dp)    , intent(inout) :: array( im, jm )


      !
      ! local variables
      !
      integer(i4b)              :: sstmask( im, jm )
      real(dp)                  :: zmsst( jm )
      integer(i4b)              :: zmnum( jm )
      integer(i4b)              :: weight
!!$      integer(i4b)              :: ip2, ip, in, in2, jp2, jp, jn, jn2
      integer(i4b)              :: jjmin, jjmax
      integer(i4b)              ::  i,  j
      integer(i4b)              :: ii, jj, iii


      do j = 1, jm
        zmsst( j ) = 0.0d0
        zmnum( j ) = 0
        do i = 1, im
          if( array( i, j ) .gt. 0.0d0 ) then
            zmsst( j ) = zmsst( j ) + array( i, j )
            zmnum( j ) = zmnum( j ) + 1
          end if
        end do
        if( zmnum( j ) .ne. 0 ) then
          zmsst( j ) = zmsst( j ) / zmnum( j )
        end if
      end do


!!$      do j = 1, jm
!!$         do i = 1, im
!!$            if( ( sfcindex( i, j ) .le. 0 ) .and. ( array( i, j ) .le. 0.0d0 ) ) then
!!$               write( 69, * ) i, j, sfcindex( i, j ), -1
!!$            else
!!$               write( 69, * ) i, j, sfcindex( i, j ),  1
!!$            end if
!!$         end do
!!$         write( 69, * )
!!$      end do


      do j = 1, jm
         do i = 1, im
            if( array( i, j ) .le. 0.0d0 ) then
               sstmask( i, j ) = 0
            else
               sstmask( i, j ) = 1
            end if
         end do
      end do

      do j = 1, jm
         do i = 1, im
            if( ( sfcindex( i, j ) .le. 0 ) .and. ( array( i, j ) .le. 0.0d0 ) ) then


!!$               ip2 = mod( ( i - 2 ) + im - 1, im ) + 1
!!$               ip  = mod( ( i - 1 ) + im - 1, im ) + 1
!!$               in  = mod( ( i + 1 )      - 1, im ) + 1
!!$               in2 = mod( ( i + 2 )      - 1, im ) + 1
!!$
!!$
!!$               jp2 = max( j - 2, 1  )
!!$               jp  = max( j - 1, 1  )
!!$               jn  = min( j + 1, jm )
!!$               jn2 = min( j + 2, jm )
!!$
!!$
!!$               if( j .eq. 1 ) then
!!$                  array( i, j ) &
!!$                       = 0.0d0 &
!!$                       + array( ip, j  ) * sstmask( ip, j  ) &
!!$                       + array( ip, jn ) * sstmask( ip, jn ) &
!!$                       + array( i , jn ) * sstmask( i , jn ) &
!!$                       + array( in, jn ) * sstmask( in, jn ) &
!!$                       + array( in, j  ) * sstmask( in, j  ) &
!!$                       + 0.0d0 &
!!$                       + 0.0d0
!!$                  weight &
!!$                       = 0 &
!!$                       + sstmask( ip, j  ) &
!!$                       + sstmask( ip, jn ) &
!!$                       + sstmask( i , jn ) &
!!$                       + sstmask( in, jn ) &
!!$                       + sstmask( in, j  ) &
!!$                       + 0 &
!!$                       + 0
!!$               else if( j .eq. jm ) then
!!$                  array( i, j ) &
!!$                       = array( ip, jp ) * sstmask( ip, jp ) &
!!$                       + array( ip, j  ) * sstmask( ip, j  ) &
!!$                       + 0.0d0 &
!!$                       + 0.0d0 &
!!$                       + 0.0d0 &
!!$                       + array( in, j  ) * sstmask( in, j  ) &
!!$                       + array( in, jp ) * sstmask( in, jp ) &
!!$                       + array( i , jp ) * sstmask( i , jp )
!!$                  weight &
!!$                       = sstmask( ip, jp ) &
!!$                       + sstmask( ip, j  ) &
!!$                       + 0 &
!!$                       + 0 &
!!$                       + 0 &
!!$                       + sstmask( in, j  ) &
!!$                       + sstmask( in, jp ) &
!!$                       + sstmask( i , jp )
!!$               else
!!$                  array( i, j ) &
!!$                       = array( ip, jp ) * sstmask( ip, jp ) &
!!$                       + array( ip, j  ) * sstmask( ip, j  ) &
!!$                       + array( ip, jn ) * sstmask( ip, jn ) &
!!$                       + array( i , jn ) * sstmask( i , jn ) &
!!$                       + array( in, jn ) * sstmask( in, jn ) &
!!$                       + array( in, j  ) * sstmask( in, j  ) &
!!$                       + array( in, jp ) * sstmask( in, jp ) &
!!$                       + array( i , jp ) * sstmask( i , jp )
!!$                  weight &
!!$                       = sstmask( ip, jp ) &
!!$                       + sstmask( ip, j  ) &
!!$                       + sstmask( ip, jn ) &
!!$                       + sstmask( i , jn ) &
!!$                       + sstmask( in, jn ) &
!!$                       + sstmask( in, j  ) &
!!$                       + sstmask( in, jp ) &
!!$                       + sstmask( i , jp )
!!$               end if
!!$
!!$               if( weight .ne. 0 ) then
!!$                  array( i, j ) = array( i, j ) / weight
!!$               else
!!$
!!$                  if( j .le. 1 ) then
!!$                     array( i, j ) &
!!$                          = 0.0d0 &
!!$                          + 0.0d0 &
!!$                          + array( ip2, j   ) * sstmask( ip2, j   ) &
!!$                          + array( ip2, jn  ) * sstmask( ip2, jn  ) &
!!$                          + array( ip2, jn2 ) * sstmask( ip2, jn2 ) &
!!$                          + array( ip , jn2 ) * sstmask( ip , jn2 ) &
!!$                          + array( i  , jn2 ) * sstmask( i  , jn2 ) &
!!$                          + array( in , jn2 ) * sstmask( in , jn2 ) &
!!$                          + array( in2, jn2 ) * sstmask( in2, jn2 ) &
!!$                          + array( in2, jn  ) * sstmask( in2, jn  ) &
!!$                          + array( in2, j   ) * sstmask( in2, j   ) &
!!$                          + 0.0d0 &
!!$                          + 0.0d0 &
!!$                          + 0.0d0 &
!!$                          + 0.0d0 &
!!$                          + 0.0d0
!!$                     weight &
!!$                          = 0 &
!!$                          + 0 &
!!$                          + sstmask( ip2, j   ) &
!!$                          + sstmask( ip2, jn  ) &
!!$                          + sstmask( ip2, jn2 ) &
!!$                          + sstmask( ip , jn2 ) &
!!$                          + sstmask( i  , jn2 ) &
!!$                          + sstmask( in , jn2 ) &
!!$                          + sstmask( in2, jn2 ) &
!!$                          + sstmask( in2, jn  ) &
!!$                          + sstmask( in2, j   ) &
!!$                          + 0 &
!!$                          + 0 &
!!$                          + 0 &
!!$                          + 0 &
!!$                          + 0
!!$                  else if( j .eq. 2 ) then
!!$                     array( i, j ) &
!!$                          = 0.0d0 &
!!$                          + array( ip2, jp  ) * sstmask( ip2, jp  ) &
!!$                          + array( ip2, j   ) * sstmask( ip2, j   ) &
!!$                          + array( ip2, jn  ) * sstmask( ip2, jn  ) &
!!$                          + array( ip2, jn2 ) * sstmask( ip2, jn2 ) &
!!$                          + array( ip , jn2 ) * sstmask( ip , jn2 ) &
!!$                          + array( i  , jn2 ) * sstmask( i  , jn2 ) &
!!$                          + array( in , jn2 ) * sstmask( in , jn2 ) &
!!$                          + array( in2, jn2 ) * sstmask( in2, jn2 ) &
!!$                          + array( in2, jn  ) * sstmask( in2, jn  ) &
!!$                          + array( in2, j   ) * sstmask( in2, j   ) &
!!$                          + array( in2, jp  ) * sstmask( in2, jp  ) &
!!$                          + 0.0d0 &
!!$                          + 0.0d0 &
!!$                          + 0.0d0 &
!!$                          + 0.0d0
!!$                     weight &
!!$                          = 0 &
!!$                          + sstmask( ip2, jp  ) &
!!$                          + sstmask( ip2, j   ) &
!!$                          + sstmask( ip2, jn  ) &
!!$                          + sstmask( ip2, jn2 ) &
!!$                          + sstmask( ip , jn2 ) &
!!$                          + sstmask( i  , jn2 ) &
!!$                          + sstmask( in , jn2 ) &
!!$                          + sstmask( in2, jn2 ) &
!!$                          + sstmask( in2, jn  ) &
!!$                          + sstmask( in2, j   ) &
!!$                          + sstmask( in2, jp  ) &
!!$                          + 0 &
!!$                          + 0 &
!!$                          + 0 &
!!$                          + 0
!!$                  else if( j .ge. jm-1 ) then
!!$                     array( i, j ) &
!!$                          = array( ip2, jp2 ) * sstmask( ip2, jp2 ) &
!!$                          + array( ip2, jp  ) * sstmask( ip2, jp  ) &
!!$                          + array( ip2, j   ) * sstmask( ip2, j   ) &
!!$                          + array( ip2, jn  ) * sstmask( ip2, jn  ) &
!!$                          + 0.0d0 &
!!$                          + 0.0d0 &
!!$                          + 0.0d0 &
!!$                          + 0.0d0 &
!!$                          + 0.0d0 &
!!$                          + array( in2, jn  ) * sstmask( in2, jn  ) &
!!$                          + array( in2, j   ) * sstmask( in2, j   ) &
!!$                          + array( in2, jp  ) * sstmask( in2, jp  ) &
!!$                          + array( in2, jp2 ) * sstmask( in2, jp2 ) &
!!$                          + array( in , jp2 ) * sstmask( in , jp2 ) &
!!$                          + array( i  , jp2 ) * sstmask( i  , jp2 ) &
!!$                          + array( ip , jp2 ) * sstmask( ip , jp2 )
!!$                     weight &
!!$                          = sstmask( ip2, jp2 ) &
!!$                          + sstmask( ip2, jp  ) &
!!$                          + sstmask( ip2, j   ) &
!!$                          + sstmask( ip2, jn  ) &
!!$                          + 0 &
!!$                          + 0 &
!!$                          + 0 &
!!$                          + 0 &
!!$                          + 0 &
!!$                          + sstmask( in2, jn  ) &
!!$                          + sstmask( in2, j   ) &
!!$                          + sstmask( in2, jp  ) &
!!$                          + sstmask( in2, jp2 ) &
!!$                          + sstmask( in , jp2 ) &
!!$                          + sstmask( i  , jp2 ) &
!!$                          + sstmask( ip , jp2 )
!!$                  else if( j .ge. jm ) then
!!$                     array( i, j ) &
!!$                          = array( ip2, jp2 ) * sstmask( ip2, jp2 ) &
!!$                          + array( ip2, jp  ) * sstmask( ip2, jp  ) &
!!$                          + array( ip2, j   ) * sstmask( ip2, j   ) &
!!$                          + 0.0d0 &
!!$                          + 0.0d0 &
!!$                          + 0.0d0 &
!!$                          + 0.0d0 &
!!$                          + 0.0d0 &
!!$                          + 0.0d0 &
!!$                          + 0.0d0 &
!!$                          + array( in2, j   ) * sstmask( in2, j   ) &
!!$                          + array( in2, jp  ) * sstmask( in2, jp  ) &
!!$                          + array( in2, jp2 ) * sstmask( in2, jp2 ) &
!!$                          + array( in , jp2 ) * sstmask( in , jp2 ) &
!!$                          + array( i  , jp2 ) * sstmask( i  , jp2 ) &
!!$                          + array( ip , jp2 ) * sstmask( ip , jp2 )
!!$                     weight &
!!$                          = sstmask( ip2, jp2 ) &
!!$                          + sstmask( ip2, jp  ) &
!!$                          + sstmask( ip2, j   ) &
!!$                          + 0 &
!!$                          + 0 &
!!$                          + 0 &
!!$                          + 0 &
!!$                          + 0 &
!!$                          + 0 &
!!$                          + 0 &
!!$                          + sstmask( in2, j   ) &
!!$                          + sstmask( in2, jp  ) &
!!$                          + sstmask( in2, jp2 ) &
!!$                          + sstmask( in , jp2 ) &
!!$                          + sstmask( i  , jp2 ) &
!!$                          + sstmask( ip , jp2 )
!!$                  else
!!$                     array( i, j ) &
!!$                          = array( ip2, jp2 ) * sstmask( ip2, jp2 ) &
!!$                          + array( ip2, jp  ) * sstmask( ip2, jp  ) &
!!$                          + array( ip2, j   ) * sstmask( ip2, j   ) &
!!$                          + array( ip2, jn  ) * sstmask( ip2, jn  ) &
!!$                          + array( ip2, jn2 ) * sstmask( ip2, jn2 ) &
!!$                          + array( ip , jn2 ) * sstmask( ip , jn2 ) &
!!$                          + array( i  , jn2 ) * sstmask( i  , jn2 ) &
!!$                          + array( in , jn2 ) * sstmask( in , jn2 ) &
!!$                          + array( in2, jn2 ) * sstmask( in2, jn2 ) &
!!$                          + array( in2, jn  ) * sstmask( in2, jn  ) &
!!$                          + array( in2, j   ) * sstmask( in2, j   ) &
!!$                          + array( in2, jp  ) * sstmask( in2, jp  ) &
!!$                          + array( in2, jp2 ) * sstmask( in2, jp2 ) &
!!$                          + array( in , jp2 ) * sstmask( in , jp2 ) &
!!$                          + array( i  , jp2 ) * sstmask( i  , jp2 ) &
!!$                          + array( ip , jp2 ) * sstmask( ip , jp2 )
!!$                     weight &
!!$                          = sstmask( ip2, jp2 ) &
!!$                          + sstmask( ip2, jp  ) &
!!$                          + sstmask( ip2, j   ) &
!!$                          + sstmask( ip2, jn  ) &
!!$                          + sstmask( ip2, jn2 ) &
!!$                          + sstmask( ip , jn2 ) &
!!$                          + sstmask( i  , jn2 ) &
!!$                          + sstmask( in , jn2 ) &
!!$                          + sstmask( in2, jn2 ) &
!!$                          + sstmask( in2, jn  ) &
!!$                          + sstmask( in2, j   ) &
!!$                          + sstmask( in2, jp  ) &
!!$                          + sstmask( in2, jp2 ) &
!!$                          + sstmask( in , jp2 ) &
!!$                          + sstmask( i  , jp2 ) &
!!$                          + sstmask( ip , jp2 )
!!$                  end if
!!$
!!$                  if( weight .ne. 0 ) then
!!$                     array( i, j ) = array( i, j ) / weight
!!$                  end if
!!$               end if


               array( i, j ) = 0.0d0
               weight        = 0


               !
               ! first trial to fill data
               !
               write( 6, * ) 'First trial to fill data at', i, j
               if( j .eq. 1 ) then
                  jjmin = 1
                  jjmax = j+1
               else if( j .eq. jm ) then
                  jjmin = j-1
                  jjmax = jm
               else
                  jjmin = j-1
                  jjmax = j+1
               end if
               do jj = jjmin, jjmax
                  do ii = -1, 1
                     iii = mod( ( i+ii ) + im - 1, im ) + 1
                     array( i, j ) = array( i, j ) &
                          + sstmask( iii, jj ) * array( iii, jj )
                     weight        = weight        &
                          + sstmask( iii, jj )
                  end do
               end do

               if( weight .ne. 0 ) then
                  array( i, j ) = array( i, j ) / weight
               else

                  !
                  ! second trial to fill data
                  !
                  write( 6, * ) '  Second trial to fill data at', i, j
                  if( j .le. 2 ) then
                     jjmin = 1
                     jjmax = j+2
                  else if( j .ge. jm-1 ) then
                     jjmin = j-2
                     jjmax = jm
                  else
                     jjmin = j-2
                     jjmax = j+2
                  end if
                  do jj = jjmin, jjmax
                     do ii = -2, 2
                        iii = mod( ( i+ii ) + im - 1, im ) + 1
                        array( i, j ) = array( i, j ) &
                             + sstmask( iii, jj ) * array( iii, jj )
                        weight        = weight        &
                             + sstmask( iii, jj )
                     end do
                  end do

                  if( weight .ne. 0 ) then
                     array( i, j ) = array( i, j ) / weight
                  else

                     !
                     ! third trial to fill data
                     !
                     write( 6, * ) '    Third trial to fill data at', i, j
                     if( j .le. 3 ) then
                        jjmin = 1
                        jjmax = j+3
                     else if( j .ge. jm-1 ) then
                        jjmin = j-3
                        jjmax = jm
                     else
                        jjmin = j-3
                        jjmax = j+3
                     end if
                     do jj = jjmin, jjmax
                        do ii = -3, 3
                           iii = mod( ( i+ii ) + im - 1, im ) + 1
                           array( i, j ) = array( i, j ) &
                                + sstmask( iii, jj ) * array( iii, jj )
                           weight        = weight        &
                                + sstmask( iii, jj )
                        end do
                     end do

                     if( weight .ne. 0 ) then
                        array( i, j ) = array( i, j ) / weight
                     else
                        array( i, j ) = 0.0d0

                        write( 6, * ) 'Warning : Unfilled SST data at', i, j

                        !
                        ! last trial to fill data
                        !
                        array( i, j ) = zmsst( j )
                        if( zmnum( j ) .eq. 0 ) then
                           write( 6, * ) '*** WARNING : zonal mean SST is not filled'
                        else
                           write( 6, * ) 'INFO    : SST is filled by zonal mean value'
                        end if
                     end if
                  end if

               end if


!!$               if(  ( array( i-1, j ) .gt. 0.0d0 ) .and. &
!!$                    ( array( i+1, j ) .gt. 0.0d0 ) ) then
!!$                  array( i, j ) = ( array( i-1, j ) + array( i+1, j ) ) * 0.5d0
!!$               else if( ( array( i-1, j ) .gt. 0.0d0 ) .and. &
!!$                        ( array( i+1, j ) .le. 0.0d0 ) ) then
!!$                  array( i, j ) = array( i-1, j )
!!$               else if( ( array( i-1, j ) .le. 0.0d0 ) .and. &
!!$                        ( array( i+1, j ) .gt. 0.0d0 ) ) then
!!$                  array( i, j ) = array( i+1, j )
!!$               else if( ( array( i, j-1 ) .gt. 0.0d0 ) .and. &
!!$                        ( array( i, j+1 ) .gt. 0.0d0 ) ) then
!!$                  array( i, j ) &
!!$                       = ( array( i, j+1 ) - array( i, j-1 ) ) &
!!$                       / ( lat  ( j+1 )    - lat  ( j-1 )    ) &
!!$                       * ( lat  ( j   )    - lat  ( j-1 )    ) &
!!$                       + array( i, j-1 )
!!$               else if( ( array( i, j-1 ) .gt. 0.0d0 ) .and. &
!!$                        ( array( i, j+1 ) .le. 0.0d0 ) ) then
!!$                  array( i, j ) = array( i, j-1 )
!!$               else if( ( array( i, j-1 ) .le. 0.0d0 ) .and. &
!!$                        ( array( i, j+1 ) .gt. 0.0d0 ) ) then
!!$                  array( i, j ) = array( i, j+1 )
!!$               end if

            end if

         end do
      end do

!!$      do j = 1, jm
!!$         do i = 1, im
!!$            if( ( sfcindex( i, j ) .le. 0 ) .and. ( array( i, j ) .le. 0.0d0 ) ) then
!!$               write( 68, * ) i, j, sfcindex( i, j ), -1
!!$            else
!!$               write( 68, * ) i, j, sfcindex( i, j ),  1
!!$            end if
!!$         end do
!!$         write( 68, * )
!!$      end do


    end subroutine fillgrid
