
    subroutine interpolate( &
      & nx, ny, x, y, xyz_o3_in, fillvalue, &
      & im, jm, x_lon, y_lat, &
      & xyz_o3_out &
      & )

      use vtype_module

      implicit none


      integer(i4b), intent(in ) :: nx
      integer(i4b), intent(in ) :: ny
      real(dp)    , intent(in ) :: x(nx)
      real(dp)    , intent(in ) :: y(ny)
      real(dp)    , intent(in ) :: xyz_o3_in( nx, ny )
      real(dp)    , intent(in ) :: fillvalue
      integer(i4b), intent(in ) :: im
      integer(i4b), intent(in ) :: jm
      real(dp)    , intent(in ) :: x_lon(im)
      real(dp)    , intent(in ) :: y_lat(jm)
      real(dp)    , intent(out) :: xyz_o3_out(im,jm)

      real(dp)                  :: tmp11, tmp12, tmp21, tmp22
      real(dp)                  :: tmp1, tmp2
      real(dp)                  :: x_ex(nx+1)
      real(dp)                  :: xyz_o3_in_ex(nx+1,ny)

      integer(i4b) :: x_i(im)
      integer(i4b) :: y_j(jm)

      integer(i4b)              ::  i,  j
      integer(i4b)              :: ii, jj


      do i = 1, nx
        x_ex(i) = x(i)
      end do
      x_ex(nx+1) = 360.0d0


      do j = 1, ny
        do i = 1, nx
!!$          if( xyz_o3_in(i,j) == fillvalue ) xyz_o3_in(i,j) = 0.0d0
          if( xyz_o3_in(i,j) == fillvalue ) then
            write( 6, * ) 'Negative at ', i, j
            stop
          end if
        end do
      end do

      do j = 1, ny
        do i = 1, nx
          xyz_o3_in_ex(i,j) = xyz_o3_in(i,j)
        end do
      end do
      do j = 1, ny
        xyz_o3_in_ex(nx+1,j) = xyz_o3_in(1,j)
      end do

      do i = 1, im
        x_i(i) = -1
        search_i : do ii = 2, nx+1
          if ( x_ex(ii) >= x_lon( i ) ) then
            x_i(i) = ii
            exit search_i
          end if
        end do search_i
        if ( x_i(i) < 0 ) then
          x_i(i) = nx+1
        end if
      end do
      do j = 1, jm
        y_j(j) = -1
        search_j : do jj = 2, ny
          if ( y(jj) >= y_lat( j ) ) then
            y_j(j) = jj
            exit search_j
          end if
        end do search_j
        if ( y_j(j) < 0 ) then
          y_j(j) = ny
        end if
      end do


      do j = 1, jm
        do i = 1, im

          ii = x_i(i)
          jj = y_j(j)

          tmp11 = xyz_o3_in_ex(ii-1,jj-1)
          tmp21 = xyz_o3_in_ex(ii  ,jj-1)
          tmp12 = xyz_o3_in_ex(ii-1,jj  )
          tmp22 = xyz_o3_in_ex(ii  ,jj  )

          tmp1 = &
            &   ( tmp12 - tmp11 ) &
            & / ( y(jj) - y(jj-1) ) * ( y_lat(j) - y(jj-1) ) &
            & + tmp11
          tmp2 = &
            &   ( tmp22 - tmp21 ) &
            & / ( y(jj) - y(jj-1) ) * ( y_lat(j) - y(jj-1) ) &
            & + tmp21

          xyz_o3_out(i,j) = &
            &   ( tmp2 - tmp1 ) &
            & / ( x_ex(ii) - x_ex(ii-1) ) * ( x_lon(i) - x_ex(ii-1) ) &
            & + tmp1

        end do
      end do

!!$      xyz_o3_out = max( xyz_o3_out, 0.0d0 )

    end subroutine interpolate
