
    program main

      use vtype_module
      use const_module, only : const_set, r2d
      use lt2_module
      use ni3_module
      use netcdf


      implicit none


      integer(i4b)              :: im, jmg, jm, lm, ntrunc

      integer(i4b)              :: ita( 5, 2 )
      real(dp)    , allocatable :: dta( :, : )
      real(dp)    , allocatable :: sinlatg( : ), coslatg( : ), gwg( : )
      integer(i4b), allocatable :: ord( : ), deg( : )
      real(dp)    , allocatable :: pmn( :, : ), eps( : )

      real(dp)    , allocatable :: lon( : ), latg( : )

      real(dp)    , allocatable :: midlon( : )
      real(dp)    , allocatable :: midlat( : )
      real(dp)    , allocatable :: bcarray( :, : )
      integer(i4b), allocatable :: sfcindex( :, : )

      real(dp)    , allocatable :: farrr( :, : ), farri( :, : )
      real(dp)    , allocatable :: sarr( : )

      integer(i4b)              :: ipow
      real(dp)                  :: factor

      character(extstr)         :: mode
      character(extstr)         :: path_out
      integer(i4b)              :: ncid_out
      character(extstr)         :: name, stdname, longname, units
      integer(i4b)              :: ndims
      character(extstr)         :: dimname( 3 )
      character(extstr)         :: varname_out
      character(extstr)         :: unit_out


      character(extstr)         :: path_in
      integer(i4b)              :: ncid_in
      integer(i4b)              :: varid, status, st( 2 ), co( 2 )

      character(extstr)         :: name_xaxis, name_yaxis, name_mv, name_bc

      real(dp)                  :: fv

      character(extstr)         :: path_sfcindex
      integer(i4b)              :: ncid_sfcindex

      character(10*extstr)      :: title, inst, src, com
      logical                   :: flag_fill


      integer(i4b)              :: nx, ny, nt
      integer(i4b), allocatable :: nz( :, : )
      real(dp)    , allocatable :: data_tmp( :, : )
      real(dp)    , allocatable :: x( : ), y( : ), z( :, : )
      real(dp)    , allocatable :: z1d( : )

      real(dp)                  :: time

      integer(i4b)              :: i, j, l, t

      logical                   :: flag_annual_mean
      integer(i4b)              :: id_variable
      integer(i4b), parameter   :: id_variable_sst = 1
      integer(i4b), parameter   :: id_variable_sic = 2



      ! T10
      im  = 32
      ! T21
      im  = 64
      ! T31
      im  = 32 * 3
      ! T42
      im  = 64 * 2
!!$      ! T63
!!$      im  = 64 * 3
!!$      ! T85
!!$      im  = 64 * 2 * 2
!!$      ! T106
!!$      im  = 64 * 5
!!$      ! T170
!!$      im  = 64 * 2 * 2 * 2
!!$      ! T255
!!$      im  = 64 * 2 * 2 * 3
!!$      ! T341
!!$      im  = 64 * 2 * 2 * 2 * 2


      ! flag for annual mean
      flag_annual_mean = .false.

      ! select variable
!!$      id_variable = id_variable_sst
      id_variable = id_variable_sic

      ! path for original data file
!!$!      path_in     = '../amip2/data/sst_bc_clim.nc'
!!$      path_in     = '../sst_sic/data/sst_bc_clim.nc'
!!$!      path_in     = '../amip2/data/sic_bc_clim.nc'
      path_in     = '../sst_sic/data/sic_bc_clim.nc'

      ! path for DCPAM surface index data file
      path_sfcindex = './sp_for_Earth_T042.nc'
!!$      write( path_sfcindex, '( a, i3.3, a )' ) &
!!$!           '../prog-20110225/out/sp_for_Earth_T', ( im-1 ) / 3, '.nc'
!!$!           '../prog-20130124/out/sp_for_Earth_T', ( im-1 ) / 3, '.nc'
!!$           './sp_for_Earth_T', ( im-1 ) / 3, '.nc'


      !========================================
      ! Set planetary parameters
      !
      !----------------------------------------
      ! Parameters for the Earth
      !
      call const_set( 0 )
      !
      !----------------------------------------
      ! Parameters for Mars
      !
!      call const_set( 1 )
      !
      !========================================


      jmg    = im / 2
      ntrunc = ( im - 1 ) / 3


      call lt2_inq_arraysize( jmg, ntrunc, jm, lm )


      allocate( dta( im, 2 ) )
      allocate( sinlatg( jmg ), coslatg( jmg ), gwg( jmg ) )
      allocate( ord( lm ), deg( lm ) )
      allocate( pmn( lm, jmg ), eps( lm ) )


      call lt2_init( im, jmg, lm, ntrunc, &
           ita, dta, sinlatg, coslatg, gwg, ord, deg, pmn, eps )


      allocate( lon( im ), latg( jmg ) )
      do i = 1, im
         lon( i ) = 360.0d0 / im * dble( i - 1 )
      end do
      do j = 1, jmg
         latg( j ) = asin( sinlatg( j ) ) * r2d
      end do


      allocate( midlon( im+1 ) , midlat( jmg+1 ) )
      allocate( bcarray( im, jm ) )
      allocate( sfcindex( im, jm ) )

      allocate( farrr( im, jm ), farri( im, jm ) )
      allocate( sarr( lm ) )


      do i = 1, im+1-1
         midlon( i ) = 360.0d0 / dble( im ) * dble( i-1 ) &
              - 360.0d0 / dble( im ) / 2.0d0
      end do
      i = im+1
      midlon( i ) = 360.0d0


      j = 1
      midlat( j ) = -90.0d0
      do j = 2, jm
         midlat( j ) = ( latg( j-1 ) + latg( j ) ) / 2.0d0
      end do
      j = jm + 1
      midlat( j ) =  90.0d0


!      do i = 1, im
!         write( 6, * ) i, lon( i )
!      end do
!      do j = 1, jm
!         write( 6, * ) j, lat( j )
!      end do



      !
      ! for OISST
      !
!!$      path       = '../oisst/sst_month_clim.nc'
!!$      name_xaxis = 'lon'
!!$      name_yaxis = 'lat'
!!$      name_mv    = '_FillValue'
!!$      name_bc    = 'sst'


      ! select variable
      select case ( id_variable )
      case ( id_variable_sst )

        !
        ! for AMIP2 SST climatology
        !
!!$        path_in     = '../amip2/data/sst_bc_clim.nc'
!!$        path_in     = '../sst_sic/data/sst_bc_clim.nc'
        name_xaxis  = 'longitude'
        name_yaxis  = 'latitude'
        name_mv     = 'missing_value'
        name_bc     = 'tosbcs'
        varname_out = 'sst'
        unit_out    = 'K'

        title = "Sea Surface Temperature (SST) data"
        inst  = "dcpam/dcmodel project, GFD Dennou Club"
        src   = "AMIP2 SST climatology 1987-2006 from http://www-pcmdi.llnl.gov/projects/amip/AMIP2EXPDSN/BCS/amipbc_dwnld.php"
        com = "SST distribution are constructed by areal averaging original data."

        flag_fill   = .true.
        if ( flag_annual_mean ) then
          write( path_out, '( a, i3.3, a )' ) 'out/sst_amipII_bc_clim_am_T', ( im-1 ) / 3, '.nc'
        else
          write( path_out, '( a, i3.3, a )' ) 'out/sst_amipII_bc_clim_T', ( im-1 ) / 3, '.nc'
        end if
        factor      = 1.0d0

      case ( id_variable_sic )

        !
        ! for AMIP2 sea ice climatology
        !
!!$        path_in     = '../amip2/data/sic_bc_clim.nc'
!!$        path_in     = '../sst_sic/data/sic_bc_clim.nc'
        name_xaxis  = 'longitude'
        name_yaxis  = 'latitude'
        name_mv     = 'missing_value'
        name_bc     = 'sicbcs'
        varname_out = 'sic'
        unit_out    = '1'

        title = "Sea Ice Concentration data"
        inst  = "dcpam/dcmodel project, GFD Dennou Club"
        src   = "AMIP2 SEA ICE climatology 1987-2006 from http://www-pcmdi.llnl.gov/projects/amip/AMIP2EXPDSN/BCS/amipbc_dwnld.php"
        com = "Sea Ice Concentration distribution are constructed by areal averaging original data."

        flag_fill   = .false.
        if ( flag_annual_mean ) then
          write( path_out, '( a, i3.3, a )' ) 'out/sic_amipII_bc_clim_am_T', ( im-1 ) / 3, '.nc'
        else
          write( path_out, '( a, i3.3, a )' ) 'out/sic_amipII_bc_clim_T', ( im-1 ) / 3, '.nc'
        end if
        factor      = 1.0d-2

      case default
        stop 'Unexpected value of id_variable'
      end select


      mode = 'read'
      call ni3_open( path_sfcindex, mode, ncid_sfcindex )
      call ni3_get_var( ncid_sfcindex, 'sfcindex', sfcindex )
      call ni3_close( ncid_sfcindex )



      !
      ! preparation for input
      !
      mode = 'read'
      call ni3_open( path_in, mode, ncid_in )

      call ni3_inq_dimlen( ncid_in, name_xaxis, nx )
      call ni3_inq_dimlen( ncid_in, name_yaxis, ny )
      call ni3_inq_dimlen( ncid_in, 'time', nt )

      allocate( x( nx ), y( ny ) )

      call ni3_get_var( ncid_in, name_xaxis, x )
      call ni3_get_var( ncid_in, name_yaxis, y )

      call ni3_get_att( ncid_in, name_bc, name_mv, fv )

      allocate( z( nx, ny ) )


      !
      ! preparation for output
      !
      mode = 'new'
      call ni3_open( path_out, mode, ncid_out )

!!$      call ni3_set_ga( ncid_out, com = com_out )
      call ni3_set_ga( ncid_out, title = title, inst = inst, src = src, com = com )


      name     = 'lon'
      stdname  = name
      longname = name
      units    = 'degrees_east'
      call ni3_set_dim( ncid_out, name, NF90_DOUBLE, lon, &
           stdname, longname, units )

      name     = 'lat'
      stdname  = name
      longname = name
      units    = 'degrees_north'
      call ni3_set_dim( ncid_out, name, NF90_DOUBLE, latg, &
           stdname, longname, units )

      name     = 'time'
      stdname  = name
      longname = name
      units    = 'days since 2-1-1 0'
      call ni3_def_dim( ncid_out, name, NF90_DOUBLE, NF90_UNLIMITED, &
           stdname, longname, units )

      name         = varname_out
      stdname      = name
      longname     = name
      ndims        = 3
      dimname( 1 ) = 'lon'
      dimname( 2 ) = 'lat'
      dimname( 3 ) = 'time'
      units        = unit_out
      call ni3_def_var( ncid_out, name, NF90_DOUBLE, ndims, dimname, &
           stdname, longname, units )
      call ni3_put_att( ncid_out, name, 'missing_value', -1.0d0 )



      if ( flag_annual_mean ) then
        !
        ! annual mean
        !
        allocate( data_tmp( nx, ny ), nz( nx, ny ) )
        do j = 1, ny
          do i = 1, nx
            z ( i, j ) = 0.0d0
            nz( i, j ) = 0
          end do
        end do
        do t = 1, nt
          call ni3_get_varss( ncid_in, name_bc, t, data_tmp )
          do j = 1, ny
            do i = 1, nx
              if( data_tmp( i, j ) .ne. fv ) then
                z ( i, j ) = z ( i, j ) + data_tmp( i, j )
                nz( i, j ) = nz( i, j ) + 1
              end if
            end do
          end do
        end do
        do j = 1, ny
          do i = 1, nx
            if( nz( i, j ) .eq. 0 ) then
              z( i, j ) = -1.0d0
            else
              z( i, j ) = z( i, j ) / nz( i, j )
            end if
          end do
        end do

!!$        call ave( &
!!$          & nx, ny, x, y, z, &
!!$          & im, jm, midlon, midlat, sfcindex, &
!!$          & flag_fill, &
!!$          & bcarray &
!!$          )
        if ( ntrunc <= 106 ) then
          write( 6, * ) 'Lower resolution version, truncation at ', ntrunc
          call ave( &
            & nx, ny, x, y, z, &
            & im, jm, midlon, midlat, sfcindex, &
            & flag_fill, &
            & bcarray &
            & )
        else
          write( 6, * ) 'High resolution version, truncation at ', ntrunc
          write( 6, * ) 'Notice that land-sea contrast is not considered.'
          call interpolate( &
            & nx, ny, x, y, z, fv, &
            & im, jm, lon, latg, &
            & bcarray &
            & )
        end if

        bcarray = bcarray * factor

        t    = 1
        time = 0.0d0

        name = varname_out
        call ni3_put_varss( ncid_out, name, t, bcarray )
        name = 'time'
        call ni3_put_varss( ncid_out, name, t, time )

      else
        !
        ! seasonal variation
        !
        do t = 1, nt
          call ni3_get_varss( ncid_in, 'time' , t, time )
          call ni3_get_varss( ncid_in, name_bc, t, z    )

          if ( ntrunc <= 106 ) then
            write( 6, * ) 'Lower resolution version, truncation at ', ntrunc
            call ave( &
              & nx, ny, x, y, z, &
              & im, jm, midlon, midlat, sfcindex, &
              & flag_fill, &
              & bcarray &
              & )
          else
            write( 6, * ) 'High resolution version, truncation at ', ntrunc
            write( 6, * ) 'Notice that land-sea contrast is not considered.'
            call interpolate( &
              & nx, ny, x, y, z, fv, &
              & im, jm, lon, latg, &
              & bcarray &
              & )
          end if

          bcarray = bcarray * factor

          name = varname_out
          call ni3_put_varss( ncid_out, name, t, bcarray )
          name = 'time'
          call ni3_put_varss( ncid_out, name, t, time )
        end do

      end if



      call ni3_close( ncid_out )

      call ni3_close( ncid_in )






    end program main
