
== 概要

DCPAM の火星計算で用いる地形, アルベド, 熱慣性のデータを, 下の「処理内容」に
説明する方法で作成します. 

なお, out-sample ディレクトリ内には, これまでに作成されたいくつかの解像度の
データを置いています.


== 処理内容

* 地形(標高)
  * 使用データ
    * Mars Global Surveyor Mars Orbiter Laser Altimeter data
    * http://www.gfd-dennou.org/library/dcpam/related-program/data_input_Mars/orog/data/topog_MGS_MOLA_0.03125x0.03125.nc
  * 処理内容
    * ガウス格子内のデータを平均
      * データ数が少ない場合には補間
    * ルジャンドル変換
    * F(n) = 1 - (n/N)**4 のファクタをかける
    * 非常に強いフィルタです.
    * ルジャンドル逆変換
* アルベド
  * 使用データ
    * http://www.gfd-dennou.org/library/dcpam/related-program/data_input_Mars/orog/data/albedo_MGS_TES.nc
    * 元データ
      * http://geo.pds.nasa.gov/missions/mgs/tesspecial.html
      * Matthews (1983)
      * 「使用データ」は, この元データを netcdf に変換したもの
  * 処理内容
    * ガウス格子内のデータを平均
      * データ数が少ない場合には補間
    * ルジャンドル変換
    * F(n) = 1 - (n/N)**4 のファクタをかける
    * 非常に強いフィルタです.
    * ルジャンドル逆変換
* 熱慣性
  * 使用データ
    * http://www.gfd-dennou.org/library/dcpam/related-program/data_input_Mars/orog/data/ti_MGS_TES_night.nc
    * 元データ
      * http://pds-geosciences.wustl.edu/missions/mgs/tes-timap.html
      * 「使用データ」は, この元データを netcdf に変換したもの
  * 処理内容
    * ガウス格子内のデータを平均
      * データ数が少ない場合には補間
    * ルジャンドル変換
    * F(n) = 1 - (n/N)**4 のファクタをかける
    * 非常に強いフィルタです.
    * ルジャンドル逆変換


== 使用方法

* Makefile の編集
  * 下の変数を設定
    * FC : Fortran90 コンパイラ
    * FFLAGS : Fortran オプション
    * NCDIR : netcdf ライブラリのパス ($(NCDIR)/lib, $(NCDIR)/include を想定)
* 東西方向の格子点数 (解像度) の指定
  * main.f90 内の変数 im を編集
    * 打ち切り波数は (im-1)/3 となる
* 使用データファイルの指定
  * main.f90 内の下の変数を編集
  * path_topog  : A path of topography NetCDF file (topog_MGS_MOLA_0.03125x0.03125.nc)
  * path_albedo : A path of albedo NetCDF file (albedo_MGS_TES.nc)
  * path_ti     : A path of thermal inertia NetCDF file (ti_MGS_TES_night.nc)
* コンパイル
  * make
* 実行
  * 実行ファイルは a.out
  * 結果は out ディレクトリ内に生成
