
    program main

      use vtype_module
      use const_module   , only : const_set, r2d
      use lt2_module
      use ni3_module
      use netcdf


      implicit none


      integer(i4b)              :: im, jmg, jm, lm, ntrunc

      integer(i4b)              :: ita( 5, 2 )
      real(dp)    , allocatable :: dta( :, : )
      real(dp)    , allocatable :: sinlatg( : ), coslatg( : ), gwg( : )
      integer(i4b), allocatable :: ord( : ), deg( : )
      real(dp)    , allocatable :: pmn( :, : ), eps( : )

      real(dp)    , allocatable :: lon( : ), latg( : )

      real(dp)    , allocatable :: midlon( : )
      real(dp)    , allocatable :: midlat( : )
      real(dp)    , allocatable :: topog( :, : )
      real(dp)    , allocatable :: albed( :, : )
      real(dp)    , allocatable :: ti( :, : )
      real(dp)    , allocatable :: topogstd( :, : )
      real(dp)    , allocatable :: tmpstd( :, : )
      real(dp)    , allocatable :: zmtopog( : )
      real(dp)    , allocatable :: zmalbed( : )
      real(dp)    , allocatable :: zmti( : )
      real(dp)    , allocatable :: zmtopogstd( : )
      real(dp)                  :: gmtopog
      real(dp)                  :: gmalbed
      real(dp)                  :: gmti
      real(dp)                  :: gmtopogstd

      real(dp)    , allocatable :: farrr( :, : ), farri( :, : )
      real(dp)    , allocatable :: sarr( : )

      integer(i4b)              :: ipow
      real(dp)                  :: factor

      character(extstr)         :: path_topog, path_albedo, path_ti
      character(extstr)         :: path, mode
      integer(i4b)              :: ncid
      character(extstr)         :: name, stdname, longname, units
      integer(i4b)              :: ndims
      character(extstr)         :: dimname( 2 )

      character(extstr)         :: pathtail

      character(extstr*10)      :: title, inst, src, com

      logical                   :: FlagSPTIMod
      real(dp)                  :: LatSPModEdge = -85.0d0
      integer(i4b)              :: js
      integer(i4b)              :: je

      integer(i4b)              :: i, j, l


      ! path_topog  : A path of topography NetCDF file
      ! path_albedo : A path of albedo NetCDF file
      ! path_ti     : A path of thermal inertia NetCDF file
      !
      ! FlagSPTIMod : A flag for modification of thermal inertia at south pole (expert use)
      !
      ! im          : Number of longitudinal grid points

      path_topog  = "../topog_MGS_MOLA_lowres-2013-03-06/ncfile/topog_MGS_MOLA_0.03125x0.03125.nc"
      path_albedo = "../albedo-2_MGS_TES/ncfiles/albedo_MGS_TES.nc"
      path_ti     = "../ti-2_MGS_TES/ncfiles/ti_MGS_TES_night.nc"

      FlagSPTIMod = .false.
!!$      FlagSPTIMod = .true.

      ! T10
!!$      im  = 32
!!$      ! T21
      im  = 64
!!$      ! T31
!!$      im  = 32 * 3
!!$      ! T42
!!$      im  = 64 * 2
!!$      ! T63
!!$      im  = 64 * 3
!!$      ! T85
!!$      im  = 64 * 2 * 2
!!$      ! T106
!!$      im  = 64 * 5
!!$      ! T170
!!$      im  = 64 * 2 * 2 * 2
!!$      ! T319
!!$      im  = 960
!!$      ! T639
!!$      im  = 1920



      !========================================
      ! Set planetary parameters
      !
      !----------------------------------------
      ! Parameters for the Earth
      !
!      call const_set( 0 )
      !
      !----------------------------------------
      ! Parameters for Mars
      !
      call const_set( 1 )
      !
      !========================================


      jmg    = im / 2
      ntrunc = ( im - 1 ) / 3


      call lt2_inq_arraysize( jmg, ntrunc, jm, lm )


      allocate( dta( im, 2 ) )
      allocate( sinlatg( jmg ), coslatg( jmg ), gwg( jmg ) )
      allocate( ord( lm ), deg( lm ) )
      allocate( pmn( lm, jmg ), eps( lm ) )


      call lt2_init( im, jmg, lm, ntrunc, &
           ita, dta, sinlatg, coslatg, gwg, ord, deg, pmn, eps )


      allocate( lon( im ), latg( jmg ) )
      do i = 1, im
         lon( i ) = 360.0d0 / im * dble( i - 1 )
      end do
      do j = 1, jmg
         latg( j ) = asin( sinlatg( j ) ) * r2d
      end do


      allocate( midlon( im+1 ) , midlat( jmg+1 ) )
      allocate( topog( im, jm ) )
      allocate( albed( im, jm ) )
      allocate( ti   ( im, jm ) )
      allocate( topogstd( im, jm ) )
      allocate( tmpstd  ( im, jm ) )

      allocate( farrr( im, jm ), farri( im, jm ) )
      allocate( sarr( lm ) )


      do i = 1, im+1-1
         midlon( i ) = 360.0d0 / dble( im ) * dble( i-1 ) &
              - 360.0d0 / dble( im ) / 2.0d0
      end do
      i = im+1
      midlon( i ) = 360.0d0


      j = 1
      midlat( j ) = -90.0d0
      do j = 2, jm
         midlat( j ) = ( latg( j-1 ) + latg( j ) ) / 2.0d0
      end do
      j = jm + 1
      midlat( j ) =  90.0d0


!      do i = 1, im
!         write( 6, * ) i, lon( i )
!      end do
!      do j = 1, jm
!         write( 6, * ) j, lat( j )
!      end do


      !
      ! topography
      !
      write( 6, * ) '-----'
      write( 6, * ) 'Processing topography data'
!!$      path = "../topog_MGS_MOLA/ncfile/topog_MGS_MOLA_0.03125x0.03125.nc"
!!$      path = "../topog_MGS_MOLA_lowres-2013-03-06/ncfile/topog_MGS_MOLA_0.03125x0.03125.nc"
      path = path_topog
      call ave( path, 'topog', im, jm, lon, latg, midlon, midlat, topog, topogstd )
      !
!!$      do j = 1, jm
!!$         do i = 1, im
!!$!            if( topog( i, j ) .lt. 0.0d0 ) then
!!$!               ! ocean
!!$!               sfcindex( i, j ) = 0
!!$!            else
!!$!               ! land
!!$!               sfcindex( i, j ) = 1
!!$!            end if
!!$            topog( i, j ) = max( topog( i, j ), 0.0d0 )
!!$         end do
!!$      end do
      !
      call lt2_g2s_2d( im, jmg, jm, lm, ita, dta, gwg, pmn, &
           topog, sarr )
      !
      ! truncation
      !
      call lt2_truncate_2d( lm, ntrunc, sarr )
      !
      ! filtering
      !
      ipow = 4
      do l = 1, lm
         if( deg( l ) .gt. ntrunc ) then
            factor = 0.0d0
         else
            factor = 1.0d0 - ( dble( deg( l ) ) / dble( ntrunc ) )**ipow
         end if
         sarr( l ) = sarr( l ) * factor
      end do
      !
      call lt2_s2g_2d( im, jmg, jm, lm, ita, dta, pmn, &
           sarr, topog )

      !
      !
      call lt2_g2s_2d( im, jmg, jm, lm, ita, dta, gwg, pmn, &
           topogstd, sarr )
      !
      ! truncation
      !
      call lt2_truncate_2d( lm, ntrunc, sarr )
      !
      ! filtering
      !
      ipow = 4
      do l = 1, lm
         if( deg( l ) .gt. ntrunc ) then
            factor = 0.0d0
         else
            factor = 1.0d0 - ( dble( deg( l ) ) / dble( ntrunc ) )**ipow
         end if
         sarr( l ) = sarr( l ) * factor
      end do
      !
      call lt2_s2g_2d( im, jmg, jm, lm, ita, dta, pmn, &
           sarr, topogstd )


      !
      ! albedo
      !
      write( 6, * ) '-----'
      write( 6, * ) 'Processing albedo data'
!!$      path = "../albedo-2_MGS_TES/ncfiles/albedo_MGS_TES.nc"
      path = path_albedo
      call ave( path, 'albedo', im, jm, lon, latg, midlon, midlat, albed, tmpstd )
      !
      call lt2_g2s_2d( im, jmg, jm, lm, ita, dta, gwg, pmn, &
           albed, sarr )
      ! truncation
      call lt2_truncate_2d( lm, ntrunc, sarr )
      ! filtering
      ipow = 4
      do l = 1, lm
         if( deg( l ) .gt. ntrunc ) then
            factor = 0.0d0
         else
            factor = 1.0d0 - ( dble( deg( l ) ) / dble( ntrunc ) )**ipow
         end if
         sarr( l ) = sarr( l ) * factor
      end do
      !
      call lt2_s2g_2d( im, jmg, jm, lm, ita, dta, pmn, &
           sarr, albed )


      !
      ! ti
      !
      write( 6, * ) '-----'
      write( 6, * ) 'Processing thermal inertia data'
!!$      path = "../ti-2_MGS_TES/ncfiles/ti_MGS_TES_night.nc"
      path = path_ti
      call ave( path, 'ti', im, jm, lon, latg, midlon, midlat, ti, tmpstd )
      !
      call lt2_g2s_2d( im, jmg, jm, lm, ita, dta, gwg, pmn, &
           ti, sarr )
      ! truncation
      if ( ntrunc > 360 ) then
        write( 6, * ) 'NOTE: Truncation wavenumber is greater than 360.'
        write( 6, * ) 'NOTE: This may result in "noisy" distribution of thermal inertia.'
      end if
      call lt2_truncate_2d( lm, ntrunc, sarr )
      ! filtering
      ipow = 4
      do l = 1, lm
         if( deg( l ) .gt. ntrunc ) then
            factor = 0.0d0
         else
            factor = 1.0d0 - ( dble( deg( l ) ) / dble( ntrunc ) )**ipow
         end if
         sarr( l ) = sarr( l ) * factor
      end do
      !
      call lt2_s2g_2d( im, jmg, jm, lm, ita, dta, pmn, &
           sarr, ti )
      !
      if ( FlagSPTIMod ) then
        if ( latg(1) > LatSPModEdge ) then
          js = 1
          je = 1
        else
          js = 1
          je = 1
          do j = 1, jm
            if ( latg(j) <= LatSPModEdge ) then
              je = j
            end if
          end do
        end if
        write( 6, * ) 'TI values at following latitude are modified, ', latg(js:je)
        do j = js, je
          ti(:,j) = 3000.0d0
        end do
      end if

      !
      ! output
      !

!!$      write( path, '( a, i3.3, a )' ) &
!!$           'out/sp_for_Mars_T', ( im-1 ) / 3, '_MGS+cons+cons.nc'
#ifdef AXISYMMETRY
      write( path, '( a, i3.3, a )' ) &
           'out/sp_for_Mars_lon1_T', ( im-1 ) / 3, '_MGS'
#elif defined ZONALMEAN
      write( path, '( a, i3.3, a )' ) &
           'out/sp_for_Mars_ZM_T', ( im-1 ) / 3, '_MGS'
#elif defined ZONALWAVE
      write( path, '( a, i3.3, a )' ) &
           'out/sp_for_Mars_ZW_T', ( im-1 ) / 3, '_MGS'
#else
      write( path, '( a, i3.3, a )' ) &
           'out/sp_for_Mars_T', ( im-1 ) / 3, '_MGS'
#endif
      if ( FlagSPTIMod ) then
        pathtail = '_SPTIMod'
      else
        pathtail = ''
      end if
      path = trim( path ) // trim( pathtail ) // '.nc'

      mode = 'new'
      call ni3_open( path, mode, ncid )

      title = "Orographic height, surface albedo, and thermal inertia"
      inst  = "dcpam/dcmodel project, GFD Dennou Club"
      src   = "Orographic height: MGS MOLA 1/32 degree resolution data from" &
        & // " http://pds-geosciences.wustl.edu/missions/mgs/megdr.html;" &
        & // " Surface albedo: MGS TES Special Products from http://geo.pds.nasa.gov/missions/mgs/tesspecial.html;" &
        & // " Thermal inertia: MGS TES Thermal Inertia Maps from http://pds-geosciences.wustl.edu/missions/mgs/tes-timap.html."
      com   = "Orographic height, surface albedo, and thermal inertia are obtained by areal averaging src data."
!!$      src   = " "
!!$      com   = " "
      call ni3_set_ga( ncid, title = title, inst = inst, src = src, com = com )

      name     = 'lon'
      stdname  = name
      longname = name
      units    = 'degrees_east'
#ifdef AXISYMMETRY
      call ni3_set_dim( ncid, name, NF90_DOUBLE, lon(1:1), &
           stdname, longname, units )
#else
      call ni3_set_dim( ncid, name, NF90_DOUBLE, lon, &
           stdname, longname, units )
#endif

      name     = 'lat'
      stdname  = name
      longname = name
      units    = 'degrees_north'
      call ni3_set_dim( ncid, name, NF90_DOUBLE, latg, &
           stdname, longname, units )

      name         = 'topog'
      stdname      = name
      longname     = 'topography'
      ndims        = 2
      dimname( 1 ) = 'lon'
      dimname( 2 ) = 'lat'
      units        = 'm'
      call ni3_def_var( ncid, name, NF90_DOUBLE, ndims, dimname, &
        & longname = longname, units = units )

      name         = 'albedo'
      stdname      = name
      longname     = 'albedo'
      ndims        = 2
      dimname( 1 ) = 'lon'
      dimname( 2 ) = 'lat'
      units        = 'm'
      call ni3_def_var( ncid, name, NF90_DOUBLE, ndims, dimname, &
        & longname = longname, units = units )

      name         = 'ti'
      stdname      = name
      longname     = 'thermal inertia'
      ndims        = 2
      dimname( 1 ) = 'lon'
      dimname( 2 ) = 'lat'
      units        = 'm'
      call ni3_def_var( ncid, name, NF90_DOUBLE, ndims, dimname, &
        & longname = longname, units = units )

      name         = 'topogstd'
      stdname      = name
      longname     = 'standard deviation of topography'
      ndims        = 2
      dimname( 1 ) = 'lon'
      dimname( 2 ) = 'lat'
      units        = 'm'
      call ni3_def_var( ncid, name, NF90_DOUBLE, ndims, dimname, &
        & longname = longname, units = units )


#ifdef AXISYMMETRY
      do j = 1, jm
        do i = 2, im
          topog   (1,j) = topog   (1,j) + topog   (i,j)
          albed   (1,j) = albed   (1,j) + albed   (i,j)
          ti      (1,j) = ti      (1,j) + ti      (i,j)
          topogstd(1,j) = topogstd(1,j) + topogstd(i,j)
        end do
        topog   (1,j) = topog   (1,j) / dble( im )
        albed   (1,j) = albed   (1,j) / dble( im )
        ti      (1,j) = ti      (1,j) / dble( im )
        topogstd(1,j) = topogstd(1,j) / dble( im )
      end do
      name = 'topog'
      call ni3_put_var( ncid, name, topog(1:1,:) )
      name = 'albedo'
      call ni3_put_var( ncid, name, albed(1:1,:) )
      name = 'ti'
      call ni3_put_var( ncid, name, ti   (1:1,:) )
      name = 'topogstd'
      call ni3_put_var( ncid, name, topogstd(1:1,:) )
#elif defined ZONALMEAN
      do j = 1, jm
        do i = 2, im
          topog   (1,j) = topog   (1,j) + topog   (i,j)
          albed   (1,j) = albed   (1,j) + albed   (i,j)
          ti      (1,j) = ti      (1,j) + ti      (i,j)
          topogstd(1,j) = topogstd(1,j) + topogstd(i,j)
        end do
        topog   (1,j) = topog   (1,j) / dble( im )
        albed   (1,j) = albed   (1,j) / dble( im )
        ti      (1,j) = ti      (1,j) / dble( im )
        topogstd(1,j) = topogstd(1,j) / dble( im )
        do i = 2, im
          topog   (i,j) = topog   (1,j)
          albed   (i,j) = albed   (1,j)
          ti      (i,j) = ti      (1,j)
          topogstd(i,j) = topogstd(1,j)
        end do
      end do
      name = 'topog'
      call ni3_put_var( ncid, name, topog    )
      name = 'albedo'
      call ni3_put_var( ncid, name, albed    )
      name = 'ti'
      call ni3_put_var( ncid, name, ti       )
      name = 'topogstd'
      call ni3_put_var( ncid, name, topogstd )
#elif defined ZONALWAVE
      gmtopog    = 0.0d0
      gmalbed    = 0.0d0
      gmti       = 0.0d0
      gmtopogstd = 0.0d0
      do j = 1, jm
        do i = 1, im
          gmtopog    = gmtopog + topog   (i,j) * gwg(j)
          gmalbed    = gmalbed + albed   (i,j) * gwg(j)
          gmti       = gmti    + ti      (i,j) * gwg(j)
          gmtopogstd = gmtopog + topogstd(i,j) * gwg(j)
        end do
      end do
      gmtopog    = gmtopog    / dble( im ) / 2.0d0
      gmalbed    = gmalbed    / dble( im ) / 2.0d0
      gmti       = gmti       / dble( im ) / 2.0d0
      gmtopogstd = gmtopogstd / dble( im ) / 2.0d0
      write( 6, * ) 'GM: ', gmtopog, gmalbed, gmti, gmtopogstd
!!$      name = 'topog'
!!$      call ni3_put_att( ncid, name, 'global_mean', gmtopog )
      name = 'albedo'
      call ni3_put_att( ncid, name, 'global_mean', gmalbed )
      name = 'ti'
      call ni3_put_att( ncid, name, 'global_mean', gmti    )
      name = 'topogstd'
      call ni3_put_att( ncid, name, 'global_mean', gmtopogstd )
      allocate( zmtopog   ( jm ) )
      allocate( zmalbed   ( jm ) )
      allocate( zmti      ( jm ) )
      allocate( zmtopogstd( jm ) )
      zmtopog   (:) = 0.0d0
      zmalbed   (:) = 0.0d0
      zmti      (:) = 0.0d0
      zmtopogstd(:) = 0.0d0
      do j = 1, jm
        do i = 1, im
          zmtopog   (j) = zmtopog   (j) + topog(i,j)
          zmalbed   (j) = zmalbed   (j) + albed(i,j)
          zmti      (j) = zmti      (j) + ti   (i,j)
          zmtopogstd(j) = zmtopogstd(j) + topogstd(i,j)
        end do
        zmtopog   (j) = zmtopog   (j) / dble( im )
        zmalbed   (j) = zmalbed   (j) / dble( im )
        zmti      (j) = zmti      (j) / dble( im )
        zmtopogstd(j) = zmtopogstd(j) / dble( im )
        do i = 1, im
          topog   (i,j) = topog   (i,j) - zmtopog(j)
          albed   (i,j) = albed   (i,j) - zmalbed(j) + gmalbed
          ti      (i,j) = ti      (i,j) - zmti   (j) + gmti
          topogstd(i,j) = topogstd(i,j) - zmtopogstd(j)
        end do
      end do
      do j = 1, jm
        do i = 1, im
          if ( albed(i,j) < 0.01d0 ) then
            write( 6, * ) 'Albedo is less than 0.01 at ', i, j, albed(i,j)
          end if
          if ( ti(i,j) < 10.0d0 ) then
            write( 6, * ) 'TI is less than 10 at ', i, j, ti(i,j)
          end if
        end do
      end do
      name = 'topog'
      call ni3_put_var( ncid, name, topog    )
      name = 'albedo'
      call ni3_put_var( ncid, name, albed    )
      name = 'ti'
      call ni3_put_var( ncid, name, ti       )
      name = 'topogstd'
      call ni3_put_var( ncid, name, topogstd )
#else
      name = 'topog'
      call ni3_put_var( ncid, name, topog    )
      name = 'albedo'
      call ni3_put_var( ncid, name, albed    )
      name = 'ti'
      call ni3_put_var( ncid, name, ti       )
      name = 'topogstd'
      call ni3_put_var( ncid, name, topogstd )
#endif

      call ni3_close( ncid )


!!$      open( 51, file = fn, status = 'unknown' )
!!$      write( 51, * ) "# ", im, jm
!!$      do j = 1, jm
!!$         do i = 1, im
!!$            write( 51, '(5e)' ) lon( i ), lat( j ), &
!!$                 topog( i, j ) * 1.0d-3
!!$         end do
!!$         write( 51, * )
!!$      end do
!!$      close( 51 )

!!$      write( fn, '( a, i2.2, a )' ) "out/sp_for_Earth_T", ( im-1 ) / 3, &
!!$           ".data"
!!$      open( 51, file = fn, status = 'unknown' )
!!$      write( 51, * ) "#", im, jm
!!$      do j = 1, jm
!!$         do i = 1, im
!!$            write( 51, * ) lon( i ), lat( j ), &
!!$                 topog( i, j )
!!$         end do
!!$      end do
!!$      close( 51 )


    end program main
