# -*- coding: euc-jp -*-
require 'gphys_const_v1.1'
require 'gphys_methods_v1.4'
require "numru/ggraph"
include NumRu
include NMath

## NCEP / NCAR reanalysis data, which can be downloaded from 
## ftp://ftp.cdc.noaa.gov/Datasets/ncep.reanalysis.derived/pressure/vwnd.mon.mean.nc
fn1    = 'vwnd.mon.mean.nc'
vname1 = 'vwnd'
## Meridional velocity by dcpam, which has been converted onto pressure levels.
## Conversion can be done by the use of util_s2p program.
#fn1    = 'V.nc'
#vname1 = 'V'

gphys1 = GPhys::NetCDF_IO.open(fn1, vname1)

gphysdisp = calc_msf( gphys1.cut('time'=>0).mean('lon') )

DCL.gropn(1)
DCL.sgpset('lcntl', false)   # ʸᤷʤ
DCL.sgpset('lfull',true)     # ɽ
DCL.uzfact(0.75)             # ɸʸ󥵥 0.75 
DCL.sgpset('lfprop',true)    # ץݡʥեȤȤ

GGraph.set_fig 'itr'=>2, 'viewport'=>[0.2,0.8,0.2,0.5], 'window'=>[-90,90,1e5,1e3]
GGraph.set_axes('xlabelint'=>30)

GGraph.tone( gphysdisp, true )
GGraph.color_bar


DCL.grcls

