!= ͥǡեץ
!
!= dcpam main program for generation of initial data file
!
! Authors::   Yasuhiro Morikawa, Yoshiyuki O. Takahashi
! Version::   $Id: dcpam_init_data.f90,v 1.1 2013/10/06 13:42:17 yot Exp $
! Tag Name::  $Name: dcpam5-20150217 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

program dcpam_insol
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ͥǡեޤ. 
  !
  ! Initial data file is created. 
  !

  ! ⥸塼 ; USE statements
  !

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING, &  ! ʸ.       Strings. 
    &                 TOKEN      ! .   Keywords. 

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax    ! ٳʻ. 
                             ! Number of grid points in latitude

  use gtool_historyauto, only: HistoryAutoAddVariable, HistoryAutoPut


  ! 
  ! Time control
  !
  use timeset, only: TimesetProgress, &
    & TimeB, &                ! ƥå $ t - \Delta t $ λ. 
                              ! Time of step $ t - \Delta t $. 
    & TimeN, &                ! ƥå $ t $ λ. 
                              ! Time of step $ t $. 
    & TimeA, &                ! ƥå $ t + \Delta t $ λ. 
                              ! Time of step $ t + \Delta t $. 
    & EndTime, &              ! ׻λ. 
                              ! End time of calculation
    & DelTime                 ! $ \Delta t $ [s]

  use rad_short_income, only: RadShortIncome, RadShortIncomeInit


  ! ʸ ; Declaration statements
  !
  implicit none

  ! ûѾ
  ! Information for short wave incoming
  !
  real(DP), allocatable, save:: xy_IncomRadSFlux (:,:)
                              ! û () եå. 
                              ! Short wave (insolation) flux
  real(DP), allocatable, save:: xy_InAngle (:,:)
                              ! sec (ͳ). 
                              ! sec (angle of incidence)


  ! ûȥեåѾ
  ! Information for short wave flux
  !
  real(DP), save:: SolarConst
                              ! . 
                              ! Solar constant.



  ! ϤΤκѿ
  ! Work variables for output
  !
  real(DP), allocatable:: xy_CosSZA (:,:)  !(0:imax-1, 1:jmax)

  real(DP), allocatable, save:: xy_IncomRadSFluxZM (:)
                              ! û () եåӾʿ 
                              ! Zonal mean short wave (insolation) flux



  ! ѿ
  ! Work variables
  !
  real(DP) :: DistFromStarScld
  real(DP) :: DiurnalMeanFactor
  integer :: i,j


  ! ¹ʸ ; Executable statement
  !

  ! ץν (֥롼)
  ! Initialization for the main program (Internal subroutine)
  !
  call MainInit

  call RadShortIncomeInit

  ! ʬ
  ! Time integration
  !
  loop_time : do while ( TimeB < EndTime )

    ! ûͤη׻
    ! Calculate short wave (insolation) incoming radiation
    !
    call RadShortIncome(                       &
      & xy_CosZet         = xy_CosSZA,         & ! (out) optional
      & xy_InAngle        = xy_InAngle,        & ! (out) optional
      & DistFromStarScld  = DistFromStarScld,  &
      & DiurnalMeanFactor = DiurnalMeanFactor  &
      & )


    ! ûȥեåη׻
    ! Calculate short wave (insolation) flux
    !

    do j = 1, jmax
      do i = 0, imax-1
        if ( xy_CosSZA(i,j) > 0.0_DP ) then
          xy_IncomRadSFlux(i,j) = SolarConst / DistFromStarScld**2 * xy_CosSZA(i,j)
        else
          xy_IncomRadSFlux(i,j) = 0.0_DP
        end if
      end do
    end do

    do j = 1, jmax
      xy_IncomRadSFluxZM(j) = sum(xy_IncomRadSFlux(:,j)) / imax
    end do

    ! ҥȥǡ
    ! History data output
    !
!    call HistoryAutoPut( TimeN, 'ISR', xy_IncomRadSFlux   (:,:) )
    call HistoryAutoPut( TimeN, 'ISRZM', xy_IncomRadSFluxZM   (:) )

!!! debug
!    print *, TimeN, xy_IncomRadSFlux(0,1)
!    print *, TimeN, xy_IncomRadSFluxZM(1), SolarConst

    ! οʹ
    ! Progress time
    !
    call TimesetProgress


    ! ʬλ
    ! Time integration is finished
    !
  end do loop_time
  
  ! ץνλ (֥롼)
  ! Termination for the main program (Internal subroutine)
  !
  call MainTerminate

contains

  !-------------------------------------------------------------------

  subroutine MainInit
    !
    ! ץν³. 
    !
    ! Initialization procedure for the main program. 
    !

    ! MPI
    !
    use mpi_wrapper, only : MPIWrapperInit

    use dc_message, only: MessageNotify

    ! ޥɥ饤
    ! Command line option parser
    !
    use option_parser, only: OptParseInit

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: NmlutilInit, NmlutilMsg

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! 
    ! Time control
    !
    use timeset, only: TimesetInit
                              ! ƥå $ t $ λ. Time of step $ t $. 

    ! ϥեδܾ
    ! Management basic information for output files
    ! 
    use fileset, only: FilesetInit

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: GridsetInit, &
      &                imax, & ! ٳʻ. 
                               ! Number of grid points in longitude
      &                jmax    ! ٳʻ. 
                               ! Number of grid points in latitude

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: ConstantsInit

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: AxessetInit

    ! ե뤫 1 ץեɤꤹ. 
    ! read 1-D profile from a file and set it 
    !
    use set_1d_profile, only : Set1DProfileInit

    ! ͥǡ (ꥹȥǡ) 
    ! Prepare initial data (restart data)
    !
    use initial_data, only: InitDataInit

    ! ҥȥǡ
    ! History data output
    !
    use history_file_io, only: HistoryFileOpen
    use gtool_historyauto, only: HistoryAutoAddVariable, HistoryAutoPut


    ! ʸ ; Declaration statements
    !
    implicit none
    character(*), parameter:: prog_name = 'dcpam_insol'
                              ! ץ̾. 
                              ! Main program name
    character(*), parameter:: version = &
      & '$Name: dcpam5-20150217 $' // &
      & '$Id: dcpam_insol.f90 $'
                              ! ץΥС
                              ! Main program version
    character(STRING)      :: namelist_filename
                              ! NAMELIST ե̾. 
                              ! NAMELIST file name

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    character(STRING):: brief
                              ! ¹ԥեδʷ
                              ! Brief account of executable file

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /dcpam_insol_nml/ &
      & SolarConst

    ! ¹ʸ ; Executable statement
    !

    ! Initialize MPI
    !
    call MPIWrapperInit


    brief = 'Initial data generation'
    call MessageNotify( 'M', prog_name, 'Run: %c', c1 = trim(brief) )
    call MessageNotify( 'M', prog_name, '-- version = %c', c1 = trim(version) )

    ! ޥɥ饤
    ! Command line option parser
    !
    call OptParseInit(       &
      & namelist_filename,   & ! (out)
      & prog_name,           & ! (in )
      & brief                & ! (in )
      & )

    ! NAMELIST ե̾
    ! Input NAMELIST file name
    !
    call NmlutilInit( &
      & namelist_filename  & ! (in)
      & )

    ! 
    ! Time control
    !
    call TimesetInit

    ! ϥեδܾ
    ! Management basic information for output files
    ! 
    call FilesetInit

    ! ʻ
    ! Grid points settings
    !
    call GridsetInit

    ! ʪ
    ! Physical constants settings
    !
    call ConstantsInit

    ! ɸǡ
    ! Axes data settings
    !
    call AxessetInit

    ! ͥǡ (ꥹȥǡ) 
    ! Prepare initial data (restart data)
    !
    call InitDataInit

    ! ûȥեåѾ
    ! Information for short wave flux
    !
    SolarConst             = 1380.0_DP

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml,                     & ! (in)
        & nml = dcpam_insol_nml,       & ! (out)
        & iostat = iostat_nml )             ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, prog_name ) ! (in)
    end if


    ! ͽѿγ
    ! Allocation of prediction variables
    !
!    allocate( xyz_U    (0:imax-1, 1:jmax, 1:kmax) )
!    allocate( xyz_V    (0:imax-1, 1:jmax, 1:kmax) )
!    allocate( xyz_Temp (0:imax-1, 1:jmax, 1:kmax) )
!    allocate( xyzf_QVap(0:imax-1, 1:jmax, 1:kmax, 1:ncmax) )
!    allocate( xy_Ps    (0:imax-1, 1:jmax) )

    allocate( xy_CosSZA (0:imax-1, 1:jmax) )
    allocate( xy_IncomRadSFlux (0:imax-1, 1:jmax) )
    allocate( xy_IncomRadSFluxZM (1:jmax) )
    allocate( xy_InAngle (0:imax-1, 1:jmax) )


    ! ե뤫 1 ץեɤꤹ. 
    ! read 1-D profile from a file and set it 
    !
    call Set1DProfileInit

    ! ҥȥǡեν
    ! Initialization of history data files
    !
    call HistoryFileOpen

    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
!    call HistoryAutoAddVariable( 'ISR', &
!      & (/ 'lon ', 'lat ', 'time' /), &
!      & 'insolation flux', 'W m-2' )
    call HistoryAutoAddVariable( 'ISRZM', &
      & (/ 'lat ', 'time' /), &
      & 'zonal mean incoming shortwave', 'W m-2' )

    !  ; Print
    !
    call MessageNotify( 'M', prog_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', prog_name, 'dcpam_insol:' )
    call MessageNotify( 'M', prog_name, '  SolarConst               = %f', d = (/ SolarConst                /) )
    call MessageNotify( 'M', prog_name, '-- version = %c', c1 = trim(version) )

  end subroutine MainInit

  !-------------------------------------------------------------------

  subroutine MainTerminate
    !
    ! ץνλ³. 
    !
    ! Termination procedure for the main program. 
    !

    ! MPI
    !
    use mpi_wrapper, only : MPIWrapperFinalize

    ! 
    ! Time control
    !
    use timeset, only: TimesetClose

    ! ꥹȥǡ
    ! Restart data input/output
    !
    use restart_file_io, only: RestartFileClose

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ¹ʸ ; Executable statement
    !

    ! ꥹȥǡե륯
    ! Close restart data input
    !
    call RestartFileClose

    ! λ
    ! Termination of time control
    !
    call TimesetClose

    ! ͽѿγղ
    ! Deallocation of prediction variables
    !
!    deallocate( xyz_U     )
!    deallocate( xyz_V     )
!    deallocate( xyz_Temp  )
!    deallocate( xyzf_QVap )
!    deallocate( xy_Ps     )

    deallocate( xy_CosSZA  )
    deallocate( xy_IncomRadSFlux  )
    deallocate( xy_IncomRadSFluxZM )
    deallocate( xy_InAngle  )

    ! Finalize MPI
    !
    call MPIWrapperFinalize

  end subroutine MainTerminate

end program dcpam_insol
