program main

  use vtype_module
  use ni3_module
  use ca_module
  use netcdf

  implicit none

  interface
    subroutine findfu( fn, ios, fu, mode )
      use vtype_module
      implicit none
      character(len=*), intent(in )           :: fn
      integer(i4b)    , intent(out)           :: ios, fu
      character(len=*), intent(in ), optional :: mode
    end subroutine findfu
  end interface

  character(len=extstr)            :: mode

  character(len=extstr)            :: ncfn_in
  character(len=extstr)            :: ncfn_out
  integer                          :: ncid_in
  integer                          :: ncid_out
  character(len=extstr)            :: varname

  character(len=extstr)            :: name
!!$  character(len=extstr)            :: stdname
!!$  character(len=extstr)            :: units

  integer(i4b)                       :: NDims
  character(len=extstr), allocatable :: a_DimNames(:)

  integer                          :: imax
  integer                          :: jmax
  integer                          :: kmax
  integer                          :: tmax

  real(dp)                         :: FillValue

  real(dp)           , allocatable :: x_Lon(:)
  real(dp)           , allocatable :: y_Lat(:)
  real(dp)           , allocatable :: z_VLev(:)
  real(dp)           , allocatable :: xy_Arr   (:,:)
  real(dp)           , allocatable :: xyz_Arr  (:,:,:)
  real(dp)           , allocatable :: xy_TMArr (:,:)
  real(dp)           , allocatable :: xyz_TMArr(:,:,:)
  integer            , allocatable :: xyz_NData(:,:,:)
  real(dp)           , allocatable :: a_Time(:)


  integer            , parameter   :: MaxArray = 500
  integer                          :: NDataPerDay
  integer                          :: NDataDays( MaxArray )
  integer                          :: NAve

  real(dp)                         :: Time
  real(dp)                         :: TMTime

  logical                          :: ex
  integer                          :: ios

!!$  integer                          :: DayStart
!!$  integer                          :: DayEnd

  integer                          :: i
  integer                          :: j
  integer                          :: k
  integer                          :: t
  integer                          :: nMon
  integer                          :: iMon
  integer                          :: iDay


  character(extstr)                :: fn

  character(extstr)                :: ctlfn = "timemean.cntl"
  integer                          :: ctlfu


  namelist /file/  ncfn_in, varname, ncfn_out
  namelist /mean/  NDataPerDay, NDataDays

  NDataDays = -1

  ncfn_in  = "ps"
  varname  = "Ps"
  ncfn_out = "out.nc"


  fn = ctlfn
  inquire( file = fn, exist = ex )
  if( .not. ex ) then
    write( 6, * ) "Control file ", trim( ctlfn ), " does not exit."
    write( 6, * ) "Control file should contain namelists listed below."
    write( 6, * ) "    &input"
    write( 6, * ) "        dir       = '.'"
    write( 6, * ) "    &end"
    write( 6, * ) "    &lander"
    write( 6, * ) "        LanderSym = 'VL1'"
    write( 6, * ) "    &end"
    write( 6, * ) "    &output"
    write( 6, * ) "        outfn     = 'vl1_dmps.dat'"
    write( 6, * ) "    &end"
    write( 6, * ) "    &dayinfo"
    write( 6, * ) "        DayStart  =     1"
    write( 6, * ) "        DayEnd    = 10000"
    write( 6, * ) "    &end"
    stop
  end if
  call findfu( fn, ios, ctlfu )
  if( ios /= 0 ) then
    write( 6, * ) 'STOP: ', ios
    stop
  end if
  open( ctlfu, file = fn, status = 'unknown' )

  rewind( ctlfu )
  read( ctlfu, mean )
  write( 6, mean )


  rewind( ctlfu )

  loop_namelist : do

    read( ctlfu, nml = file, iostat = ios )
    if ( ios /= 0 ) exit
    write( 6, * ) 'Read ', trim( ncfn_in ), ' and output to ', trim( ncfn_out )


    !----------------------------------------------------------
    !
    ! Preparing for ps file
    !
    mode = 'read'
    call ni3_open( ncfn_in, mode, ncid_in )
    !
    !----------------------------------------------------------

    !
    ! Number of dimensions are checked.
    !
    call ni3_inq_var( ncid_in, varname, ndims = NDims )
    allocate( a_DimNames( NDims ) )
    call ni3_inq_vardimnames( ncid_in, varname, NDims, a_DimNames )

    call ni3_inq_dimlen( ncid_in, a_DimNames(1)    , imax )
    call ni3_inq_dimlen( ncid_in, a_DimNames(2)    , jmax )
    call ni3_inq_dimlen( ncid_in, a_DimNames(NDims), tmax )
    allocate( x_Lon (0:imax-1) )
    allocate( y_Lat (1:jmax  ) )
    allocate( a_Time(1:tmax  ) )
    call ni3_get_var( ncid_in, a_DimNames(1)    , x_Lon  )
    call ni3_get_var( ncid_in, a_DimNames(2)    , y_Lat  )
    call ni3_get_var( ncid_in, a_DimNames(NDims), a_Time )

    select case ( NDims )
    case ( 4 )
      call ni3_inq_dimlen( ncid_in, a_DimNames(3), kmax )
      allocate( z_VLev(1:kmax) )
      call ni3_get_var( ncid_in, a_DimNames(3), z_VLev )
    end select

    select case ( NDims )
    case ( 3 )
      allocate( xy_Arr   (0:imax-1, 1:jmax) )
      allocate( xy_TMArr (0:imax-1, 1:jmax) )
    case ( 4 )
      allocate( xyz_Arr  (0:imax-1, 1:jmax, 1:kmax) )
      allocate( xyz_TMArr(0:imax-1, 1:jmax, 1:kmax) )
      allocate( xyz_NData(0:imax-1, 1:jmax, 1:kmax) )
    end select


    !----------------------------------------------------------
    !
    ! Preparing for output file
    !
    mode = 'new'
    call ni3_open( ncfn_out, mode, ncid_out )

    name = a_DimNames(1)
    call ni3_set_dim( ncid_out, name, NF90_REAL, x_Lon )
    call ni3_cp_atts( ncid_in, ncid_out, name )

    name = a_DimNames(2)
    call ni3_set_dim( ncid_out, name, NF90_REAL, y_Lat )
    call ni3_cp_atts( ncid_in, ncid_out, name )

    select case ( NDims )
    case ( 4 )
      name = a_DimNames(3)
      call ni3_set_dim( ncid_out, name, NF90_REAL, z_VLev )
      call ni3_cp_atts( ncid_in, ncid_out, name )
    end select

    name = a_DimNames(NDims)
    call ni3_def_dim( ncid_out, name, NF90_REAL, NF90_UNLIMITED )
    call ni3_cp_atts( ncid_in, ncid_out, name )

!!$  name    = "time"
!!$  stdname = "time"
!!$  units   = "days since 0000-01-01"
!!$  call ni3_def_dim( ncid_out, name, NF90_REAL, NF90_UNLIMITED, stdname = stdname, units  = units )
!!$  call ni3_cp_atts( ncid_ice, ncid_out, name )


    name = varname
    call ni3_def_var( ncid_out, name, NF90_REAL, NDims, a_DimNames )
    call ni3_cp_atts( ncid_in, ncid_out, name )

    if ( ni3_chk_att( ncid_in, varname, "missing_value" ) ) then
      call ni3_get_att( ncid_in , varname, "missing_value", FillValue )
      call ni3_put_att( ncid_out, varname, "missing_value", real(FillValue) )
      call ni3_put_att( ncid_out, varname, "_FillValue"   , real(FillValue) )
    else if ( ni3_chk_att( ncid_in, varname, "_FillValue" ) ) then
      call ni3_get_att( ncid_in , varname, "_FillValue"   , FillValue )
      call ni3_put_att( ncid_out, varname, "missing_value", real(FillValue) )
      call ni3_put_att( ncid_out, varname, "_FillValue"   , real(FillValue) )
    else
      FillValue = -999.0
      call ni3_put_att( ncid_out, varname, "missing_value", real(FillValue) )
      call ni3_put_att( ncid_out, varname, "_FillValue"   , real(FillValue) )
    end if
    !
    !----------------------------------------------------------


    NMon = 1
    loop_find_NMon : do
      if ( NDataDays(NMon) < 0 ) exit loop_find_NMon
      NMon = NMon + 1
    end do loop_find_NMon
    NMon = NMon - 1
    write( 6, * ) 'Number of average period is ', NMon

    iMon = 1
    t    = 1
    loop_time : do

!!$      print *, "Day ", iMon

      select case ( NDims )
      case ( 3 )
        xy_TMArr =  0.0d0
      case ( 4 )
        xyz_TMArr = 0.0d0
        xyz_NData = 0
      end select
      TMTime   =  0.0d0

      NAve = NDataPerDay * NDataDays( mod( iMon-1, NMon ) + 1 )
!!$      write( 6, * ) NAve, NAve / NDataPerDay

      if ( ( t + NAve ) > tmax ) exit loop_time

      loop_date : do iDay = 1, NAve
        ! A lat '+1' means that an initial condition is stored in a file.

        !
        ! Read data
        !
        select case ( NDims )
        case ( 3 )
          call ni3_get_varss( ncid_in, varname, t, xy_Arr )
        case ( 4 )
          call ni3_get_varss( ncid_in, varname, t, xyz_Arr )
        end select


        select case ( NDims )
        case ( 3 )
          xy_TMArr = xy_TMArr + xy_Arr
        case ( 4 )
!!$        xyz_TMArr = xyz_TMArr + xyz_Arr
!!$          call ca_add( imax, jmax, kmax, xyz_Arr, xyz_TMArr, FillValue )
          do k = 1, kmax
            do j = 1, jmax
              do i = 0, imax-1
                if ( xyz_Arr(i,j,k) /= FillValue ) then
                  xyz_TMArr(i,j,k) = xyz_TMArr(i,j,k) + xyz_Arr(i,j,k)
                  xyz_NData(i,j,k) = xyz_NData(i,j,k) + 1
                end if
              end do
            end do
          end do
        end select


        time = a_Time(t)

        TMTime = TMTime + time

        t = t + 1

      end do loop_date

      select case ( NDims )
      case ( 3 )
        xy_TMArr  = xy_TMArr  / dble( NAve )
      case ( 4 )
!!$        call ca_div( imax, jmax, kmax, xyz_TMArr, dble( NAve ), FillValue )
        do k = 1, kmax
          do j = 1, jmax
            do i = 0, imax-1
              if ( xyz_NData(i,j,k) > 0 ) then
                xyz_TMArr(i,j,k) = xyz_TMArr(i,j,k) / dble( xyz_NData(i,j,k) )
              else
                xyz_TMArr(i,j,k) = FillValue
              end if
            end do
          end do
        end do
      end select
      TMTime   = TMTime / dble( NAve )

      call ni3_put_varss( ncid_out, "time", iMon, TMTime )
      select case ( NDims )
      case ( 3 )
        call ni3_put_varss( ncid_out, varname, iMon, xy_TMArr )
      case ( 4 )
        call ni3_put_varss( ncid_out, varname, iMon, xyz_TMArr )
      end select

      iMon = iMon + 1

    end do loop_time


    deallocate( a_DimNames )
    deallocate( x_Lon )
    deallocate( y_Lat )
    deallocate( a_Time )
    select case ( NDims )
    case ( 4 )
      deallocate( z_VLev )
    end select

    select case ( NDims )
    case ( 3 )
      deallocate( xy_Arr   )
      deallocate( xy_TMArr )
    case ( 4 )
      deallocate( xyz_Arr   )
      deallocate( xyz_TMArr )
      deallocate( xyz_NData )
    end select


    call ni3_close( ncid_in  )

    call ni3_close( ncid_out )

  end do loop_namelist

  close( ctlfu )

end program main
