!= Ūʥ֥롼󡦴ؿ
!= Auxiliary subroutines and functions
!
! Authors::   Yasuhiro MORIKAWA, Yukiko YAMADA
! Version::   $Id: auxiliary.f90,v 1.5 2009-03-17 05:54:00 morikawa Exp $ 
! Tag Name::  $Name: dcpam5-20090405 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module auxiliary
  !
  != Ūʥ֥롼󡦴ؿ
  !
  != Auxiliary subroutines and functions
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! Υ⥸塼Ǥ, Ūʥ֥롼ؿ󶡤ޤ. 
  !
  ! This module provides Auxiliary subroutines and functions. 
  !
  !== Procedures List
  !
  ! AuxVars          :: ٤Ⱦ $ \sigma $ ٥֤
  !                     ȹ٤λ
  ! AuxFinalize      :: λ (⥸塼ѿγդ)
  ! ---------------  :: ---------------
  ! AuxVars          :: Interpolate temperature on half $ \sigma $ level, 
  !                     and calculate pressure and height
  ! AuxFinalize      :: Termination (deallocate variables in this module)
  !
  !--
  !== NAMELIST
  !
  ! NAMELIST#auxiliary_nml
  !++

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: AuxVars, AuxFinalize

  ! ѿ
  ! Public variables
  !
  logical, save, public:: auxiliary_inited = .false.
                              ! ե饰. 
                              ! Initialization flag


  ! ѿ
  ! Private variables
  !
  real(DP), save, allocatable:: z_TempInpolM (:)
                              ! ٤Ѥη. 
                              ! Coefficient for interpolation of temperature
  real(DP), save, allocatable:: z_TempInpol (:)
                              ! ٤Ѥη. 
                              ! Coefficient for interpolation of temperature
  real(DP), save:: RefPress
                              ! ൤. 
                              ! Reference air pressure

  character(*), parameter:: module_name = 'auxiliary'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20090405 $' // &
    & '$Id: auxiliary.f90,v 1.5 2009-03-17 05:54:00 morikawa Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
  interface AuxVars
    module procedure AuxVars
  end interface

  interface AuxFinalize
    module procedure AuxFinalize
  end interface

contains

  subroutine AuxVars( &
    & xy_Ps,      xyz_Temp, &    ! (in)
    & xyr_Temp, &                ! (out) optional
    & xyz_Press,  xyr_Press, &   ! (out) optional
    & xyz_Height, xyr_Height, &  ! (out) optional
    & xyz_Exner,  xyr_Exner &    ! (out) optional
    & )
    !
    ! ٤Ⱦҥ٥, ȹ٤λ, 
    ! ʡؿη׻Ԥޤ. 
    !
    ! Interpolate temperature on half sigma level, 
    ! and calculate pressure and height, 
    ! and calculate exner function. 

    ! ⥸塼 ; USE statements
    !

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & z_Sigma, &
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
      & r_Sigma, &
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level
      & z_DelSigma, &
                              ! $ \Delta \sigma $ (). 
                              ! $ \Delta \sigma $ (Full)
      & r_DelSigma
                              ! $ \Delta \sigma $ (Ⱦ). 
                              ! $ \Delta \sigma $ (Half)

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & Grav, &               ! $ g $ [m s-2]. 
                              ! ϲ®. 
                              ! Gravitational acceleration
      & GasRDry, &
                              ! $ R $ [J kg-1 K-1]. 
                              ! 絤ε. 
                              ! Gas constant of air
      & CpDry
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure

    ! 
    ! Time control
    !
    use timeset, only: TimesetClockStart, TimesetClockStop

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: xy_Ps       (0:imax-1, 1:jmax)
                              ! $ p_s (t-\Delta t) $ . ɽ̵. Surface pressure
    real(DP), intent(in):: xyz_Temp    (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .     . Temperature
    real(DP), intent(out), optional:: xyr_Temp   (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{T} $ .  (Ⱦ٥). 
                              ! Temperature (half level)
    real(DP), intent(out), optional:: xyz_Press  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ p $ .  (٥). 
                              ! Air pressure (full level)
    real(DP), intent(out), optional:: xyr_Press  (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)
    real(DP), intent(out), optional:: xyz_Height (0:imax-1, 1:jmax, 1:kmax)
                              !  (٥). 
                              ! Height (full level)
    real(DP), intent(out), optional:: xyr_Height (0:imax-1, 1:jmax, 0:kmax)
                              !  (Ⱦ٥). 
                              ! Height (half level)
    real(DP), intent(out), optional:: xyz_Exner (0:imax-1, 1:jmax, 1:kmax)
                              ! Exner ؿ (٥). 
                              ! Exner function (full level)
    real(DP), intent(out), optional:: xyr_Exner (0:imax-1, 1:jmax, 0:kmax)
                              ! Exner ؿ (Ⱦ٥). 
                              ! Exner function (half level)


    ! ѿ
    ! Work variables
    !
    real(DP):: xyz_PressWork  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ p $ .  (٥). 
                              ! Air pressure (full level)
    real(DP):: xyr_PressWork  (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)

    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement
    !

    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )

    ! 
    ! Initialization
    !
    if ( .not. auxiliary_inited ) call AuxInit

    ! ٤
    ! Interpolate temperature
    !
    if ( present( xyr_Temp ) ) then
      do k = 2, kmax
        xyr_Temp(:,:,k-1) =   z_TempInpolM(k) * xyz_Temp(:,:,k-1)  &
          &                 + z_TempInpol (k) * xyz_Temp(:,:,k)
      end do

      xyr_Temp(:,:,kmax) = xyz_Temp(:,:,kmax)
      xyr_Temp(:,:,0)    = xyz_Temp(:,:,1)
    end if

    ! η׻
    ! Calculate pressure
    !
    if ( present( xyz_Press ) ) then
      do k = 1, kmax
        xyz_Press(:,:,k) = xy_Ps * z_Sigma(k)
      end do
    end if

    if ( present( xyr_Press ) ) then
      do k = 0, kmax
        xyr_Press(:,:,k) = xy_Ps * r_Sigma(k)
      end do
    end if

    ! ٤η׻
    ! Calculate height
    !
    if ( present( xyz_Height ) ) then
      xyz_Height(:,:,1) = &
        & GasRDry / Grav * xyz_Temp(:,:,1) * ( 1. - z_Sigma(1) )

      do k = 2, kmax
        xyz_Height(:,:,k) = &
          &   xyz_Height(:,:,k-1) &
          & + GasRDry / Grav * xyr_Temp(:,:,k-1) &
          &   * r_DelSigma(k-1) / r_Sigma(k-1)
      end do
    end if

    if ( present( xyr_Height ) ) then
      xyr_Height = 0.
      do k = 1, kmax
        xyr_Height(:,:,k) = &
          &   xyr_Height(:,:,k-1) &
          & + GasRDry / Grav * xyz_Temp(:,:,k)  &
          &   * z_DelSigma(k) / z_Sigma(k)
      end do
    end if

    ! ʡؿη׻
    ! Calculate exner function
    !
    if ( present( xyz_Exner ) ) then
      if ( present( xyz_Press ) ) then
        xyz_PressWork = xyz_Press
      else
        do k = 1, kmax
          xyz_PressWork(:,:,k) = xy_Ps * z_Sigma(k)
        end do
      end if

      xyz_Exner = ( xyz_PressWork / RefPress ) ** ( GasRDry / CpDry )
    end if


    if ( present( xyr_Exner ) ) then
      if ( present( xyr_Press ) ) then
        xyr_PressWork = xyr_Press
      else
        do k = 0, kmax
          xyr_PressWork(:,:,k) = xy_Ps * r_Sigma(k)
        end do
      end if

      xyr_Exner = ( xyr_PressWork / RefPress ) ** ( GasRDry / CpDry )
    end if

    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine AuxVars

  !-------------------------------------------------------------------

  subroutine AuxInit
    !
    ! auxiliary ⥸塼νԤޤ. 
    ! NAMELIST#auxiliary_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "auxiliary" module is initialized. 
    ! "NAMELIST#auxiliary_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & z_Sigma, &
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
      & r_Sigma
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ʸ ; Declaration statements
    !
    implicit none

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /auxiliary_nml/ &
      & RefPress
          !
          ! ǥեͤˤĤƤϽ³ "auxiliary#AuxInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "auxiliary#AuxInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( auxiliary_inited ) return
    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !
    RefPress        =   1.0e+6

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &           ! (in)
        & nml = auxiliary_nml, &  ! (out)
        & iostat = iostat_nml )   ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if

    !  Ѥηη׻
    !  Calculate coefficient for interpolation
    !
    allocate( z_TempInpolM(1:kmax) )
    allocate( z_TempInpol(1:kmax) )

    z_TempInpolM(1) = 0.
    z_TempInpol (1) = 0.

    do k = 2, kmax
      z_TempInpolM(k) = &
        &    ( log( r_Sigma( k-1 ) ) - log( z_Sigma( k ) ) ) &
        &  / ( log( z_Sigma( k-1 ) ) - log( z_Sigma( k ) ) )
      z_TempInpol(k) = &
        &    ( log( z_Sigma( k-1 ) ) - log( r_Sigma( k-1 ) ) ) &
        &  / ( log( z_Sigma( k-1 ) ) - log( z_Sigma( k )   ) )
    end  do

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  z_TempInpolM = %*r', r = real( z_TempInpolM ), n = (/ kmax /) )
    call MessageNotify( 'M', module_name, '  z_TempInpol  = %*r', r = real( z_TempInpol  ), n = (/ kmax /) )
    call MessageNotify( 'M', module_name, '  RefPress     = %f', d = (/ RefPress /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    auxiliary_inited = .true.
  end subroutine AuxInit

  !-------------------------------------------------------------------

  subroutine AuxFinalize
    !
    ! ⥸塼ѿγդԤޤ. 
    !
    ! Deallocate variables in this module. 
    !

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ¹ʸ ; Executable statement
    !

    if ( .not. auxiliary_inited ) return

    ! դ
    ! Deallocation
    !
    if ( allocated( z_TempInpolM ) ) deallocate( z_TempInpolM )
    if ( allocated( z_TempInpol  ) ) deallocate( z_TempInpol  )

    auxiliary_inited = .false.
  end subroutine AuxFinalize

  !-------------------------------------------------------------------

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: gridset_inited

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: constants_inited

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: axesset_inited

    ! ¹ʸ ; Executable statement
    !

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

    if ( .not. gridset_inited ) &
      & call MessageNotify( 'E', module_name, '"gridset" module is not initialized.' )

    if ( .not. constants_inited ) &
      & call MessageNotify( 'E', module_name, '"constants" module is not initialized.' )

    if ( .not. axesset_inited ) &
      & call MessageNotify( 'E', module_name, '"axesset" module is not initialized.' )

  end subroutine InitCheck

end module auxiliary
