!= ɸǡ
!
!= Axes data settings
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: axesset.F90,v 1.5 2009-03-18 09:24:41 morikawa Exp $ 
! Tag Name::  $Name: dcpam5-20090405 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module axesset
  !
  != ɸǡ
  !
  != Axes data settings
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ɸǡꤪݴɤԤޤ. 
  ! 
  !  $ \varphi $ ӷ $ \lambda $ γʻ, 
  ! gridset ⥸塼ꤵʻ, 
  ! {SPMODEL 饤֥}[http://www.gfd-dennou.org/library/spmodel]
  ! ѤƷꤵޤ. 
  ! ٤γʻΰ֤ϥ, 
  ! ٤γʻΰֳ֤֤ˤȤ뤳Ȥˤʤޤ. 
  ! 
  ! ľҤγʻ, Ⱦ٥ (ؤü) ˤĤ 
  ! NAMELIST#Sigma ˻ꤷޤ. 
  ! ٥ (ؤ濴) , Ⱦ٥ constants 
  ! ⥸塼ꤵ봥絤갵Ǯ $ C_p $ 
  ! 絤ε $ R $ ѤƷꤷޤ. 
  ! ľҤγʻˤĤƤ, sigma_data ⥸塼ѰդƤ
  ! ΤѤ뤳ȤǽǤ. 
  !
  ! Axes data is set and stored. 
  !
  ! Grid points of latitude $ \varphi $ and longitude $ \lambda $ are
  ! determined 
  ! with number of grid points configured in "gridset" module
  ! by {SPMODEL Library}[http://www.gfd-dennou.org/library/spmodel/index.htm.en]
  ! Grid points of latitude becomes Gaussian latitude, 
  ! and grid points of latitude becomes equally spaced. 
  !
  !== Variables List
  !
  ! x_Lon          :: ٺɸ
  ! x_Lon_Weight   :: ٺɸŤ
  ! y_Lat          :: ٺɸ
  ! y_Lat_Weight   :: ٺɸŤ
  ! z_Sigma        :: $ \sigma $ ٥ ()
  ! r_Sigma        :: $ \sigma $ ٥ (Ⱦ)
  ! z_DelSigma     :: $ \Delta \sigma $ ()
  ! r_DelSigma     :: $ \Delta \sigma $ (Ⱦ)
  ! w_Number       :: ڥȥǡźֹ
  ! spml_inited    :: SPML 饤֥νե饰
  ! ------------   :: ------------
  ! x_Lon          :: Longitude
  ! x_Lon_Weight   :: Weight of longitude
  ! y_Lat          :: Latitude
  ! y_Lat_Weight   :: Weight of latitude
  ! z_Sigma        :: Full $ \sigma $ level
  ! r_Sigma        :: Half $ \sigma $ level
  ! z_DelSigma     :: $ \Delta \sigma $ (Full)
  ! r_DelSigma     :: $ \Delta \sigma $ (Half)
  ! w_Number       :: Subscript of spectral data
  ! spml_inited    :: Initialization flag of SPML library
  !
  !== Variables List (MPI)
  !
  ! ʲ MPI ѻ, ΰΤκɸǡ򻲾Ȥݤ˻ѤƤ. 
  !
  ! Use following variables in order to refer data of axes in whole area. 
  !
  ! x_Lon_wholeMPI    :: ٺɸ
  ! y_Lat_wholeMPI    :: ٺɸ
  ! z_Sigma_wholeMPI  :: $ \sigma $ ٥ ()
  ! r_Sigma_wholeMPI  :: $ \sigma $ ٥ (Ⱦ)
  ! ------------      :: ------------
  ! x_Lon_wholeMPI    :: Longitude
  ! y_Lat_wholeMPI    :: Latitude
  ! z_Sigma_wholeMPI  :: Full $ \sigma $ level
  ! r_Sigma_wholeMPI  :: Half $ \sigma $ level
  !
  !== Procedures List
  !
  ! AxessetInit     :: ɸǡ
  ! AxessetFinalize :: λ (⥸塼ѿγդ)
  ! ------------    :: ------------
  ! AxessetInit     :: Settings of axes data
  ! AxessetFinalize :: Termination (deallocate variables in this module)
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: &
    &                GridsetChange, &
    &                nmax, & ! ȿ. 
                             ! Maximum truncated wavenumber
    &                imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level
  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP     ! ټ¿. Double precision. 

  ! NAMELIST եϤ˴ؤ桼ƥƥ
  ! Utilities for NAMELIST file input
  !
  use namelist_util, only: MaxNmlArySize
                              ! NAMELIST ɤ߹κ祵. 
                              ! Maximum size of arrays loaded from NAMELIST

#ifdef LIB_MPI
  ! MPI 饤֥
  ! MPI library
  !
  use mpi
#endif

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: AxessetInit, AxessetFinalize

  ! ѿ
  ! Public variables
  !
  logical, save, public:: axesset_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  real(DP), allocatable, save, public:: x_Lon (:)
                              ! $ \lambda $ [rad.] . . Longitude
  real(DP), allocatable, save, public:: x_Lon_Weight (:)
                              ! $ \Delta \lambda $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of longitude
  real(DP), allocatable, save, public:: y_Lat (:)
                              ! $ \varphi $ [rad.] . . Latitude
  real(DP), allocatable, save, public:: y_Lat_Weight (:)
                              ! $ \Delta \varphi $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of latitude
  real(DP), allocatable, save, public:: z_Sigma (:)
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
  real(DP), allocatable, save, public:: r_Sigma (:)
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level
  real(DP), allocatable, save, public:: z_DelSigma (:)
                              ! $ \Delta \sigma $ (). 
                              ! $ \Delta \sigma $ (Full)
  real(DP), allocatable, save, public:: r_DelSigma (:)
                              ! $ \Delta \sigma $ (Ⱦ). 
                              ! $ \Delta \sigma $ (half)
  integer, allocatable, save, public:: w_Number (:)
                              ! ڥȥǡźֹ. 
                              ! Subscript of spectral data

  logical, save, public:: spml_inited = .false.
                              ! SPML 饤֥νե饰. 
                              ! Initialization flag of SPML library

  real(DP), allocatable, save, public:: x_Lon_wholeMPI (:)
                              ! $ \lambda $ [rad.] . . Longitude
  real(DP), allocatable, save, public:: y_Lat_wholeMPI (:)
                              ! $ \varphi $ [rad.] . . Latitude
  real(DP), allocatable, save, public:: z_Sigma_wholeMPI (:)
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
  real(DP), allocatable, save, public:: r_Sigma_wholeMPI (:)
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level

  ! ѿ
  ! Private variables
  !
  real(DP), save:: Sigma (1:MaxNmlArySize)
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level

  character(*), parameter:: module_name = 'axesset'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20090405 $' // &
    & '$Id: axesset.F90,v 1.5 2009-03-18 09:24:41 morikawa Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
  interface AxessetInit
    module procedure AxessetInit
  end interface

  interface AxessetFinalize
    module procedure AxessetFinalize
  end interface

contains

  subroutine AxessetInit
    !
    ! axesset ⥸塼νԤޤ. 
    ! NAMELIST#axesset_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "axesset" module is initialized. 
    ! NAMELIST#axesset_nml is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: PI, &    ! $ \pi $ .
                                  ! ߼Ψ.  Circular constant
      &                  CpDry, & ! $ C_p $ [J kg-1 K-1]. 
                                  ! 絤갵Ǯ. 
                                  ! Specific heat of air at constant pressure
      &                  GasRDry  ! $ R $ [J kg-1 K-1]. 
                                  ! 絤ε. 
                                  ! Gas constant of air

#ifdef LIB_MPI
    ! MPI  SPMODEL 饤֥, ̾ĴȡѴˤ(¿б) 
    ! SPMODEL library MPI version, problems on sphere are solved with spherical harmonics (multi layer is supported)
    !
    use wa_mpi_module, only: wa_mpi_Initial, &
      & spml_jc           => jc, &
                              ! ʬʻ. 
                              ! Number of grid points for MPI in latitude
      & spml_x_Lon        => x_Lon, & 
                              ! $ \lambda $ [rad.] . . Longitude
      & spml_y_Lat        => v_Lat, &
                              ! $ \varphi $ [rad.] . . Latitude
      & spml_y_Lat_wholeMPI => y_Lat, &
                              ! $ \varphi $ [rad.] . . Latitude
      & spml_x_Lon_Weight => x_Lon_Weight, &
                              ! $ \Delta \lambda $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of longitude
      & spml_y_Lat_Weight => v_Lat_Weight
                              ! $ \Delta \varphi $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of latitude
#else
    ! SPMODEL 饤֥, ̾ĴȡѴˤ(¿б) 
    ! SPMODEL library, problems on sphere are solved with spherical harmonics (multi layer is supported)
    !
    use wa_module, only: wa_Initial, &
      & spml_x_Lon        => x_Lon, & 
                              ! $ \lambda $ [rad.] . . Longitude
      & spml_y_Lat        => y_Lat, &
                              ! $ \varphi $ [rad.] . . Latitude
      & spml_x_Lon_Weight => x_Lon_Weight, &
                              ! $ \Delta \lambda $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of longitude
      & spml_y_Lat_Weight => y_Lat_Weight
                              ! $ \Delta \varphi $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of latitude
#endif

    ! ľҥ٥ǡ
    ! Prepare vertical sigma level data
    !
    use sigma_data, only: SigmaDataGetHalf

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: &
      &                 STDOUT, &  ! ɸϤֹ. Unit number of standard output
      &                 TOKEN      ! .   Keywords. 

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! ʸ
    ! Character handling
    !
    use dc_string, only: CPrintf

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ѿ
    ! Work variables
    !
    integer:: i               ! ڥȥźֹǲ DO 롼Ѻѿ
                              ! Work variables for DO loop in subscript of spectral data
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction
    real(DP):: Kappa          ! $ \kappa = R / C_p $ .
                              ! 絤ˤ, 갵ǮФ.
                              ! Ratio of gas constant to specific heat in dry air
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    integer:: IspackOpenmpThreads
                              ! OPENMP Ǥκ祹åɿ.
                              ! openmp_threads  1 礭ͤꤹ 
                              ! ISPACK[http://www.gfd-dennou.org/library/ispack/] 
                              ! εĴȡѴ OPENMP ׻
                              ! 롼Ѥ. ׻¹Ԥˤ,
                              ! ¹Ի˴Ķѿ OMP_NUM_THREADS 
                              !  IspackOpenmpThreads ʲοꤹ
                              ! Υƥ˱ɬפȤʤ.
                              !
                              ! IspackOpenmpThreads  1 礭ͤ
                              ! ꤷʤ׻롼ϸƤФʤ.

    character(TOKEN):: rank_str
                              ! 󥯿. Rank number
#ifdef LIB_MPI
    logical:: initflag_mpi
    integer:: err_mpi
#endif
    integer:: myrank_mpi      ! ץ. Number of total processes
    integer:: nprocs_mpi      ! ȤΥץ. Number of my process
    integer:: ra              ! MPI Υ󥯿˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in rank number of MPI direction

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /axesset_nml/ &
      & Sigma, IspackOpenmpThreads
          !
          ! ǥեͤˤĤƤϽ³ "axesset#AxessetInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "axesset#AxessetInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( axesset_inited ) return
    call InitCheck

    ! դ
    ! Allocation
    !
    allocate( z_Sigma      (1:kmax)   )
    allocate( r_Sigma      (0:kmax)   )
    allocate( z_DelSigma   (1:kmax)   )
    allocate( r_DelSigma   (0:kmax)   )
    allocate( w_Number     (1:(nmax+1)**2) )

    allocate( z_Sigma_wholeMPI (1:kmax)   )
    allocate( r_Sigma_wholeMPI (0:kmax)   )

    ! ǥեͤ
    ! Default values settings
    !
    IspackOpenmpThreads = 0

    ! Sigma (Ⱦ٥) ν (̵) 
    ! Setting of initial value (invalid value) of "Sigma" (half level sigma)
    !
    Sigma = -999.0_DP

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &         ! (in)
        & nml = axesset_nml, &  ! (out)
        & iostat = iostat_nml ) ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if

    ! Sigma (Ⱦ٥) μư
    ! Automation setting of "Sigma" (half level sigma)
    !
    if ( all( Sigma < 0.0_DP ) ) then
      call SigmaDataGetHalf( Sigma(1:kmax+1) ) ! (out)
    end if

    ! Sigma (Ⱦ٥) å
    ! Check "Sigma" (half level sigma)
    !
    call NmlutilAryValid( module_name, & ! (in)
      & Sigma,  'Sigma', &               ! (in)
      & kmax+1, 'kmax+1' )               ! (in)

    ! r_Sigma (Ⱦ٥) 
    ! Setting of "r_Sigma" (half level sigma)
    !
    r_Sigma(0:kmax) = Sigma(1:kmax+1)
    r_Sigma_wholeMPI(0:kmax) = r_Sigma(0:kmax)

    ! z_DelSigma (٥ $ \Delta \sigma $ ) 
    ! Setting of "z_DelSigma" (full level $ \Delta \sigma $ )
    !
    do k = 1, kmax
      z_DelSigma(k) = r_Sigma(k-1) - r_Sigma(k)
    enddo

    ! z_Sigma (٥) 
    ! Setting of "z_Sigma" (full level sigma)
    !
    Kappa = GasRDry / CpDry
    do k = 1, kmax
      z_Sigma(k) = &
        & ( &
        &   (   r_Sigma(k-1) ** ( 1.0_DP + Kappa ) &
        &     - r_Sigma(k)   ** ( 1.0_DP + Kappa ) &
        &   ) / ( z_DelSigma(k) * ( 1.0_DP + Kappa ) ) &
        & ) ** ( 1.0_DP / Kappa )
    enddo
    z_Sigma_wholeMPI(1:kmax) = z_Sigma(1:kmax)

    ! r_DelSigma (Ⱦ٥ $ \Delta \sigma $ ) 
    ! Setting of "r_DelSigma" (half level $ \Delta \sigma $ )
    !
    r_DelSigma(0)    = r_Sigma(0)    - z_Sigma(1)
    r_DelSigma(kmax) = z_Sigma(kmax) - r_Sigma(kmax)
    do k = 1, kmax - 1
      r_DelSigma(k) = z_Sigma(k) - z_Sigma(k+1)
    end do

    ! ٷ٤
    ! Settings of longitude and latitude
    !
    allocate( x_Lon_wholeMPI (0:imax-1) )
    allocate( y_Lat_wholeMPI (1:jmax)   )

    if ( .not. spml_inited ) then
#ifdef LIB_MPI
      call MPI_Initialized(initflag_mpi, err_mpi)
      if ( .not. initflag_mpi ) then
        call MessageNotify( 'E', module_name, 'Initialize MPI by "MPI_Init" before AxessetInit' )
      end if

      call wa_mpi_Initial( nmax, imax, jmax, kmax ) ! (in)
      call GridsetChange( jm = spml_jc ) ! (in)
#else
      if ( IspackOpenmpThreads < 2 ) then
        call wa_Initial( nmax, imax, jmax, kmax ) ! (in)
      else
        call wa_Initial( nmax, imax, jmax, kmax, IspackOpenmpThreads ) ! (in)
      end if
#endif
      spml_inited = .true.
    end if

    allocate( x_Lon        (0:imax-1) )
    allocate( x_Lon_Weight (0:imax-1) )
    allocate( y_Lat        (1:jmax)   )
    allocate( y_Lat_Weight (1:jmax)   )
    x_Lon          = spml_x_Lon
    x_Lon_wholeMPI = spml_x_Lon
    x_Lon_Weight   = spml_x_Lon_Weight
    y_Lat          = spml_y_Lat
    y_Lat_Weight   = spml_y_Lat_Weight

#ifdef LIB_MPI
    y_Lat_wholeMPI = spml_y_Lat_wholeMPI
#else
    y_Lat_wholeMPI = spml_y_Lat
#endif

    ! ڥȥǡźֹ
    ! Settings of subscript of spectral data
    !
    do i = 1, size(w_Number)
      w_Number(i) = i
    end do

    ! 󥯤˴ؤμ
    ! Get information about rank
    !
    myrank_mpi = -1
    nprocs_mpi = 1
#ifdef LIB_MPI
    call MPI_Initialized(initflag_mpi, err_mpi)
    if ( initflag_mpi ) then
      call MPI_Comm_Rank(MPI_COMM_WORLD, myrank_mpi, err_mpi)
      rank_str = CPrintf( ' [rank=%06d]', i = (/ myrank_mpi /) )
      call MPI_Comm_Size(MPI_COMM_WORLD, nprocs_mpi, err_mpi)
    else
      rank_str = ''
    end if
#else
    rank_str = ''
#endif


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )

    do ra = 0, nprocs_mpi - 1

#ifdef LIB_MPI
      if ( initflag_mpi ) call MPI_Barrier(MPI_COMM_WORLD, err_mpi)
      if ( myrank_mpi > -1 .and. ra /= myrank_mpi ) cycle
#endif

      call MessageNotify( 'M', module_name, 'Axes:%c', c1 = trim(rank_str), rank_mpi = -1 )
      call MessageNotify( 'M', module_name, '  x_Lon(%d:%d) [deg.] = %*f', &
        & i = (/ 0, imax - 1/), &
        & d = format_print(x_Lon / PI * 180.0_DP, imax), &
        & n =(/ imax /), rank_mpi = -1 )
      call MessageNotify( 'M', module_name, '  y_Lat(%d:%d) [deg.] = %*f', &
        & i = (/ 1, jmax/), &
        & d = format_print(y_Lat / PI * 180.0_DP, jmax), &
        & n =(/ jmax /), rank_mpi = -1 )
      call MessageNotify( 'M', module_name, '  z_Sigma(%d:%d) = %*f', &
        & i = (/ 1, kmax /), &
        & d = format_print(z_Sigma, kmax), n =(/ kmax /), rank_mpi = -1 )
      call MessageNotify( 'M', module_name, '  r_Sigma(%d:%d) = %*f', &
        & i = (/ 0, kmax /), &
        & d = format_print(r_Sigma, kmax+1), n =(/ kmax+1 /), rank_mpi = -1 )
      call MessageNotify( 'M', module_name, '  w_Number(%d:%d) = %d .. %d', &
        & i = (/ 1, size(w_Number), 1, size(w_Number) /), rank_mpi = -1 )
  !
      call MessageNotify( 'M', module_name, 'Weight:' )
      call MessageNotify( 'M', module_name, '  x_Lon_Weight(%d:%d) = %*f', &
        & i = (/ 0, imax - 1/), &
        & d = format_print(x_Lon_Weight, imax), n =(/ imax /), rank_mpi = -1 )
      call MessageNotify( 'M', module_name, '  y_Lat_Weight(%d:%d) = %*f', &
        & i = (/ 1, jmax/), &
        & d = format_print(y_Lat_Weight, jmax), n =(/ jmax /), rank_mpi = -1 )
      call MessageNotify( 'M', module_name, '  z_DelSigma(%d:%d) = %*f', &
        & i = (/ 1, kmax /), &
        & d = format_print(z_DelSigma, kmax), n =(/ kmax /), rank_mpi = -1 )
      call MessageNotify( 'M', module_name, '' )
    end do

    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version), rank_mpi = -1 )

    axesset_inited = .true.
  end subroutine AxessetInit

  !-------------------------------------------------------------------

  subroutine AxessetFinalize
    !
    ! ⥸塼ѿγդԤޤ. 
    !
    ! Deallocate variables in this module. 
    !

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ¹ʸ ; Executable statement
    !

    if ( .not. axesset_inited ) return

    ! դ
    ! Deallocation
    !
    if ( allocated( z_Sigma    ) ) deallocate( z_Sigma    )
    if ( allocated( r_Sigma    ) ) deallocate( r_Sigma    )
    if ( allocated( z_DelSigma ) ) deallocate( z_DelSigma )
    if ( allocated( r_DelSigma ) ) deallocate( r_DelSigma )
    if ( allocated( w_Number   ) ) deallocate( w_Number   )

    if ( allocated( z_Sigma_wholeMPI ) ) deallocate( z_Sigma_wholeMPI )
    if ( allocated( r_Sigma_wholeMPI ) ) deallocate( r_Sigma_wholeMPI )
    if ( allocated( x_Lon_wholeMPI   ) ) deallocate( x_Lon_wholeMPI   )
    if ( allocated( y_Lat_wholeMPI   ) ) deallocate( y_Lat_wholeMPI   )

    if ( allocated( x_Lon        ) ) deallocate( x_Lon        )
    if ( allocated( x_Lon_Weight ) ) deallocate( x_Lon_Weight )
    if ( allocated( y_Lat        ) ) deallocate( y_Lat        )
    if ( allocated( y_Lat_Weight ) ) deallocate( y_Lat_Weight )

    axesset_inited = .false.
  end subroutine AxessetFinalize

  !-------------------------------------------------------------------

  function format_print( ary, size ) result(result)
    !
    ! ɸϤƸ䤹褦ŬͭηȤ֤. 
    !
    ! Effective digit is reduced for output to standard output and returned. 
    !

    ! ʸ ; Declaration statements
    !
    implicit none
    integer, intent(in):: size
    real(DP), intent(in):: ary(size)
    real(DP):: result(size)
  
    ! ¹ʸ ; Executable statement
    !
    result(1:size) = int( ary(1:size) * 1000.0_DP ) / 1000.0_DP
    
  end function format_print

  !-------------------------------------------------------------------

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: gridset_inited

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: constants_inited

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! ¹ʸ ; Executable statement
    !

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

    if ( .not. gridset_inited ) &
      & call MessageNotify( 'E', module_name, '"gridset" module is not initialized.' )

    if ( .not. constants_inited ) &
      & call MessageNotify( 'E', module_name, '"constants" module is not initialized.' )

  end subroutine InitCheck

end module axesset
