!= dcpam ץ
!
!= dcpam main program
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: dcpam_main.F90,v 1.35 2009-03-18 09:40:37 morikawa Exp $ 
! Tag Name::  $Name: dcpam5-20090405 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

program dcpam_main
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ʲΤ줫η׻Ԥޤ. ڤؤˤĤƤ 
  ! {塼ȥꥢ}[link:../../../doc/tutorial/rakuraku/] 
  ! ȤƤ. 
  ! 
  ! * , ʤ夬ʤƤ褦絤η׻
  ! * Held and Suarez (1994) ٥ޡƥ
  !
  ! Following any calculation is performed. 
  ! See {Tutorial}[link:../../../doc/tutorial/rakuraku/index.htm.en] 
  ! for switch of them. 
  ! 
  ! * Calculation of atmosphere on a planet covered with water globally
  ! * Held and Suarez (1994) benchmark test
  !
  !== References
  !
  ! * Held, I. M., Suarez, M. J., 1994: 
  !   A proposal for the intercomparison of the dynamical cores of
  !   atmospheric general circuation models.
  !   <i>Bull. Am. Meteor. Soc.</i>, <b>75</b>, 1825--1830.
  ! 

  ! ⥸塼 ; USE statements
  !

  ! ϳز (ڥȥˡ, Arakawa and Suarez (1983))
  ! Dynamical process (Spectral method, Arakawa and Suarez (1983))
  !
  use dynamics_hspl_vas83, only: Dynamics

  ! Held and Suarez (1994) ˤ붯Ȼ
  ! Forcing and dissipation suggested by Held and Suarez (1994)
  !
  use held_suarez_1994, only: Hs94Forcing

  ! ͥեå (Хɥǥ)
  ! Radiation flux (band model)
  !
  use radiation_band, only: RadiationFlux, RadiationDTempDt, &
    & RadiationFluxOutput

  ! ľȻեå (Mellor and Yamada, 1974, ٥ 2)
  ! Vertical diffusion flux (Mellor and Yamada, 1974, Level 2)
  !
  use vdiffusion_my1974, only: VerticalDiffusion, VerticalDiffusionOutput

  ! ѱѥ᥿ꥼ (ήĴ)
  ! Cumulus parameterization (convection adjust)
  !
  use cumulus_adjust, only: Cumulus

  ! 絬϶ŷ
  ! Large scale condensation
  !
  use lscond, only: LScaleCond

  ! ɽ̥եå
  ! Surface flux
  use surface_flux_bulk, only: SurfaceFlux, SurfaceFluxOutput

  ! ήĴ
  ! Dry convective adjustment
  !
  use dryconv_adjust, only: DryConvectAdjust

  ! ο
  ! Remove negative moisture
  !
  use negative_moist, only: RemoveNegMoist

  ! ٤Ⱦҥ٥, ȹ٤λ
  ! Interpolate temperature on half sigma level, 
  ! and calculate pressure and height
  !
  use auxiliary, only: AuxVars

  ! ˡΤι (ʪ)
  ! Matrices handling for implicit scheme (for a part of physical processes)
  !
  use phy_implicit, only: PhyImplTendency, PhyImplEvalRadLFluxA

  ! ̲٤λʬɽ
  ! Time integration of surface temperature, correction of flux on surface
  !
  use intg_surftemp, only: IntegralSurfTemp

  ! ե륿 (Asselin, 1972)
  ! Time filter (Asselin, 1972)
  !
  use timefilter_asselin1972, only: TimeFilter

  ! 
  ! Time control
  !
  use timeset, only: TimesetProgress, &
    & TimeN, &                ! ƥå $ t $ λ. 
                              ! Time of step $ t $. 
    & TimeA, &                ! ƥå $ t + \Delta t $ λ. 
                              ! Time of step $ t + \Delta t $. 
    & EndTime, &              ! ׻λ. 
                              ! End time of calculation
    & DelTime                 ! $ \Delta t $ [s]

  ! ꥹȥǡ
  ! Restart data input/output
  !
  use restart_file_io, only: RestartFileOutPut

  ! ɽ̲٥ꥹȥǡ
  ! Restart data of surface temperature input/output
  !
  use restart_surftemp_io, only: RestartSurfTempOutPut

  ! ɽ̥ǡե
  ! Ground data file input
  !
  use ground_file_io, only: GroundFileGet

  ! ҥȥǡ
  ! History data output
  !
  use gtool_historyauto, only: HistoryAutoPut, HistoryAutoAllVarFix

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, &  ! ٳʻ. 
                              ! Number of grid points in longitude
    &                jmax, &  ! ٳʻ. 
                              ! Number of grid points in latitude
    &                kmax     ! ľؿ. 
                              ! Number of vertical level

  ! դӻμ갷
  ! Date and time handler
  !
  use dc_date, only: &
    & operator(==), operator(<), operator(>), operator(<=), operator(>=), &
    & operator(+), operator(-), operator(*), operator(/), DCDiffTimePutLine

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING, &  ! ʸ.       Strings. 
    &                 TOKEN      ! .   Keywords. 

#ifdef LIB_MPI
  ! MPI 饤֥
  ! MPI library
  !
  use mpi
#endif

  ! ʸ ; Declaration statements
  !
  implicit none

  ! ͽѿ (ƥå $ t-\Delta t $ , $ t $ , $ t+\Delta t $ )
  ! Prediction variables  (Step $ t-\Delta t $ , $ t $ , $ t+\Delta t $ )
  !
  real(DP), allocatable:: xyz_UB (:,:,:)
                              ! $ u (t-\Delta t) $ .   ®. Eastward wind
  real(DP), allocatable:: xyz_VB (:,:,:)
                              ! $ v (t-\Delta t) $ .   ®. Northward wind
  real(DP), allocatable:: xyz_TempB (:,:,:)
                              ! $ T (t-\Delta t) $ .   . Temperature
  real(DP), allocatable:: xyz_QVapB (:,:,:)
                              ! $ q (t-\Delta t) $ .   漾. Specific humidity
  real(DP), allocatable:: xy_PsB (:,:)
                              ! $ p_s (t-\Delta t) $ . ɽ̵. Surface pressure
  real(DP), allocatable:: xyz_UN (:,:,:)
                              ! $ u (t) $ .     ®. Eastward wind
  real(DP), allocatable:: xyz_VN (:,:,:)
                              ! $ v (t) $ .     ®. Northward wind
  real(DP), allocatable:: xyz_TempN (:,:,:)
                              ! $ T (t) $ .     . Temperature
  real(DP), allocatable:: xyz_QVapN (:,:,:)
                              ! $ q (t) $ .     漾. Specific humidity
  real(DP), allocatable:: xy_PsN (:,:)
                              ! $ p_s (t) $ .   ɽ̵. Surface pressure
  real(DP), allocatable:: xyz_UA (:,:,:)
                              ! $ u (t+\Delta t) $ .   ®. Eastward wind
  real(DP), allocatable:: xyz_VA (:,:,:)
                              ! $ v (t+\Delta t) $ .   ®. Northward wind
  real(DP), allocatable:: xyz_TempA (:,:,:)
                              ! $ T (t+\Delta t) $ .   . Temperature
  real(DP), allocatable:: xyz_QVapA (:,:,:)
                              ! $ q (t+\Delta t) $ .   漾. Specific humidity
  real(DP), allocatable:: xy_PsA (:,:)
                              ! $ p_s (t+\Delta t) $ . ɽ̵. Surface pressure


  ! ѿ, ¾
  ! Diagnostic variables, etc.
  !
  real(DP), allocatable:: xyz_DUDt (:,:,:)
                              ! $ \DP{u}{t} $ . ®Ѳ. 
                              ! Eastward wind tendency
  real(DP), allocatable:: xyz_DVDt (:,:,:)
                              ! $ \DP{v}{t} $ . ®Ѳ. 
                              ! Northward wind tendency
  real(DP), allocatable:: xyz_DTempDt (:,:,:)
                              ! $ \DP{T}{t} $ . Ѳ. 
                              ! Temperature tendency
  real(DP), allocatable:: xyz_DQVapDt (:,:,:)
                              ! $ \DP{q}{t} $ . 漾Ѳ. 
                              ! Temperature tendency

  real(DP), allocatable:: xy_SurfHeight (:,:)
                              ! $ z_s $ . ɽ̹. 
                              ! Surface height. 

  real(DP), allocatable:: xy_SurfTemp (:,:)
                              ! ɽ̲. 
                              ! Surface temperature
  real(DP), allocatable:: xy_SurfAlbedo (:,:)
                              ! ɽ٥. 
                              ! Surface albedo
  real(DP), allocatable:: xy_SurfHumidCoef (:,:)
                              ! ɽ. 
                              ! Surface humidity coefficient
  real(DP), allocatable:: xy_SurfRoughLength (:,:)
                              ! ɽĹ. 
                              ! Surface rough length
  real(DP), allocatable:: xy_SurfHeatCapacity (:,:)
                              ! ɽǮ. 
                              ! Surface heat capacity
  integer, allocatable:: xy_SurfCond (:,:)
                              ! ɽ (0: , 1: ). 
                              ! Surface condition (0: fixed, 1: variable)
  real(DP), allocatable:: xy_GroundTempFlux (:,:)
                              ! Ǯեå. 
                              ! Ground temperature flux

  real(DP), allocatable:: xyr_Temp (:,:,:)
                              ! $ \hat{T} $ .  (Ⱦ٥). 
                              ! Temperature (half level)
  real(DP), allocatable:: xyz_Press (:,:,:)
                              ! $ p $ .  (٥). 
                              ! Air pressure (full level)
  real(DP), allocatable:: xyr_Press (:,:,:)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)
  real(DP), allocatable:: xyz_Height (:,:,:)
                              !  (٥). 
                              ! Height (full level)
  real(DP), allocatable:: xyr_Height (:,:,:)
                              !  (Ⱦ٥). 
                              ! Height (half level)
  real(DP), allocatable:: xyz_Exner (:,:,:)
                              ! Exner ؿ (٥). 
                              ! Exner function (full level)
  real(DP), allocatable:: xyr_Exner (:,:,:)
                              ! Exner ؿ (Ⱦ٥). 
                              ! Exner function (half level)

  real(DP), allocatable:: xyr_RadLFlux (:,:,:)
                              ! Ĺȥեå. 
                              ! Longwave flux
  real(DP), allocatable:: xyr_RadLFluxA (:,:,:)
                              ! $ t-\Delta t $ ˤѲΨ򸵤
                              ! Ф줿 $ t+\Delta t $ ˤ
                              ! Ĺȥեå. 
                              ! , 줬ľܼΥƥå $ t $ ˤ
                              ! ĹȥեåȤѤ櫓ǤϤʤ.
                              !
                              ! Longwave flux at $ t+\Delta t $ 
                              ! calculated from the tendency at 
                              ! $ t-\Delta t $ . 
                              ! However, this is not used directly as
                              ! Longwave flux at next step $ t $ .
                              !
  real(DP), allocatable:: xyr_RadSFlux (:,:,:)
                              ! û () եå. 
                              ! Shortwave (insolation) flux
  real(DP), allocatable:: xyra_DelRadLFlux (:,:,:,:)
                              ! ĹɽѲ. 
                              ! Surface temperature tendency with longwave

  real(DP), allocatable:: xyr_UFlux (:,:,:)
                              ! ®եå. 
                              ! Eastward wind flux
  real(DP), allocatable:: xyr_VFlux (:,:,:)
                              ! ®եå. 
                              ! Northward wind flux
  real(DP), allocatable:: xyr_TempFlux (:,:,:)
                              ! ٥եå. 
                              ! Temperature flux
  real(DP), allocatable:: xyr_QVapFlux (:,:,:)
                              ! 漾եå. 
                              ! Specific humidity flux

  real(DP), allocatable:: xyr_VelTransCoef (:,:,:)
                              ! ͢ư. 
                              ! Transfer coefficient: velocity
  real(DP), allocatable:: xyr_TempTransCoef (:,:,:)
                              ! ͢. 
                              ! Transfer coefficient: temperature
  real(DP), allocatable:: xyr_QVapTransCoef (:,:,:)
                              ! ͢漾. 
                              ! Transfer coefficient: specific humidity

  real(DP), allocatable:: xy_SurfVelTransCoef (:,:)
                              ! ͢ư. 
                              ! Diffusion coefficient: velocity
  real(DP), allocatable:: xy_SurfTempTransCoef (:,:)
                              ! ͢. 
                              ! Transfer coefficient: temperature
  real(DP), allocatable:: xy_SurfQVapTransCoef (:,:)
                              ! ͢漾. 
                              ! Transfer coefficient: specific humidity

  real(DP), allocatable:: xy_DSurfTempDt (:,:)
                              ! ɽ̲ѲΨ. 
                              ! Surface temperature tendency

  real(DP), allocatable:: xyz_DTempDtRadL (:,:,:)
                              ! ĹȲǮΨ. 
                              ! Temperature tendency with longwave
  real(DP), allocatable:: xyz_DTempDtRadS (:,:,:)
                              ! ûȲǮΨ. 
                              ! Temperature tendency with shortwave

  real(DP), allocatable:: xy_Rain (:,:)
                              ! ߿. 
                              ! Precipitation
  real(DP), allocatable:: xyz_DTempDtCond (:,:,:)
                              ! ŷǮΨ. 
                              ! Condensation heating
  real(DP), allocatable:: xyz_DQVapDtCond (:,:,:)
                              ! ŷ漾Ѳ. 
                              ! Condensation specific humidity tendency

  real(DP), allocatable:: xyz_DNegQVap1Dt (:,:,:)
                              ! ο˴ؤ漾ѲΨ (1). 
                              ! Specific humidity tendency by elimination of negative moist (1)
  real(DP), allocatable:: xyz_DNegQVap2Dt (:,:,:)
                              ! ο˴ؤ漾ѲΨ (2). 
                              ! Specific humidity tendency by elimination of negative moist (2)

  ! ѿ
  ! Work variables
  !
  logical:: FlagAPE           ! ʪ (APE) ׻󡿥. 
                              ! Physical processes (APE) calculation on/off. 
  logical:: FlagHS94          ! Held and Suarez (1994) 󡿥. 
                              ! Held and Suarez (1994) forcing on/off. 
  logical:: firstloop = .true.
                              ! Υ롼פǤ뤳Ȥ򼨤ե饰. 
                              ! Flag implying first loop

  logical:: flag_initial
                              ! ֥롼 MainInit ꤵޤ. 
                              ! ꥹȥǡɤ߹ˤ, 
                              ! .false. , ͥǡɤ߹ˤ
                              ! .true. ꤵޤ. 
                              ! 
                              ! This variable is set in an internal 
                              ! subroutine "MainInit". 
                              ! If restart data is loaded, .false. is set. 
                              ! On the other hand, if initial data is loaded, 
                              ! .true. is set.

  ! ¹ʸ ; Executable statement
  !

  ! ץν (֥롼)
  ! Initialization for the main program (Internal subroutine)
  !
  call MainInit


  ! ʬ
  ! Time integration
  !
  do while ( TimeN <= EndTime )

    if ( .not. FlagAPE ) then
      ! ɽ̾
      ! Configure surface conditions
      !
      call GroundFileGet( &
        & xy_SurfHeight = xy_SurfHeight ) ! (inout) optional
    end if

    if ( FlagHS94 ) then
      ! Held and Suarez (1994) ˤ붯Ȼ
      ! Forcing and dissipation suggested by Held and Suarez (1994)
      !
      call Hs94Forcing( &
        & xyz_UB, xyz_VB, xyz_TempB, xy_PsB, & ! (in)
        & xyz_DUDt, xyz_DVDt, xyz_DTempDt )    ! (out)
      xyz_DQVapDt   = 0.

    end if

    if ( FlagAPE ) then
      ! ɽ̾
      ! Configure surface conditions
      !
      call GroundFileGet( &
        & xy_SurfTemp, xy_SurfAlbedo, xy_SurfHumidCoef, & ! (inout) optional
        & xy_SurfRoughLength, xy_SurfHeatCapacity, &      ! (inout) optional
        & xy_GroundTempFlux, xy_SurfCond, &               ! (inout) optional
        & xy_SurfHeight )                                 ! (inout) optional

      ! ٤Ⱦҥ٥, ȹ٤λ
      ! Interpolate temperature on half sigma level, 
      ! and calculate pressure and height
      !
      call AuxVars( &
        & xy_PsB,     xyz_TempB, &   ! (in)
        & xyr_Temp, &                ! (out) optional
        & xyr_Press  = xyr_Press, &  ! (out) optional
        & xyz_Height = xyz_Height, xyr_Height = xyr_Height, & ! (out) optional
        & xyz_Exner  = xyz_Exner,  xyr_Exner  = xyr_Exner )   ! (out) optional

      ! ͥեå (Хɥǥ)
      ! Radiation flux (band model)
      !
      call RadiationFlux( & 
        & xyz_TempB, xyz_QVapB, xyr_Press, &   ! (in)
        & xy_SurfTemp, xy_SurfAlbedo, &        ! (in)
        & xyr_RadLFlux, xyr_RadSFlux, &        ! (out)
        & xyra_DelRadLFlux, &                  ! (out)
        & flag_rst = .not. flag_initial )      ! (in) optional

      ! ľȻեå
      ! Vertical diffusion flux
      !
      call VerticalDiffusion( &
        & xyz_UB,     xyz_VB,     xyz_QVapB, &                  ! (in)
        & xyz_TempB,  xyr_Temp,   xyr_Press, &                  ! (in)
        & xyz_Height, xyr_Height, xyz_Exner,    xyr_Exner, &    ! (in)
        & xyr_UFlux,  xyr_VFlux,  xyr_TempFlux, xyr_QVapFlux, & ! (out)
        & xyr_VelTransCoef, xyr_TempTransCoef, &                ! (out)
        & xyr_QVapTransCoef )                                   ! (out)

      ! ɽ̥եå
      ! Surface flux
      !
      call SurfaceFlux( &
        & xyz_UB, xyz_VB, xyz_TempB, xyr_Temp, xyz_QVapB, &   ! (in)
        & xyr_Press, xyz_Height, xyz_Exner, xyr_Exner, &      ! (in)
        & xy_SurfTemp, xy_SurfHumidCoef, &                    ! (in)
        & xy_SurfRoughLength, &                               ! (in)
        & xyr_UFlux, xyr_VFlux, xyr_TempFlux, xyr_QVapFlux, & ! (inout)
        & xy_SurfVelTransCoef, xy_SurfTempTransCoef, &        ! (out)
        & xy_SurfQVapTransCoef )                              ! (out)

      ! ʪλѲΨη׻ (ˡ)
      ! Calculate tendency by a part of physical processes (implicit)
      !
      call PhyImplTendency( &
        & xyr_UFlux, xyr_VFlux, xyr_TempFlux, xyr_QVapFlux, & ! (in)
        & xyr_RadSFlux, xyr_RadLFlux, &                       ! (in)
        & xy_GroundTempFlux, &                                ! (in)
        & xy_SurfTemp, xy_SurfHumidCoef, xy_SurfCond, &       ! (in)
        & xy_SurfHeatCapacity, &                              ! (in)
        & xyra_DelRadLFlux, &                                 ! (in)
        & xyr_Press, xyz_Exner, xyr_Exner, &                  ! (in)
        & xyr_VelTransCoef, xyr_TempTransCoef, &              ! (in)
        & xyr_QVapTransCoef, &                                ! (in)
        & xy_SurfVelTransCoef, xy_SurfTempTransCoef, &        ! (in)
        & xy_SurfQVapTransCoef, &                             ! (in)
        & xyz_DUDt, xyz_DVDt, xyz_DTempDt, xyz_DQVapDt, &     ! (out)
        & xy_DSurfTempDt )                                    ! (out)

      ! ľȻեåν 
      !   * ϤΤߤΥ֥롼Ǥ, ׻ˤϱƶʤ
      ! 
      ! Output Vertical diffusion fluxes
      !   * This subroutine works for output only, 
      !     so it does not influence a calculation.
      !
      call VerticalDiffusionOutput( &
        & xyr_UFlux, xyr_VFlux, xyr_TempFlux, xyr_QVapFlux, & ! (in)
        & xyz_DUDt,  xyz_DVDt,  xyz_DTempDt,  xyz_DQVapDt, &  ! (in)
        & xyz_Exner, xyr_Exner, &                             ! (in)
        & xyr_VelTransCoef, xyr_TempTransCoef, &              ! (in)
        & xyr_QVapTransCoef )                                 ! (in)

      ! ɽ̥եåν 
      !   * ϤΤߤΥ֥롼Ǥ, ׻ˤϱƶʤ
      ! 
      ! Output surface fluxes
      !   * This subroutine works for output only, 
      !     so it does not influence a calculation.
      !
      call SurfaceFluxOutput( &
        & xyr_UFlux, xyr_VFlux, xyr_TempFlux, xyr_QVapFlux, &  ! (in)
        & xyz_DUDt, xyz_DVDt, xyz_DTempDt, xyz_DQVapDt, &      ! (in)
        & xy_SurfTemp, xy_DSurfTempDt, &                       ! (in)
        & xyr_Press, xyz_Exner, xyr_Exner, xy_SurfHumidCoef, & ! (in)
        & xy_SurfVelTransCoef, xy_SurfTempTransCoef, &         ! (in)
        & xy_SurfQVapTransCoef )                               ! (in)

      ! ͥեåν 
      !   * ϤΤߤΥ֥롼Ǥ, ׻ˤϱƶʤ
      ! 
      ! Output radiation fluxes
      !   * This subroutine works for output only, 
      !     so it does not influence a calculation.
      !
      call RadiationFluxOutput( &
        & xyr_RadSFlux, xyr_RadLFlux, &      ! (in)
        & xyra_DelRadLFlux, xy_DSurfTempDt ) ! (in)

      ! $ t+\Delta t $ Ĺȥեå
      !   * ǻФ줿ͤľܼΥƥå $ t $ ˤ
      !     ĹȥեåȤѤ櫓ǤϤʤ
      !
      ! Evaluate longwave flux at $ t+\Delta t $ 
      !   * The evaluated value is not used directly as
      !     Longwave flux at next step $ t $ .
      !
      call PhyImplEvalRadLFluxA( &
        & xyr_RadLFlux, &                                  ! (in)
        & xyz_DTempDt, xy_DSurfTempDt, xyra_DelRadLFlux, & ! (in)
        & xyr_RadLFluxA )                                  ! (out)

      ! ͤˤ벹ѲΨ
      ! Temperature tendency with radiation
      !
      call RadiationDTempDt( &
        & xyr_RadLFluxA, xyr_RadSFlux, xyr_Press, &   ! (in)
        & xyz_DTempDtRadL, xyz_DTempDtRadS )          ! (out)

      xyz_DTempDt = xyz_DTempDt + xyz_DTempDtRadL + xyz_DTempDtRadS

      ! ̲٤λʬɽ
      ! Time integration of surface temperature, correction of flux on surface
      ! 
      call IntegralSurfTemp( &
        & xy_DSurfTempDt, &     ! (in)
        & xy_SurfTemp )         ! (inout)

    end if ! FlagAPE

    ! ϳز
    ! Dynamical core
    !
    call Dynamics( &
      & xyz_UB,   xyz_VB,   xyz_TempB,   xyz_QVapB,   xy_PsB, &   ! (in)
      & xyz_UN,   xyz_VN,   xyz_TempN,   xyz_QVapN,   xy_PsN, &   ! (in)
      & xyz_DUDt, xyz_DVDt, xyz_DTempDt, xyz_DQVapDt, &           ! (in)
      & xy_SurfHeight, &                                          ! (in)
      & xyz_UA,   xyz_VA,   xyz_TempA,   xyz_QVapA,   xy_PsA  )   ! (out)

    if ( FlagAPE ) then
      ! ٤Ⱦҥ٥, ȹ٤λ
      ! Interpolate temperature on half sigma level, 
      ! and calculate pressure and height
      !
      call AuxVars( &
        & xy_PsA,     xyz_TempA, & ! (in)
        & xyz_Press = xyz_Press, & ! (out) optional
        & xyr_Press = xyr_Press )  ! (out) optional
      
      ! ο (1)
      ! Remove negative moisture (1)
      !
      xyz_DNegQVap1Dt = 0.
      call RemoveNegMoist( &
        & xyr_Press = xyr_Press, &                                  ! (in)
        & xyz_QVap = xyz_QVapA, xyz_DNegQVapDt = xyz_DNegQVap1Dt )  ! (inout)

      ! ѱѥ᥿ꥼ
      ! Cumulus parameterization
      !
      xy_Rain         = 0.
      xyz_DTempDtCond = 0.
      xyz_DQVapDtCond = 0.
      call Cumulus( &
        & xyz_TempA, xyz_QVapA, xy_Rain, &     ! (inout)
        & xyz_DTempDtCond, xyz_DQVapDtCond, &  ! (inout)
        & xyz_Press, xyr_Press )               ! (in)

      ! 絬϶ŷ
      ! Large scale condensation
      !
      call LScaleCond( &
        & xyz_TempA, xyz_QVapA, xy_Rain, &     ! (inout)
        & xyz_DTempDtCond, xyz_DQVapDtCond, &  ! (inout)
        & xyz_Press, xyr_Press )               ! (in)

      ! ήĴ
      ! Dry convective adjustment
      !
      call DryConvectAdjust( &
        & xyz_Press, xyr_Press, & ! (in)
        & xyz_TempA )             ! (inout)

      ! ο (2)
      ! Remove negative moisture (2)
      !
      xyz_DNegQVap2Dt = 0.
      call RemoveNegMoist( &
        & xyr_Press = xyr_Press, &                                  ! (in)
        & xyz_QVap = xyz_QVapA, xyz_DNegQVapDt = xyz_DNegQVap2Dt )  ! (inout)

    end if ! FlagAPE

    ! ֥ե륿
    ! Time filter
    !
    if ( .not. flag_initial .or. .not. firstloop ) then
      call TimeFilter( &
        & xyz_UB, xyz_VB, xyz_TempB, xyz_QVapB, xy_PsB, &   ! (in)
        & xyz_UN, xyz_VN, xyz_TempN, xyz_QVapN, xy_PsN, &   ! (inout)
        & xyz_UA, xyz_VA, xyz_TempA, xyz_QVapA, xy_PsA  )   ! (in)
    end if

    ! ҥȥǡ
    ! History data output
    !
    call HistoryAutoPut( TimeA, 'U',    xyz_UA )
    call HistoryAutoPut( TimeA, 'V',    xyz_VA )
    call HistoryAutoPut( TimeA, 'Temp', xyz_TempA )
    call HistoryAutoPut( TimeA, 'QVap', xyz_QVapA )
    call HistoryAutoPut( TimeA, 'Ps',   xy_PsA )

    if ( FlagAPE ) then
      call HistoryAutoPut( TimeN, 'SurfTemp', xy_SurfTemp )
      call HistoryAutoPut( TimeN, 'Rain', xy_Rain )
      call HistoryAutoPut( TimeN, 'DTempDtCond', xyz_DTempDtCond )
      call HistoryAutoPut( TimeN, 'DQVapDtCond', xyz_DQVapDtCond )
    end if

    ! ͽѿλդؤ
    ! Exchange time of prediction variables
    !
    xyz_UB    = xyz_UN    ; xyz_UN    = xyz_UA    ; xyz_UA    = 0.
    xyz_VB    = xyz_VN    ; xyz_VN    = xyz_VA    ; xyz_VA    = 0.
    xyz_TempB = xyz_TempN ; xyz_TempN = xyz_TempA ; xyz_TempA = 0.
    xyz_QVapB = xyz_QVapN ; xyz_QVapN = xyz_QVapA ; xyz_QVapA = 0.
    xy_PsB    = xy_PsN    ; xy_PsN    = xy_PsA    ; xy_PsA    = 0.

    ! οʹ
    ! Progress time
    !
    call TimesetProgress

    ! NAMELIST ɤ߹ѿ̵̾ʤΤ¸ߤɤå
    ! HistoryAutoAddVariable Ͽѿ̾
    !
    ! Check that invalid variable names are loaded from NAMELIST or not
    ! Print registered variable names by "HistoryAutoAddVariable"
    !
    if ( firstloop ) call HistoryAutoAllVarFix

    ! ꥹȥǡ
    ! Restart data output
    !
    call RestartFileOutput( &
      & xyz_UB, xyz_VB, xyz_TempB, xyz_QVapB, xy_PsB, &   ! (in)
      & xyz_UN, xyz_VN, xyz_TempN, xyz_QVapN, xy_PsN  )   ! (in)

    if ( FlagAPE ) then
      ! ɽ̲٥ꥹȥǡ
      ! Restart data of surface temperature output
      !
      call RestartSurfTempOutput( &
        & xy_SurfTemp  )             ! (in)
    end if

    firstloop = .false.

  ! ʬλ
  ! Time integration is finished
  !
  end do

  ! ץνλ (֥롼)
  ! Termination for the main program (Internal subroutine)
  !
  call MainTerminate



contains

  !-------------------------------------------------------------------

  subroutine MainInit
    !
    ! ץν³. 
    !
    ! Initialization procedure for the main program. 
    !

#ifdef LIB_MPI
    ! å
    ! Message output
    !
    use dc_message, only: MessageSuppressMPI
#endif
    use dc_message, only: MessageNotify

    ! ޥɥ饤
    ! Command line option parser
    !
    use option_parser, only: OptParseInit

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: NmlutilInit, NmlutilMsg, namelist_filename

    ! 
    ! Time control
    !
    use timeset, only: TimesetInit, TimesetDelTimeHalf, &
      & TimeN                 ! ƥå $ t $ λ. Time of step $ t $. 

    ! ϥեδܾ
    ! Management basic information for output files
    ! 
    use fileset, only: FilesetInit

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: GridsetInit, &
      &                imax, & ! ٳʻ. 
                               ! Number of grid points in longitude
      &                jmax, & ! ٳʻ. 
                               ! Number of grid points in latitude
      &                kmax    ! ľؿ. 
                               ! Number of vertical level

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: ConstantsInit

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: AxessetInit

    ! ꥹȥǡ
    ! Restart data input/output
    !
    use restart_file_io, only: RestartFileOpen, RestartFileGet

    ! ɽ̲٥ꥹȥǡ
    ! Restart data of surface temperature input/output
    !
    use restart_surftemp_io, only: RestartSurfTempOpen, RestartSurfTempGet

    ! ҥȥǡ
    ! History data output
    !
    use history_file_io, only: HistoryFileOpen
    use gtool_historyauto, only: HistoryAutoAddVariable, HistoryAutoPut

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: &
      & STDOUT               ! ɸϤֹ. Unit number of standard output

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ʸ ; Declaration statements
    !
    implicit none
    character(*), parameter:: prog_name = 'dcpam_main'
                              ! ץ̾. 
                              ! Main program name
    character(*), parameter:: version = &
      & '$Name: dcpam5-20090405 $' // &
      & '$Id: dcpam_main.F90,v 1.35 2009-03-18 09:40:37 morikawa Exp $'
                              ! ץΥС
                              ! Main program version

    character(STRING):: brief
                              ! ¹ԥեδʷ
                              ! Brief account of executable file

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /dcpam_main_nml/ &
      & FlagAPE, FlagHS94
          !
          ! ǥեͤˤĤƤϽ³ "main/dcpam_main.F90#MainInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "main/dcpam_main.F90#MainInit" for the default values. 
          !

#ifdef LIB_MPI
    integer :: myrank_mpi, nprocs_mpi, err_mpi
                              ! MPI νκݤ˻Ѥѿ. 
                              ! Variables used for initialization of MPI. 
#endif

    ! ¹ʸ ; Executable statement
    !

#ifdef LIB_MPI
    ! MPI 
    ! Initialization of MPI
    !
    CALL MPI_Init(err_mpi)
    CALL MPI_Comm_Rank(mpi_comm_world, myrank_mpi, err_mpi)
    CALL MPI_Comm_Size(mpi_comm_world, nprocs_mpi, err_mpi)
#endif

#ifdef LIB_MPI
    ! å
    ! Message output
    !
    call MessageSuppressMPI( rank = 0 )
#endif

    ! ޥɥ饤
    ! Command line option parser
    !
    call OptParseInit(prog_name)

    ! NAMELIST ե̾
    ! Input NAMELIST file name
    !
    call NmlutilInit

    ! ǥեͤ
    ! Default values settings
    !
    FlagAPE  = .true.
    FlagHS94 = .false.

    ! ׻⡼ɤ
    ! Configure calculation mode
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &            ! (in)
        & nml = dcpam_main_nml, &  ! (out)
        & iostat = iostat_nml )    ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, prog_name ) ! (in)
      if ( iostat_nml == 0 ) write( STDOUT, nml = dcpam_main_nml )
    end if

    if ( FlagAPE .and. FlagHS94 ) then
      call MessageNotify( 'E', prog_name, &
        & 'FlagAPE=<%b> and FlagHS94=<%b> are conflicted.', &
        & l = (/FlagAPE, FlagHS94/) )
    end if

    ! ׻⡼ɤɽ
    ! Display calculation mode
    !
    brief = ''
    if ( FlagHS94 ) &
      & brief = 'Held and Suarez (1994) benchmark test'
    if ( FlagAPE ) &
      & brief = 'Aqua Planet Experiment'
    if ( trim(brief) == '' ) &
      & brief = 'Only Dynamical process'

    call MessageNotify( 'M', prog_name, '' )
    call MessageNotify( 'M', prog_name, '+-------------------------------------' )
    call MessageNotify( 'M', prog_name, '|  Run: %c', c1 = trim(brief) )
    call MessageNotify( 'M', prog_name, '|  -- version = %c', c1 = trim(version) )
    call MessageNotify( 'M', prog_name, '+-------------------------------------' )
    call MessageNotify( 'M', prog_name, '' )

    ! 
    ! Time control
    !
    call TimesetInit

    ! ϥեδܾ
    ! Management basic information for output files
    ! 
    call FilesetInit

    ! ʻ
    ! Grid points settings
    !
    call GridsetInit

    ! ʪ
    ! Physical constants settings
    !
    call ConstantsInit

    ! ɸǡ
    ! Axes data settings
    !
    call AxessetInit

    ! ͽѿγ
    ! Allocation of prediction variables
    !
    allocate( xyz_UB    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_VB    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_TempB (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_QVapB (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xy_PsB    (0:imax-1, 1:jmax) )

    allocate( xyz_UN    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_VN    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_TempN (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_QVapN (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xy_PsN    (0:imax-1, 1:jmax) )

    allocate( xyz_UA    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_VA    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_TempA (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_QVapA (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xy_PsA    (0:imax-1, 1:jmax) )

    ! ꥹȥǡ
    ! Restart data input
    !
    call RestartFileGet( &
      & xyz_UB, xyz_VB, xyz_TempB, xyz_QVapB, xy_PsB, & ! (out)
      & xyz_UN, xyz_VN, xyz_TempN, xyz_QVapN, xy_PsN, & ! (out)
      & flag_initial )                                  ! (out) optional

    ! ꥹȥǡեν
    ! Initialization of restart data file
    !
    call RestartFileOpen

    ! ҥȥǡեν
    ! Initialization of history data files
    !
    call HistoryFileOpen

    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
    call HistoryAutoAddVariable( 'U' , &         ! (in)
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &  ! (in)
      & 'eastward wind', 'm s-1' )               ! (in)

    call HistoryAutoAddVariable( 'V' , &         ! (in)
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &  ! (in)
      & 'northward wind', 'm s-1' )              ! (in)

    call HistoryAutoAddVariable( 'Temp' , &      ! (in)
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &  ! (in)
      & 'temperature', 'K' )                     ! (in)

    call HistoryAutoAddVariable( 'QVap' , &      ! (in)
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &  ! (in)
      & 'specific humidity', 'kg kg-1' )         ! (in)

    call HistoryAutoAddVariable( 'Ps' , &        ! (in)
      & (/ 'lon ', 'lat ', 'time' /), &          ! (in)
      & 'surface pressure', 'Pa' )               ! (in)

    ! ҥȥǡ (Ȼ)
    ! History data output (Start time)
    !
    call HistoryAutoPut( TimeN, 'U', xyz_UN )
    call HistoryAutoPut( TimeN, 'V', xyz_VN )
    call HistoryAutoPut( TimeN, 'Temp', xyz_TempN )
    call HistoryAutoPut( TimeN, 'QVap', xyz_QVapN )
    call HistoryAutoPut( TimeN, 'Ps', xy_PsN )

    if ( FlagAPE ) then
      ! ɽ̲٤γ
      ! Allocation of surface temperature
      !
      allocate( xy_SurfTemp (0:imax-1, 1:jmax) )

      ! ɽ̲٥ꥹȥǡ
      ! Restart data of surface temperature input
      !
      call RestartSurfTempGet( &
        & xy_SurfTemp  )          ! (out)

      ! ɽ̲٥ꥹȥǡեν
      ! Initialization of restart data file of surface temperature
      !
      call RestartSurfTempOpen

      ! ҥȥǡϤΤΤؤѿϿ
      ! Register of variables for history data output
      !
      call HistoryAutoAddVariable( 'SurfTemp' , &
        & (/ 'lon ', 'lat ', 'time' /), &
        & 'surface temperature', 'K' )

      call HistoryAutoAddVariable( 'Rain', &
        & (/ 'lon ', 'lat ', 'time' /), &
        & 'precipitation', 'W m-2' )

      call HistoryAutoAddVariable( 'DTempDtCond' , &
        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
        & 'condensation heating', 'K s-1' )

      call HistoryAutoAddVariable( 'DQVapDtCond' , &
        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
        & 'condensation moistening', 'kg kg-1 s-1' )
    end if ! FlagAPE

    ! ѿγ
    ! Allocation of diagnostic variables
    !
    allocate( xyz_DUDt    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_DVDt    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_DQVapDt (0:imax-1, 1:jmax, 1:kmax) )

    allocate( xy_SurfHeight (0:imax-1, 1:jmax) )

    if ( FlagAPE ) then
      allocate( xy_SurfAlbedo       (0:imax-1, 1:jmax) )
      allocate( xy_SurfHumidCoef    (0:imax-1, 1:jmax) )
      allocate( xy_SurfRoughLength  (0:imax-1, 1:jmax) )
      allocate( xy_SurfHeatCapacity (0:imax-1, 1:jmax) )
      allocate( xy_SurfCond         (0:imax-1, 1:jmax) )
      allocate( xy_GroundTempFlux   (0:imax-1, 1:jmax) )

      allocate( xyr_Temp   (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyz_Press  (0:imax-1, 1:jmax, 1:kmax) )
      allocate( xyr_Press  (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyz_Height (0:imax-1, 1:jmax, 1:kmax) )
      allocate( xyr_Height (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyz_Exner  (0:imax-1, 1:jmax, 1:kmax) )
      allocate( xyr_Exner  (0:imax-1, 1:jmax, 0:kmax) )

      allocate( xyr_RadLFlux     (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_RadLFluxA    (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_RadSFlux     (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyra_DelRadLFlux (0:imax-1, 1:jmax, 0:kmax,  0:1) )

      allocate( xyr_UFlux    (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_VFlux    (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_TempFlux (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_QVapFlux (0:imax-1, 1:jmax, 0:kmax) )

      allocate( xyr_VelTransCoef  (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_TempTransCoef (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_QVapTransCoef (0:imax-1, 1:jmax, 0:kmax) )

      allocate( xy_SurfVelTransCoef  (0:imax-1, 1:jmax) )
      allocate( xy_SurfTempTransCoef (0:imax-1, 1:jmax) )
      allocate( xy_SurfQVapTransCoef (0:imax-1, 1:jmax) )

      allocate( xy_DSurfTempDt (0:imax-1, 1:jmax) )

      allocate( xyz_DTempDtRadL (0:imax-1, 1:jmax, 1:kmax) )
      allocate( xyz_DTempDtRadS (0:imax-1, 1:jmax, 1:kmax) )


      allocate( xy_Rain         (0:imax-1, 1:jmax) )
      allocate( xyz_DTempDtCond (0:imax-1, 1:jmax, 1:kmax) )
      allocate( xyz_DQVapDtCond (0:imax-1, 1:jmax, 1:kmax) )
      allocate( xyz_DNegQVap1Dt (0:imax-1, 1:jmax, 1:kmax) )
      allocate( xyz_DNegQVap2Dt (0:imax-1, 1:jmax, 1:kmax) )
    end if ! FlagAPE

    ! ϥ顼ˡѤ뤿, t Ⱦʬ
    ! Delta t is reduced to half in order to use Euler method at initial step
    !
    if ( flag_initial ) then
      call TimesetDelTimeHalf
    end if

  end subroutine MainInit

  !-------------------------------------------------------------------

  subroutine MainTerminate
    !
    ! ץνλ³. 
    !
    ! Termination procedure for the main program. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ϳز (ڥȥˡ, Arakawa and Suarez (1983))
    ! Dynamical process (Spectral method, Arakawa and Suarez (1983))
    !
    use dynamics_hspl_vas83, only: DynamicsFinalize

    ! Held and Suarez (1994) ˤ붯Ȼ
    ! Forcing and dissipation suggested by Held and Suarez (1994)
    !
    use held_suarez_1994, only: Hs94Finalize

    ! ͥեå (Хɥǥ)
    ! Radiation flux (band model)
    !
    use radiation_band, only: RadiationFinalize

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: AxessetFinalize

    ! ٤Ⱦҥ٥, ȹ٤λ
    ! Interpolate temperature on half sigma level, 
    ! and calculate pressure and height
    !
    use auxiliary, only: AuxFinalize

    ! 
    ! Time control
    !
    use timeset, only: TimesetClose

    ! ꥹȥǡ
    ! Restart data input/output
    !
    use restart_file_io, only: RestartFileClose

    ! ɽ̲٥ꥹȥǡ
    ! Restart data of surface temperature input/output
    !
    use restart_surftemp_io, only: RestartSurfTempClose

    ! ҥȥǡ
    ! History data output
    !
    use history_file_io, only: HistoryFileClose

    ! ʸ ; Declaration statements
    !
    implicit none
#ifdef LIB_MPI
    integer :: err_mpi
                              ! MPI νλκݤ˻Ѥѿ. 
                              ! Variable used for termination of MPI. 
#endif

    ! ¹ʸ ; Executable statement
    !

    ! ꥹȥǡե륯
    ! Close restart data file
    !
    call RestartFileClose

    if ( FlagAPE ) then
      ! ɽ̲٥ꥹȥǡե륯
      ! Close restart data file of surface temperature
      !
      call RestartSurfTempClose
    end if

    ! ҥȥǡե륯
    ! Close history data files
    !
    call HistoryFileClose

    ! ͽѿγղ
    ! Deallocation of prediction variables
    !
    deallocate( xyz_UB    )
    deallocate( xyz_VB    )
    deallocate( xyz_TempB )
    deallocate( xyz_QVapB )
    deallocate( xy_PsB    )

    deallocate( xyz_UN    )
    deallocate( xyz_VN    )
    deallocate( xyz_TempN )
    deallocate( xyz_QVapN )
    deallocate( xy_PsN    )

    deallocate( xyz_UA    )
    deallocate( xyz_VA    )
    deallocate( xyz_TempA )
    deallocate( xyz_QVapA )
    deallocate( xy_PsA    )

    ! ѿγղ
    ! Dellocation of diagnostic variables
    !
    deallocate( xyz_DUDt    )
    deallocate( xyz_DVDt    )
    deallocate( xyz_DTempDt )
    deallocate( xyz_DQVapDt )

    deallocate( xy_SurfHeight )

    if ( FlagAPE ) then
      deallocate( xy_SurfAlbedo       )
      deallocate( xy_SurfHumidCoef    )
      deallocate( xy_SurfRoughLength  )
      deallocate( xy_SurfHeatCapacity )
      deallocate( xy_SurfCond         )
      deallocate( xy_GroundTempFlux   )

      deallocate( xyr_Temp   )
      deallocate( xyz_Press  )
      deallocate( xyr_Press  )
      deallocate( xyz_Height )
      deallocate( xyr_Height )
      deallocate( xyz_Exner  )
      deallocate( xyr_Exner  )

      deallocate( xyr_RadLFlux     )
      deallocate( xyr_RadLFluxA    )
      deallocate( xyr_RadSFlux     )
      deallocate( xyra_DelRadLFlux )

      deallocate( xyr_UFlux    )
      deallocate( xyr_VFlux    )
      deallocate( xyr_TempFlux )
      deallocate( xyr_QVapFlux )

      deallocate( xyr_VelTransCoef  )
      deallocate( xyr_TempTransCoef )
      deallocate( xyr_QVapTransCoef )

      deallocate( xy_SurfVelTransCoef  )
      deallocate( xy_SurfTempTransCoef )
      deallocate( xy_SurfQVapTransCoef )

      deallocate( xy_DSurfTempDt )

      deallocate( xyz_DTempDtRadL )
      deallocate( xyz_DTempDtRadS )


      deallocate( xy_Rain         )
      deallocate( xyz_DTempDtCond )
      deallocate( xyz_DQVapDtCond )
      deallocate( xyz_DNegQVap1Dt )
      deallocate( xyz_DNegQVap2Dt )
    end if ! FlagAPE

    ! ƥ⥸塼ѿγղ
    ! Dellocation of variables in modules
    !
    call DynamicsFinalize
    call AuxFinalize

    if ( FlagHS94 ) then
      call Hs94Finalize
    end if

    if ( FlagAPE ) then
      ! ղȥꥹȥեνλ
      ! Dellocation and close a restart file
      !
      call RadiationFinalize
    end if

    call AxessetFinalize

    ! λ
    ! Termination of time control
    !
    call TimesetClose

#ifdef LIB_MPI
    ! MPI λ
    ! Termination of MPI
    !
    call MPI_Finalize(err_mpi)
#endif

  end subroutine MainTerminate

end program dcpam_main
